/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.withrottle;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.PowerManager;
import jmri.jmrit.withrottle.AbstractController;
import jmri.jmrit.withrottle.ControllerInterface;
import jmri.jmrit.withrottle.DeviceServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackPowerController
extends AbstractController
implements PropertyChangeListener {
    private PowerManager pwrMgr = InstanceManager.getNullableDefault(PowerManager.class);
    private static final Logger log = LoggerFactory.getLogger(TrackPowerController.class);

    public TrackPowerController() {
        if (this.pwrMgr == null) {
            log.info("No power manager instance.");
            this.isValid = false;
        } else {
            this.register();
            this.isValid = true;
        }
    }

    @Override
    public boolean verifyCreation() {
        return this.isValid;
    }

    @Override
    public void handleMessage(String message, DeviceServer deviceServer) {
        if (message.charAt(0) == 'A') {
            switch (message.charAt(1)) {
                case '1': {
                    this.setTrackPowerOn();
                    break;
                }
                case '0': {
                    this.setTrackPowerOff();
                    break;
                }
                default: {
                    log.warn("Unknown Track Power message from wi-fi device");
                }
            }
        }
    }

    private void setTrackPowerOn() {
        if (this.pwrMgr != null) {
            try {
                this.pwrMgr.setPower(2);
            }
            catch (JmriException jmriException) {
                log.error("Cannot turn power on.");
            }
        }
    }

    private void setTrackPowerOff() {
        if (this.pwrMgr != null) {
            try {
                this.pwrMgr.setPower(4);
            }
            catch (JmriException jmriException) {
                log.error("Cannot turn power off.");
            }
        }
    }

    public void sendCurrentState() {
        if (this.listeners == null) {
            return;
        }
        String message = null;
        switch (this.pwrMgr.getPower()) {
            case 2: {
                message = "PPA1";
                break;
            }
            case 4: {
                message = "PPA0";
                break;
            }
            case 1: {
                message = "PPA2";
                break;
            }
            default: {
                log.error("Unexpected state value: +{}", (Object)this.pwrMgr.getPower());
            }
        }
        for (ControllerInterface listener : this.listeners) {
            listener.sendPacketToDevice(message);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        this.sendCurrentState();
    }

    @Override
    public void register() {
        this.pwrMgr.addPropertyChangeListener(this);
    }

    @Override
    public void deregister() {
        this.pwrMgr.removePropertyChangeListener(this);
    }
}

