/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.withrottle;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jmri.InstanceManager;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.Route;
import jmri.RouteManager;
import jmri.Sensor;
import jmri.jmrit.withrottle.AbstractController;
import jmri.jmrit.withrottle.Bundle;
import jmri.jmrit.withrottle.ControllerInterface;
import jmri.jmrit.withrottle.DeviceServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteController
extends AbstractController
implements PropertyChangeListener {
    private RouteManager manager = null;
    private HashMap<NamedBeanHandle<Sensor>, Route> indication;
    protected NamedBeanHandleManager nbhm = InstanceManager.getDefault(NamedBeanHandleManager.class);
    private static final Logger log = LoggerFactory.getLogger(RouteController.class);

    public RouteController() {
        this.manager = InstanceManager.getNullableDefault(RouteManager.class);
        if (this.manager == null) {
            log.info("No route manager instance.");
            this.isValid = false;
        } else {
            this.indication = new HashMap();
            this.isValid = true;
        }
    }

    @Override
    boolean verifyCreation() {
        return this.isValid;
    }

    @Override
    public void filterList() {
        ArrayList<String> tempList = new ArrayList<String>(0);
        for (String sysName : this.sysNameList) {
            Object o;
            Route r = this.manager.getBySystemName(sysName);
            if (r == null || (o = r.getProperty("WifiControllable")) != null && !Boolean.valueOf(o.toString()).booleanValue()) continue;
            tempList.add(sysName);
        }
        this.sysNameList = tempList;
    }

    @Override
    void handleMessage(String message, DeviceServer deviceServer) {
        String rName = message.substring(2);
        try {
            if (message.charAt(0) == 'A' && message.charAt(1) == '2') {
                Route r = this.manager.getBySystemName(rName);
                if (r != null) {
                    r.setRoute();
                    log.debug("Route '{}' set.", (Object)rName);
                } else {
                    String msg = Bundle.getMessage("ErrorRouteNotDefined", rName);
                    log.warn(msg);
                    deviceServer.sendAlertMessage(msg);
                }
            } else {
                String msg = Bundle.getMessage("ErrorRouteBadMessage", message);
                log.warn(msg);
                deviceServer.sendAlertMessage(msg);
            }
        }
        catch (NullPointerException nullPointerException) {
            String msg = Bundle.getMessage("ErrorRouteOther", rName);
            log.warn(msg);
            deviceServer.sendAlertMessage(msg);
        }
    }

    public void sendTitles() {
        if (this.listeners == null) {
            return;
        }
        StringBuilder labels = new StringBuilder("PRT");
        labels.append("]\\[").append(Bundle.getMessage("MenuItemRouteTable")).append("}|{Route");
        labels.append("]\\[").append(Bundle.getMessage("StateActive")).append("}|{2");
        labels.append("]\\[").append(Bundle.getMessage("StateInactive")).append("}|{4");
        labels.append("]\\[").append(Bundle.getMessage("StateUnknown")).append("}|{0");
        labels.append("]\\[").append(Bundle.getMessage("StateInconsistent")).append("}|{8");
        labels.append("]\\[").append(Bundle.getMessage("StateUnknown")).append("}|{");
        String message = labels.toString();
        for (ControllerInterface listener : this.listeners) {
            listener.sendPacketToDevice(message);
        }
    }

    public void sendList() {
        if (this.listeners == null) {
            return;
        }
        if (this.canBuildList) {
            this.buildList(this.manager);
        }
        if (this.sysNameList.isEmpty()) {
            return;
        }
        StringBuilder list = new StringBuilder("PRL");
        for (String sysName : this.sysNameList) {
            Route r = this.manager.getBySystemName(sysName);
            if (r == null) continue;
            list.append("]\\[").append(sysName);
            list.append("}|{");
            if (r.getUserName() != null) {
                list.append(r.getUserName());
            }
            list.append("}|{");
            String turnoutsAlignedSensor = r.getTurnoutsAlignedSensor();
            if (turnoutsAlignedSensor.equals("")) continue;
            try {
                Sensor routeAligned = InstanceManager.sensorManagerInstance().provideSensor(turnoutsAlignedSensor);
                list.append(routeAligned.getKnownState());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.warn("Failed to provide turnoutsAlignedSensor \"{}\" in sendList", (Object)turnoutsAlignedSensor);
            }
        }
        String message = list.toString();
        for (ControllerInterface listener : this.listeners) {
            listener.sendPacketToDevice(message);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("KnownState")) {
            Sensor s = (Sensor)evt.getSource();
            for (Map.Entry<NamedBeanHandle<Sensor>, Route> entry : this.indication.entrySet()) {
                if (entry.getKey().getBean() != s) continue;
                Route r = entry.getValue();
                String message = "PRA" + s.getKnownState() + r.getSystemName();
                for (ControllerInterface listener : this.listeners) {
                    listener.sendPacketToDevice(message);
                }
                return;
            }
        }
    }

    @Override
    public void register() {
        for (String sysName : this.sysNameList) {
            String turnoutsAlignedSensor;
            Route r = this.manager.getBySystemName(sysName);
            if (r == null || (turnoutsAlignedSensor = r.getTurnoutsAlignedSensor()).equals("")) continue;
            Sensor sensor = InstanceManager.sensorManagerInstance().provideSensor(turnoutsAlignedSensor);
            NamedBeanHandle<Sensor> routeAligned = this.nbhm.getNamedBeanHandle(turnoutsAlignedSensor, sensor);
            this.indication.put(routeAligned, r);
            sensor.addPropertyChangeListener(this, routeAligned.getName(), "Wi Throttle Route Controller");
            log.debug("Add listener to Sensor: {} for Route: {}", (Object)routeAligned.getName(), (Object)r.getSystemName());
        }
    }

    @Override
    public void deregister() {
        if (this.sysNameList.isEmpty()) {
            return;
        }
        this.indication.keySet().forEach(namedSensor -> {
            ((Sensor)namedSensor.getBean()).removePropertyChangeListener(this);
            if (log.isDebugEnabled()) {
                log.debug("Removing listener from Sensor: {} for Route: {}", (Object)namedSensor.getName(), (Object)this.indication.get(namedSensor).getSystemName());
            }
        });
        this.indication = new HashMap();
    }
}

