/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.withrottle;

import java.beans.PropertyChangeEvent;
import jmri.DccThrottle;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.SpeedStepMode;
import jmri.ThrottleListener;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.withrottle.ControllerInterface;
import jmri.jmrit.withrottle.ThrottleController;
import jmri.jmrit.withrottle.ThrottleControllerListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiThrottleController
extends ThrottleController {
    protected boolean isStealAddress;
    private static final Logger log = LoggerFactory.getLogger(MultiThrottleController.class);

    public MultiThrottleController(char id, String key, ThrottleControllerListener tcl, ControllerInterface ci) {
        super(id, tcl, ci);
        log.debug("New MT controller");
        this.locoKey = key;
        this.isStealAddress = false;
    }

    public String buildPacketWithChar(char chr) {
        return "M" + this.whichThrottle + chr + this.locoKey + "<;>";
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        StringBuilder message;
        String eventName = event.getPropertyName();
        log.debug("property change: {}", (Object)eventName);
        if (eventName.startsWith("F")) {
            if (eventName.contains("Momentary")) {
                return;
            }
            message = new StringBuilder(this.buildPacketWithChar('A'));
            try {
                if (((Boolean)event.getNewValue()).booleanValue()) {
                    message.append("F1");
                } else {
                    message.append("F0");
                }
                message.append(eventName.substring(1));
            }
            catch (ClassCastException cce) {
                log.debug("Invalid event value. {}", (Object)cce.getMessage());
            }
            catch (IndexOutOfBoundsException oob) {
                log.debug("Invalid event name. {}", (Object)oob.getMessage());
            }
            for (ControllerInterface listener : this.controllerListeners) {
                listener.sendPacketToDevice(message.toString());
            }
        }
        if (eventName.matches("SpeedSteps")) {
            message = new StringBuilder(this.buildPacketWithChar('A'));
            message.append("s");
            message.append(MultiThrottleController.encodeSpeedStepMode((SpeedStepMode)((Object)event.getNewValue())));
            for (ControllerInterface listener : this.controllerListeners) {
                listener.sendPacketToDevice(message.toString());
            }
        }
        if (eventName.matches("IsForward")) {
            message = new StringBuilder(this.buildPacketWithChar('A'));
            message.append("R");
            message.append((Boolean)event.getNewValue() != false ? "1" : "0");
            for (ControllerInterface listener : this.controllerListeners) {
                listener.sendPacketToDevice(message.toString());
            }
        }
        if (eventName.matches("SpeedSetting")) {
            float currentSpeed = ((Float)event.getNewValue()).floatValue();
            log.debug("Speed Setting: {} head of queue {}", (Object)Float.valueOf(currentSpeed), this.lastSentSpeed.peek());
            if (this.lastSentSpeed.isEmpty()) {
                StringBuilder message2 = new StringBuilder(this.buildPacketWithChar('A'));
                message2.append("V");
                message2.append(Math.round(currentSpeed / this.speedMultiplier));
                for (ControllerInterface listener : this.controllerListeners) {
                    listener.sendPacketToDevice(message2.toString());
                }
            } else if ((double)Math.abs(((Float)this.lastSentSpeed.peek()).floatValue() - currentSpeed) < 5.0E-4) {
                Float f = (Float)this.lastSentSpeed.poll();
                log.debug("removed value {} from queue", (Object)f);
            }
        }
    }

    @Override
    public void sendFunctionLabels(RosterEntry re) {
        if (re != null) {
            StringBuilder functionString = new StringBuilder(this.buildPacketWithChar('L'));
            int i = 0;
            while (i < 29) {
                functionString.append("]\\[");
                if (re.getFunctionLabel(i) != null) {
                    functionString.append(re.getFunctionLabel(i));
                }
                ++i;
            }
            for (ControllerInterface listener : this.controllerListeners) {
                listener.sendPacketToDevice(functionString.toString());
            }
        }
    }

    @Override
    public void sendAllFunctionStates(DccThrottle t) {
        log.debug("Sending state of all functions");
        int cnt = 0;
        while (cnt < 29) {
            StringBuilder message = new StringBuilder(this.buildPacketWithChar('A'));
            message.append(t.getFunction(cnt) ? "F1" : "F0");
            message.append(cnt);
            this.controllerListeners.forEach(listener -> listener.sendPacketToDevice(message.toString()));
            ++cnt;
        }
    }

    @Override
    protected synchronized void sendCurrentSpeed(DccThrottle t) {
        float currentSpeed = t.getSpeedSetting();
        StringBuilder message = new StringBuilder(this.buildPacketWithChar('A'));
        message.append("V");
        message.append(Math.round(currentSpeed / this.speedMultiplier));
        for (ControllerInterface listener : this.controllerListeners) {
            listener.sendPacketToDevice(message.toString());
        }
    }

    @Override
    protected void sendCurrentDirection(DccThrottle t) {
        StringBuilder message = new StringBuilder(this.buildPacketWithChar('A'));
        message.append("R");
        message.append(t.getIsForward() ? "1" : "0");
        for (ControllerInterface listener : this.controllerListeners) {
            listener.sendPacketToDevice(message.toString());
        }
    }

    @Override
    protected void sendSpeedStepMode(DccThrottle t) {
        StringBuilder message = new StringBuilder(this.buildPacketWithChar('A'));
        message.append("s");
        message.append(MultiThrottleController.encodeSpeedStepMode(this.throttle.getSpeedStepMode()));
        for (ControllerInterface listener : this.controllerListeners) {
            listener.sendPacketToDevice(message.toString());
        }
    }

    @Override
    protected void sendAllMomentaryStates(DccThrottle t) {
        log.debug("Sending momentary state of all functions");
        int cnt = 0;
        while (cnt < 29) {
            StringBuilder message = new StringBuilder(this.buildPacketWithChar('A'));
            message.append(t.getFunctionMomentary(cnt) ? "m1" : "m0");
            message.append(cnt);
            this.controllerListeners.forEach(listener -> listener.sendPacketToDevice(message.toString()));
            ++cnt;
        }
    }

    @Override
    public void sendAddress() {
        for (ControllerInterface listener : this.controllerListeners) {
            if (this.isAddressSet) {
                listener.sendPacketToDevice(this.buildPacketWithChar('+'));
                continue;
            }
            listener.sendPacketToDevice(this.buildPacketWithChar('-'));
        }
    }

    public void sendStealAddress() {
        StringBuilder message = new StringBuilder(this.buildPacketWithChar('S'));
        message.append(this.locoKey);
        for (ControllerInterface listener : this.controllerListeners) {
            listener.sendPacketToDevice(message.toString());
        }
    }

    @Override
    public void notifyDecisionRequired(LocoAddress address, ThrottleListener.DecisionType question) {
        if (question == ThrottleListener.DecisionType.STEAL) {
            if (this.isStealAddress) {
                InstanceManager.throttleManagerInstance().responseThrottleDecision(address, (ThrottleListener)this, ThrottleListener.DecisionType.STEAL);
                this.isStealAddress = false;
            } else {
                this.sendStealAddress();
                this.notifyFailedThrottleRequest(address, "Steal Required");
            }
        } else if (question == ThrottleListener.DecisionType.STEAL_OR_SHARE) {
            if (this.isStealAddress) {
                InstanceManager.throttleManagerInstance().responseThrottleDecision(address, (ThrottleListener)this, ThrottleListener.DecisionType.STEAL);
                this.isStealAddress = false;
            } else {
                this.sendStealAddress();
                this.notifyFailedThrottleRequest(address, "Steal Required");
            }
        } else {
            log.info("{} question not supported by WiThrottle.", (Object)question);
        }
    }

    private static String encodeSpeedStepMode(SpeedStepMode mode) {
        switch (mode) {
            case NMRA_DCC_128: {
                return "1";
            }
            case NMRA_DCC_28: {
                return "2";
            }
            case NMRA_DCC_27: {
                return "4";
            }
            case NMRA_DCC_14: {
                return "8";
            }
            case MOTOROLA_28: {
                return "16";
            }
        }
        return mode.name;
    }
}

