/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.withrottle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import jmri.InstanceManager;
import jmri.jmrit.withrottle.Bundle;
import jmri.jmrit.withrottle.ControllerInterface;
import jmri.jmrit.withrottle.MultiThrottleController;
import jmri.jmrit.withrottle.ThrottleControllerListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiThrottle {
    private ThrottleControllerListener parentTCL = null;
    private ControllerInterface parentController = null;
    char whichThrottle;
    ConcurrentHashMap<String, MultiThrottleController> throttles;
    private static final Logger log = LoggerFactory.getLogger(MultiThrottle.class);

    public MultiThrottle(char id, ThrottleControllerListener tcl, ControllerInterface ci) {
        if (log.isDebugEnabled()) {
            log.debug("Creating new MultiThrottle for id: {}", (Object)Character.valueOf(id));
        }
        this.whichThrottle = id;
        this.parentTCL = tcl;
        this.parentController = ci;
    }

    public void handleMessage(String message) {
        log.debug("MT handleMessage: {}", (Object)message);
        List<String> unit = Arrays.asList(message.substring(1).split("<;>"));
        String key = unit.get(0);
        String action = unit.get(1);
        if (key == null || action == null) {
            return;
        }
        switch (message.charAt(0)) {
            case 'A': {
                this.passActionsToControllers(key, action);
                break;
            }
            case '+': {
                this.addThrottleController(key, action);
                break;
            }
            case '-': {
                this.removeThrottleController(key, action);
                break;
            }
            case 'S': {
                this.stealThrottleController(key, action);
                break;
            }
            default: {
                log.warn("Unhandled code: {}", (Object)Character.valueOf(message.charAt(0)));
            }
        }
    }

    private MultiThrottleController createThrottleController(String key) {
        if (!this.isValidAddr(key)) {
            return null;
        }
        if (this.throttles == null) {
            this.throttles = new ConcurrentHashMap(1);
        }
        if (this.throttles.containsKey(key)) {
            log.debug("Throttle: {} already in MultiThrottle consist.", (Object)key);
            return null;
        }
        MultiThrottleController mtc = new MultiThrottleController(this.whichThrottle, key, this.parentTCL, this.parentController);
        this.throttles.put(key, mtc);
        log.debug("Throttle: {} added to MultiThrottle consist.", (Object)key);
        return mtc;
    }

    protected void addThrottleController(String key, String action) {
        MultiThrottleController mtc = this.createThrottleController(key);
        if (mtc != null) {
            mtc.sort(action);
        }
    }

    protected void stealThrottleController(String key, String action) {
        MultiThrottleController mtc = this.createThrottleController(key);
        if (mtc != null) {
            mtc.isStealAddress = true;
            mtc.sort(action);
        }
        log.debug("Throttle: {} stolen to MultiThrottle consist.", (Object)key);
    }

    private boolean isValidAddr(String key) {
        block9: {
            block10: {
                int addr;
                block7: {
                    block8: {
                        if (key.length() < 2) {
                            String msg = Bundle.getMessage("ErrorInvalidAddressFormat", key);
                            log.warn(msg);
                            this.parentController.sendAlertMessage(msg);
                            return false;
                        }
                        try {
                            addr = Integer.parseInt(key.substring(1));
                            if (key.charAt(0) != 'L') break block7;
                            if (!InstanceManager.throttleManagerInstance().canBeLongAddress(addr)) break block8;
                            return true;
                        }
                        catch (NumberFormatException numberFormatException) {
                            String msg = Bundle.getMessage("ErrorInvalidAddressFormat", key);
                            this.parentController.sendAlertMessage(msg);
                            log.warn(msg);
                            return false;
                        }
                    }
                    String msg = Bundle.getMessage("ErrorLongAddress", key);
                    log.warn(msg);
                    this.parentController.sendAlertMessage(msg);
                    return false;
                }
                if (key.charAt(0) != 'S') break block9;
                if (!InstanceManager.throttleManagerInstance().canBeShortAddress(addr)) break block10;
                return true;
            }
            String msg = Bundle.getMessage("ErrorShortAddress", key);
            log.warn(msg);
            this.parentController.sendAlertMessage(msg);
            return false;
        }
        String msg = Bundle.getMessage("ErrorInvalidAddressFormat", key);
        this.parentController.sendAlertMessage(msg);
        log.warn(msg);
        return false;
    }

    protected boolean removeThrottleController(String key, String action) {
        if (this.throttles == null) {
            log.debug("No MultiThrottle to remove {} from.", (Object)key);
            return false;
        }
        if (key.equals("*")) {
            ArrayList<String> throttleKeys = new ArrayList<String>(this.throttles.keySet());
            throttleKeys.forEach(throttle -> this.removeThrottleController((String)throttle, action));
            return true;
        }
        if (!this.throttles.containsKey(key)) {
            if (log.isDebugEnabled()) {
                log.debug("Throttle: {} not in MultiThrottle.", (Object)key);
            }
            return false;
        }
        MultiThrottleController mtc = this.throttles.get(key);
        mtc.sort(action);
        mtc.shutdownThrottle();
        mtc.removeControllerListener(this.parentController);
        mtc.removeThrottleControllerListener(this.parentTCL);
        this.throttles.remove(key);
        if (log.isDebugEnabled()) {
            log.debug("Throttle: {} removed from MultiThrottle.", (Object)key);
        }
        return true;
    }

    protected void passActionsToControllers(String key, String action) {
        if (this.throttles == null) {
            log.debug("No throttles in MultiThrottle to receive action.");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("MultiThrottle key: {}, action: {}", (Object)key, (Object)action);
        }
        if (key.equals("*")) {
            ArrayList<String> throttleKeys = new ArrayList<String>(this.throttles.keySet());
            throttleKeys.forEach(throttle -> this.passActionsToControllers((String)throttle, action));
            return;
        }
        if (this.throttles.containsKey(key)) {
            this.throttles.get(key).sort(action);
        }
    }

    public void dispose() {
        if (this.throttles == null) {
            return;
        }
        ArrayList<String> throttleKeys = new ArrayList<String>(this.throttles.keySet());
        throttleKeys.forEach(throttle -> this.removeThrottleController((String)throttle, "r"));
    }

    public void eStop() {
        if (this.throttles == null) {
            return;
        }
        ArrayList<String> throttleKeys = new ArrayList<String>(this.throttles.keySet());
        throttleKeys.forEach(throttle -> this.passActionsToControllers((String)throttle, "X"));
    }

    public void canceledThrottleRequest(String key) {
        if (this.throttles == null) {
            log.warn("No MultiThrottle to remove {} from.", (Object)key);
            return;
        }
        if (!this.throttles.containsKey(key)) {
            if (log.isDebugEnabled()) {
                log.debug("Throttle: {} not in MultiThrottle.", (Object)key);
            }
            return;
        }
        MultiThrottleController mtc = this.throttles.get(key);
        if (!mtc.isStealAddress) {
            mtc.removeControllerListener(this.parentController);
            this.throttles.remove(key);
            log.debug("Throttle: {} cancelled from MultiThrottle.", (Object)key);
        }
    }
}

