/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.withrottle;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.TimeZone;
import jmri.InstanceManager;
import jmri.Timebase;
import jmri.jmrit.withrottle.AbstractController;
import jmri.jmrit.withrottle.ControllerInterface;
import jmri.jmrit.withrottle.DeviceServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastClockController
extends AbstractController {
    private final Timebase fastClock = InstanceManager.getDefault(Timebase.class);
    private final PropertyChangeListener timeAndRateListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            log.trace("timeAndRateListener propertyChange for '{}' from '{}' to '{}'", new Object[]{e.getPropertyName(), e.getOldValue(), e.getNewValue()});
            if (!e.getPropertyName().equals("minutes")) {
                FastClockController.this.sendFastTimeAndRate();
            }
        }
    };
    private static final Logger log = LoggerFactory.getLogger(FastClockController.class);

    public FastClockController() {
        this.isValid = true;
        this.fastClock.addPropertyChangeListener(this.timeAndRateListener);
    }

    @Override
    boolean verifyCreation() {
        return this.isValid;
    }

    @Override
    void handleMessage(String message, DeviceServer deviceServer) {
        throw new UnsupportedOperationException("Not used.");
    }

    @Override
    void register() {
        throw new UnsupportedOperationException("Not used.");
    }

    @Override
    void deregister() {
        this.fastClock.removePropertyChangeListener(this.timeAndRateListener);
    }

    private long getAdjustedTime() {
        long fastClockTime = this.fastClock.getTime().getTime();
        int timeZoneOffset = TimeZone.getDefault().getOffset(fastClockTime);
        return (fastClockTime + (long)timeZoneOffset) / 1000L;
    }

    public void sendFastTimeAndRate() {
        if (this.listeners != null) {
            for (ControllerInterface listener : this.listeners) {
                listener.sendPacketToDevice("PFT" + this.getAdjustedTime() + "<;>" + this.fastClock.userGetRate());
            }
            if (!this.fastClock.getRun()) {
                for (ControllerInterface listener : this.listeners) {
                    listener.sendPacketToDevice("PFT" + this.getAdjustedTime() + "<;>" + 0.0);
                }
            }
        }
    }
}

