/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.withrottle;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import jmri.InstanceManager;
import jmri.ShutDownManager;
import jmri.UserPreferencesManager;
import jmri.jmrit.withrottle.DeviceListener;
import jmri.jmrit.withrottle.DeviceManager;
import jmri.jmrit.withrottle.DeviceServer;
import jmri.jmrit.withrottle.WiThrottlePreferences;
import jmri.util.ThreadingUtil;
import jmri.util.zeroconf.ZeroConfService;
import jmri.util.zeroconf.ZeroConfServiceEvent;
import jmri.util.zeroconf.ZeroConfServiceListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FacelessServer
implements DeviceListener,
DeviceManager,
ZeroConfServiceListener {
    private static final Logger log = LoggerFactory.getLogger(FacelessServer.class);
    UserPreferencesManager userPreferences = InstanceManager.getNullableDefault(UserPreferencesManager.class);
    int port;
    ZeroConfService service;
    boolean isListen = true;
    ServerSocket socket = null;
    private final ArrayList<DeviceServer> deviceList = new ArrayList();
    private final ArrayList<DeviceListener> deviceListenerList = new ArrayList();
    private int threadNumber = 1;
    private String rosterGroup = null;

    FacelessServer() {
        this.createServerThread();
        this.setShutDownTask();
    }

    @Override
    public void listen() {
        int socketPort = InstanceManager.getDefault(WiThrottlePreferences.class).getPort();
        try {
            this.socket = new ServerSocket(socketPort);
        }
        catch (IOException iOException) {
            log.error("New ServerSocket({}) Failed during listen()", (Object)socketPort);
            return;
        }
        this.port = this.socket.getLocalPort();
        log.debug("WiThrottle listening on TCP port: {}", (Object)this.port);
        this.service = ZeroConfService.create("_withrottle._tcp.local.", this.port);
        this.service.addEventListener(this);
        this.service.publish();
        this.addDeviceListener(this);
        while (this.isListen) {
            try {
                log.info("Creating new WiThrottle DeviceServer(socket) on port {}, waiting for incoming connection...", (Object)this.port);
                DeviceServer device = new DeviceServer(this.socket.accept(), this);
                String threadName = "DeviceServer-" + this.threadNumber++;
                Thread t = ThreadingUtil.newThread(device, threadName);
                for (DeviceListener dl : this.deviceListenerList) {
                    device.addDeviceListener(dl);
                }
                log.debug("Starting thread '{}'", (Object)threadName);
                t.start();
            }
            catch (IOException iOException) {
                if (this.isListen) {
                    log.error("Listen Failed on port {}", (Object)this.port);
                }
                return;
            }
        }
    }

    ZeroConfService getZeroConfService() {
        return this.service;
    }

    int getPort() {
        return this.port;
    }

    @Override
    public void addDeviceListener(DeviceListener dl) {
        if (!this.deviceListenerList.contains(dl)) {
            this.deviceListenerList.add(dl);
        }
    }

    @Override
    public void removeDeviceListener(DeviceListener dl) {
        if (this.deviceListenerList.contains(dl)) {
            this.deviceListenerList.remove(dl);
        }
    }

    @Override
    public void notifyDeviceConnected(DeviceServer device) {
        this.deviceList.add(device);
    }

    @Override
    public void notifyDeviceDisconnected(DeviceServer device) {
        if (this.deviceList.size() < 1) {
            return;
        }
        if (!this.deviceList.remove(device)) {
            return;
        }
        device.removeDeviceListener(this);
    }

    @Override
    public void notifyDeviceInfoChanged(DeviceServer device) {
        if (device.getUDID() != null) {
            for (DeviceServer listDevice : this.deviceList) {
                if (device == listDevice || !device.getUDID().equals(listDevice.getUDID())) continue;
                log.debug("Has duplicate of device '{}', clearing old one.", (Object)listDevice.getUDID());
                listDevice.closeThrottles();
                break;
            }
        }
    }

    public ArrayList<DeviceServer> getDeviceList() {
        return this.deviceList;
    }

    @Override
    public void notifyDeviceAddressChanged(DeviceServer device) {
    }

    @Override
    public void setSelectedRosterGroup(String group) {
        this.rosterGroup = group;
    }

    @Override
    public String getSelectedRosterGroup() {
        return this.rosterGroup;
    }

    @Override
    public void serviceQueued(ZeroConfServiceEvent se) {
    }

    @Override
    public void servicePublished(ZeroConfServiceEvent se) {
        try {
            log.info("Published ZeroConf service for '{}' on {}:{}", new Object[]{se.getService().getKey(), se.getAddress().getHostAddress(), this.port});
        }
        catch (NullPointerException ex) {
            log.error("NPE in FacelessServer.servicePublished(): {}", (Object)ex.getLocalizedMessage());
        }
    }

    void disableServer() {
        this.isListen = false;
        this.stopDevices();
        try {
            this.socket.close();
            log.debug("closed socket in ServerThread");
            this.service.stop();
        }
        catch (NullPointerException nullPointerException) {
            log.debug("NPE while attempting to close socket, ignored");
        }
        catch (IOException iOException) {
            log.error("socket in ServerThread won't close");
        }
    }

    private void stopDevices() {
        int cnt = 0;
        if (this.deviceList.size() > 0) {
            do {
                DeviceServer device;
                if ((device = this.deviceList.get(0)) == null) continue;
                device.closeThrottles();
                device.closeSocket();
                if (++cnt > 200) break;
            } while (!this.deviceList.isEmpty());
        }
        this.deviceList.clear();
    }

    private void setShutDownTask() {
        InstanceManager.getDefault(ShutDownManager.class).register(this::disableServer);
    }

    @Override
    public void serviceUnpublished(ZeroConfServiceEvent se) {
    }
}

