/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.withrottle;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TimerTask;
import jmri.CommandStation;
import jmri.DccLocoAddress;
import jmri.InstanceManager;
import jmri.ThrottleListener;
import jmri.Version;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.withrottle.ConsistController;
import jmri.jmrit.withrottle.ControllerInterface;
import jmri.jmrit.withrottle.DeviceListener;
import jmri.jmrit.withrottle.DeviceManager;
import jmri.jmrit.withrottle.FastClockController;
import jmri.jmrit.withrottle.MultiThrottle;
import jmri.jmrit.withrottle.MultiThrottleController;
import jmri.jmrit.withrottle.RouteController;
import jmri.jmrit.withrottle.ThrottleController;
import jmri.jmrit.withrottle.ThrottleControllerListener;
import jmri.jmrit.withrottle.TrackPowerController;
import jmri.jmrit.withrottle.TurnoutController;
import jmri.jmrit.withrottle.WiThrottleManager;
import jmri.jmrit.withrottle.WiThrottlePreferences;
import jmri.util.StringUtil;
import jmri.util.ThreadingUtil;
import jmri.util.TimerUtil;
import jmri.web.server.WebServerPreferences;
import jmri.web.servlet.ServletUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceServer
implements Runnable,
ThrottleControllerListener,
ControllerInterface {
    private static final String VERSION_NUMBER = "2.0";
    private Socket device;
    private final CommandStation cmdStation = InstanceManager.getNullableDefault(CommandStation.class);
    String newLine = System.getProperty("line.separator");
    BufferedReader in = null;
    PrintStream out = null;
    private final ArrayList<DeviceListener> listeners = new ArrayList();
    String deviceName = "Unknown";
    String deviceUDID;
    ThrottleController throttleController;
    ThrottleController secondThrottleController;
    HashMap<Character, MultiThrottle> multiThrottles;
    private boolean keepReading;
    private boolean isUsingHeartbeat = false;
    private boolean heartbeat = true;
    private int pulseInterval = 16;
    private TimerTask ekgTask;
    private int stopEKGCount;
    private TrackPowerController trackPower = null;
    final boolean isTrackPowerAllowed = InstanceManager.getDefault(WiThrottlePreferences.class).isAllowTrackPower();
    private TurnoutController turnoutC = null;
    private RouteController routeC = null;
    final boolean isTurnoutAllowed = InstanceManager.getDefault(WiThrottlePreferences.class).isAllowTurnout();
    final boolean isRouteAllowed = InstanceManager.getDefault(WiThrottlePreferences.class).isAllowRoute();
    private ConsistController consistC = null;
    private boolean isConsistAllowed;
    private FastClockController fastClockC = null;
    final boolean isClockDisplayed = InstanceManager.getDefault(WiThrottlePreferences.class).isDisplayFastClock();
    final String railroadName = InstanceManager.getDefault(ServletUtil.class).getRailroadName(false);
    private DeviceManager manager;
    private static final Logger log = LoggerFactory.getLogger(DeviceServer.class);

    DeviceServer(Socket socket, DeviceManager manager) {
        this.device = socket;
        this.manager = manager;
        try {
            if (log.isDebugEnabled()) {
                log.debug("Creating input  stream reader for {}", (Object)this.device.getRemoteSocketAddress());
            }
            this.in = new BufferedReader(new InputStreamReader(this.device.getInputStream(), "UTF8"));
            if (log.isDebugEnabled()) {
                log.debug("Creating output stream writer for {}", (Object)this.device.getRemoteSocketAddress());
            }
            this.out = new PrintStream(this.device.getOutputStream(), true, "UTF8");
        }
        catch (IOException iOException) {
            log.error("Stream creation failed (DeviceServer)");
            return;
        }
        this.sendPacketToDevice("VN" + DeviceServer.getWiTVersion());
        this.sendPacketToDevice("HTJMRI");
        this.sendPacketToDevice("HtJMRI " + Version.getCanonicalVersion() + " " + this.railroadName);
        this.sendPacketToDevice(this.sendRoster());
        this.addControllers();
        this.sendPacketToDevice("PW" + DeviceServer.getWebServerPort());
    }

    @Override
    public void run() {
        int i = 0;
        while (i < this.listeners.size()) {
            DeviceListener l = this.listeners.get(i);
            log.debug("Notify Device Add");
            l.notifyDeviceConnected(this);
            ++i;
        }
        String inPackage = null;
        this.keepReading = true;
        int consecutiveErrors = 0;
        do {
            try {
                inPackage = this.in.readLine();
                if (inPackage != null) {
                    this.heartbeat = true;
                    consecutiveErrors = 0;
                    if (log.isDebugEnabled()) {
                        String s = String.valueOf(inPackage) + "                    ";
                        s = s.substring(0, Math.max(inPackage.length(), 20));
                        log.debug("Rcvd: {} from {}{}", new Object[]{s, this.getName(), this.device.getRemoteSocketAddress()});
                    }
                    block2 : switch (inPackage.charAt(0)) {
                        case 'T': {
                            if (this.throttleController == null) {
                                this.throttleController = new ThrottleController('T', this, this);
                            }
                            this.keepReading = this.throttleController.sort(inPackage.substring(1));
                            break;
                        }
                        case 'S': {
                            if (this.secondThrottleController == null) {
                                this.secondThrottleController = new ThrottleController('S', this, this);
                            }
                            this.keepReading = this.secondThrottleController.sort(inPackage.substring(1));
                            break;
                        }
                        case 'M': {
                            char id;
                            if (this.multiThrottles == null) {
                                this.multiThrottles = new HashMap(1);
                            }
                            if (!this.multiThrottles.containsKey(Character.valueOf(id = inPackage.charAt(1)))) {
                                this.multiThrottles.put(Character.valueOf(id), new MultiThrottle(id, this, this));
                            }
                            this.multiThrottles.get(Character.valueOf(id)).handleMessage(inPackage.substring(2));
                            break;
                        }
                        case 'D': {
                            if (log.isDebugEnabled()) {
                                log.debug("Sending hex packet: {} to command station.", (Object)inPackage.substring(2));
                            }
                            int repeats = Character.getNumericValue(inPackage.charAt(1));
                            byte[] packet = StringUtil.bytesFromHexString(inPackage.substring(2));
                            this.cmdStation.sendPacket(packet, repeats);
                            break;
                        }
                        case '*': {
                            if (inPackage.length() <= 1) break;
                            switch (inPackage.charAt(1)) {
                                case '+': {
                                    if (this.isUsingHeartbeat) break block2;
                                    this.startEKG();
                                    break;
                                }
                                case '-': {
                                    if (!this.isUsingHeartbeat) break block2;
                                    this.stopEKG();
                                    break;
                                }
                                default: {
                                    log.warn("Unhandled code: {}", (Object)Character.valueOf(inPackage.charAt(1)));
                                    break;
                                }
                            }
                            break;
                        }
                        case 'C': {
                            switch (inPackage.charAt(1)) {
                                case 'T': {
                                    this.keepReading = this.throttleController.sort(inPackage.substring(2));
                                    break block2;
                                }
                            }
                            log.warn("Received unknown network package: {}", (Object)inPackage);
                            break;
                        }
                        case 'N': {
                            this.deviceName = inPackage.substring(1);
                            log.info("Received Name: {}", (Object)this.deviceName);
                            if (!InstanceManager.getDefault(WiThrottlePreferences.class).isUseEStop()) break;
                            this.pulseInterval = InstanceManager.getDefault(WiThrottlePreferences.class).getEStopDelay();
                            this.sendPacketToDevice("*" + this.pulseInterval);
                            break;
                        }
                        case 'H': {
                            switch (inPackage.charAt(1)) {
                                case 'U': {
                                    this.deviceUDID = inPackage.substring(2);
                                    int i2 = 0;
                                    while (i2 < this.listeners.size()) {
                                        DeviceListener l = this.listeners.get(i2);
                                        l.notifyDeviceInfoChanged(this);
                                        ++i2;
                                    }
                                    break block2;
                                }
                                default: {
                                    log.warn("Unhandled code: {}", (Object)Character.valueOf(inPackage.charAt(1)));
                                    break;
                                }
                            }
                            break;
                        }
                        case 'P': {
                            switch (inPackage.charAt(1)) {
                                case 'P': {
                                    if (!this.isTrackPowerAllowed) break block2;
                                    this.trackPower.handleMessage(inPackage.substring(2), this);
                                    break;
                                }
                                case 'T': {
                                    if (!this.isTurnoutAllowed) break block2;
                                    this.turnoutC.handleMessage(inPackage.substring(2), this);
                                    break;
                                }
                                case 'R': {
                                    if (!this.isRouteAllowed) break block2;
                                    this.routeC.handleMessage(inPackage.substring(2), this);
                                    break;
                                }
                                default: {
                                    log.warn("Unhandled code: {}", (Object)Character.valueOf(inPackage.charAt(1)), (Object)this);
                                    break;
                                }
                            }
                            break;
                        }
                        case 'R': {
                            switch (inPackage.charAt(1)) {
                                case 'C': {
                                    if (!this.isConsistAllowed) break block2;
                                    this.consistC.handleMessage(inPackage.substring(2), this);
                                    break;
                                }
                                default: {
                                    log.warn("Unhandled code: {}", (Object)Character.valueOf(inPackage.charAt(1)));
                                    break;
                                }
                            }
                            break;
                        }
                        case 'Q': {
                            this.keepReading = false;
                            break;
                        }
                        default: {
                            log.warn("Received unknown network package: {}", (Object)inPackage);
                        }
                    }
                    inPackage = null;
                } else {
                    log.warn("null readLine() from device '{}', consecutive error # {}", (Object)this.getName(), (Object)(++consecutiveErrors));
                }
            }
            catch (IOException iOException) {
                log.warn("readLine from device '{}' failed, consecutive error # {}", (Object)this.getName(), (Object)(++consecutiveErrors));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                log.warn("Bad message '{}' from device '{}'", (Object)inPackage, (Object)this.getName());
            }
            if (consecutiveErrors <= 0) continue;
            if (consecutiveErrors < 25) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            this.keepReading = false;
            log.error("readLine failure limit exceeded, ending thread run loop for device '{}'", (Object)this.getName());
        } while (this.keepReading);
        log.debug("Ending thread run loop for device '{}'", (Object)this.getName());
        this.closeThrottles();
    }

    public void closeThrottles() {
        this.stopEKG();
        if (this.throttleController != null) {
            this.throttleController.shutdownThrottle();
            this.throttleController.removeThrottleControllerListener(this);
            this.throttleController.removeControllerListener(this);
        }
        if (this.secondThrottleController != null) {
            this.secondThrottleController.shutdownThrottle();
            this.secondThrottleController.removeThrottleControllerListener(this);
            this.secondThrottleController.removeControllerListener(this);
        }
        if (this.multiThrottles != null) {
            for (char key : this.multiThrottles.keySet()) {
                log.debug("Closing throttles for key: {} for device: {}", (Object)Character.valueOf(key), (Object)this.getName());
                this.multiThrottles.get(Character.valueOf(key)).dispose();
            }
        }
        if (this.multiThrottles != null) {
            this.multiThrottles.clear();
            this.multiThrottles = null;
        }
        this.throttleController = null;
        this.secondThrottleController = null;
        if (this.trackPower != null) {
            this.trackPower.removeControllerListener(this);
        }
        if (this.turnoutC != null) {
            this.turnoutC.removeControllerListener(this);
        }
        if (this.routeC != null) {
            this.routeC.removeControllerListener(this);
        }
        if (this.consistC != null) {
            this.consistC.removeControllerListener(this);
        }
        if (this.fastClockC != null) {
            this.fastClockC.removeControllerListener(this);
        }
        this.closeSocket();
        int i = 0;
        while (i < this.listeners.size()) {
            DeviceListener l = this.listeners.get(i);
            l.notifyDeviceDisconnected(this);
            ++i;
        }
    }

    public void closeSocket() {
        block6: {
            this.keepReading = false;
            try {
                if (this.device.isClosed()) {
                    if (log.isDebugEnabled()) {
                        log.debug("device socket {}{} already closed.", (Object)this.getName(), (Object)this.device.getRemoteSocketAddress());
                    }
                } else {
                    this.device.close();
                    if (log.isDebugEnabled()) {
                        log.debug("device socket {}{} closed.", (Object)this.getName(), (Object)this.device.getRemoteSocketAddress());
                    }
                }
            }
            catch (IOException iOException) {
                if (!log.isDebugEnabled()) break block6;
                log.debug("device socket {}{} close failed with IOException.", (Object)this.getName(), (Object)this.device.getRemoteSocketAddress());
            }
        }
    }

    public void startEKG() {
        log.debug("starting heartbeat EKG for '{}' with interval: {}", (Object)this.getName(), (Object)this.pulseInterval);
        this.isUsingHeartbeat = true;
        this.stopEKGCount = 0;
        this.ekgTask = new TimerTask(){

            @Override
            public void run() {
                ThreadingUtil.runOnLayout(() -> {
                    if (!DeviceServer.this.heartbeat) {
                        DeviceServer deviceServer = DeviceServer.this;
                        deviceServer.stopEKGCount = deviceServer.stopEKGCount + 1;
                        if (log.isDebugEnabled()) {
                            log.debug("Lost signal from: {}, sending eStop", (Object)DeviceServer.this.getName());
                        }
                        if (DeviceServer.this.throttleController != null) {
                            DeviceServer.this.throttleController.sort("X");
                        }
                        if (DeviceServer.this.secondThrottleController != null) {
                            DeviceServer.this.secondThrottleController.sort("X");
                        }
                        if (DeviceServer.this.multiThrottles != null) {
                            for (char key : DeviceServer.this.multiThrottles.keySet()) {
                                if (log.isDebugEnabled()) {
                                    log.debug("Sending eStop to MT key: {}", (Object)Character.valueOf(key));
                                }
                                DeviceServer.this.multiThrottles.get(Character.valueOf(key)).eStop();
                            }
                        }
                        if (DeviceServer.this.stopEKGCount > 2) {
                            DeviceServer.this.closeThrottles();
                        }
                    }
                    DeviceServer.this.heartbeat = false;
                });
            }
        };
        TimerUtil.scheduleAtFixedRate(this.ekgTask, (long)this.pulseInterval * 900L, (long)this.pulseInterval * 900L);
    }

    public void stopEKG() {
        this.isUsingHeartbeat = false;
        if (this.ekgTask != null) {
            this.ekgTask.cancel();
        }
    }

    private void addControllers() {
        if (this.isTrackPowerAllowed) {
            this.trackPower = InstanceManager.getDefault(WiThrottleManager.class).getTrackPowerController();
            if (this.trackPower.isValid) {
                if (log.isDebugEnabled()) {
                    log.debug("Track Power valid.");
                }
                this.trackPower.addControllerListener(this);
                this.trackPower.sendCurrentState();
            }
        }
        if (this.isTurnoutAllowed) {
            this.turnoutC = InstanceManager.getDefault(WiThrottleManager.class).getTurnoutController();
            if (this.turnoutC.verifyCreation()) {
                if (log.isDebugEnabled()) {
                    log.debug("Turnout Controller valid.");
                }
                this.turnoutC.addControllerListener(this);
                this.turnoutC.sendTitles();
                this.turnoutC.sendList();
            }
        }
        if (this.isRouteAllowed) {
            this.routeC = InstanceManager.getDefault(WiThrottleManager.class).getRouteController();
            if (this.routeC.verifyCreation()) {
                if (log.isDebugEnabled()) {
                    log.debug("Route Controller valid.");
                }
                this.routeC.addControllerListener(this);
                this.routeC.sendTitles();
                this.routeC.sendList();
            }
        }
        this.consistC = InstanceManager.getDefault(WiThrottleManager.class).getConsistController();
        if (this.consistC.verifyCreation()) {
            if (log.isDebugEnabled()) {
                log.debug("Consist Controller valid.");
            }
            this.isConsistAllowed = InstanceManager.getDefault(WiThrottlePreferences.class).isAllowConsist();
            this.consistC.addControllerListener(this);
            this.consistC.setIsConsistAllowed(this.isConsistAllowed);
            this.consistC.sendConsistListType();
            this.consistC.sendAllConsistData();
        }
        if (this.isClockDisplayed) {
            this.fastClockC = InstanceManager.getDefault(WiThrottleManager.class).getFastClockController();
            if (this.fastClockC.verifyCreation()) {
                if (log.isDebugEnabled()) {
                    log.debug("Fast Clock Controller valid.");
                }
                this.fastClockC.addControllerListener(this);
                this.fastClockC.sendFastTimeAndRate();
            }
        }
    }

    public String getUDID() {
        return this.deviceUDID;
    }

    public String getName() {
        return this.deviceName;
    }

    public String getCurrentAddressString() {
        StringBuilder s = new StringBuilder("");
        if (this.throttleController != null) {
            s.append(this.throttleController.getCurrentAddressString());
            s.append(" ");
        }
        if (this.secondThrottleController != null) {
            s.append(this.secondThrottleController.getCurrentAddressString());
            s.append(" ");
        }
        if (this.multiThrottles != null) {
            for (MultiThrottle mt : this.multiThrottles.values()) {
                if (mt.throttles == null) continue;
                for (MultiThrottleController mtc : mt.throttles.values()) {
                    s.append(mtc.getCurrentAddressString());
                    s.append(" ");
                }
            }
        }
        return s.toString();
    }

    public String getCurrentRosterIdString() {
        StringBuilder s = new StringBuilder("");
        if (this.throttleController != null) {
            s.append(this.throttleController.getCurrentRosterIdString());
            s.append(" ");
        }
        if (this.secondThrottleController != null) {
            s.append(this.secondThrottleController.getCurrentRosterIdString());
            s.append(" ");
        }
        if (this.multiThrottles != null) {
            for (MultiThrottle mt : this.multiThrottles.values()) {
                if (mt.throttles == null) continue;
                for (MultiThrottleController mtc : mt.throttles.values()) {
                    s.append(mtc.getCurrentRosterIdString());
                    s.append(" ");
                }
            }
        }
        return s.toString();
    }

    public static String getWiTVersion() {
        return VERSION_NUMBER;
    }

    public static String getWebServerPort() {
        return Integer.toString(InstanceManager.getDefault(WebServerPreferences.class).getPort());
    }

    @Override
    public void sendPacketToDevice(String message) {
        if (message == null) {
            return;
        }
        this.out.println(String.valueOf(message) + this.newLine);
        if (log.isDebugEnabled()) {
            String s = String.valueOf(message) + "                    ";
            s = s.substring(0, Math.max(message.length(), 20));
            log.debug("Sent: {}  to  {}{}", new Object[]{s, this.getName(), this.device.getRemoteSocketAddress()});
        }
    }

    @Override
    public void sendAlertMessage(String message) {
        this.sendPacketToDevice("HM" + message);
    }

    @Override
    public void sendInfoMessage(String message) {
        this.sendPacketToDevice("Hm" + message);
    }

    public void addDeviceListener(DeviceListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeDeviceListener(DeviceListener l) {
        if (this.listeners.contains(l)) {
            this.listeners.remove(l);
        }
    }

    @Override
    public void notifyControllerAddressFound(ThrottleController TC) {
        int i = 0;
        while (i < this.listeners.size()) {
            DeviceListener l = this.listeners.get(i);
            l.notifyDeviceAddressChanged(this);
            if (log.isDebugEnabled()) {
                log.debug("Notify DeviceListener: {} address: {}", l.getClass(), (Object)TC.getCurrentAddressString());
            }
            ++i;
        }
    }

    @Override
    public void notifyControllerAddressReleased(ThrottleController TC) {
        int i = 0;
        while (i < this.listeners.size()) {
            DeviceListener l = this.listeners.get(i);
            l.notifyDeviceAddressChanged(this);
            if (log.isDebugEnabled()) {
                log.debug("Notify DeviceListener: {} address: {}", l.getClass(), (Object)TC.getCurrentAddressString());
            }
            ++i;
        }
    }

    @Override
    public void notifyControllerAddressDeclined(ThrottleController tc, DccLocoAddress address, String reason) {
        log.warn("notifyControllerAddressDeclined: {}", (Object)reason);
        this.sendAlertMessage(reason);
        if (this.multiThrottles != null) {
            InstanceManager.throttleManagerInstance().cancelThrottleRequest(address, (ThrottleListener)tc);
            this.multiThrottles.get(Character.valueOf(tc.whichThrottle)).canceledThrottleRequest(tc.locoKey);
        }
    }

    public String sendRoster() {
        List<RosterEntry> rosterList = Roster.getDefault().getEntriesInGroup(this.manager.getSelectedRosterGroup());
        StringBuilder rosterString = new StringBuilder(rosterList.size() * 25);
        for (RosterEntry entry : rosterList) {
            StringBuilder entryInfo = new StringBuilder(entry.getId());
            entryInfo.append("}|{");
            entryInfo.append(entry.getDccAddress());
            if (entry.isLongAddress()) {
                entryInfo.append("}|{L");
            } else {
                entryInfo.append("}|{S");
            }
            rosterString.append("]\\[");
            rosterString.append((CharSequence)entryInfo);
        }
        rosterString.trimToSize();
        return "RL" + rosterList.size() + rosterString;
    }
}

