/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.withrottle;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jmri.InstanceManager;
import jmri.Route;
import jmri.RouteManager;
import jmri.Turnout;
import jmri.TurnoutManager;
import jmri.configurexml.StoreXmlUserAction;
import jmri.jmrit.withrottle.Bundle;
import jmri.util.JmriJFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerFilterFrame
extends JmriJFrame
implements TableModelListener {
    private static final String[] COLUMN_NAMES = new String[]{Bundle.getMessage("ColumnSystemName"), Bundle.getMessage("ColumnUserName"), Bundle.getMessage("Include")};
    private static final Logger log = LoggerFactory.getLogger(ControllerFilterFrame.class);

    public ControllerFilterFrame() {
        super(Bundle.getMessage("TitleControlsFilter"), true, true);
    }

    @Override
    public void initComponents() {
        JTabbedPane tabbedPane = new JTabbedPane();
        if (InstanceManager.getNullableDefault(TurnoutManager.class) != null) {
            tabbedPane.addTab(Bundle.getMessage("Turnouts"), null, this.addTurnoutPanel(), Bundle.getMessage("ToolTipTurnoutTab"));
        }
        if (InstanceManager.getNullableDefault(RouteManager.class) != null) {
            tabbedPane.addTab(Bundle.getMessage("LabelRoute"), null, this.addRoutePanel(), Bundle.getMessage("ToolTipRouteTab"));
        }
        this.add(tabbedPane);
        this.pack();
        this.addHelpMenu("package.jmri.jmrit.withrottle.UserInterface", true);
    }

    private JPanel addTurnoutPanel() {
        JPanel tPanel = new JPanel(new BorderLayout());
        JLabel label = new JLabel(Bundle.getMessage("LabelTurnoutTab"), 0);
        tPanel.add((Component)label, "North");
        tPanel.add((Component)this.addCancelSavePanel(), "West");
        TurnoutFilterModel filterModel = new TurnoutFilterModel();
        JTable table = new JTable(filterModel);
        this.buildTable(table);
        JScrollPane scrollPane = new JScrollPane(table);
        tPanel.add((Component)scrollPane, "Center");
        tPanel.add((Component)this.getIncludeButtonsPanel(filterModel), "South");
        return tPanel;
    }

    private JPanel addRoutePanel() {
        JPanel tPanel = new JPanel(new BorderLayout());
        JLabel label = new JLabel(Bundle.getMessage("LabelRouteTab"), 0);
        tPanel.add((Component)label, "North");
        tPanel.add((Component)this.addCancelSavePanel(), "West");
        RouteFilterModel filterModel = new RouteFilterModel();
        JTable table = new JTable(filterModel);
        this.buildTable(table);
        JScrollPane scrollPane = new JScrollPane(table);
        tPanel.add((Component)scrollPane, "Center");
        tPanel.add((Component)this.getIncludeButtonsPanel(filterModel), "South");
        return tPanel;
    }

    private void buildTable(JTable table) {
        table.getModel().addTableModelListener(this);
        table.setRowSelectionAllowed(false);
        table.setPreferredScrollableViewportSize(new Dimension(580, 240));
        table.setShowGrid(false);
        table.setShowHorizontalLines(true);
        table.setGridColor(Color.gray);
        table.setRowHeight(30);
        TableColumnModel columnModel = table.getColumnModel();
        TableColumn include = columnModel.getColumn(2);
        include.setResizable(false);
        include.setMinWidth(60);
        include.setMaxWidth(70);
        TableColumn sName = columnModel.getColumn(0);
        sName.setResizable(true);
        sName.setMinWidth(80);
        sName.setPreferredWidth(80);
        sName.setMaxWidth(340);
        TableColumn uName = columnModel.getColumn(1);
        uName.setResizable(true);
        uName.setMinWidth(180);
        uName.setPreferredWidth(300);
        uName.setMaxWidth(440);
    }

    private JPanel getIncludeButtonsPanel(AbstractFilterModel fm) {
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 0));
        pane.add(Box.createHorizontalGlue());
        JButton selectAllButton = new JButton(Bundle.getMessage("ButtonSelectAll"));
        selectAllButton.addActionListener(event -> fm.setIncludeColToValue(true));
        pane.add(selectAllButton);
        JButton deselectAllButton = new JButton(Bundle.getMessage("ButtonDeselectAll"));
        deselectAllButton.addActionListener(event -> fm.setIncludeColToValue(false));
        pane.add(deselectAllButton);
        JButton selectUserNamedButton = new JButton(Bundle.getMessage("ButtonSelectByUserName"));
        selectUserNamedButton.addActionListener(event -> fm.setIncludeToUserNamed());
        pane.add(selectUserNamedButton);
        return pane;
    }

    private JPanel addCancelSavePanel() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(Box.createVerticalGlue());
        JButton cancelButton = new JButton(Bundle.getMessage("ButtonCancel"));
        cancelButton.setAlignmentX(0.5f);
        cancelButton.setToolTipText(Bundle.getMessage("ToolTipCancel"));
        cancelButton.addActionListener(event -> this.dispose());
        p.add(cancelButton);
        JButton saveButton = new JButton(Bundle.getMessage("ButtonSave"));
        saveButton.setAlignmentX(0.5f);
        saveButton.setToolTipText(Bundle.getMessage("ToolTipSave"));
        saveButton.addActionListener(event -> {
            this.storeValues();
            this.dispose();
        });
        p.add(saveButton);
        return p;
    }

    @Override
    protected void storeValues() {
        new StoreXmlUserAction().actionPerformed(null);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (log.isDebugEnabled()) {
            log.debug("Set mod flag true for: {}", (Object)this.getTitle());
        }
        this.setModifiedFlag(true);
    }

    public abstract class AbstractFilterModel
    extends AbstractTableModel
    implements PropertyChangeListener {
        List<String> sysNameList = null;
        boolean isDirty;
        public static final int SNAMECOL = 0;
        public static final int UNAMECOL = 1;
        public static final int INCLUDECOL = 2;

        @Override
        public Class<?> getColumnClass(int c) {
            if (c == 2) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("length")) {
                this.fireTableDataChanged();
            }
        }

        public void dispose() {
            InstanceManager.turnoutManagerInstance().removePropertyChangeListener(this);
            InstanceManager.getDefault(RouteManager.class).removePropertyChangeListener(this);
        }

        @Override
        public String getColumnName(int c) {
            return COLUMN_NAMES[c];
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.sysNameList.size();
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            return c == 2;
        }

        abstract void setIncludeColToValue(boolean var1);

        abstract void setIncludeToUserNamed();
    }

    class RouteFilterModel
    extends AbstractFilterModel {
        RouteManager mgr = InstanceManager.getDefault(RouteManager.class);

        RouteFilterModel() {
            this.sysNameList = new ArrayList(this.mgr.getNamedBeanSet().size());
            this.mgr.getNamedBeanSet().forEach(bean -> this.sysNameList.add(bean.getSystemName()));
            this.mgr.addPropertyChangeListener(this);
        }

        @Override
        public Object getValueAt(int r, int c) {
            if (r >= this.sysNameList.size()) {
                log.debug("row is greater than turnout list size");
                return null;
            }
            Route rt = this.mgr.getBySystemName((String)this.sysNameList.get(r));
            switch (c) {
                case 2: {
                    if (rt == null) {
                        return null;
                    }
                    Object o = rt.getProperty("WifiControllable");
                    if (o != null) {
                        return Boolean.valueOf(o.toString());
                    }
                    return true;
                }
                case 0: {
                    return this.sysNameList.get(r);
                }
                case 1: {
                    if (rt == null) {
                        return null;
                    }
                    return rt.getUserName();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object type, int r, int c) {
            switch (c) {
                case 2: {
                    Route rt = this.mgr.getBySystemName((String)this.sysNameList.get(r));
                    if (rt == null) break;
                    rt.setProperty("WifiControllable", type);
                    if (this.isDirty) break;
                    this.fireTableChanged(new TableModelEvent(this));
                    this.isDirty = true;
                    break;
                }
                default: {
                    log.warn("Unhandled col: {}", (Object)c);
                }
            }
        }

        @Override
        public void setIncludeColToValue(boolean value) {
            for (String sysName : this.sysNameList) {
                Route rt = this.mgr.getBySystemName(sysName);
                if (rt == null) continue;
                rt.setProperty("WifiControllable", value);
            }
            this.fireTableDataChanged();
        }

        @Override
        public void setIncludeToUserNamed() {
            for (String sysName : this.sysNameList) {
                Route bean = this.mgr.getBySystemName(sysName);
                if (bean != null) {
                    String uname = bean.getUserName();
                    if (uname != null && uname.length() > 0) {
                        bean.setProperty("WifiControllable", true);
                        continue;
                    }
                    bean.setProperty("WifiControllable", false);
                    continue;
                }
                log.error("Failed to get bean from getBySystemName {}", (Object)sysName);
            }
            this.fireTableDataChanged();
        }
    }

    class TurnoutFilterModel
    extends AbstractFilterModel {
        TurnoutManager mgr = InstanceManager.turnoutManagerInstance();

        TurnoutFilterModel() {
            this.sysNameList = new ArrayList(this.mgr.getNamedBeanSet().size());
            this.mgr.getNamedBeanSet().forEach(bean -> this.sysNameList.add(bean.getSystemName()));
            this.mgr.addPropertyChangeListener(this);
        }

        @Override
        public Object getValueAt(int r, int c) {
            if (r >= this.sysNameList.size()) {
                log.debug("row is greater than turnout list size");
                return null;
            }
            Turnout t = this.mgr.getBySystemName((String)this.sysNameList.get(r));
            switch (c) {
                case 2: {
                    Object o;
                    if (t != null && (o = t.getProperty("WifiControllable")) != null) {
                        return Boolean.valueOf(o.toString());
                    }
                    return true;
                }
                case 0: {
                    return this.sysNameList.get(r);
                }
                case 1: {
                    return t != null ? t.getUserName() : null;
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object type, int r, int c) {
            Turnout t = this.mgr.getBySystemName((String)this.sysNameList.get(r));
            if (t != null) {
                switch (c) {
                    case 2: {
                        t.setProperty("WifiControllable", type);
                        if (this.isDirty) break;
                        this.fireTableChanged(new TableModelEvent(this));
                        this.isDirty = true;
                        break;
                    }
                    default: {
                        log.warn("Unhandled col: {}", (Object)c);
                    }
                }
            }
        }

        @Override
        public void setIncludeColToValue(boolean value) {
            for (String sysName : this.sysNameList) {
                Turnout t = this.mgr.getBySystemName(sysName);
                if (t == null) continue;
                t.setProperty("WifiControllable", value);
            }
            this.fireTableDataChanged();
        }

        @Override
        public void setIncludeToUserNamed() {
            for (String sysName : this.sysNameList) {
                Turnout t = this.mgr.getBySystemName(sysName);
                if (t == null) continue;
                String uname = t.getUserName();
                if (uname != null && uname.length() > 0) {
                    t.setProperty("WifiControllable", true);
                    continue;
                }
                t.setProperty("WifiControllable", false);
            }
            this.fireTableDataChanged();
        }
    }
}

