/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.withrottle;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jmri.AddressedProgrammer;
import jmri.AddressedProgrammerManager;
import jmri.Consist;
import jmri.ConsistManager;
import jmri.DccLocoAddress;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.ProgListener;
import jmri.ProgrammerException;
import jmri.jmrit.consisttool.ConsistFile;
import jmri.jmrit.withrottle.AbstractController;
import jmri.jmrit.withrottle.ControllerInterface;
import jmri.jmrit.withrottle.DeviceServer;
import jmri.jmrit.withrottle.WiFiConsistFile;
import jmri.jmrit.withrottle.WiFiConsistManager;
import jmri.jmrit.withrottle.WiThrottlePreferences;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsistController
extends AbstractController
implements ProgListener {
    private ConsistManager manager;
    private ConsistFile file;
    private boolean isConsistAllowed;
    private static final Logger log = LoggerFactory.getLogger(ConsistController.class);

    public ConsistController() {
        if (InstanceManager.getDefault(WiThrottlePreferences.class).isUseWiFiConsist()) {
            try {
                this.manager = new WiFiConsistManager();
                InstanceManager.store(this.manager, ConsistManager.class);
                log.debug("Using WiFiConsisting");
            }
            catch (NullPointerException nullPointerException) {
                log.error("Attempting to use WiFiConsisting, but no Command Station available");
                this.manager = null;
            }
        } else {
            this.manager = InstanceManager.getNullableDefault(ConsistManager.class);
            log.debug("Using JMRIConsisting");
        }
        if (this.manager == null) {
            log.info("No consist manager instance.");
            this.isValid = false;
        } else {
            if (InstanceManager.getDefault(WiThrottlePreferences.class).isUseWiFiConsist()) {
                this.file = new WiFiConsistFile(this.manager);
            } else {
                this.file = new ConsistFile();
                try {
                    this.file.readFile();
                }
                catch (IOException | JDOMException e) {
                    log.warn("error reading consist file: {}", (Object)e);
                }
            }
            this.isValid = true;
        }
    }

    public void sendConsistListType() {
        if (this.listeners == null) {
            return;
        }
        int numConsists = this.manager.getConsistList().size();
        if (log.isDebugEnabled()) {
            log.debug("{} consists found.", (Object)numConsists);
        }
        String message = this.isConsistAllowed ? "RCC" + numConsists : "RCL" + numConsists;
        for (ControllerInterface listener : this.listeners) {
            listener.sendPacketToDevice(message);
        }
    }

    public void sendAllConsistData() {
        for (LocoAddress conAddr : this.manager.getConsistList()) {
            this.sendDataForConsist(this.manager.getConsist(conAddr));
        }
    }

    public void sendDataForConsist(Consist con) {
        if (this.listeners == null) {
            return;
        }
        StringBuilder list = new StringBuilder("RCD");
        list.append("}|{");
        list.append(con.getConsistAddress());
        list.append("}|{");
        if (con.getConsistID().length() > 0) {
            list.append(con.getConsistID());
        }
        for (DccLocoAddress loco : con.getConsistList()) {
            list.append("]\\[");
            list.append(loco.toString());
            list.append("}|{");
            list.append(con.getLocoDirection(loco));
        }
        String message = list.toString();
        for (ControllerInterface listener : this.listeners) {
            listener.sendPacketToDevice(message);
        }
    }

    public void setIsConsistAllowed(boolean b) {
        this.isConsistAllowed = b;
    }

    @Override
    boolean verifyCreation() {
        return this.isValid;
    }

    @Override
    void handleMessage(String message, DeviceServer deviceServer) {
        try {
            if (message.charAt(0) == 'P') {
                this.reorderConsist(message);
            }
            if (message.charAt(0) == 'R') {
                this.removeConsist(message);
            }
            if (message.charAt(0) == '+') {
                this.addLoco(message);
            }
            if (message.charAt(0) == '-') {
                this.removeLoco(message);
            }
            if (message.charAt(0) == 'F') {
                this.setConsistCVs(message);
            }
        }
        catch (NullPointerException nullPointerException) {
            log.warn("Message \"{}\" does not match a consist command.", (Object)message);
        }
    }

    private void reorderConsist(String message) {
        List<String> headerAndLocos = Arrays.asList(message.split("<:>"));
        if (headerAndLocos.size() < 2) {
            log.warn("reorderConsist missing data in message: {}", (Object)message);
            return;
        }
        try {
            List<String> headerData = Arrays.asList(headerAndLocos.get(0).split("<;>"));
            Consist consist = this.manager.getConsist(ConsistController.stringToDcc(headerData.get(1)));
            List<String> locoData = Arrays.asList(headerAndLocos.get(1).split("<;>"));
            for (String loco : locoData) {
                ArrayList<DccLocoAddress> conList = consist.getConsistList();
                int index = conList.indexOf(ConsistController.stringToDcc(loco));
                if (index == -1) continue;
                conList.add(conList.remove(index));
            }
        }
        catch (NullPointerException nullPointerException) {
            log.warn("reorderConsist error for message: {}", (Object)message);
            return;
        }
        this.writeFile();
    }

    private void removeConsist(String message) {
        List<String> header = Arrays.asList(message.split("<;>"));
        try {
            Consist consist = this.manager.getConsist(ConsistController.stringToDcc(header.get(1)));
            while (!consist.getConsistList().isEmpty()) {
                DccLocoAddress loco = consist.getConsistList().get(0);
                log.debug("Remove loco: {}, from consist: {}", (Object)loco, (Object)consist.getConsistAddress());
                consist.remove(loco);
            }
        }
        catch (NullPointerException nullPointerException) {
            log.warn("Consist: {} not found. Cannot delete.", (Object)header.get(1));
            return;
        }
        try {
            this.manager.delConsist(ConsistController.stringToDcc(header.get(1)));
        }
        catch (NullPointerException nullPointerException) {
            log.warn("Consist: {} not found. Cannot delete.", (Object)header.get(1));
            return;
        }
        this.writeFile();
    }

    private void addLoco(String message) {
        List<String> headerAndLoco = Arrays.asList(message.split("<:>"));
        try {
            List<String> headerData = Arrays.asList(headerAndLoco.get(0).split("<;>"));
            Consist consist = this.manager.getConsist(ConsistController.stringToDcc(headerData.get(1)));
            consist.setConsistID(headerData.get(2));
            List<String> locoData = Arrays.asList(headerAndLoco.get(1).split("<;>"));
            if (consist.isAddressAllowed(ConsistController.stringToDcc(locoData.get(0)))) {
                consist.add(ConsistController.stringToDcc(locoData.get(0)), Boolean.valueOf(locoData.get(1)));
                if (log.isDebugEnabled()) {
                    log.debug("add loco: {}, to consist: {}", (Object)locoData.get(0), (Object)headerData.get(1));
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            log.warn("addLoco error for message: {}", (Object)message);
            return;
        }
        this.writeFile();
    }

    private void removeLoco(String message) {
        List<String> headerAndLoco = Arrays.asList(message.split("<:>"));
        log.debug("remove loco string: {}", (Object)message);
        try {
            List<String> headerData = Arrays.asList(headerAndLoco.get(0).split("<;>"));
            Consist consist = this.manager.getConsist(ConsistController.stringToDcc(headerData.get(1)));
            List<String> locoData = Arrays.asList(headerAndLoco.get(1).split("<;>"));
            DccLocoAddress loco = ConsistController.stringToDcc(locoData.get(0));
            if (this.checkForBroadcastAddress(loco)) {
                return;
            }
            if (consist.contains(loco)) {
                consist.remove(loco);
                if (log.isDebugEnabled()) {
                    log.debug("Remove loco: {}, from consist: {}", (Object)loco, (Object)headerData.get(1));
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            log.warn("removeLoco error for message: {}", (Object)message);
            return;
        }
        this.writeFile();
    }

    private void writeFile() {
        try {
            if (InstanceManager.getDefault(WiThrottlePreferences.class).isUseWiFiConsist()) {
                this.file.writeFile(this.manager.getConsistList(), String.valueOf(WiFiConsistFile.getFileLocation()) + "wifiConsist.xml");
            } else {
                this.file.writeFile(this.manager.getConsistList());
            }
        }
        catch (IOException iOException) {
            log.warn("Consist file could not be written!");
        }
    }

    private void setConsistCVs(String message) {
        DccLocoAddress loco;
        List<String> headerAndCVs = Arrays.asList(message.split("<:>"));
        log.debug("setConsistCVs string: {}", (Object)message);
        try {
            List<String> headerData = Arrays.asList(headerAndCVs.get(0).split("<;>"));
            loco = ConsistController.stringToDcc(headerData.get(1));
            if (this.checkForBroadcastAddress(loco)) {
                return;
            }
        }
        catch (NullPointerException nullPointerException) {
            log.warn("setConsistCVs error for message: {}", (Object)message);
            return;
        }
        AddressedProgrammer pom = InstanceManager.getDefault(AddressedProgrammerManager.class).getAddressedProgrammer(loco);
        if (pom != null) {
            int i = 1;
            while (i < headerAndCVs.size()) {
                List<String> CVData = Arrays.asList(headerAndCVs.get(i).split("<;>"));
                try {
                    try {
                        pom.writeCV(CVData.get(0), Integer.parseInt(CVData.get(1)), this);
                    }
                    catch (ProgrammerException programmerException) {
                        log.debug("Unable to communicate with programmer manager.");
                    }
                }
                catch (NumberFormatException nfe) {
                    log.warn("Error in setting CVs: {}", (Object)nfe);
                }
                ++i;
            }
            InstanceManager.getDefault(AddressedProgrammerManager.class).releaseAddressedProgrammer(pom);
        }
    }

    @Override
    public void programmingOpReply(int value, int status) {
    }

    public static DccLocoAddress stringToDcc(String s) {
        int num = Integer.parseInt(s.substring(1));
        boolean isLong = s.charAt(0) == 'L';
        return new DccLocoAddress(num, isLong);
    }

    public boolean checkForBroadcastAddress(DccLocoAddress addr) {
        if (addr.getNumber() < 1) {
            log.warn("Trying to use broadcast address!");
            return true;
        }
        return false;
    }

    @Override
    void register() {
        throw new UnsupportedOperationException("Not used.");
    }

    @Override
    void deregister() {
        throw new UnsupportedOperationException("Not used.");
    }
}

