/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.whereused;

import java.util.Collections;
import java.util.Enumeration;
import jmri.BlockManager;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.LightManager;
import jmri.LogixManager;
import jmri.NamedBean;
import jmri.RouteManager;
import jmri.SectionManager;
import jmri.SignalGroupManager;
import jmri.SignalMastLogicManager;
import jmri.TransitManager;
import jmri.TurnoutManager;
import jmri.jmrit.blockboss.BlockBossLogic;
import jmri.jmrit.blockboss.BlockBossLogicProvider;
import jmri.jmrit.ctc.CtcManager;
import jmri.jmrit.display.EditorManager;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.display.switchboardEditor.SwitchboardEditor;
import jmri.jmrit.entryexit.EntryExitPairs;
import jmri.jmrit.logix.OBlockManager;
import jmri.jmrit.logix.WarrantManager;
import jmri.jmrit.logixng.LogixNG_Manager;
import jmri.jmrit.logixng.ModuleManager;
import jmri.jmrit.whereused.Bundle;

public class WhereUsedCollectors {
    static CtcManager mgr = null;

    static String checkTurnouts(NamedBean bean) {
        StringBuilder sb = new StringBuilder();
        InstanceManager.getDefault(TurnoutManager.class).getNamedBeanSet().forEach(turnout -> {
            int feedback = turnout.getFeedbackMode();
            if (feedback == 16 || feedback == 32) {
                turnout.getUsageReport(bean).forEach(report -> {
                    if (report.usageKey.startsWith("TurnoutFeedback")) {
                        String name = turnout.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME);
                        sb.append(Bundle.getMessage("ReferenceLineName", name));
                    }
                });
            }
        });
        return WhereUsedCollectors.addHeader(sb, "ReferenceFeedback");
    }

    static String checkLights(NamedBean bean) {
        StringBuilder sb = new StringBuilder();
        InstanceManager.getDefault(LightManager.class).getNamedBeanSet().forEach(light -> light.getUsageReport(bean).forEach(report -> {
            if (report.usageKey.startsWith("LightControl")) {
                String name = light.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME);
                sb.append(Bundle.getMessage("ReferenceLineData", name, report.usageData));
            }
        }));
        return WhereUsedCollectors.addHeader(sb, "ReferenceLightControl");
    }

    static String checkRoutes(NamedBean bean) {
        StringBuilder sb = new StringBuilder();
        InstanceManager.getDefault(RouteManager.class).getNamedBeanSet().forEach(route -> route.getUsageReport(bean).forEach(report -> {
            if (report.usageKey.startsWith("Route")) {
                String name = route.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME);
                sb.append(Bundle.getMessage("ReferenceLineName", name));
            }
        }));
        return WhereUsedCollectors.addHeader(sb, "ReferenceRoutes");
    }

    static String checkBlocks(NamedBean bean) {
        StringBuilder sb = new StringBuilder();
        InstanceManager.getDefault(BlockManager.class).getNamedBeanSet().forEach(block -> block.getUsageReport(bean).forEach(report -> {
            if (report.usageKey.startsWith("Block")) {
                String name = block.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME);
                sb.append(Bundle.getMessage("ReferenceLineName", name));
            }
        }));
        return WhereUsedCollectors.addHeader(sb, "ReferenceBlock");
    }

    static String checkLayoutBlocks(NamedBean bean) {
        StringBuilder sb = new StringBuilder();
        InstanceManager.getDefault(LayoutBlockManager.class).getNamedBeanSet().forEach(layoutBlock -> layoutBlock.getUsageReport(bean).forEach(report -> {
            if (report.usageKey.startsWith("LayoutBlock")) {
                String name = layoutBlock.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME);
                sb.append(Bundle.getMessage("ReferenceLineData", name, report.usageData));
            }
        }));
        return WhereUsedCollectors.addHeader(sb, "ReferenceLayoutBlock");
    }

    static String checkSignalHeadLogic(NamedBean bean) {
        StringBuilder sb = new StringBuilder();
        Enumeration<BlockBossLogic> e = Collections.enumeration(InstanceManager.getDefault(BlockBossLogicProvider.class).provideAll());
        while (e.hasMoreElements()) {
            BlockBossLogic ssl = e.nextElement();
            ssl.getUsageReport(bean).forEach(report -> {
                if (report.usageKey.startsWith("SSL")) {
                    String name = report.usageBean.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME);
                    sb.append(Bundle.getMessage("ReferenceLineName", name));
                }
            });
        }
        return WhereUsedCollectors.addHeader(sb, "ReferenceHeadSSL");
    }

    static String checkSignalMastLogic(NamedBean bean) {
        StringBuilder sb = new StringBuilder();
        InstanceManager.getDefault(SignalMastLogicManager.class).getNamedBeanSet().forEach(sml -> sml.getUsageReport(bean).forEach(report -> {
            String name = bean.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME);
            if (report.usageKey.startsWith("SMLSource")) {
                sb.append(Bundle.getMessage("ReferenceLineData", name, Bundle.getMessage("SourceMast")));
                return;
            }
            if (report.usageKey.startsWith("SMLDest")) {
                sb.append(Bundle.getMessage("ReferenceLineData", name, Bundle.getMessage("DestMast")));
                return;
            }
            if (report.usageKey.startsWith("SML")) {
                sb.append(Bundle.getMessage("ReferenceLinePair", sml.getSourceMast().getDisplayName(), report.usageBean.getDisplayName()));
            }
        }));
        return WhereUsedCollectors.addHeader(sb, "ReferenceMastSML");
    }

    static String checkSignalGroups(NamedBean bean) {
        StringBuilder sb = new StringBuilder();
        InstanceManager.getDefault(SignalGroupManager.class).getNamedBeanSet().forEach(group -> group.getUsageReport(bean).forEach(report -> {
            if (report.usageKey.startsWith("SignalGroup")) {
                String name = group.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME);
                sb.append(Bundle.getMessage("ReferenceLineName", name));
            }
        }));
        return WhereUsedCollectors.addHeader(sb, "ReferenceSignalGroup");
    }

    static String checkOBlocks(NamedBean bean) {
        StringBuilder sb = new StringBuilder();
        InstanceManager.getDefault(OBlockManager.class).getNamedBeanSet().forEach(oblock -> oblock.getUsageReport(bean).forEach(report -> {
            if (report.usageKey.startsWith("OBlock")) {
                String name = oblock.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME);
                sb.append(Bundle.getMessage("ReferenceLineData", name, report.usageData));
            }
        }));
        return WhereUsedCollectors.addHeader(sb, "ReferenceOBlock");
    }

    static String checkWarrants(NamedBean bean) {
        StringBuilder sb = new StringBuilder();
        InstanceManager.getDefault(WarrantManager.class).getNamedBeanSet().forEach(warrant -> warrant.getUsageReport(bean).forEach(report -> {
            if (report.usageKey.startsWith("Warrant")) {
                String name = warrant.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME);
                sb.append(Bundle.getMessage("ReferenceLineName", name));
            }
        }));
        return WhereUsedCollectors.addHeader(sb, "ReferenceWarrant");
    }

    static String checkEntryExit(NamedBean bean) {
        StringBuilder sb = new StringBuilder();
        InstanceManager.getDefault(EntryExitPairs.class).getNamedBeanSet().forEach(destPoint -> destPoint.getUsageReport(bean).forEach(report -> {
            if (report.usageKey.startsWith("EntryExit")) {
                String name = destPoint.getDisplayName();
                sb.append(Bundle.getMessage("ReferenceLineName", name));
            }
        }));
        return WhereUsedCollectors.addHeader(sb, "ReferenceEntryExit");
    }

    static String checkLogixConditionals(NamedBean bean) {
        StringBuilder sb = new StringBuilder();
        InstanceManager.getDefault(LogixManager.class).getNamedBeanSet().forEach(logix -> logix.getUsageReport(bean).forEach(report -> {
            if (report.usageKey.startsWith("ConditionalVariable") || report.usageKey.startsWith("ConditionalAction")) {
                String name = logix.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME);
                String cdlName = report.usageBean.getDisplayName();
                sb.append(Bundle.getMessage("ReferenceLineConditional", name, cdlName, Bundle.getMessage(report.usageKey), report.usageData));
            }
        }));
        return WhereUsedCollectors.addHeader(sb, "ReferenceConditionals");
    }

    static String checkLogixNGConditionals(NamedBean bean) {
        StringBuilder sb = new StringBuilder();
        InstanceManager.getDefault(LogixNG_Manager.class).getNamedBeanSet().forEach(logixng -> logixng.getUsageReport(bean).forEach(report -> {
            if (report.usageKey.startsWith("LogixNG")) {
                String name = logixng.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME);
                String cdlName = report.usageBean != null ? report.usageBean.getDisplayName() : "";
                sb.append(Bundle.getMessage("ReferenceLineLogixNG", name, cdlName, Bundle.getMessage(report.usageKey), report.usageData));
            }
        }));
        InstanceManager.getDefault(ModuleManager.class).getNamedBeanSet().forEach(module -> module.getUsageReport(bean).forEach(report -> {
            if (report.usageKey.startsWith("LogixNG")) {
                String name = module.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME);
                sb.append(Bundle.getMessage("ReferenceLineModule", name, Bundle.getMessage(report.usageKey), report.usageData));
            }
        }));
        return WhereUsedCollectors.addHeader(sb, "ReferenceLogixNG");
    }

    static String checkSections(NamedBean bean) {
        StringBuilder sb = new StringBuilder();
        InstanceManager.getDefault(SectionManager.class).getNamedBeanSet().forEach(section -> section.getUsageReport(bean).forEach(report -> {
            if (report.usageKey.startsWith("SectionSensor")) {
                String name = section.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME);
                sb.append(Bundle.getMessage("ReferenceLineName", name));
            }
        }));
        return WhereUsedCollectors.addHeader(sb, "ReferenceSections");
    }

    static String checkTransits(NamedBean bean) {
        StringBuilder sb = new StringBuilder();
        InstanceManager.getDefault(TransitManager.class).getNamedBeanSet().forEach(transit -> transit.getUsageReport(bean).forEach(report -> {
            String name = transit.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME);
            if (report.usageKey.startsWith("TransitSensor") || report.usageKey.startsWith("TransitSection")) {
                sb.append(Bundle.getMessage("ReferenceLineName", name));
            }
            if (report.usageKey.startsWith("TransitAction")) {
                sb.append(Bundle.getMessage("ReferenceLineAction", name, report.usageBean.getDisplayName()));
            }
        }));
        return WhereUsedCollectors.addHeader(sb, "ReferenceTransits");
    }

    static String checkPanels(NamedBean bean) {
        StringBuilder sb = new StringBuilder();
        InstanceManager.getDefault(EditorManager.class).getAll().forEach(panel -> panel.getUsageReport(bean).forEach(report -> {
            if (panel instanceof SwitchboardEditor) {
                sb.append(Bundle.getMessage("ReferenceLineName", report.usageData));
            } else {
                sb.append(Bundle.getMessage("ReferenceLinePanel", panel.getTitle(), report.usageData));
            }
        }));
        return WhereUsedCollectors.addHeader(sb, "ReferencePanels");
    }

    static String checkCTC(NamedBean bean) {
        StringBuilder sb = new StringBuilder();
        InstanceManager.getOptionalDefault(ConfigureManager.class).ifPresent(cm -> cm.getInstanceList(CtcManager.class).forEach(m -> {
            mgr = (CtcManager)m;
        }));
        if (mgr != null) {
            mgr.getUsageReport(bean).forEach(report -> sb.append(Bundle.getMessage("ReferenceLineName", report.usageData)));
        }
        return WhereUsedCollectors.addHeader(sb, "ReferenceCTC");
    }

    static String addHeader(StringBuilder sb, String bundleKey) {
        if (sb.length() > 0) {
            sb.insert(0, Bundle.getMessage("ReferenceHeader", Bundle.getMessage(bundleKey)));
            sb.append("\n");
        }
        return sb.toString();
    }
}

