/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.vsdecoder.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import jmri.jmrit.vsdecoder.VSDecoderManager;
import jmri.jmrit.vsdecoder.VSDecoderPreferences;
import jmri.jmrit.vsdecoder.swing.Bundle;
import jmri.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VSDecoderPreferencesPane
extends JPanel
implements PropertyChangeListener {
    private JCheckBox cbAutoStartEngine;
    private JCheckBox cbAutoLoadVSDFile;
    private JTextField tfDefaultVSDFilePath;
    private JTextField tfDefaultVSDFileName;
    private JLabel labelDefaultVSDFilePath;
    private JLabel labelDefaultVSDFileName;
    private JRadioButton audioModeRoomButton;
    private JRadioButton audioModeHeadphoneButton;
    private ButtonGroup audioModeGroup;
    private JLabel labelApplyWarning;
    private JButton jbApply;
    private JButton jbCancel;
    private JButton jbSave;
    private JFrame m_container = null;
    private static final Logger log = LoggerFactory.getLogger(VSDecoderPreferencesPane.class);

    public VSDecoderPreferencesPane(VSDecoderPreferences tp) {
        this.initComponents();
        this.setComponents(tp);
        this.checkConsistency();
        tp.addPropertyChangeListener(this);
    }

    public VSDecoderPreferencesPane() {
        this(VSDecoderManager.instance().getVSDecoderPreferences());
    }

    private GridBagConstraints setConstraints(Insets i, int x, int y, int width, int fill) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = i;
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = width;
        gbc.anchor = 21;
        gbc.fill = fill;
        return gbc;
    }

    private void initComponents() {
        JPanel prefsPane = new JPanel();
        JPanel controlPane = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder());
        this.jbCancel = new JButton();
        this.jbSave = new JButton();
        this.jbApply = new JButton();
        this.labelApplyWarning = new JLabel();
        this.labelDefaultVSDFilePath = new JLabel();
        this.labelDefaultVSDFileName = new JLabel();
        this.cbAutoStartEngine = new JCheckBox();
        this.cbAutoLoadVSDFile = new JCheckBox();
        this.tfDefaultVSDFilePath = new JTextField(40);
        this.tfDefaultVSDFileName = new JTextField(40);
        JButton jbPathBrowse = new JButton(Bundle.getMessage("Browse"));
        jbPathBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VSDecoderPreferencesPane.this.jbPathBrowseActionPerformed(evt);
            }
        });
        JButton jbFileBrowse = new JButton(Bundle.getMessage("Browse"));
        jbFileBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VSDecoderPreferencesPane.this.jbFileBrowseActionPerformed(evt);
            }
        });
        this.audioModeRoomButton = new JRadioButton(Bundle.getMessage("ButtonAudioModeRoom"));
        this.audioModeHeadphoneButton = new JRadioButton(Bundle.getMessage("ButtonAudioModeHeadphone"));
        this.audioModeGroup = new ButtonGroup();
        this.audioModeGroup.add(this.audioModeRoomButton);
        this.audioModeGroup.add(this.audioModeHeadphoneButton);
        JPanel amPanel = new JPanel();
        amPanel.setLayout(new BoxLayout(amPanel, 2));
        amPanel.add(new JLabel("Audio Mode:"));
        amPanel.add(this.audioModeRoomButton);
        amPanel.add(this.audioModeHeadphoneButton);
        this.cbAutoStartEngine.setText(Bundle.getMessage("AutoStartEngine"));
        this.cbAutoLoadVSDFile.setText(Bundle.getMessage("AutoLoadVSDFile"));
        this.tfDefaultVSDFilePath.setColumns(30);
        this.tfDefaultVSDFilePath.setColumns(30);
        this.labelDefaultVSDFilePath.setText(Bundle.getMessage("DefaultVSDFilePath"));
        this.labelDefaultVSDFileName.setText(Bundle.getMessage("DefaultVSDFileName"));
        this.labelApplyWarning.setText(Bundle.getMessage("ExVSDecoderLabelApplyWarning"));
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VSDecoderPreferencesPane.this.checkConsistency();
            }
        };
        this.cbAutoStartEngine.addActionListener(al);
        this.cbAutoLoadVSDFile.addActionListener(al);
        this.tfDefaultVSDFilePath.addActionListener(al);
        this.tfDefaultVSDFileName.addActionListener(al);
        this.jbSave.setText(Bundle.getMessage("ButtonSave"));
        this.jbSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VSDecoderPreferencesPane.this.jbSaveActionPerformed(evt);
            }
        });
        this.jbSave.setVisible(false);
        this.jbCancel.setText(Bundle.getMessage("ButtonCancel"));
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VSDecoderPreferencesPane.this.jbCancelActionPerformed(evt);
            }
        });
        this.jbApply.setText(Bundle.getMessage("ButtonApply"));
        this.jbApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VSDecoderPreferencesPane.this.jbApplyActionPerformed(evt);
            }
        });
        prefsPane.setLayout(new GridBagLayout());
        prefsPane.setBorder(BorderFactory.createEmptyBorder());
        controlPane.setLayout(new GridBagLayout());
        controlPane.setBorder(BorderFactory.createEmptyBorder());
        prefsPane.add((Component)this.cbAutoStartEngine, this.setConstraints(new Insets(2, 10, 2, 2), 0, 0, 2, 0));
        prefsPane.add((Component)this.cbAutoLoadVSDFile, this.setConstraints(new Insets(2, 10, 2, 2), 0, 1, 2, 0));
        prefsPane.add((Component)this.labelDefaultVSDFilePath, this.setConstraints(new Insets(2, 10, 2, 2), 0, 2, 1, 0));
        prefsPane.add((Component)this.tfDefaultVSDFilePath, this.setConstraints(new Insets(2, 10, 2, 2), 1, 2, 3, 2));
        prefsPane.add((Component)jbPathBrowse, this.setConstraints(new Insets(2, 2, 2, 2), 5, 2, 1, 0));
        prefsPane.add((Component)this.labelDefaultVSDFileName, this.setConstraints(new Insets(2, 10, 2, 2), 0, 3, 1, 0));
        prefsPane.add((Component)this.tfDefaultVSDFileName, this.setConstraints(new Insets(2, 10, 2, 2), 1, 3, 2, 2));
        prefsPane.add((Component)jbFileBrowse, this.setConstraints(new Insets(2, 2, 2, 2), 5, 3, 1, 0));
        prefsPane.add((Component)amPanel, this.setConstraints(new Insets(2, 10, 2, 2), 0, 6, 2, 2));
        controlPane.add((Component)this.jbSave, this.setConstraints(new Insets(5, 3, 5, 2), 2, 100, 1, 0));
        controlPane.add((Component)this.jbCancel, this.setConstraints(new Insets(5, 3, 5, 2), 0, 100, 1, 0));
        controlPane.add((Component)this.jbApply, this.setConstraints(new Insets(5, 3, 5, 5), 1, 100, 1, 0));
        this.add((Component)prefsPane, this.setConstraints(new Insets(2, 2, 2, 2), 0, 0, 1, 0));
        this.add((Component)controlPane, this.setConstraints(new Insets(2, 2, 2, 2), 0, 1, 1, 0));
        this.setVisible(true);
    }

    private void setComponents(VSDecoderPreferences tp) {
        if (tp == null) {
            return;
        }
        this.cbAutoStartEngine.setSelected(tp.isAutoStartingEngine());
        this.cbAutoLoadVSDFile.setSelected(tp.isAutoLoadingDefaultVSDFile());
        this.tfDefaultVSDFilePath.setText(tp.getDefaultVSDFilePath());
        this.tfDefaultVSDFileName.setText(tp.getDefaultVSDFileName());
        switch (tp.getAudioMode()) {
            case HEADPHONES: {
                this.audioModeHeadphoneButton.setSelected(true);
                break;
            }
            default: {
                this.audioModeRoomButton.setSelected(true);
            }
        }
    }

    private VSDecoderPreferences getVSDecoderPreferences() {
        VSDecoderPreferences tp = new VSDecoderPreferences();
        tp.setAutoStartEngine(this.cbAutoStartEngine.isSelected());
        tp.setAutoLoadDefaultVSDFile(this.cbAutoLoadVSDFile.isSelected());
        tp.setDefaultVSDFilePath(this.tfDefaultVSDFilePath.getText());
        tp.setDefaultVSDFileName(this.tfDefaultVSDFileName.getText());
        tp.setListenerPosition(VSDecoderManager.instance().getVSDecoderPreferences().getListenerPosition());
        if (this.audioModeRoomButton.isSelected()) {
            tp.setAudioMode(VSDecoderPreferences.AudioMode.ROOM_AMBIENT);
        } else if (this.audioModeHeadphoneButton.isSelected()) {
            tp.setAudioMode(VSDecoderPreferences.AudioMode.HEADPHONES);
        }
        tp.setMasterVolume(VSDecoderManager.instance().getVSDecoderPreferences().getMasterVolume());
        return tp;
    }

    private void checkConsistency() {
    }

    private void jbPathBrowseActionPerformed(ActionEvent evt) {
        String path = this.tfDefaultVSDFilePath.getText() != null ? this.tfDefaultVSDFilePath.getText() : VSDecoderManager.instance().getVSDecoderPreferences().getDefaultVSDFilePath();
        JFileChooser fc = new JFileChooser(path);
        fc.setFileSelectionMode(1);
        int rv = fc.showOpenDialog(this);
        if (rv == 0) {
            try {
                this.tfDefaultVSDFilePath.setText(fc.getSelectedFile().getCanonicalPath());
            }
            catch (IOException iOException) {}
        }
    }

    private void jbFileBrowseActionPerformed(ActionEvent evt) {
        String path = this.tfDefaultVSDFilePath.getText() != null ? this.tfDefaultVSDFilePath.getText() : VSDecoderManager.instance().getVSDecoderPreferences().getDefaultVSDFilePath();
        JFileChooser fc = new JFileChooser(path);
        fc.setFileFilter(new FileNameExtensionFilter(Bundle.getMessage("LoadVSDFileChooserFilterLabel"), "vsd", "zip"));
        fc.setFileSelectionMode(0);
        int rv = fc.showOpenDialog(this);
        if (rv == 0) {
            try {
                URI base = null;
                base = this.tfDefaultVSDFilePath.getText() != null ? FileUtil.findURL(this.tfDefaultVSDFilePath.getText()).toURI() : FileUtil.findURL(VSDecoderManager.instance().getVSDecoderPreferences().getDefaultVSDFilePath()).toURI();
                URI absolute = fc.getSelectedFile().toURI();
                URI relative = base.relativize(absolute);
                log.debug("URI absolute = {} relative = {}", (Object)absolute.toString(), (Object)relative.toString());
                this.tfDefaultVSDFileName.setText(relative.getPath());
            }
            catch (URISyntaxException ex) {
                log.warn("Unable to get URI for {}", (Object)path, (Object)ex);
            }
        }
    }

    private void jbApplyActionPerformed(ActionEvent evt) {
        VSDecoderManager.instance().getVSDecoderPreferences().set(this.getVSDecoderPreferences());
    }

    public void jbSaveActionPerformed(ActionEvent evt) {
        VSDecoderManager.instance().getVSDecoderPreferences().set(this.getVSDecoderPreferences());
        VSDecoderManager.instance().getVSDecoderPreferences().save();
        if (this.m_container != null) {
            VSDecoderManager.instance().getVSDecoderPreferences().removePropertyChangeListener(this);
            this.m_container.setVisible(false);
            this.m_container.dispose();
        }
    }

    private void jbCancelActionPerformed(ActionEvent evt) {
        this.setComponents(VSDecoderManager.instance().getVSDecoderPreferences());
        this.checkConsistency();
        if (this.m_container != null) {
            VSDecoderManager.instance().getVSDecoderPreferences().removePropertyChangeListener(this);
            this.m_container.setVisible(false);
            this.m_container.dispose();
        }
    }

    public void setContainer(JFrame f) {
        this.m_container = f;
        this.jbSave.setVisible(true);
        this.jbCancel.setText(Bundle.getMessage("ButtonCancel"));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt == null || evt.getPropertyName() == null) {
            return;
        }
        if (evt.getPropertyName().equals("VSDecoderPreferences") && evt.getNewValue() != null && evt.getNewValue() instanceof VSDecoderPreferences) {
            this.setComponents((VSDecoderPreferences)evt.getNewValue());
            this.checkConsistency();
        }
    }
}

