/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.vsdecoder.swing;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.vsdecoder.LoadVSDFileAction;
import jmri.jmrit.vsdecoder.SoundEvent;
import jmri.jmrit.vsdecoder.VSDConfig;
import jmri.jmrit.vsdecoder.VSDecoder;
import jmri.jmrit.vsdecoder.VSDecoderManager;
import jmri.jmrit.vsdecoder.swing.Bundle;
import jmri.jmrit.vsdecoder.swing.VSDConfigDialog;
import jmri.jmrit.vsdecoder.swing.VSDControl;
import jmri.jmrit.vsdecoder.swing.VSDPreferencesAction;
import jmri.util.JmriJFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VSDManagerFrame
extends JmriJFrame {
    public static final String MUTE = "VSDMF:Mute";
    public static final String VOLUME_CHANGE = "VSDMF:VolumeChange";
    public static final String REMOVE_DECODER = "VSDMF:RemoveDecoder";
    public static final String CLOSE_WINDOW = "VSDMF:CloseWindow";
    private static final Map<String, Integer> Mnemonics = new HashMap<String, Integer>();
    private int master_volume;
    JPanel decoderPane;
    JPanel volumePane;
    JPanel decoderBlank;
    private VSDConfig config;
    private VSDConfigDialog cd;
    private List<JMenu> menuList;
    private boolean is_auto_loading;
    private boolean is_viewing;
    private List<VSDecoder> vsdlist;
    private static final Logger log;

    static {
        Mnemonics.put("FileMenu", 70);
        Mnemonics.put("EditMenu", 69);
        Mnemonics.put("MuteButton", 77);
        Mnemonics.put("AddButton", 65);
        log = LoggerFactory.getLogger(VSDManagerFrame.class);
    }

    public VSDManagerFrame() {
        super(false, false);
        this.addPropertyChangeListener(VSDecoderManager.instance());
        this.is_auto_loading = VSDecoderManager.instance().getVSDecoderPreferences().isAutoLoadingDefaultVSDFile();
        this.is_viewing = !VSDecoderManager.instance().getVSDecoderList().isEmpty();
        this.initGUI();
    }

    @Override
    public void initComponents() {
    }

    private void initGUI() {
        log.debug("initGUI");
        this.setTitle(Bundle.getMessage("VSDManagerFrameTitle"));
        this.buildMenu();
        this.setLayout(new BoxLayout(this.getContentPane(), 3));
        this.decoderPane = new JPanel();
        this.decoderPane.setLayout(new BoxLayout(this.decoderPane, 3));
        this.decoderBlank = VSDControl.generateBlank();
        this.decoderPane.add(this.decoderBlank);
        this.volumePane = new JPanel();
        this.volumePane.setLayout(new BoxLayout(this.volumePane, 2));
        JToggleButton muteButton = new JToggleButton(Bundle.getMessage("MuteButtonLabel"));
        JButton addButton = new JButton(Bundle.getMessage("AddButtonLabel"));
        JSlider volume = new JSlider(0, 100);
        volume.setMinorTickSpacing(10);
        volume.setPaintTicks(true);
        this.master_volume = VSDecoderManager.instance().getMasterVolume();
        volume.setValue(this.master_volume);
        volume.setPreferredSize(new Dimension(200, 20));
        volume.setToolTipText(Bundle.getMessage("MgrVolumeToolTip"));
        volume.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                VSDManagerFrame.this.volumeChange(e);
            }
        });
        this.volumePane.add(new JLabel(Bundle.getMessage("VolumePaneLabel")));
        this.volumePane.add(volume);
        this.volumePane.add(muteButton);
        muteButton.setToolTipText(Bundle.getMessage("MgrMuteToolTip"));
        muteButton.setMnemonic(Mnemonics.get("MuteButton"));
        muteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VSDManagerFrame.this.muteButtonPressed(e);
            }
        });
        this.volumePane.add(addButton);
        addButton.setToolTipText(Bundle.getMessage("MgrAddButtonToolTip"));
        addButton.setMnemonic(Mnemonics.get("AddButton"));
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VSDManagerFrame.this.addButtonPressed(e);
            }
        });
        this.add(this.decoderPane);
        this.add(this.volumePane);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                VSDManagerFrame.this.firePropertyChange(VSDManagerFrame.CLOSE_WINDOW, null, null);
            }
        });
        log.debug("pane size + {}", (Object)this.decoderPane.getPreferredSize());
        this.pack();
        this.setVisible(true);
        log.debug("done...");
        if (this.is_viewing) {
            this.vsdlist = new ArrayList<VSDecoder>();
            for (VSDecoder vsd : VSDecoderManager.instance().getVSDecoderList()) {
                if (vsd.getRosterEntry() != null) {
                    addButton.doClick();
                    this.cd.setRosterItem(vsd.getRosterEntry());
                    continue;
                }
                this.vsdlist.add(vsd);
            }
            for (VSDecoder v : this.vsdlist) {
                VSDecoderManager.instance().deleteDecoder(v.getAddress().toString());
            }
            this.is_viewing = false;
        } else if (this.is_auto_loading) {
            log.info("Auto-Loading VSDecoder");
            String vsdRosterGroup = "VSD";
            String msg = "";
            if (Roster.getDefault().getRosterGroupList().contains(vsdRosterGroup)) {
                List<RosterEntry> rosterList = Roster.getDefault().getEntriesInGroup(vsdRosterGroup);
                if (!rosterList.isEmpty()) {
                    int entry_counter = 1;
                    for (RosterEntry entry : rosterList) {
                        if (entry_counter <= 4) {
                            addButton.doClick();
                            this.cd.setRosterItem(entry);
                            ++entry_counter;
                            continue;
                        }
                        msg = "Only 4 Roster Entries allowed. Discarded " + (rosterList.size() - 4);
                    }
                } else {
                    msg = "No Roster Entry found in Roster Group " + vsdRosterGroup;
                }
            } else {
                msg = "Roster Group \"" + vsdRosterGroup + "\" not found";
            }
            if (!msg.isEmpty()) {
                JOptionPane.showMessageDialog(null, "Auto-Loading: " + msg);
                log.warn("Auto-Loading VSDecoder aborted");
            }
        }
    }

    protected void muteButtonPressed(ActionEvent e) {
        JToggleButton b = (JToggleButton)e.getSource();
        log.debug("Mute button pressed. value: {}", (Object)b.isSelected());
        this.firePropertyChange(MUTE, !b.isSelected(), b.isSelected());
    }

    protected void addButtonPressed(ActionEvent e) {
        log.debug("Add button pressed");
        if (!this.is_viewing && VSDecoderManager.instance().getVSDecoderList().size() >= 4) {
            JOptionPane.showMessageDialog(null, "VSDecoder cannot be created. Maximal number is " + String.valueOf(4));
        } else {
            this.config = new VSDConfig();
            this.cd = new VSDConfigDialog(this.decoderPane, Bundle.getMessage("NewDecoderConfigPaneTitle"), this.config, this.is_auto_loading, this.is_viewing);
            this.cd.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    log.debug("property change name {}, old: {}, new: {}", new Object[]{event.getPropertyName(), event.getOldValue(), event.getNewValue()});
                    VSDManagerFrame.this.addButtonPropertyChange(event);
                }
            });
        }
    }

    protected void addButtonPropertyChange(PropertyChangeEvent event) {
        log.debug("internal config dialog handler");
        if (!this.is_viewing && VSDecoderManager.instance().getVSDecoderByAddress(this.config.getLocoAddress().toString()) != null) {
            JOptionPane.showMessageDialog(null, Bundle.getMessage("MgrAddDuplicateMessage"));
        } else {
            VSDecoder newDecoder = VSDecoderManager.instance().getVSDecoder(this.config);
            if (newDecoder == null) {
                log.error("Lost context, VSDecoder is null. Quit JMRI and start over. No New Decoder constructed! Address: {}, profile: {}", (Object)this.config.getLocoAddress(), (Object)this.config.getProfileName());
                return;
            }
            VSDControl newControl = new VSDControl(this.config);
            newControl.addPropertyChangeListener(newDecoder);
            this.addPropertyChangeListener(newDecoder);
            newControl.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    log.debug("property change name {}, old: {}, new: {}", new Object[]{event.getPropertyName(), event.getOldValue(), event.getNewValue()});
                    VSDManagerFrame.this.vsdControlPropertyChange(event);
                }
            });
            if (this.decoderPane.isAncestorOf(this.decoderBlank)) {
                this.decoderPane.remove(this.decoderBlank);
            }
            this.decoderPane.add(newControl);
            newControl.addSoundButtons(new ArrayList<SoundEvent>(newDecoder.getEventList()));
            this.firePropertyChange(VOLUME_CHANGE, (Object)this.master_volume, null);
            log.debug("Master volume set to {}", (Object)this.master_volume);
            this.decoderPane.revalidate();
            this.decoderPane.repaint();
            this.pack();
        }
    }

    protected void vsdControlPropertyChange(PropertyChangeEvent event) {
        String property = event.getPropertyName();
        if (property.equals("DeleteDecoder")) {
            String ov = (String)event.getOldValue();
            log.debug("vsdControlPropertyChange. ID: {}, old: {}", (Object)"DeleteDecoder", (Object)ov);
            VSDecoder vsd = VSDecoderManager.instance().getVSDecoderByAddress(ov);
            if (vsd == null) {
                log.warn("Lost context, VSDecoder is null. Quit JMRI and start over.");
                return;
            }
            if (vsd.getEngineSound().isEngineStarted()) {
                JOptionPane.showMessageDialog(null, Bundle.getMessage("MgrDeleteWhenEngineStopped"));
                return;
            }
            this.removePropertyChangeListener(vsd);
            log.debug("vsdControlPropertyChange. ID: {}, old: {}", (Object)REMOVE_DECODER, (Object)ov);
            this.firePropertyChange(REMOVE_DECODER, ov, null);
            this.decoderPane.remove((VSDControl)event.getSource());
            if (this.decoderPane.getComponentCount() == 0) {
                this.decoderPane.add(this.decoderBlank);
            }
            this.decoderPane.revalidate();
            this.decoderPane.repaint();
            this.pack();
        }
    }

    protected void volumeChange(ChangeEvent event) {
        JSlider v = (JSlider)event.getSource();
        log.debug("Volume slider moved. value: {}", (Object)v.getValue());
        this.master_volume = v.getValue();
        this.firePropertyChange(VOLUME_CHANGE, (Object)this.master_volume, null);
        if (VSDecoderManager.instance().getMasterVolume() != v.getValue()) {
            VSDecoderManager.instance().setMasterVolume(v.getValue());
            VSDecoderManager.instance().getVSDecoderPreferences().save();
            log.debug("VSD Preferences saved");
        }
    }

    private void buildMenu() {
        JMenu fileMenu = new JMenu(Bundle.getMessage("MenuFile"));
        fileMenu.setMnemonic(Mnemonics.get("FileMenu"));
        fileMenu.add(new LoadVSDFileAction(Bundle.getMessage("VSDecoderFileMenuLoadVSDFile")));
        JMenu editMenu = new JMenu(Bundle.getMessage("MenuEdit"));
        editMenu.setMnemonic(Mnemonics.get("EditMenu"));
        editMenu.add(new VSDPreferencesAction(Bundle.getMessage("VSDecoderFileMenuPreferences")));
        this.menuList = new ArrayList<JMenu>(2);
        this.menuList.add(fileMenu);
        this.menuList.add(editMenu);
        this.setJMenuBar(new JMenuBar());
        this.getJMenuBar().add(fileMenu);
        this.getJMenuBar().add(editMenu);
        this.addHelpMenu("package.jmri.jmrit.vsdecoder.swing.VSDManagerFrame", true);
    }
}

