/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.vsdecoder.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import jmri.InstanceManager;
import jmri.jmrit.DccLocoAddressSelector;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.roster.swing.RosterEntrySelectorPanel;
import jmri.jmrit.throttle.ThrottleFrame;
import jmri.jmrit.throttle.ThrottleFrameManager;
import jmri.jmrit.vsdecoder.LoadVSDFileAction;
import jmri.jmrit.vsdecoder.VSDConfig;
import jmri.jmrit.vsdecoder.VSDManagerEvent;
import jmri.jmrit.vsdecoder.VSDManagerListener;
import jmri.jmrit.vsdecoder.VSDecoderManager;
import jmri.jmrit.vsdecoder.swing.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VSDConfigDialog
extends JDialog {
    private static final String CONFIG_PROPERTY = "Config";
    private static final Map<String, Integer> Mnemonics = new HashMap<String, Integer>();
    private JLabel addressLabel;
    private JButton addressSetButton;
    private DccLocoAddressSelector addressSelector;
    private RosterEntrySelectorPanel rosterSelector;
    private JLabel rosterLabel;
    private JButton rosterSaveButton;
    private JComboBox<Object> profileComboBox;
    private JButton profileLoadButton;
    private JPanel rosterPanel;
    private JPanel profilePanel;
    private JPanel addressPanel;
    private JTabbedPane locoSelectPanel;
    private JButton closeButton;
    private NullProfileBoxItem loadProfilePrompt;
    private VSDConfig config;
    private RosterEntry rosterEntry;
    private RosterEntry rosterEntrySelected;
    private boolean is_auto_loading;
    private boolean is_viewing;
    private static final Logger log;

    static {
        Mnemonics.put("RosterTab", 82);
        Mnemonics.put("ManualTab", 77);
        Mnemonics.put("AddressSet", 84);
        Mnemonics.put("ProfileLoad", 76);
        Mnemonics.put("RosterSave", 83);
        Mnemonics.put("CloseButton", 79);
        Mnemonics.put("CancelButton", 67);
        log = LoggerFactory.getLogger(VSDConfigDialog.class);
    }

    public VSDConfigDialog(JPanel parent, String title, VSDConfig c, boolean ial, boolean viewing) {
        super(SwingUtilities.getWindowAncestor(parent), title);
        this.config = c;
        this.is_auto_loading = ial;
        this.is_viewing = viewing;
        VSDecoderManager.instance().addEventListener(new VSDManagerListener(){

            @Override
            public void eventAction(VSDManagerEvent evt) {
                VSDConfigDialog.this.vsdecoderManagerEventAction(evt);
            }
        });
        this.initComponents();
    }

    protected void initComponents() {
        this.setLayout(new BoxLayout(this.getContentPane(), 3));
        this.locoSelectPanel = new JTabbedPane();
        TitledBorder title = BorderFactory.createTitledBorder(BorderFactory.createLoweredBevelBorder(), Bundle.getMessage("LocoTabbedPaneTitle"));
        title.setTitlePosition(0);
        this.locoSelectPanel.setBorder(title);
        this.rosterPanel = new JPanel();
        this.rosterPanel.setLayout(new BoxLayout(this.rosterPanel, 2));
        this.addressPanel = new JPanel();
        this.addressPanel.setLayout(new BoxLayout(this.addressPanel, 2));
        this.locoSelectPanel.addTab(Bundle.getMessage("RosterLabel"), this.rosterPanel);
        this.locoSelectPanel.addTab(Bundle.getMessage("LocoTabbedPaneManualTab"), this.addressPanel);
        try {
            this.locoSelectPanel.setToolTipTextAt(this.locoSelectPanel.indexOfTab(Bundle.getMessage("RosterLabel")), Bundle.getMessage("LTPRosterTabToolTip"));
            this.locoSelectPanel.setMnemonicAt(this.locoSelectPanel.indexOfTab(Bundle.getMessage("RosterLabel")), Mnemonics.get("RosterTab"));
            this.locoSelectPanel.setToolTipTextAt(this.locoSelectPanel.indexOfTab(Bundle.getMessage("LocoTabbedPaneManualTab")), Bundle.getMessage("LTPManualTabToolTip"));
            this.locoSelectPanel.setMnemonicAt(this.locoSelectPanel.indexOfTab(Bundle.getMessage("LocoTabbedPaneManualTab")), Mnemonics.get("ManualTab"));
        }
        catch (IndexOutOfBoundsException iobe) {
            log.debug("Index out of bounds setting up tabbed Pane: {}", (Throwable)iobe);
        }
        this.rosterSelector = new RosterEntrySelectorPanel();
        this.rosterSelector.setNonSelectedItem(Bundle.getMessage("EmptyRosterBox"));
        this.rosterSelector.setToolTipText(Bundle.getMessage("LTPRosterSelectorToolTip"));
        this.rosterSelector.addPropertyChangeListener("selectedRosterEntries", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                VSDConfigDialog.this.rosterItemSelectAction(null);
            }
        });
        this.rosterPanel.add(this.rosterSelector);
        this.rosterLabel = new JLabel();
        this.rosterLabel.setText(Bundle.getMessage("RosterLabel"));
        this.addressLabel = new JLabel();
        this.addressSelector = new DccLocoAddressSelector();
        this.addressSelector.setToolTipText(Bundle.getMessage("LTPAddressSelectorToolTip", Bundle.getMessage("ButtonSet")));
        this.addressSetButton = new JButton();
        this.addressSetButton.setText(Bundle.getMessage("ButtonSet"));
        this.addressSetButton.setEnabled(true);
        this.addressSetButton.setToolTipText(Bundle.getMessage("AddressSetButtonToolTip"));
        this.addressSetButton.setMnemonic(Mnemonics.get("AddressSet"));
        this.addressSetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VSDConfigDialog.this.addressSetButtonActionPerformed(evt);
            }
        });
        this.addressPanel.add(this.addressSelector.getCombinedJPanel());
        this.addressPanel.add(this.addressSetButton);
        this.addressPanel.add(this.addressLabel);
        this.profilePanel = new JPanel();
        this.profilePanel.setLayout(new BoxLayout(this.profilePanel, 3));
        this.profileComboBox = new JComboBox();
        this.profileComboBox.setToolTipText(Bundle.getMessage("ProfileComboBoxToolTip"));
        this.profileLoadButton = new JButton(Bundle.getMessage("VSDecoderFileMenuLoadVSDFile"));
        this.profileLoadButton.setToolTipText(Bundle.getMessage("ProfileLoadButtonToolTip"));
        this.profileLoadButton.setMnemonic(Mnemonics.get("ProfileLoad"));
        this.profileLoadButton.setEnabled(true);
        TitledBorder title2 = BorderFactory.createTitledBorder(BorderFactory.createLoweredBevelBorder(), Bundle.getMessage("ProfileSelectorPaneTitle"));
        title.setTitlePosition(0);
        this.profilePanel.setBorder(title2);
        this.profileComboBox.setModel(new DefaultComboBoxModel());
        ArrayList<String> sl = VSDecoderManager.instance().getVSDProfileNames();
        if (sl.isEmpty()) {
            this.profileComboBox.setEnabled(false);
        } else {
            this.profileComboBox.setEnabled(true);
        }
        this.updateProfileList(sl);
        this.loadProfilePrompt = new NullProfileBoxItem();
        this.profileComboBox.addItem(this.loadProfilePrompt);
        this.profileComboBox.setSelectedItem(this.loadProfilePrompt);
        this.profileComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VSDConfigDialog.this.profileComboBoxActionPerformed(evt);
            }
        });
        this.profilePanel.add(this.profileComboBox);
        this.profilePanel.add(this.profileLoadButton);
        this.profileLoadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VSDConfigDialog.this.profileLoadButtonActionPerformed(evt);
            }
        });
        this.rosterSaveButton = new JButton();
        this.rosterSaveButton.setText(Bundle.getMessage("ConfigSaveButtonLabel"));
        this.rosterSaveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VSDConfigDialog.this.rosterSaveButtonAction(e);
            }
        });
        this.rosterSaveButton.setEnabled(false);
        this.rosterSaveButton.setToolTipText(Bundle.getMessage("RosterSaveButtonToolTip"));
        this.rosterSaveButton.setMnemonic(Mnemonics.get("RosterSave"));
        JPanel cbPanel = new JPanel();
        this.closeButton = new JButton(Bundle.getMessage("ButtonOK"));
        this.closeButton.setEnabled(false);
        this.closeButton.setToolTipText(Bundle.getMessage("CD_CloseButtonToolTip"));
        this.closeButton.setMnemonic(Mnemonics.get("CloseButton"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VSDConfigDialog.this.closeButtonActionPerformed(e);
            }
        });
        JButton cancelButton = new JButton(Bundle.getMessage("ButtonCancel"));
        cancelButton.setToolTipText(Bundle.getMessage("CD_CancelButtonToolTip"));
        cancelButton.setMnemonic(Mnemonics.get("CancelButton"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VSDConfigDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        cbPanel.add(cancelButton);
        cbPanel.add(this.rosterSaveButton);
        cbPanel.add(this.closeButton);
        this.add(this.locoSelectPanel);
        this.add(this.profilePanel);
        this.add(cbPanel);
        this.pack();
        this.setVisible(true);
    }

    private void cancelButtonActionPerformed(ActionEvent ae) {
        this.dispose();
    }

    private void closeButtonActionPerformed(ActionEvent ae) {
        if (this.profileComboBox.getSelectedItem() == null) {
            log.debug("Profile item selected: {}", this.profileComboBox.getSelectedItem());
            JOptionPane.showMessageDialog(null, "Please select a valid Profile");
            this.rosterSaveButton.setEnabled(false);
            this.closeButton.setEnabled(false);
        } else {
            this.config.setProfileName(this.profileComboBox.getSelectedItem().toString());
            log.debug("Profile item selected: {}", (Object)this.config.getProfileName());
            this.config.setLocoAddress(this.addressSelector.getAddress());
            if (this.getSelectedRosterItem() != null) {
                this.config.setRosterEntry(this.getSelectedRosterItem());
                String dv = this.config.getRosterEntry().getAttribute("VSDecoder_Volume");
                if (dv != null && !dv.isEmpty()) {
                    this.config.setVolume(Float.parseFloat(dv));
                }
                log.debug("Decoder volume in config: {}", (Object)Float.valueOf(this.config.getVolume()));
            } else {
                this.config.setRosterEntry(null);
            }
            this.firePropertyChange(CONFIG_PROPERTY, this.config, null);
            this.dispose();
        }
    }

    private void enableProfileStuff(Boolean t) {
        this.closeButton.setEnabled(t);
        this.profileComboBox.setEnabled(t);
        this.profileLoadButton.setEnabled(t);
        this.rosterSaveButton.setEnabled(t);
    }

    private void rosterItemSelectAction(ActionEvent e) {
        if (this.getSelectedRosterItem() != null) {
            log.debug("Roster Entry selected... {}", (Object)this.getSelectedRosterItem().getId());
            this.setRosterEntry(this.getSelectedRosterItem());
            this.enableProfileStuff(true);
            log.debug("profile ComboBox selected item: {}", this.profileComboBox.getSelectedItem());
            if (this.profileComboBox.getSelectedIndex() == -1 || this.profileComboBox.getSelectedItem() instanceof NullProfileBoxItem) {
                this.rosterSaveButton.setEnabled(false);
                this.closeButton.setEnabled(false);
                log.warn("No Profile found");
            } else {
                this.closeButton.doClick();
            }
        }
    }

    void setRosterItem(RosterEntry s) {
        this.rosterEntrySelected = s;
        log.debug("Auto-Load selected roster id: {}, profile: {}", (Object)this.rosterEntrySelected.getId(), (Object)this.rosterEntrySelected.getAttribute("VSDecoder_Profile"));
        this.rosterItemSelectAction(null);
    }

    private RosterEntry getRosterItem() {
        return this.rosterEntrySelected;
    }

    private RosterEntry getSelectedRosterItem() {
        this.rosterEntrySelected = (this.is_auto_loading || this.is_viewing) && this.getRosterItem() != null ? this.getRosterItem() : (this.rosterSelector.getSelectedRosterEntries().length != 0 ? this.rosterSelector.getSelectedRosterEntries()[0] : null);
        return this.rosterEntrySelected;
    }

    private void rosterSaveButtonAction(ActionEvent e) {
        log.debug("rosterSaveButton pressed");
        if (this.rosterSelector.getSelectedRosterEntries().length != 0) {
            RosterEntry r = this.rosterSelector.getSelectedRosterEntries()[0];
            String profile = this.profileComboBox.getSelectedItem().toString();
            String path = VSDecoderManager.instance().getProfilePath(profile);
            if (path == null) {
                log.warn("Path not selected.  Ignore Save button press.");
                return;
            }
            int value = JOptionPane.showConfirmDialog(null, MessageFormat.format(Bundle.getMessage("UpdateRoster"), r.titleString()), Bundle.getMessage("SaveRoster?"), 0);
            if (value == 0) {
                r.putAttribute("VSDecoder_Path", path);
                r.putAttribute("VSDecoder_Profile", profile);
                if (r.getAttribute("VSDecoder_LaunchThrottle") == null) {
                    r.putAttribute("VSDecoder_LaunchThrottle", "no");
                }
                if (r.getAttribute("VSDecoder_Volume") == null) {
                    r.putAttribute("VSDecoder_Volume", String.valueOf(this.config.DEFAULT_VOLUME));
                }
                r.updateFile();
                log.info("Roster Media updated for {}", (Object)r.getDisplayName());
                this.closeButton.doClick();
            } else {
                log.info("Roster Media not saved");
            }
        }
    }

    private void profileComboBoxActionPerformed(ActionEvent evt) {
        if (this.addressSelector.getAddress() != null && !(this.profileComboBox.getSelectedItem() instanceof NullProfileBoxItem)) {
            this.closeButton.setEnabled(true);
            if (this.rosterSelector.getSelectedRosterEntries().length != 0) {
                this.rosterSaveButton.setEnabled(true);
            }
        }
    }

    private void profileLoadButtonActionPerformed(ActionEvent evt) {
        LoadVSDFileAction vfa = new LoadVSDFileAction();
        vfa.actionPerformed(evt);
    }

    private void addressSetButtonActionPerformed(ActionEvent evt) {
        if (this.addressSelector.getAddress() == null) {
            log.warn("Address is not valid");
        }
        if (this.profileComboBox.getSelectedIndex() != -1 && !(this.profileComboBox.getSelectedItem() instanceof NullProfileBoxItem)) {
            this.closeButton.setEnabled(true);
        }
    }

    private void vsdecoderManagerEventAction(VSDManagerEvent evt) {
        if (evt.getType() == VSDManagerEvent.EventType.PROFILE_LIST_CHANGE) {
            log.debug("Received Profile List Change Event");
            this.updateProfileList((ArrayList)evt.getData());
        }
    }

    private void updateProfileList(ArrayList<String> s) {
        if (s == null) {
            return;
        }
        ArrayList<String> ce_list = new ArrayList<String>();
        int i = 0;
        while (i < this.profileComboBox.getItemCount()) {
            if (!(this.profileComboBox.getItemAt(i) instanceof NullProfileBoxItem)) {
                ce_list.add(this.profileComboBox.getItemAt(i).toString());
            }
            ++i;
        }
        for (String st : s) {
            if (ce_list.contains(st)) continue;
            log.debug("added item {}", (Object)st);
            this.profileComboBox.addItem(st);
        }
        if (this.profileComboBox.getItemCount() > 0) {
            this.profileComboBox.setEnabled(true);
            if (this.getSelectedRosterItem() != null) {
                RosterEntry r = this.getSelectedRosterItem();
                String profile = r.getAttribute("VSDecoder_Profile");
                log.debug("Trying to set the ProfileComboBox to this Profile: {}", (Object)profile);
                if (profile != null) {
                    this.profileComboBox.setSelectedItem(profile);
                }
            }
        }
    }

    private void setRosterEntry(RosterEntry entry) {
        this.rosterEntry = entry;
        String vsd_path = this.rosterEntry.getAttribute("VSDecoder_Path");
        String vsd_launch_throttle = this.rosterEntry.getAttribute("VSDecoder_LaunchThrottle");
        log.debug("Roster entry path: {}, LaunchThrottle: {}", (Object)vsd_path, (Object)vsd_launch_throttle);
        if (vsd_path == null || vsd_path.isEmpty()) {
            log.warn("No VSD Path found for Roster Entry \"{}\". Use the \"Save to Roster\" button to add the VSD info.", (Object)this.rosterEntry.getId());
        } else {
            boolean is_loaded = LoadVSDFileAction.loadVSDFile(vsd_path);
            if (is_loaded && vsd_launch_throttle != null && vsd_launch_throttle.equals("yes") && InstanceManager.throttleManagerInstance().getThrottleUsageCount(this.rosterEntry) == 0) {
                ThrottleFrame tf = InstanceManager.getDefault(ThrottleFrameManager.class).createThrottleFrame();
                tf.toFront();
                tf.getAddressPanel().setRosterEntry(Roster.getDefault().entryFromTitle(this.rosterEntry.getId()));
            }
        }
        this.addressSelector.setAddress(entry.getDccLocoAddress());
        this.addressSelector.setEnabled(true);
        this.addressSetButton.setEnabled(true);
    }

    static class NullProfileBoxItem {
        NullProfileBoxItem() {
        }

        public String toString() {
            return Bundle.getMessage("NoLocoSelectedText");
        }
    }
}

