/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.vsdecoder.swing;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import jmri.Block;
import jmri.BlockManager;
import jmri.InstanceManager;
import jmri.Reporter;
import jmri.ReporterManager;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.vsdecoder.VSDecoderManager;
import jmri.jmrit.vsdecoder.listener.ListeningSpot;
import jmri.jmrit.vsdecoder.swing.Bundle;
import jmri.jmrit.vsdecoder.swing.ManageLocationsTableModel;
import jmri.jmrit.vsdecoder.swing.VSDPreferencesAction;
import jmri.util.JmriJFrame;
import jmri.util.PhysicalLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageLocationsFrame
extends JmriJFrame {
    private static final Map<String, Integer> Mnemonics = new HashMap<String, Integer>();
    private JTabbedPane tabbedPane;
    private JPanel listenerPanel;
    private JPanel reporterPanel;
    private JPanel opsPanel;
    private JPanel blockPanel;
    private Object[][] reporterData;
    private Object[][] opsData;
    private Object[][] locData;
    private Object[][] blockData;
    private ManageLocationsTableModel.ReporterBlockTableModel reporterModel;
    private ManageLocationsTableModel.LocationTableModel opsModel;
    private ManageLocationsTableModel.ListenerTableModel locModel;
    private ManageLocationsTableModel.ReporterBlockTableModel blockModel;
    private ListeningSpot listenerLoc;
    private HashMap<String, PhysicalLocation> data;
    private List<JMenu> menuList;
    private static final Logger log;

    static {
        Mnemonics.put("RoomMode", 82);
        Mnemonics.put("HeadphoneMode", 72);
        Mnemonics.put("ReporterTab", 69);
        Mnemonics.put("OpsTab", 80);
        Mnemonics.put("ListenerTab", 76);
        Mnemonics.put("BlockTab", 66);
        Mnemonics.put("CloseButton", 79);
        Mnemonics.put("SaveButton", 83);
        log = LoggerFactory.getLogger(ManageLocationsFrame.class);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="2D array of different types passed as complex parameter. Better to switch to passing use-specific objects rather than papering this over with a deep copy of the arguments. In any case, there's no risk of exposure here.")
    public ManageLocationsFrame(ListeningSpot listener, Object[][] reporters, Object[][] ops, Object[][] blocks) {
        super(false, false);
        this.reporterData = reporters;
        this.opsData = ops;
        this.listenerLoc = listener;
        this.blockData = blocks;
        this.initGui();
    }

    private void initGui() {
        this.setTitle(Bundle.getMessage("FieldManageLocationsFrameTitle"));
        this.buildMenu();
        this.listenerPanel = new JPanel();
        this.listenerPanel.setLayout(new BoxLayout(this.listenerPanel, 1));
        JRadioButton b1 = new JRadioButton(Bundle.getMessage("ButtonAudioModeRoom"));
        b1.setToolTipText(Bundle.getMessage("ToolTipButtonAudioModeRoom"));
        b1.setMnemonic(Mnemonics.get("RoomMode"));
        b1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageLocationsFrame.this.modeRadioButtonPressed(e);
            }
        });
        JRadioButton b2 = new JRadioButton(Bundle.getMessage("ButtonAudioModeHeadphone"));
        b2.setMnemonic(Mnemonics.get("HeadphoneMode"));
        b2.setToolTipText(Bundle.getMessage("ToolTipButtonAudioModeHeadphone"));
        b2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageLocationsFrame.this.modeRadioButtonPressed(e);
            }
        });
        b2.setEnabled(false);
        ButtonGroup bg = new ButtonGroup();
        bg.add(b1);
        bg.add(b2);
        b1.setSelected(true);
        JPanel modePanel = new JPanel();
        modePanel.setLayout(new BoxLayout(modePanel, 2));
        modePanel.add(new JLabel(Bundle.getMessage("FieldAudioMode")));
        modePanel.add(b1);
        modePanel.add(b2);
        this.locData = new Object[1][7];
        this.locData[0][0] = this.listenerLoc.getName();
        this.locData[0][1] = true;
        this.locData[0][2] = this.listenerLoc.getLocation().x;
        this.locData[0][3] = this.listenerLoc.getLocation().y;
        this.locData[0][4] = this.listenerLoc.getLocation().z;
        this.locData[0][5] = this.listenerLoc.getBearing();
        this.locData[0][6] = this.listenerLoc.getAzimuth();
        log.debug("Listener: {}", (Object)this.listenerLoc.toString());
        log.debug("locData:");
        int i = 0;
        while (i < 7) {
            log.debug("{}", this.locData[0][i]);
            ++i;
        }
        JPanel locPanel = new JPanel();
        locPanel.setLayout(new BoxLayout(locPanel, 2));
        JScrollPane locScrollPanel = new JScrollPane();
        this.locModel = new ManageLocationsTableModel.ListenerTableModel(this.locData);
        JTable locTable = new JTable(this.locModel);
        locTable.setFillsViewportHeight(true);
        locTable.setPreferredScrollableViewportSize(new Dimension(520, 200));
        locScrollPanel.getViewport().add(locTable);
        this.listenerPanel.add(modePanel);
        this.listenerPanel.add(locScrollPanel);
        this.reporterPanel = new JPanel();
        this.reporterPanel.setLayout(new GridBagLayout());
        JScrollPane reporterScrollPanel = new JScrollPane();
        this.reporterModel = new ManageLocationsTableModel.ReporterBlockTableModel(this.reporterData);
        JTable reporterTable = new JTable(this.reporterModel);
        reporterTable.setFillsViewportHeight(true);
        reporterTable.setPreferredScrollableViewportSize(new Dimension(540, 200));
        reporterScrollPanel.getViewport().add(reporterTable);
        this.blockPanel = new JPanel();
        this.blockPanel.setLayout(new GridBagLayout());
        JScrollPane blockScrollPanel = new JScrollPane();
        this.blockModel = new ManageLocationsTableModel.ReporterBlockTableModel(this.blockData);
        JTable blockTable = new JTable(this.blockModel);
        blockTable.setFillsViewportHeight(true);
        blockTable.setPreferredScrollableViewportSize(new Dimension(540, 200));
        blockScrollPanel.getViewport().add(blockTable);
        this.opsPanel = new JPanel();
        this.opsPanel.setLayout(new GridBagLayout());
        this.opsPanel.revalidate();
        JScrollPane opsScrollPanel = new JScrollPane();
        this.opsModel = new ManageLocationsTableModel.LocationTableModel(this.opsData);
        JTable opsTable = new JTable(this.opsModel);
        opsTable.setFillsViewportHeight(true);
        opsTable.setPreferredScrollableViewportSize(new Dimension(520, 200));
        opsScrollPanel.getViewport().add(opsTable);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab(Bundle.getMessage("Reporters"), reporterScrollPanel);
        this.tabbedPane.setToolTipTextAt(0, Bundle.getMessage("ToolTipReporterTab"));
        this.tabbedPane.setMnemonicAt(0, Mnemonics.get("ReporterTab"));
        this.tabbedPane.addTab(Bundle.getMessage("Blocks"), blockScrollPanel);
        this.tabbedPane.setToolTipTextAt(1, Bundle.getMessage("ToolTipBlockTab"));
        this.tabbedPane.setMnemonicAt(1, Mnemonics.get("BlockTab"));
        this.tabbedPane.addTab(Bundle.getMessage("FieldOpsTabTitle"), opsScrollPanel);
        this.tabbedPane.setToolTipTextAt(2, Bundle.getMessage("ToolTipOpsTab"));
        this.tabbedPane.setMnemonicAt(2, Mnemonics.get("OpsTab"));
        this.tabbedPane.addTab(Bundle.getMessage("FieldListenersTabTitle"), this.listenerPanel);
        this.tabbedPane.setToolTipTextAt(3, Bundle.getMessage("ToolTipListenerTab"));
        this.tabbedPane.setMnemonicAt(3, Mnemonics.get("ListenerTab"));
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        JButton closeButton = new JButton(Bundle.getMessage("ButtonCancel"));
        closeButton.setToolTipText(Bundle.getMessage("ToolTipButtonMLFClose"));
        closeButton.setMnemonic(Mnemonics.get("CloseButton"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageLocationsFrame.this.closeButtonPressed(e);
            }
        });
        JButton saveButton = new JButton(Bundle.getMessage("ButtonSave"));
        saveButton.setToolTipText(Bundle.getMessage("ToolTipButtonMLFSave"));
        saveButton.setMnemonic(Mnemonics.get("SaveButton"));
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageLocationsFrame.this.saveButtonPressed(e);
            }
        });
        buttonPane.add(closeButton);
        buttonPane.add(saveButton);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(this.tabbedPane);
        this.getContentPane().add(buttonPane);
        this.pack();
        this.setVisible(true);
    }

    private void buildMenu() {
        JMenu editMenu = new JMenu(Bundle.getMessage("MenuEdit"));
        editMenu.add(new VSDPreferencesAction(Bundle.getMessage("VSDecoderFileMenuPreferences")));
        this.menuList = new ArrayList<JMenu>(1);
        this.menuList.add(editMenu);
        this.setJMenuBar(new JMenuBar());
        this.getJMenuBar().add(editMenu);
        this.addHelpMenu("package.jmri.jmrit.vsdecoder.swing.ManageLocationsFrame", true);
    }

    private void saveButtonPressed(ActionEvent e) {
        int value = JOptionPane.showConfirmDialog(null, Bundle.getMessage("FieldMLFSaveDialogConfirmMessage"), Bundle.getMessage("FieldMLFSaveDialogTitle"), 0);
        if (value == 0) {
            this.saveTableValues();
            OperationsXml.save();
        }
        if (Setup.isCloseWindowOnSaveEnabled()) {
            this.dispose();
        }
    }

    @SuppressFBWarnings(value={"WMI_WRONG_MAP_ITERATOR"}, justification="only in slow debug")
    private void saveTableValues() {
        if (((Boolean)this.locModel.getValueAt(0, 1)).booleanValue()) {
            if ((Double)this.locModel.getValueAt(0, 6) != null && ((Double)this.locModel.getValueAt(0, 6) == 90.0 || (Double)this.locModel.getValueAt(0, 6) == -90.0)) {
                JOptionPane.showMessageDialog(null, Bundle.getMessage("FieldTableAzimuthInvalidValue"));
            } else {
                this.listenerLoc.setLocation((Double)this.locModel.getValueAt(0, 2), (Double)this.locModel.getValueAt(0, 3), (Double)this.locModel.getValueAt(0, 4));
                this.listenerLoc.setOrientation((Double)this.locModel.getValueAt(0, 5), (Double)this.locModel.getValueAt(0, 6));
                VSDecoderManager.instance().getVSDecoderPreferences().save();
                VSDecoderManager.instance().getVSDecoderPreferences().setListenerPosition(this.listenerLoc);
            }
        }
        this.data = this.reporterModel.getDataMap();
        ReporterManager mgr = InstanceManager.getDefault(ReporterManager.class);
        for (String s : this.data.keySet()) {
            log.debug("Reporter: {}, Location: {}", (Object)s, (Object)this.data.get(s));
            Reporter r = mgr.getByDisplayName(s);
            if (r == null) continue;
            PhysicalLocation.setBeanPhysicalLocation(this.data.get(s), r);
        }
        this.data = this.blockModel.getDataMap();
        BlockManager bmgr = InstanceManager.getDefault(BlockManager.class);
        for (String s : this.data.keySet()) {
            log.debug("Block: {}, Location: {}", (Object)s, (Object)this.data.get(s));
            Block b = bmgr.getByDisplayName(s);
            if (b == null) continue;
            PhysicalLocation.setBeanPhysicalLocation(this.data.get(s), b);
        }
        this.data = this.opsModel.getDataMap();
        LocationManager lmgr = InstanceManager.getDefault(LocationManager.class);
        for (String s : this.data.keySet()) {
            log.debug("OpsLocation: {}, Location: {}", (Object)s, (Object)this.data.get(s));
            Location l = lmgr.getLocationByName(s);
            l.setPhysicalLocation(this.data.get(s));
        }
    }

    private void modeRadioButtonPressed(ActionEvent e) {
    }

    private void closeButtonPressed(ActionEvent e) {
        this.dispose();
    }
}

