/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.vsdecoder.listener;

import javax.vecmath.Vector3f;
import jmri.AudioManager;
import jmri.InstanceManager;
import jmri.jmrit.audio.AudioFactory;
import jmri.jmrit.audio.AudioListener;
import jmri.jmrit.vsdecoder.listener.ListeningSpot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VSDListener {
    public static final String ListenerSysName = "IAL$";
    private AudioFactory af;
    private AudioListener listener;
    private String sysname;
    private String username;
    private ListeningSpot location;
    private static final Logger log = LoggerFactory.getLogger(VSDListener.class);

    public VSDListener() {
        AudioManager am = InstanceManager.getDefault(AudioManager.class);
        am.init();
        this.af = am.getActiveAudioFactory();
        if (this.af != null) {
            this.listener = this.af.getActiveAudioListener();
            log.debug("Default listener: {}, system name: {}", (Object)this.listener, (Object)this.listener.getSystemName());
            this.setSystemName(this.listener.getSystemName());
            this.setUserName(this.listener.getUserName());
        } else {
            log.warn("AudioFactory not available");
        }
    }

    public String getSystemName() {
        return this.sysname;
    }

    public String getUserName() {
        return this.username;
    }

    public ListeningSpot getLocation() {
        return this.location;
    }

    void setSystemName(String s) {
        this.sysname = s;
    }

    void setUserName(String u) {
        this.username = u;
    }

    public void setLocation(ListeningSpot l) {
        this.location = l;
        this.listener.setPosition(new Vector3f(l.getLocation()));
        this.listener.setOrientation(new Vector3f(l.getLookAtVector()), new Vector3f(l.getUpVector()));
    }
}

