/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.vsdecoder;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import jmri.jmrit.XmlFile;
import jmri.jmrit.vsdecoder.VSDecoderManager;
import jmri.jmrit.vsdecoder.listener.ListeningSpot;
import jmri.util.FileUtil;
import jmri.util.PhysicalLocation;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VSDecoderPreferences {
    public static final String VSDPreferencesFileName = "VSDecoderPreferences.xml";
    public static final Map<AudioMode, String> AudioModeMap;
    public static final AudioMode DefaultAudioMode;
    public static final int DefaultMasterVolume = 80;
    private boolean _autoStartEngine = false;
    private String _defaultVSDFilePath = null;
    private String _defaultVSDFileName = null;
    private boolean _autoLoadDefaultVSDFile = false;
    private ListeningSpot _listenerPosition;
    private AudioMode _audioMode;
    private int _masterVolume;
    private String prefFile;
    private ArrayList<PropertyChangeListener> listeners;
    private static final Logger log;

    static {
        HashMap<AudioMode, String> aMap = new HashMap<AudioMode, String>();
        aMap.put(AudioMode.ROOM_AMBIENT, "RoomAmbient");
        aMap.put(AudioMode.HEADPHONES, "Headphones");
        AudioModeMap = Collections.unmodifiableMap(aMap);
        DefaultAudioMode = AudioMode.ROOM_AMBIENT;
        log = LoggerFactory.getLogger(VSDecoderPreferences.class);
    }

    public VSDecoderPreferences(String sfile) {
        Element root;
        this.prefFile = sfile;
        VSDecoderPrefsXml prefs = new VSDecoderPrefsXml();
        File file = new File(this.prefFile);
        this._defaultVSDFilePath = FileUtil.getExternalFilename("program:resources/vsdecoder");
        this._defaultVSDFileName = "example.vsd";
        this._listenerPosition = new ListeningSpot();
        this._audioMode = DefaultAudioMode;
        this._masterVolume = 80;
        try {
            root = prefs.rootFromFile(file);
        }
        catch (IOException iOException) {
            log.info("Did not find VSDecoder preferences file.  This is normal if you haven't save the preferences before");
            root = null;
        }
        catch (RuntimeException | JDOMException e) {
            log.error("Exception while loading VSDecoder preferences: {}", e);
            root = null;
        }
        if (root != null) {
            this.load(root.getChild("VSDecoderPreferences"));
        }
    }

    public VSDecoderPreferences() {
    }

    public void load(Element e) {
        Element c;
        if (e == null) {
            return;
        }
        Attribute a = e.getAttribute("isAutoStartingEngine");
        if (a != null) {
            this.setAutoStartEngine(a.getValue().compareTo("true") == 0);
        }
        if ((a = e.getAttribute("isAutoLoadingDefaultVSDFile")) != null) {
            this.setAutoLoadDefaultVSDFile(a.getValue().compareTo("true") == 0);
        }
        if ((c = e.getChild("DefaultVSDFilePath")) != null) {
            this.setDefaultVSDFilePath(c.getValue());
        }
        if ((c = e.getChild("DefaultVSDFileName")) != null) {
            this.setDefaultVSDFileName(c.getValue());
        }
        this._listenerPosition = (c = e.getChild("ListenerPosition")) != null ? new ListeningSpot(c) : new ListeningSpot();
        c = e.getChild("AudioMode");
        if (c != null) {
            this.setAudioMode(c.getValue());
        }
        if ((c = e.getChild("MasterVolume")) != null) {
            this.setMasterVolume(Integer.parseInt(c.getValue()));
        }
    }

    private Element store() {
        Element e = new Element("VSDecoderPreferences");
        e.setAttribute("isAutoStartingEngine", "" + this.isAutoStartingEngine());
        e.setAttribute("isAutoLoadingDefaultVSDFile", "" + this.isAutoLoadingDefaultVSDFile());
        Element ec = new Element("DefaultVSDFilePath");
        ec.setText(this.getDefaultVSDFilePath());
        e.addContent((Content)ec);
        ec = new Element("DefaultVSDFileName");
        ec.setText(this.getDefaultVSDFileName());
        e.addContent((Content)ec);
        e.addContent((Content)this._listenerPosition.getXml("ListenerPosition"));
        ec = new Element("AudioMode");
        ec.setText(AudioModeMap.get((Object)this._audioMode));
        ec = new Element("MasterVolume");
        ec.setText("" + this.getMasterVolume());
        e.addContent((Content)ec);
        return e;
    }

    public void set(VSDecoderPreferences tp) {
        this.setAutoStartEngine(tp.isAutoStartingEngine());
        this.setAutoLoadDefaultVSDFile(tp.isAutoLoadingDefaultVSDFile());
        this.setDefaultVSDFilePath(tp.getDefaultVSDFilePath());
        this.setDefaultVSDFileName(tp.getDefaultVSDFileName());
        this.setListenerPosition(tp.getListenerPosition());
        this.setAudioMode(tp.getAudioMode());
        this.setMasterVolume(tp.getMasterVolume());
        if (this.listeners != null) {
            int i = 0;
            while (i < this.listeners.size()) {
                PropertyChangeListener l = this.listeners.get(i);
                PropertyChangeEvent e = new PropertyChangeEvent(this, "VSDecoderPreferences", null, this);
                l.propertyChange(e);
                ++i;
            }
        }
    }

    public boolean compareTo(VSDecoderPreferences tp) {
        return this.isAutoStartingEngine() != tp.isAutoStartingEngine() || this.isAutoLoadingDefaultVSDFile() != tp.isAutoLoadingDefaultVSDFile() || !this.getDefaultVSDFilePath().equals(tp.getDefaultVSDFilePath()) || !this.getDefaultVSDFileName().equals(tp.getDefaultVSDFileName()) || this.getListenerPosition().equals(tp.getListenerPosition()) == false || !this.getAudioMode().equals((Object)tp.getAudioMode()) || !this.getMasterVolume().equals(tp.getMasterVolume());
    }

    public void save() {
        if (this.prefFile == null) {
            return;
        }
        XmlFile xf = new XmlFile(){};
        xf.makeBackupFile(this.prefFile);
        File file = new File(this.prefFile);
        try {
            File parentDir = file.getParentFile();
            if (!parentDir.exists() && !parentDir.mkdir()) {
                log.error("failed to make parent directory");
            }
            if (!file.createNewFile()) {
                log.error("createNewFile failed");
            }
        }
        catch (IOException | RuntimeException exp) {
            log.error("Exception while writing the new VSDecoder preferences file, may not be complete: {}", (Throwable)exp);
        }
        try {
            Element root = new Element("vsdecoder-preferences");
            Document doc = XmlFile.newDocument(root);
            root.setContent((Content)this.store());
            xf.writeXML(file, doc);
        }
        catch (IOException | RuntimeException ex) {
            log.warn("Exception in storing vsdecoder preferences xml: {}", (Throwable)ex);
        }
    }

    public String getDefaultVSDFilePath() {
        return this._defaultVSDFilePath;
    }

    public void setDefaultVSDFilePath(String s) {
        this._defaultVSDFilePath = s;
    }

    public String getDefaultVSDFileName() {
        return this._defaultVSDFileName;
    }

    public void setDefaultVSDFileName(String s) {
        this._defaultVSDFileName = s;
    }

    public boolean isAutoStartingEngine() {
        return this._autoStartEngine;
    }

    public void setAutoStartEngine(boolean b) {
        this._autoStartEngine = b;
    }

    public boolean isAutoLoadingDefaultVSDFile() {
        return this._autoLoadDefaultVSDFile;
    }

    public void setAutoLoadDefaultVSDFile(boolean b) {
        this._autoLoadDefaultVSDFile = b;
    }

    public ListeningSpot getListenerPosition() {
        log.debug("getListenerPosition() : {}", (Object)this._listenerPosition);
        return this._listenerPosition;
    }

    public void setListenerPosition(ListeningSpot p) {
        VSDecoderManager vm = VSDecoderManager.instance();
        vm.setListenerLocation(vm.getDefaultListenerName(), p);
        this._listenerPosition = p;
    }

    public PhysicalLocation getListenerPhysicalLocation() {
        return this._listenerPosition.getPhysicalLocation();
    }

    public void setListenerPosition(PhysicalLocation p) {
        VSDecoderManager vm = VSDecoderManager.instance();
        vm.setListenerLocation(vm.getDefaultListenerName(), new ListeningSpot(p));
    }

    public AudioMode getAudioMode() {
        return this._audioMode;
    }

    public void setAudioMode(AudioMode am) {
        this._audioMode = am;
    }

    public void setAudioMode(String am) {
        Set<Map.Entry<AudioMode, String>> ids = AudioModeMap.entrySet();
        for (Map.Entry<AudioMode, String> e : ids) {
            log.debug("    ID = {} Val = {}", (Object)e.getKey(), (Object)e.getValue());
            if (!e.getValue().equals(am)) continue;
            this._audioMode = e.getKey();
            return;
        }
        this._audioMode = DefaultAudioMode;
    }

    public void setMasterVolume(int v) {
        this._masterVolume = v;
    }

    public Integer getMasterVolume() {
        return this._masterVolume;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(2);
        }
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.listeners == null) {
            return;
        }
        if (this.listeners.contains(l)) {
            this.listeners.remove(l);
        }
    }

    public static enum AudioMode {
        ROOM_AMBIENT,
        HEADPHONES;

    }

    static class VSDecoderPrefsXml
    extends XmlFile {
        VSDecoderPrefsXml() {
        }
    }
}

