/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.vsdecoder;

import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import javax.swing.Timer;
import javax.swing.event.EventListenerList;
import javax.vecmath.Tuple3f;
import jmri.Audio;
import jmri.AudioManager;
import jmri.BasicRosterEntry;
import jmri.Block;
import jmri.BlockManager;
import jmri.IdTag;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.Manager;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.PhysicalLocationReporter;
import jmri.Reportable;
import jmri.Reporter;
import jmri.ReporterManager;
import jmri.implementation.DefaultIdTag;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.vsdecoder.LoadVSDFileAction;
import jmri.jmrit.vsdecoder.VSDConfig;
import jmri.jmrit.vsdecoder.VSDFile;
import jmri.jmrit.vsdecoder.VSDGeoFile;
import jmri.jmrit.vsdecoder.VSDManagerEvent;
import jmri.jmrit.vsdecoder.VSDManagerListener;
import jmri.jmrit.vsdecoder.VSDecoder;
import jmri.jmrit.vsdecoder.VSDecoderManagerThread;
import jmri.jmrit.vsdecoder.VSDecoderPreferences;
import jmri.jmrit.vsdecoder.listener.ListeningSpot;
import jmri.jmrit.vsdecoder.listener.VSDListener;
import jmri.jmrit.vsdecoder.swing.VSDManagerFrame;
import jmri.jmrix.loconet.TranspondingTag;
import jmri.util.FileUtil;
import jmri.util.JmriJFrame;
import jmri.util.PhysicalLocation;
import jmri.util.ThreadingUtil;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VSDecoderManager
implements PropertyChangeListener {
    private static final String vsd_property_change_name = "VSDecoder Manager";
    private static final int RADIUS = 0;
    private static final int SLOPE = 1;
    private static final int ROTATE_XPOS_I = 2;
    private static final int ROTATE_YPOS_I = 3;
    private static final int LENGTH = 4;
    private static final int ADDRESS = 0;
    private static final int BLOCK = 1;
    private static final int DISTANCE_TO_GO = 2;
    private static final int DIRECTION = 3;
    protected NamedBeanHandleManager nbhm = InstanceManager.getDefault(NamedBeanHandleManager.class);
    HashMap<String, VSDListener> listenerTable;
    HashMap<String, VSDecoder> decodertable;
    HashMap<String, VSDecoder> decoderAddressMap;
    HashMap<Integer, VSDecoder> decoderInBlock;
    HashMap<String, String> profiletable;
    private HashMap<String, Timer> timertable;
    private int[][] locoInBlock;
    private float[][][] blockParameter;
    private List<List<PhysicalLocation>> blockPositionlists;
    private List<List<Integer>> reporterlists;
    private List<Boolean> circlelist;
    private PhysicalLocation newPosition;
    private PhysicalLocation posToSet;
    protected EventListenerList listenerList = new EventListenerList();
    private static volatile VSDecoderManagerThread thread = null;
    private VSDecoderPreferences vsdecoderPrefs;
    private JmriJFrame managerFrame = null;
    private VSDecoder default_decoder = null;
    private int vsdecoderID = 0;
    private int locorow = -1;
    private float speed_ms = 0.0f;
    private int check_time;
    private float layout_scale;
    private float distance = 0.0f;
    private float distance_rest = 0.0f;
    private float distance_rest_old = 0.0f;
    private float distance_rest_new = 0.0f;
    private float xPosi;
    public static final int max_decoder = 4;
    boolean is_tunnel = false;
    boolean geofile_ok = false;
    int num_setups;
    private static final Logger log = LoggerFactory.getLogger(VSDecoderManager.class);

    public VSDecoderManager() {
        this.listenerTable = new HashMap();
        this.decodertable = new HashMap();
        this.decoderAddressMap = new HashMap();
        this.timertable = new HashMap();
        this.decoderInBlock = new HashMap();
        this.profiletable = new HashMap();
        this.locoInBlock = new int[4][4];
        this.reporterlists = new ArrayList<List<Integer>>();
        this.blockPositionlists = new ArrayList<List<PhysicalLocation>>();
        this.circlelist = new ArrayList<Boolean>();
        String dirname = String.valueOf(FileUtil.getUserFilesPath()) + "vsdecoder" + File.separator;
        FileUtil.createDirectory(dirname);
        this.vsdecoderPrefs = new VSDecoderPreferences(String.valueOf(dirname) + "VSDecoderPreferences.xml");
        this.setupReporterManagerListener();
        VSDListener t = new VSDListener();
        this.listenerTable.put(t.getSystemName(), t);
        this.setListenerLocation(t.getSystemName(), this.vsdecoderPrefs.getListenerPosition());
        VSDGeoFile gf = new VSDGeoFile();
        if (gf.geofile_ok) {
            this.geofile_ok = true;
            this.num_setups = gf.getNumberOfSetups();
            this.reporterlists = gf.getReporterList();
            this.blockParameter = gf.getBlockParameter();
            this.blockPositionlists = gf.getBlockPosition();
            this.circlelist = gf.getCirclingList();
            this.check_time = gf.check_time;
            this.layout_scale = gf.layout_scale;
        } else {
            this.geofile_ok = false;
        }
    }

    public static VSDecoderManager instance() {
        if (thread == null) {
            thread = VSDecoderManagerThread.instance(true);
        }
        return VSDecoderManagerThread.manager();
    }

    public VSDecoderPreferences getVSDecoderPreferences() {
        return this.vsdecoderPrefs;
    }

    public int getMasterVolume() {
        return this.getVSDecoderPreferences().getMasterVolume();
    }

    public void setMasterVolume(int mv) {
        this.getVSDecoderPreferences().setMasterVolume(mv);
    }

    public JmriJFrame provideManagerFrame() {
        if (this.managerFrame == null) {
            if (GraphicsEnvironment.isHeadless()) {
                String vsdRosterGroup = "VSD";
                if (Roster.getDefault().getRosterGroupList().contains(vsdRosterGroup)) {
                    List<RosterEntry> rosterList = Roster.getDefault().getEntriesInGroup(vsdRosterGroup);
                    int entry_counter = 0;
                    for (RosterEntry entry : rosterList) {
                        if (entry_counter < 4) {
                            VSDConfig config = new VSDConfig();
                            config.setLocoAddress(entry.getDccLocoAddress());
                            log.info("Loading Roster Entry \"{}\", VSDecoder {} ...", (Object)entry.getId(), (Object)config.getLocoAddress());
                            if (entry.getAttribute("VSDecoder_Path") != null && entry.getAttribute("VSDecoder_Profile") != null) {
                                if (!LoadVSDFileAction.loadVSDFile(entry.getAttribute("VSDecoder_Path"))) continue;
                                log.info(" VSD path: {}", (Object)entry.getAttribute("VSDecoder_Path"));
                                config.setProfileName(entry.getAttribute("VSDecoder_Profile"));
                                log.debug(" entry VSD profile: {}", (Object)entry.getAttribute("VSDecoder_Profile"));
                                if (entry.getAttribute("VSDecoder_Volume") != null) {
                                    config.setVolume(Float.parseFloat(entry.getAttribute("VSDecoder_Volume")));
                                } else {
                                    config.setVolume(0.8f);
                                }
                                VSDecoder newDecoder = VSDecoderManager.instance().getVSDecoder(config);
                                if (newDecoder != null) {
                                    log.info("VSD {}, profile \"{}\" ready.", (Object)config.getLocoAddress(), (Object)config.getProfileName());
                                    ++entry_counter;
                                    continue;
                                }
                                log.warn("VSD {} failed", (Object)config.getProfileName());
                                continue;
                            }
                            log.error("Cannot load VSD File - path or profile missing - check your Roster Media");
                            continue;
                        }
                        log.warn("Only {} roster entries allowed. Disgarded {}", (Object)4, (Object)(rosterList.size() - 4));
                    }
                    if (entry_counter == 0) {
                        log.warn("No Roster entry found in Roster Group {}", (Object)vsdRosterGroup);
                    }
                } else {
                    log.warn("Roster group \"{}\" not found", (Object)vsdRosterGroup);
                }
            } else {
                this.managerFrame = new VSDManagerFrame();
            }
        } else {
            log.warn("Virtual Sound Decoder Manager is already running");
        }
        return this.managerFrame;
    }

    private String getNextVSDecoderID() {
        return "IAD:VSD:VSDecoderID" + ++this.vsdecoderID;
    }

    private Integer getNextlocorow() {
        return ++this.locorow;
    }

    @Deprecated
    public VSDecoder getVSDecoder(String profile_name, String path) {
        VSDecoder vsd = new VSDecoder(this.getNextVSDecoderID(), profile_name, path);
        this.decodertable.put(vsd.getId(), vsd);
        if (vsd.getAddress() != null) {
            this.decoderAddressMap.put(vsd.getAddress().toString(), vsd);
        }
        return vsd;
    }

    public VSDecoder getVSDecoder(VSDConfig config) {
        String profile_name = config.getProfileName();
        if (this.decoderAddressMap.containsKey(config.getLocoAddress().toString())) {
            return this.decoderAddressMap.get(config.getLocoAddress().toString());
        }
        if (this.profiletable.containsKey(profile_name)) {
            String path = this.profiletable.get(profile_name);
            log.debug("Profile {} is in table.  Path: {}", (Object)profile_name, (Object)path);
            config.setVSDPath(path);
            config.setId(this.getNextVSDecoderID());
            VSDecoder vsd = new VSDecoder(config);
            this.decodertable.put(vsd.getId(), vsd);
            this.decoderAddressMap.put(vsd.getAddress().toString(), vsd);
            this.decoderInBlock.put(vsd.getAddress().getNumber(), vsd);
            this.locoInBlock[this.getNextlocorow().intValue()][0] = vsd.getAddress().getNumber();
            vsd.setDecoderVolume(vsd.getDecoderVolume());
            if (this.geofile_ok) {
                if (vsd.topspeed == 0) {
                    log.info("Top-speed not defined. No advanced location following possible.");
                } else {
                    this.initSoundPositionTimer(vsd);
                }
            }
            return vsd;
        }
        log.error("Requested profile not loaded: {}", (Object)profile_name);
        return null;
    }

    public VSDecoder getVSDecoderByID(String id) {
        VSDecoder v = this.decodertable.get(id);
        if (v == null) {
            log.debug("No decoder in table! ID: {}", (Object)id);
        }
        return this.decodertable.get(id);
    }

    public VSDecoder getVSDecoderByAddress(String sa) {
        if (sa == null) {
            log.debug("Decoder Address is Null");
            return null;
        }
        log.debug("Decoder Address: {}", (Object)sa);
        VSDecoder rv = this.decoderAddressMap.get(sa);
        if (rv == null) {
            log.debug("Not found.");
        } else {
            log.debug("Found: {}", (Object)rv.getAddress());
        }
        return rv;
    }

    @Deprecated
    public void setDefaultVSDecoder(VSDecoder d) {
        this.default_decoder = d;
    }

    @Deprecated
    public VSDecoder getDefaultVSDecoder() {
        return this.default_decoder;
    }

    public ArrayList<String> getVSDProfileNames() {
        ArrayList<String> sl = new ArrayList<String>();
        for (String p : this.profiletable.keySet()) {
            sl.add(p);
        }
        return sl;
    }

    public Collection<VSDecoder> getVSDecoderList() {
        return this.decodertable.values();
    }

    public String getDefaultListenerName() {
        return "IAL$";
    }

    public ListeningSpot getDefaultListenerLocation() {
        VSDListener l = this.listenerTable.get(this.getDefaultListenerName());
        if (l != null) {
            return l.getLocation();
        }
        return null;
    }

    public void setListenerLocation(String id, ListeningSpot sp) {
        VSDListener l = this.listenerTable.get(id);
        log.debug("Set listener location {} listener: {}", (Object)sp, (Object)l);
        if (l != null) {
            l.setLocation(sp);
        }
    }

    public void setDecoderPositionByID(String id, PhysicalLocation p) {
        VSDecoder d = this.decodertable.get(id);
        if (d != null) {
            d.setPosition(p);
        }
    }

    public void setDecoderPositionByAddr(LocoAddress a, PhysicalLocation l) {
        if (a == null) {
            log.warn("Decoder Address is Null");
            return;
        }
        if (l == null) {
            log.warn("PhysicalLocation is Null");
            return;
        }
        if (l.equals((Tuple3f)PhysicalLocation.Origin)) {
            log.info("Location: {} ... ignoring", (Object)l);
            return;
        }
        log.debug("Decoder Address: {}", (Object)a.getNumber());
        for (VSDecoder d : this.decodertable.values()) {
            if (d == null) {
                log.debug("VSdecoder null pointer!");
                return;
            }
            LocoAddress pa = d.getAddress();
            if (pa == null) {
                log.info("Vsdecoder {} address null!", (Object)d);
                return;
            }
            LocoAddress.Protocol p = d.getAddress().getProtocol();
            if (p == null) {
                log.debug("Vsdecoder {} address = {} protocol null!", (Object)d, (Object)pa);
                return;
            }
            if (p == LocoAddress.Protocol.DCC_LONG || p == LocoAddress.Protocol.DCC_SHORT) {
                p = LocoAddress.Protocol.DCC;
            }
            if (d.getAddress().getNumber() != a.getNumber() || p != a.getProtocol()) continue;
            d.setPosition(l);
        }
    }

    public void addEventListener(VSDManagerListener listener) {
        this.listenerList.add(VSDManagerListener.class, listener);
    }

    public void removeEventListener(VSDManagerListener listener) {
        this.listenerList.remove(VSDManagerListener.class, listener);
    }

    void fireMyEvent(VSDManagerEvent evt) {
        VSDManagerListener[] vSDManagerListenerArray = (VSDManagerListener[])this.listenerList.getListeners(VSDManagerListener.class);
        int n = vSDManagerListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            VSDManagerListener l = vSDManagerListenerArray[n2];
            l.eventAction(evt);
            ++n2;
        }
    }

    public String getProfilePath(String profile) {
        return this.profiletable.get(profile);
    }

    protected void registerReporterListener(String sysName) {
        Reporter r = InstanceManager.getDefault(ReporterManager.class).getReporter(sysName);
        if (r == null) {
            return;
        }
        NamedBeanHandle<Reporter> h = this.nbhm.getNamedBeanHandle(sysName, r);
        PropertyChangeListener[] ll = r.getPropertyChangeListenersByReference(h.getName());
        if (ll.length == 0) {
            r.addPropertyChangeListener(this, h.getName(), vsd_property_change_name);
        }
    }

    protected void registerBeanListener(Manager beanManager, String sysName) {
        Object b = beanManager.getBySystemName(sysName);
        if (b == null) {
            log.debug("No bean by name {}", (Object)sysName);
            return;
        }
        NamedBeanHandle h = this.nbhm.getNamedBeanHandle(sysName, b);
        PropertyChangeListener[] ll = b.getPropertyChangeListenersByReference(h.getName());
        if (ll.length == 0) {
            b.addPropertyChangeListener(this, h.getName(), vsd_property_change_name);
            log.debug("Added listener to bean {} type {}", (Object)b.getDisplayName(), (Object)b.getClass().getName());
        }
    }

    protected void registerReporterListeners() {
        SortedSet reporterSet = InstanceManager.getDefault(ReporterManager.class).getNamedBeanSet();
        for (Reporter r : reporterSet) {
            if (r == null) continue;
            this.registerReporterListener(r.getSystemName());
        }
        SortedSet blockSet = InstanceManager.getDefault(BlockManager.class).getNamedBeanSet();
        for (Block b : blockSet) {
            if (b == null) continue;
            this.registerBeanListener(InstanceManager.getDefault(BlockManager.class), b.getSystemName());
        }
    }

    private void setupReporterManagerListener() {
        InstanceManager.getDefault(ReporterManager.class).addPropertyChangeListener(this);
        SortedSet reporterSet = InstanceManager.getDefault(ReporterManager.class).getNamedBeanSet();
        for (Reporter r : reporterSet) {
            if (r == null) continue;
            this.registerReporterListener(r.getSystemName());
        }
        SortedSet blockSet = InstanceManager.getDefault(BlockManager.class).getNamedBeanSet();
        for (Block b : blockSet) {
            if (b == null) continue;
            this.registerBeanListener(InstanceManager.getDefault(BlockManager.class), b.getSystemName());
        }
    }

    public void deleteDecoder(String address) {
        log.debug("delete Decoder called, VSDecoder DCC address: {}", (Object)address);
        if (this.getVSDecoderByAddress(address) == null) {
            log.warn("VSDecoder not found");
        } else {
            this.removeVSDecoder(address);
        }
    }

    private void removeVSDecoder(String sa) {
        final VSDecoder d = this.getVSDecoderByAddress(sa);
        this.stopSoundPositionTimer(d);
        d.shutdown();
        d.disable();
        this.decodertable.remove(d.getId());
        this.decoderAddressMap.remove(sa);
        this.decoderInBlock.remove(d.getAddress().getNumber());
        this.locoInBlockRemove(d.getAddress().getNumber());
        this.timertable.remove(d.getId());
        --this.locorow;
        d.sound_list.clear();
        d.event_list.clear();
        AudioManager am = InstanceManager.getDefault(AudioManager.class);
        final ArrayList<Audio> sources = new ArrayList<Audio>(am.getNamedBeanSet('S'));
        final ArrayList<Audio> buffers = new ArrayList<Audio>(am.getNamedBeanSet('B'));
        ThreadingUtil.newThread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
                for (Audio source : sources) {
                    if (!source.getSystemName().contains(d.getId())) continue;
                    source.dispose();
                }
                for (Audio buffer : buffers) {
                    if (!buffer.getSystemName().contains(d.getId())) continue;
                    buffer.dispose();
                }
            }
        }).start();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        log.debug("property change type {} name {} old {} new {}", new Object[]{evt.getSource().getClass().getName(), evt.getPropertyName(), evt.getOldValue(), evt.getNewValue()});
        if (evt.getSource() instanceof ReporterManager) {
            this.reporterManagerPropertyChange(evt);
        } else if (evt.getSource() instanceof Reporter) {
            if (this.geofile_ok) {
                this.reporterPropertyChangeGeo(evt);
            } else {
                this.reporterPropertyChange(evt);
            }
        } else if (evt.getSource() instanceof Block) {
            log.debug("Block property change! name: {} old: {} new = {}", new Object[]{evt.getPropertyName(), evt.getOldValue(), evt.getNewValue()});
            this.blockPropertyChange(evt);
        } else if (evt.getSource() instanceof VSDManagerFrame) {
            if (evt.getPropertyName().equals("VSDMF:RemoveDecoder")) {
                this.removeVSDecoder((String)evt.getOldValue());
            } else if (evt.getPropertyName().equals("VSDMF:CloseWindow") && this.managerFrame != null) {
                this.managerFrame = null;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void blockPropertyChange(PropertyChangeEvent event) {
        String repVal;
        Block blk;
        block22: {
            int locoAddress;
            block24: {
                block23: {
                    String eventName;
                    block21: {
                        eventName = event.getPropertyName();
                        if (!(event.getSource() instanceof PhysicalLocationReporter)) {
                            log.debug("Reporter doesn't support physical location reporting.");
                            return;
                        }
                        blk = (Block)event.getSource();
                        repVal = null;
                        if (!eventName.equals("state")) break block21;
                        if ((Integer)event.getNewValue() != 2) {
                            log.debug("Ignoring report. not an OCCUPIED event.");
                            return;
                        }
                        if (blk.getReporter() == null) {
                            log.debug("Block {} has no reporter!  Skipping state-type report", (Object)blk.getSystemName());
                            return;
                        }
                        if (blk.isReportingCurrent()) {
                            Object currentReport = blk.getReporter().getCurrentReport();
                            if (currentReport != null) {
                                repVal = currentReport instanceof Reportable ? ((Reportable)currentReport).toReportString() : currentReport.toString();
                            }
                            break block22;
                        } else {
                            Object lastReport = blk.getReporter().getLastReport();
                            if (lastReport != null) {
                                repVal = lastReport instanceof Reportable ? ((Reportable)lastReport).toReportString() : lastReport.toString();
                            }
                        }
                        break block22;
                    }
                    if (!eventName.equals("value")) {
                        log.debug("Not a supported Block event type.  Ignoring.");
                        return;
                    }
                    if (event.getNewValue() == null) {
                        return;
                    }
                    locoAddress = 0;
                    if (!(event.getNewValue() instanceof String)) break block23;
                    repVal = event.getNewValue().toString();
                    if (Roster.getDefault().getEntryForId(repVal) != null) {
                        locoAddress = Integer.parseInt(Roster.getDefault().getEntryForId(repVal).getDccAddress());
                        break block24;
                    } else if (StringUtils.isNumeric((CharSequence)repVal)) {
                        locoAddress = Integer.parseInt(repVal);
                    }
                    break block24;
                }
                if (event.getNewValue() instanceof BasicRosterEntry) {
                    locoAddress = Integer.parseInt(((RosterEntry)event.getNewValue()).getDccAddress());
                } else if (event.getNewValue() instanceof DefaultIdTag) {
                    log.debug("DefaultIdTag: {}", event.getNewValue());
                } else if (event.getNewValue() instanceof TranspondingTag) {
                    repVal = ((Reportable)event.getNewValue()).toReportString();
                } else {
                    log.warn("Block Value \"{}\" found - unsupported object!", event.getNewValue());
                }
            }
            if (locoAddress != 0) {
                if (this.decoderInBlock.containsKey(locoAddress)) {
                    this.decoderInBlock.get((Object)Integer.valueOf((int)locoAddress)).savedSound.setTunnel(blk.getPhysicalLocation().isTunnel());
                    this.decoderInBlock.get(locoAddress).setPosition(blk.getPhysicalLocation());
                    log.debug("Block value: {}, physical location: {}", event.getNewValue(), (Object)blk.getPhysicalLocation());
                    return;
                }
                log.warn("Block value \"{}\" is not a valid VSDecoder address", event.getNewValue());
                return;
            }
        }
        if (repVal == null) {
            log.warn("Report from Block {} is null!", (Object)blk.getSystemName());
        }
        if (blk.getDirection(repVal) != PhysicalLocationReporter.Direction.ENTER) return;
        this.setDecoderPositionByAddr(blk.getLocoAddress(repVal), blk.getPhysicalLocation());
    }

    public void reporterPropertyChange(PropertyChangeEvent event) {
        String eventName = event.getPropertyName();
        if (event.getSource() instanceof PhysicalLocationReporter && eventName.equals("currentReport")) {
            PhysicalLocationReporter arp = (PhysicalLocationReporter)event.getSource();
            if (event.getNewValue() instanceof IdTag) {
                if (event.getNewValue() instanceof TranspondingTag) {
                    String repVal = ((Reportable)event.getNewValue()).toReportString();
                    if (arp.getDirection(repVal) == PhysicalLocationReporter.Direction.ENTER) {
                        this.decoderInBlock.get((Object)Integer.valueOf((int)arp.getLocoAddress((String)repVal).getNumber())).savedSound.setTunnel(arp.getPhysicalLocation(repVal).isTunnel());
                        this.setDecoderPositionByAddr(arp.getLocoAddress(repVal), arp.getPhysicalLocation(repVal));
                    }
                } else {
                    IdTag newValue = (IdTag)event.getNewValue();
                    this.decoderInBlock.get((Object)Integer.valueOf((int)arp.getLocoAddress((String)newValue.getTagID()).getNumber())).savedSound.setTunnel(arp.getPhysicalLocation(null).isTunnel());
                    this.setDecoderPositionByAddr(arp.getLocoAddress(newValue.getTagID()), arp.getPhysicalLocation(null));
                }
            } else {
                log.debug("Reporter's return type is not supported.");
            }
        } else {
            log.debug("Reporter doesn't support physical location reporting or isn't reporting new info.");
        }
    }

    public void reporterPropertyChangeGeo(PropertyChangeEvent event) {
        String eventName = event.getPropertyName();
        if (event.getSource() instanceof PhysicalLocationReporter && eventName.equals("currentReport")) {
            PhysicalLocationReporter arp = (PhysicalLocationReporter)event.getSource();
            if (event.getNewValue() instanceof IdTag) {
                if (event.getNewValue() instanceof TranspondingTag) {
                    String repVal = ((Reportable)event.getNewValue()).toReportString();
                    LocoAddress xa = arp.getLocoAddress(repVal);
                    log.debug("repVal: {}, xa: {}, number: {}", new Object[]{repVal, xa, xa.getNumber()});
                    if (this.decoderInBlock.containsKey(xa.getNumber())) {
                        VSDecoder d = this.decoderInBlock.get(xa.getNumber());
                        Reporter rp = (Reporter)event.getSource();
                        int new_rp = Integer.parseInt(rp.getSystemName().substring(2));
                        if (this.reporterlists.get(d.setup_index).contains(new_rp)) {
                            if (arp.getDirection(repVal) == PhysicalLocationReporter.Direction.ENTER) {
                                int new_rp_index = this.reporterlists.get(d.setup_index).indexOf(new_rp);
                                log.debug("new_rp: {} new_rp_index: {}", (Object)new_rp, (Object)new_rp_index);
                                int old_rp = -1;
                                int old_rp_index = -1;
                                int ix = this.getArrayIndex(xa.getNumber());
                                if (ix < this.locoInBlock.length) {
                                    old_rp = this.locoInBlock[ix][1];
                                    if (old_rp == 0) {
                                        old_rp = -1;
                                    }
                                    old_rp_index = this.reporterlists.get(d.setup_index).indexOf(old_rp);
                                } else {
                                    log.warn(" Array locoInBlock INDEX {} IS NOT VALID! Set to 0.", (Object)ix);
                                    ix = 0;
                                }
                                log.debug("new_rp: {}, old_rp: {}, new index: {}, old index: {}", new Object[]{new_rp, old_rp, new_rp_index, old_rp_index});
                                if (new_rp != old_rp) {
                                    int lastrepix = this.reporterlists.get(d.setup_index).size() - 1;
                                    if (old_rp == -1 || old_rp_index + d.dirfn == new_rp_index || this.circlelist.get(d.setup_index).booleanValue() && d.dirfn == -1 && old_rp_index == 0 && new_rp_index == lastrepix || this.circlelist.get(d.setup_index).booleanValue() && d.dirfn == 1 && old_rp_index == lastrepix && new_rp_index == 0) {
                                        this.locoInBlock[ix][1] = new_rp;
                                        log.debug(" distance rest (old) to go in block {}: {} cm", (Object)old_rp, (Object)this.locoInBlock[ix][2]);
                                        this.locoInBlock[ix][2] = Math.round(this.blockParameter[d.setup_index][new_rp_index][4] * 100.0f);
                                        log.debug(" distance rest (new) to go in block {}: {} cm", (Object)new_rp, (Object)this.locoInBlock[ix][2]);
                                        this.posToSet = d.dirfn == 1 ? this.blockPositionlists.get(d.setup_index).get(new_rp_index) : this.blockPositionlists.get(d.setup_index).get(new_rp_index + 1);
                                        if (old_rp == -1 && d.startPos != null) {
                                            this.posToSet = d.startPos;
                                        }
                                        d.savedSound.setTunnel(this.blockPositionlists.get(d.setup_index).get(new_rp_index).isTunnel());
                                        log.debug("position to set: {}", (Object)this.posToSet);
                                        this.setDecoderPositionByAddr(xa, this.posToSet);
                                        this.stopSoundPositionTimer(d);
                                        this.startSoundPositionTimer(d);
                                    } else {
                                        log.debug(" Validation failed! Last reporter: {}, new reporter: {}, dirfn: {} for {}", new Object[]{old_rp, new_rp, d.dirfn, xa.getNumber()});
                                    }
                                } else {
                                    log.debug(" Same Reporter, position not set!");
                                }
                            }
                        } else {
                            log.debug("Reporter {} not valid for {} setup {}", new Object[]{new_rp, "VSDGeoData.xml", d.setup_index + 1});
                        }
                    } else {
                        log.debug(" decoder address {} is not valid!", (Object)xa.getNumber());
                    }
                } else {
                    IdTag tagValue = (IdTag)event.getNewValue();
                    log.debug("new value: {}, id: {}", (Object)tagValue, (Object)tagValue.getTagID());
                    this.setDecoderPositionByAddr(arp.getLocoAddress(tagValue.getTagID()), arp.getPhysicalLocation(null));
                }
            } else {
                log.debug("Reporter's return type is not supported");
            }
        } else {
            log.debug("Reporter doesn't support physical location reporting or isn't reporting new info");
        }
    }

    public void reporterManagerPropertyChange(PropertyChangeEvent event) {
        String eventName = event.getPropertyName();
        log.debug("VSDecoder received Reporter Manager Property Change: {}", (Object)eventName);
        if (eventName.equals("length")) {
            for (Reporter r : InstanceManager.getDefault(ReporterManager.class).getNamedBeanSet()) {
                this.registerReporterListener(r.getSystemName());
            }
        }
    }

    public int getArrayIndex(int number) {
        int i = 0;
        while (i < this.locoInBlock.length) {
            if (this.locoInBlock[i][0] == number) {
                return i;
            }
            ++i;
        }
        return this.locoInBlock.length;
    }

    @Deprecated
    public int getNumberOfDecoders() {
        return this.locorow + 1;
    }

    public void locoInBlockRemove(int numb) {
        int k;
        int remove_index = 0;
        int i = 0;
        while (i < this.locoInBlock.length) {
            if (this.locoInBlock[i][0] == numb) {
                remove_index = i;
            }
            ++i;
        }
        i = remove_index;
        while (i < this.locoInBlock.length - 1) {
            k = 0;
            while (k < this.locoInBlock[i].length) {
                this.locoInBlock[i][k] = this.locoInBlock[i + 1][k];
                ++k;
            }
            ++i;
        }
        int il = this.locoInBlock.length - 1;
        k = 0;
        while (k < this.locoInBlock[il].length) {
            this.locoInBlock[il][k] = 0;
            ++k;
        }
    }

    public void loadProfiles(VSDFile vf) {
        Element root = vf.getRoot();
        if (root == null) {
            return;
        }
        ArrayList<String> new_entries = new ArrayList<String>();
        for (Element e : root.getChildren("profile")) {
            String pname = e.getAttributeValue("name");
            log.debug("Profile name: {}", (Object)pname);
            if (pname == null || pname.isEmpty()) continue;
            this.profiletable.put(pname, vf.getName());
            new_entries.add(pname);
        }
        if (!GraphicsEnvironment.isHeadless()) {
            this.fireMyEvent(new VSDManagerEvent(this, VSDManagerEvent.EventType.PROFILE_LIST_CHANGE, new_entries));
        }
    }

    void initSoundPositionTimer(final VSDecoder d) {
        if (this.geofile_ok) {
            Timer t = new Timer(this.check_time, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VSDecoderManager.this.calcNewPosition(d);
                }
            });
            t.setRepeats(true);
            this.timertable.put(d.getId(), t);
            log.debug("timer {} created for decoder {}, id: {}", new Object[]{t, d, d.getId()});
        } else {
            log.debug("No timer created, GeoData not available");
        }
    }

    void startSoundPositionTimer(VSDecoder d) {
        Timer t = this.timertable.get(d.getId());
        if (t != null) {
            t.setInitialDelay(this.check_time);
            t.start();
            log.debug("timer {} started for decoder id {}, {}, check time: {}", new Object[]{t, d.getId(), d, this.check_time});
        }
    }

    void stopSoundPositionTimer(VSDecoder d) {
        Timer t = this.timertable.get(d.getId());
        if (t != null) {
            if (t.isRunning()) {
                t.stop();
                log.debug("timer {} stopped for {}", (Object)t, (Object)d);
            } else {
                log.debug("timer {} was not running", (Object)t);
            }
        }
    }

    public void calcNewPosition(VSDecoder d) {
        if (d.currentspeed > 0.0f && d.topspeed > 0) {
            int dadr = d.getAddress().getNumber();
            int dadr_index = this.getArrayIndex(dadr);
            if (dadr_index < this.locoInBlock.length) {
                int dadr_block = this.locoInBlock[dadr_index][1];
                if (this.reporterlists.get(d.setup_index).contains(dadr_block)) {
                    int dadr_block_index = this.reporterlists.get(d.setup_index).indexOf(dadr_block);
                    this.newPosition = new PhysicalLocation(0.0f, 0.0f, 0.0f, d.savedSound.getTunnel());
                    this.speed_ms = d.currentspeed * (float)(d.dirfn == 1 ? d.topspeed : d.topspeed_rev) * 0.44704f / this.layout_scale;
                    this.distance = this.speed_ms * (float)this.check_time / 1000.0f;
                    if (this.locoInBlock[dadr_index][3] == 0) {
                        this.locoInBlock[dadr_index][3] = d.dirfn;
                    }
                    this.distance_rest_old = (float)this.locoInBlock[dadr_index][2] / 100.0f;
                    if (this.locoInBlock[dadr_index][3] == d.dirfn) {
                        this.distance_rest = this.distance_rest_old;
                    } else {
                        this.distance_rest = this.blockParameter[d.setup_index][dadr_block_index][4] - this.distance_rest_old;
                        this.locoInBlock[dadr_index][3] = d.dirfn;
                    }
                    this.distance_rest_new = this.distance_rest - this.distance;
                    log.debug(" distance_rest_old: {}, distance_rest: {}, distance_rest_new: {} (all in Meter)", new Object[]{Float.valueOf(this.distance_rest_old), Float.valueOf(this.distance_rest), Float.valueOf(this.distance_rest_new)});
                    if (this.distance_rest_new > 0.0f) {
                        if (this.blockParameter[d.setup_index][dadr_block_index][0] == 0.0f) {
                            this.xPosi = this.distance * (float)(-d.dirfn) * (float)Math.sqrt(1.0f / (1.0f + this.blockParameter[d.setup_index][dadr_block_index][1] * this.blockParameter[d.setup_index][dadr_block_index][1]));
                            this.newPosition.x = d.lastPos.x - this.xPosi;
                            this.newPosition.y = d.lastPos.y - this.xPosi * this.blockParameter[d.setup_index][dadr_block_index][1];
                            this.newPosition.z = 0.0f;
                        } else {
                            float anglePos = this.distance / this.blockParameter[d.setup_index][dadr_block_index][0] * (float)(-d.dirfn);
                            float rotate_xpos = this.blockParameter[d.setup_index][dadr_block_index][2];
                            float rotate_ypos = this.blockParameter[d.setup_index][dadr_block_index][3];
                            this.newPosition.x = rotate_xpos + (float)Math.cos(anglePos) * (d.lastPos.x - rotate_xpos) - (float)Math.sin(anglePos) * (d.lastPos.y - rotate_ypos);
                            this.newPosition.y = rotate_ypos + (float)Math.sin(anglePos) * (d.lastPos.x - rotate_xpos) + (float)Math.cos(anglePos) * (d.lastPos.y - rotate_ypos);
                            this.newPosition.z = 0.0f;
                        }
                        log.debug("position to set: {}", (Object)this.newPosition);
                        d.setPosition(this.newPosition);
                        log.debug(" distance rest to go in block: {} of {} cm", (Object)Math.round(this.distance_rest_new * 100.0f), (Object)Math.round(this.blockParameter[d.setup_index][dadr_block_index][4] * 100.0f));
                        this.locoInBlock[dadr_index][2] = Math.round(this.distance_rest_new * 100.0f);
                        log.debug(" saved distance rest: {}", (Object)this.locoInBlock[dadr_index][2]);
                    } else {
                        log.debug(" new position not set due to less distance");
                    }
                } else {
                    log.warn(" block for loco address {} not yet identified. May be there is another loco in the same block", (Object)dadr);
                }
            } else {
                log.warn(" decoder {} not found", (Object)dadr);
            }
        }
    }
}

