/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.vsdecoder;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import jmri.InstanceManager;
import jmri.Reporter;
import jmri.ReporterManager;
import jmri.Scale;
import jmri.ScaleManager;
import jmri.jmrit.XmlFile;
import jmri.util.FileUtil;
import jmri.util.PhysicalLocation;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VSDGeoFile
extends XmlFile {
    static final String VSDGeoDataFileName = "VSDGeoData.xml";
    protected Element root;
    private float[][][] blockParameter;
    private List<List<PhysicalLocation>> blockPositionlists;
    private List<List<Integer>> reporterlists = new ArrayList<List<Integer>>();
    private List<Boolean> circlelist;
    private int setup_index;
    private int num_issues;
    boolean geofile_ok;
    int num_setups;
    Scale _layout_scale;
    float layout_scale;
    int check_time;
    private static final Logger log = LoggerFactory.getLogger(VSDGeoFile.class);

    public VSDGeoFile() {
        ArrayList[] reporterlist = new ArrayList[4];
        this.blockPositionlists = new ArrayList<List<PhysicalLocation>>();
        ArrayList[] blockPositionlist = new ArrayList[4];
        int i = 0;
        while (i < 4) {
            reporterlist[i] = new ArrayList();
            blockPositionlist[i] = new ArrayList();
            ++i;
        }
        this.circlelist = new ArrayList<Boolean>();
        File file = new File(String.valueOf(FileUtil.getUserFilesPath()) + VSDGeoDataFileName);
        this.num_issues = 0;
        try {
            this.root = this.rootFromFile(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.debug("{} for train tracking is not available", (Object)VSDGeoDataFileName);
            this.root = null;
        }
        catch (Exception e2) {
            log.error("Exception while loading file {}:", (Object)VSDGeoDataFileName, (Object)e2);
            this.root = null;
        }
        if (this.root == null) {
            this.geofile_ok = false;
            return;
        }
        String n = this.root.getChildText("layout-scale");
        if (n != null) {
            this._layout_scale = ScaleManager.getScale(n);
            if (this._layout_scale == null) {
                this._layout_scale = ScaleManager.getScale("N");
                log.info("{}: Element layout-scale '{}' unknown, defaulting to N", (Object)VSDGeoDataFileName, (Object)n);
            }
        } else {
            this._layout_scale = ScaleManager.getScale("N");
            log.info("{}: Element layout-scale missing, defaulting to N", (Object)VSDGeoDataFileName);
        }
        this.layout_scale = (float)this._layout_scale.getScaleRatio();
        log.debug("layout-scale: {}, used for further calculations: {}", (Object)this._layout_scale.toString(), (Object)Float.valueOf(this.layout_scale));
        n = this.root.getChildText("check-time");
        if (n != null) {
            this.check_time = Integer.parseInt(n);
            if (this.check_time < 500 || this.check_time > 5000) {
                this.check_time = 2000;
                log.info("{}: Element check-time not in range, defaulting to {} ms", (Object)VSDGeoDataFileName, (Object)this.check_time);
            }
        } else {
            this.check_time = 2000;
            log.info("{}: Element check-time missing, defaulting to {} ms", (Object)VSDGeoDataFileName, (Object)this.check_time);
        }
        log.debug("check-time: {} ms", (Object)this.check_time);
        this.num_setups = 0;
        int num_geodatasets = 0;
        int max_geodatasets = 0;
        for (Element c : this.root.getChildren("setup")) {
            num_geodatasets = c.getChildren("geodataset").size();
            log.debug("setup {} has {} geodataset(s)", (Object)(this.num_setups + 1), (Object)num_geodatasets);
            if (num_geodatasets > max_geodatasets) {
                max_geodatasets = num_geodatasets;
            }
            ++this.num_setups;
        }
        log.debug("counting setups: {}, maximum geodatasets: {}", (Object)this.num_setups, (Object)max_geodatasets);
        if (this.num_setups == 0 || num_geodatasets == 0 || this.num_setups > 4) {
            log.warn("{}: Invalid number of setups or geodatasets", (Object)VSDGeoDataFileName);
            this.geofile_ok = false;
            return;
        }
        this.blockParameter = new float[this.num_setups][max_geodatasets][5];
        this.setup_index = 0;
        for (Element c0 : this.root.getChildren("setup")) {
            log.debug("--- SETUP: {}", (Object)(this.setup_index + 1));
            boolean is_end_position_set = false;
            int j = 0;
            for (Element c1 : c0.getChildren("geodataset")) {
                Reporter rep = null;
                int rep_int = 0;
                String np = c1.getChildText("reporter-systemname");
                if (np != null) {
                    rep = InstanceManager.getDefault(ReporterManager.class).getBySystemName(np);
                    if (rep != null) {
                        rep_int = Integer.parseInt(np.substring(2));
                        reporterlist[this.setup_index].add(rep_int);
                        n = c1.getChildText("position");
                        if (n != null) {
                            PhysicalLocation pl = PhysicalLocation.parse(n);
                            blockPositionlist[this.setup_index].add(pl);
                            PhysicalLocation.setBeanPhysicalLocation(pl, rep);
                            log.debug("Reporter: {}, position set to: {}", (Object)rep, (Object)pl);
                        } else {
                            log.warn("{}: Element position not found", (Object)VSDGeoDataFileName);
                            ++this.num_issues;
                        }
                        n = c1.getChildText("radius");
                        if (n != null) {
                            this.blockParameter[this.setup_index][j][0] = Float.parseFloat(n);
                            log.debug(" radius: {}", (Object)n);
                        } else {
                            log.warn("{}: Element radius not found", (Object)VSDGeoDataFileName);
                            ++this.num_issues;
                        }
                        n = c1.getChildText("slope");
                        if (n != null) {
                            this.blockParameter[this.setup_index][j][1] = Float.parseFloat(n);
                            log.debug(" slope: {}", (Object)n);
                        } else if (this.blockParameter[this.setup_index][j][0] == 0.0f) {
                            log.warn("{}: Element slope not found", (Object)VSDGeoDataFileName);
                            ++this.num_issues;
                        }
                        n = c1.getChildText("rotate-xpos");
                        if (n != null) {
                            this.blockParameter[this.setup_index][j][2] = Float.parseFloat(n);
                            log.debug(" rotate-xpos: {}", (Object)n);
                        } else if (this.blockParameter[this.setup_index][j][0] > 0.0f) {
                            log.warn("{}: Element rotate-xpos not found", (Object)VSDGeoDataFileName);
                            ++this.num_issues;
                        }
                        n = c1.getChildText("rotate-ypos");
                        if (n != null) {
                            this.blockParameter[this.setup_index][j][3] = Float.parseFloat(n);
                            log.debug(" rotate-ypos: {}", (Object)n);
                        } else if (this.blockParameter[this.setup_index][j][0] > 0.0f) {
                            log.warn("{}: Element rotate-ypos not found", (Object)VSDGeoDataFileName);
                            ++this.num_issues;
                        }
                        n = c1.getChildText("length");
                        if (n != null) {
                            this.blockParameter[this.setup_index][j][4] = Float.parseFloat(n);
                            log.debug(" length: {}", (Object)n);
                        } else {
                            log.warn("{}: Element length not found", (Object)VSDGeoDataFileName);
                            ++this.num_issues;
                        }
                        n = c1.getChildText("end-position");
                        if (n != null) {
                            if (!is_end_position_set) {
                                blockPositionlist[this.setup_index].add(PhysicalLocation.parse(n));
                                is_end_position_set = true;
                                log.debug("end-position for location {} set to {}", (Object)j, blockPositionlist[this.setup_index].get(blockPositionlist[this.setup_index].size() - 1));
                            } else {
                                log.warn("{}: Only the last geodataset should have an end-position", (Object)VSDGeoDataFileName);
                                ++this.num_issues;
                            }
                        }
                    } else {
                        log.warn("{}: No Reporter available for system name = {}", (Object)VSDGeoDataFileName, (Object)np);
                        ++this.num_issues;
                    }
                } else {
                    log.warn("{}: Reporter system name missing", (Object)VSDGeoDataFileName);
                    ++this.num_issues;
                }
                ++j;
            }
            if (!is_end_position_set) {
                log.warn("{}: End-position missing for setup {}", (Object)VSDGeoDataFileName, (Object)(this.setup_index + 1));
                ++this.num_issues;
            }
            if (this.num_issues == 0) {
                this.reporterlists.add(reporterlist[this.setup_index]);
                this.blockPositionlists.add(blockPositionlist[this.setup_index]);
                int last_index = blockPositionlist[this.setup_index].size() - 1;
                log.debug("first setup position: {}, last setup position: {}", blockPositionlist[this.setup_index].get(0), blockPositionlist[this.setup_index].get(last_index));
                if (((PhysicalLocation)((Object)blockPositionlist[this.setup_index].get((int)0))).x == ((PhysicalLocation)((Object)blockPositionlist[this.setup_index].get((int)last_index))).x && ((PhysicalLocation)((Object)blockPositionlist[this.setup_index].get((int)0))).y == ((PhysicalLocation)((Object)blockPositionlist[this.setup_index].get((int)last_index))).y && ((PhysicalLocation)((Object)blockPositionlist[this.setup_index].get((int)0))).z == ((PhysicalLocation)((Object)blockPositionlist[this.setup_index].get((int)last_index))).z) {
                    this.circlelist.add(true);
                } else {
                    this.circlelist.add(false);
                }
                log.debug("circling: {}", (Object)this.circlelist.get(this.setup_index));
            }
            ++this.setup_index;
        }
        if (log.isDebugEnabled()) {
            log.debug("--- LISTS");
            log.debug("number of Reporter lists: {}", (Object)this.reporterlists.size());
            log.debug("Reporter lists with their Reporters (digit only): {}", this.reporterlists);
            log.debug("number of Position lists: {}", (Object)this.blockPositionlists.size());
            log.debug("Position lists: {}", this.blockPositionlists);
            log.debug("--- COUNTERS");
            log.debug("number of setups: {}", (Object)this.num_setups);
            log.debug("number of issues: {}", (Object)this.num_issues);
        }
        this.geofile_ok = this.num_issues <= 0;
    }

    public int getNumberOfSetups() {
        return this.num_setups;
    }

    public List<List<Integer>> getReporterList() {
        return this.reporterlists;
    }

    public float[][][] getBlockParameter() {
        return this.blockParameter;
    }

    public List<List<PhysicalLocation>> getBlockPosition() {
        return this.blockPositionlists;
    }

    public List<Boolean> getCirclingList() {
        return this.circlelist;
    }
}

