/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.vsdecoder;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Timer;
import jmri.jmrit.vsdecoder.EngineSound;
import jmri.jmrit.vsdecoder.SoundBite;
import jmri.jmrit.vsdecoder.VSDFile;
import jmri.util.PhysicalLocation;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SteamSound
extends EngineSound {
    ArrayList<RPMSound> rpm_sounds;
    int top_speed;
    private int driver_diameter;
    private int num_cylinders;
    RPMSound current_rpm_sound;
    private float exponent;
    private static final Logger log = LoggerFactory.getLogger(SteamSound.class);

    public SteamSound(String name) {
        super(name);
    }

    @Override
    public void changeLocoDirection(int d) {
        log.debug("loco direction: {}", (Object)d);
    }

    @Override
    public void startEngine() {
        log.debug("Starting Engine");
        this.current_rpm_sound = this.getRPMSound(0);
        this.current_rpm_sound.sound.loop();
    }

    @Override
    public void stopEngine() {
        this.current_rpm_sound.sound.fadeOut();
        if (this.current_rpm_sound.use_chuff) {
            this.current_rpm_sound.stopChuff();
        }
    }

    private RPMSound getRPMSound(int rpm) {
        int i = 1;
        for (RPMSound rps : this.rpm_sounds) {
            if (rps.min_rpm <= rpm && rps.max_rpm >= rpm) {
                if (this.engine_pane != null) {
                    this.engine_pane.setThrottle(i);
                }
                return rps;
            }
            ++i;
        }
        return null;
    }

    private int calcRPM(float t) {
        double rpm_f = this.speedCurve(t) * (double)this.top_speed * 1056.0 / (Math.PI * (double)this.driver_diameter);
        log.debug("RPM Calculated: {}, (int) {}", (Object)rpm_f, (Object)((int)Math.round(rpm_f)));
        return (int)Math.round(rpm_f);
    }

    @Override
    double speedCurve(float t) {
        return Math.pow(t, this.exponent) / 1.0;
    }

    private int calcChuffInterval(int rpm) {
        return 30000 / this.num_cylinders / rpm;
    }

    @Override
    public void changeThrottle(float t) {
        if (this.isEngineStarted()) {
            if (t < 0.0f) {
                this.current_rpm_sound.sound.fadeOut();
                if (this.current_rpm_sound.use_chuff) {
                    this.current_rpm_sound.stopChuff();
                }
                this.current_rpm_sound = this.getRPMSound(0);
                this.current_rpm_sound.sound.loop();
            } else {
                RPMSound rps = this.getRPMSound(this.calcRPM(t));
                if (rps != null) {
                    if (rps != this.current_rpm_sound) {
                        if (this.current_rpm_sound != null && this.current_rpm_sound.sound != null) {
                            this.current_rpm_sound.sound.fadeOut();
                            if (this.current_rpm_sound.use_chuff) {
                                this.current_rpm_sound.stopChuff();
                            }
                        }
                        this.current_rpm_sound = rps;
                        if (rps.use_chuff) {
                            rps.setRPM(this.calcRPM(t));
                            rps.startChuff();
                        }
                        rps.sound.fadeIn();
                    } else if (rps.use_chuff) {
                        rps.setRPM(this.calcRPM(t));
                    }
                } else {
                    log.warn("No adequate sound file found for RPM = {}", (Object)this.calcRPM(t));
                }
                log.debug("RPS: {}, RPM: {}, current_RPM: {}", new Object[]{rps, this.calcRPM(t), this.current_rpm_sound});
            }
        }
    }

    @Override
    public void shutdown() {
        for (RPMSound rps : this.rpm_sounds) {
            if (rps.use_chuff) {
                rps.stopChuff();
            }
            rps.sound.stop();
        }
    }

    @Override
    public void mute(boolean m) {
        for (RPMSound rps : this.rpm_sounds) {
            rps.sound.mute(m);
        }
    }

    @Override
    public void setVolume(float v) {
        for (RPMSound rps : this.rpm_sounds) {
            rps.sound.setVolume(v);
        }
    }

    @Override
    public void setPosition(PhysicalLocation p) {
        for (RPMSound rps : this.rpm_sounds) {
            rps.sound.setPosition(p);
        }
    }

    @Override
    public Element getXml() {
        return super.getXml();
    }

    @Override
    public void setXml(Element e, VSDFile vf) {
        super.setXml(e, vf);
        log.debug("Steam EngineSound: {}, name: {}", (Object)e.getAttribute("name").getValue(), (Object)this.name);
        this.top_speed = Integer.parseInt(e.getChildText("top-speed"));
        log.debug("top speed forward: {} MPH", (Object)this.top_speed);
        String n = e.getChildText("driver-diameter");
        if (n != null) {
            this.driver_diameter = Integer.parseInt(n);
            log.debug("Driver diameter: {} inches", (Object)this.driver_diameter);
        }
        if ((n = e.getChildText("cylinders")) != null) {
            this.num_cylinders = Integer.parseInt(n);
            log.debug("Num Cylinders: {}", (Object)this.num_cylinders);
        }
        this.exponent = (n = e.getChildText("exponent")) != null ? Float.parseFloat(n) : 2.0f;
        log.debug("exponent: {}", (Object)Float.valueOf(this.exponent));
        this.is_auto_start = this.setXMLAutoStart(e);
        log.debug("config auto-start: {}", (Object)this.is_auto_start);
        this.rpm_sounds = new ArrayList();
        Iterator itr = e.getChildren("rpm-step").iterator();
        int i = 0;
        while (itr.hasNext()) {
            Element el = (Element)itr.next();
            String fn = el.getChildText("file");
            int min_r = Integer.parseInt(el.getChildText("min-rpm"));
            int max_r = Integer.parseInt(el.getChildText("max-rpm"));
            log.debug("file #: {}, file name: {}", (Object)i, (Object)fn);
            SoundBite sb = new SoundBite(vf, fn, String.valueOf(this.name) + "_Steam_n" + i, String.valueOf(this.name) + "_Steam_" + i);
            sb.setLooped(true);
            sb.setFadeTimes(100, 100);
            sb.setReferenceDistance(this.setXMLReferenceDistance(el));
            sb.setGain(this.setXMLGain(el));
            boolean chuff = false;
            Element c = el.getChild("use-chuff-gen");
            if (c != null) {
                log.debug("Use Chuff Generator: {}", (Object)c);
                chuff = true;
            }
            this.rpm_sounds.add(new RPMSound(sb, min_r, max_r, chuff));
            ++i;
        }
        this.autoStartCheck();
    }

    class RPMSound {
        public SoundBite sound;
        public int min_rpm;
        public int max_rpm;
        public boolean use_chuff;
        private Timer t;

        public RPMSound(SoundBite sb, int min_r, int max_r, boolean chuff) {
            this.sound = sb;
            this.min_rpm = min_r;
            this.max_rpm = max_r;
            this.use_chuff = chuff;
            if (this.use_chuff) {
                this.sound.setLooped(false);
                this.t = SteamSound.this.newTimer(1, true, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        RPMSound.this.doChuff();
                    }
                });
            }
        }

        private void doChuff() {
            this.sound.play();
        }

        public void setRPM(int rpm) {
            if (this.use_chuff) {
                this.t.setDelay(SteamSound.this.calcChuffInterval(rpm));
            }
        }

        public void startChuff() {
            if (!this.t.isRunning()) {
                this.t.start();
            }
        }

        public void stopChuff() {
            this.t.stop();
        }
    }
}

