/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.vsdecoder;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Timer;
import jmri.AudioException;
import jmri.AudioManager;
import jmri.InstanceManager;
import jmri.jmrit.audio.AudioBuffer;
import jmri.jmrit.vsdecoder.AudioUtil;
import jmri.jmrit.vsdecoder.EngineSound;
import jmri.jmrit.vsdecoder.SoundBite;
import jmri.jmrit.vsdecoder.VSDFile;
import jmri.jmrit.vsdecoder.VSDSound;
import jmri.jmrit.vsdecoder.VSDecoder;
import jmri.jmrit.vsdecoder.VSDecoderManager;
import jmri.util.PhysicalLocation;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Steam1Sound
extends EngineSound {
    private HashMap<Integer, S1Notch> notch_sounds;
    private HashMap<String, SoundBite> trigger_sounds;
    private String _soundName;
    int top_speed;
    int top_speed_reverse;
    private float driver_diameter_float;
    private int num_cylinders;
    private float exponent;
    private int accel_rate;
    private int decel_rate;
    private int brake_time;
    private int decel_trigger_rpms;
    private int wait_factor;
    private boolean is_dynamic_gain;
    private SoundBite idle_sound;
    private SoundBite boiling_sound;
    private SoundBite brake_sound;
    private SoundBite pre_arrival_sound;
    private S1LoopThread _loopThread = null;
    private Timer rpmTimer;
    private int accdectime;
    private static final Logger log = LoggerFactory.getLogger(Steam1Sound.class);

    public Steam1Sound(String name) {
        super(name);
        log.debug("New Steam1Sound name(param): {}, name(val): {}", (Object)name, (Object)this.getName());
    }

    private void startThread() {
        this._loopThread = new S1LoopThread(this, this._soundName, this.top_speed, this.top_speed_reverse, this.driver_diameter_float, this.num_cylinders, this.decel_trigger_rpms, true);
        this._loopThread.setName("Steam1Sound.S1LoopThread");
        log.debug("Loop Thread Started.  Sound name: {}", (Object)this._soundName);
    }

    @Override
    public void changeThrottle(float s) {
        if (this._loopThread != null) {
            this._loopThread.setThrottle(s);
        }
    }

    @Override
    public void changeLocoDirection(int dirfn) {
        log.debug("loco IsForward is {}", (Object)dirfn);
        if (this._loopThread != null) {
            this._loopThread.getLocoDirection(dirfn);
        }
    }

    @Override
    public void functionKey(String event, boolean value, String name) {
        log.debug("throttle function key {} pressed for {}: {}", new Object[]{event, name, value});
        if (this._loopThread != null) {
            this._loopThread.setFunction(event, value, name);
        }
    }

    @Override
    double speedCurve(float t) {
        return Math.pow(t, this.exponent);
    }

    private S1Notch getNotch(int n) {
        return this.notch_sounds.get(n);
    }

    private void initAccDecTimer() {
        this.rpmTimer = this.newTimer(1, true, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Steam1Sound.this._loopThread != null) {
                    Steam1Sound.this.rpmTimer.setDelay(Steam1Sound.this.accdectime);
                    Steam1Sound.this._loopThread.updateRpm();
                }
            }
        });
        log.debug("timer {} initialized, delay: {}", (Object)this.rpmTimer, (Object)this.accdectime);
    }

    private void startAccDecTimer() {
        if (!this.rpmTimer.isRunning()) {
            this.rpmTimer.start();
            log.debug("timer {} started, delay: {}", (Object)this.rpmTimer, (Object)this.accdectime);
        }
    }

    private void stopAccDecTimer() {
        if (this.rpmTimer.isRunning()) {
            this.rpmTimer.stop();
            log.debug("timer {} stopped, delay: {}", (Object)this.rpmTimer, (Object)this.accdectime);
        }
    }

    private VSDecoder getVsd() {
        return VSDecoderManager.instance().getVSDecoderByID(this._soundName.substring(0, this._soundName.indexOf("ENGINE") - 1));
    }

    @Override
    public void startEngine() {
        log.debug("startEngine. ID: {}", (Object)this.getName());
        if (this._loopThread != null) {
            this._loopThread.startEngine();
        }
    }

    @Override
    public void stopEngine() {
        log.debug("stopEngine. ID = {}", (Object)this.getName());
        if (this._loopThread != null) {
            this._loopThread.stopEngine();
        }
    }

    @Override
    public void shutdown() {
        for (VSDSound vSDSound : this.trigger_sounds.values()) {
            log.debug(" Stopping trigger sound: {}", (Object)vSDSound.getName());
            vSDSound.stop();
        }
        if (this.rpmTimer != null) {
            this.stopAccDecTimer();
        }
        if (this._loopThread != null) {
            this._loopThread.setRunning(false);
        }
    }

    @Override
    public void mute(boolean m) {
        if (this._loopThread != null) {
            this._loopThread.mute(m);
        }
    }

    @Override
    public void setVolume(float v) {
        if (this._loopThread != null) {
            this._loopThread.setVolume(v);
        }
    }

    @Override
    public void setPosition(PhysicalLocation p) {
        if (this._loopThread != null) {
            this._loopThread.setPosition(p);
        }
    }

    @Override
    public Element getXml() {
        Element me = new Element("sound");
        me.setAttribute("name", this.getName());
        me.setAttribute("type", "engine");
        return me;
    }

    @Override
    public void setXml(Element e, VSDFile vf) {
        String fn;
        Element el2;
        boolean buffer_ok = true;
        super.setXml(e, vf);
        this._soundName = String.valueOf(this.getName()) + ":LoopSound";
        log.debug("Steam1: name: {}, soundName: {}", (Object)this.getName(), (Object)this._soundName);
        this.top_speed = Integer.parseInt(e.getChildText("top-speed"));
        log.debug("top speed forward: {} MPH", (Object)this.top_speed);
        String n = e.getChildText("top-speed-reverse");
        this.top_speed_reverse = n != null && !n.isEmpty() ? Integer.parseInt(n) : this.top_speed;
        log.debug("top speed reverse: {} MPH", (Object)this.top_speed_reverse);
        this.driver_diameter_float = Float.parseFloat(e.getChildText("driver-diameter-float"));
        log.debug("driver diameter: {} inches", (Object)Float.valueOf(this.driver_diameter_float));
        this.num_cylinders = Integer.parseInt(e.getChildText("cylinders"));
        log.debug("Number of cylinders defined: {}", (Object)this.num_cylinders);
        n = e.getChildText("exponent");
        this.exponent = n != null && !n.isEmpty() ? Float.parseFloat(n) : 1.0f;
        log.debug("exponent: {}", (Object)Float.valueOf(this.exponent));
        n = e.getChildText("accel-rate");
        this.accel_rate = n != null && !n.isEmpty() ? Integer.parseInt(n) : 35;
        log.debug("accel rate: {}", (Object)this.accel_rate);
        n = e.getChildText("decel-rate");
        this.decel_rate = n != null && !n.isEmpty() ? Integer.parseInt(n) : 18;
        log.debug("decel rate: {}", (Object)this.decel_rate);
        n = e.getChildText("brake-time");
        this.brake_time = n != null && !n.isEmpty() ? Integer.parseInt(n) : 0;
        log.debug("brake time: {}", (Object)this.brake_time);
        this.is_auto_start = this.setXMLAutoStart(e);
        log.debug("config auto-start: {}", (Object)this.is_auto_start);
        this.engine_rd = this.setXMLEngineReferenceDistance(e);
        log.debug("engine-sound referenceDistance: {}", (Object)Float.valueOf(this.engine_rd));
        n = e.getChildText("engine-gain");
        if (n != null && !n.isEmpty()) {
            this.engine_gain = Float.parseFloat(n);
            if (this.engine_gain < 0.4f || this.engine_gain > 1.0f) {
                log.info("Invalid engine gain {} was set to default {}", (Object)Float.valueOf(this.engine_gain), (Object)Float.valueOf(0.8f));
                this.engine_gain = 0.8f;
            }
        } else {
            this.engine_gain = 0.8f;
        }
        log.debug("engine gain: {}", (Object)Float.valueOf(this.engine_gain));
        n = e.getChildText("dynamic-gain");
        this.is_dynamic_gain = n != null && n.equals("yes");
        log.debug("dynamic gain: {}", (Object)this.is_dynamic_gain);
        n = e.getChildText("wait-factor");
        if (n != null && !n.isEmpty()) {
            this.wait_factor = Integer.parseInt(n);
            if (this.wait_factor < 5 || this.wait_factor > 40) {
                log.info("Invalid wait-factor {} was set to default 18", (Object)this.wait_factor);
                this.wait_factor = 18;
            }
        } else {
            this.wait_factor = 18;
        }
        log.debug("number of loops to subtract from interval: {}", (Object)this.wait_factor);
        n = e.getChildText("decel-trigger-rpms");
        this.decel_trigger_rpms = n != null && !n.isEmpty() ? Integer.parseInt(n) : 999;
        log.debug("number of rpms to trigger decelerating actions: {}", (Object)this.decel_trigger_rpms);
        this.sleep_interval = this.setXMLSleepInterval(e);
        log.debug("sleep interval: {}", (Object)this.sleep_interval);
        this.notch_sounds = new HashMap();
        int nn = 1;
        for (Element el2 : e.getChildren("s1notch-sound")) {
            S1Notch sb = new S1Notch(nn);
            List elist = el2.getChildren("notch-file");
            for (Element fe : elist) {
                fn = fe.getText();
                log.debug("notch: {}, file: {}", (Object)nn, (Object)fn);
                sb.addChuffData(AudioUtil.getWavData(S1Notch.getWavStream(vf, fn)));
            }
            log.debug("Number of chuff medium/standard sounds for notch {} defined: {}", (Object)nn, (Object)elist.size());
            if (nn == 1) {
                fn = el2.getChildText("notch-file");
                int[] formats = AudioUtil.getWavFormats(S1Notch.getWavStream(vf, fn));
                sb.setBufferFmt(formats[0]);
                sb.setBufferFreq(formats[1]);
                sb.setBufferFrameSize(formats[2]);
                log.debug("WAV audio formats - format: {}, frequence: {}, frame size: {}", new Object[]{sb.getBufferFmt(), sb.getBufferFreq(), sb.getBufferFrameSize()});
                fn = el2.getChildText("notchfiller-file");
                if (fn != null) {
                    log.debug("notch filler file: {}", (Object)fn);
                    sb.setNotchFillerData(AudioUtil.getWavData(S1Notch.getWavStream(vf, fn)));
                } else {
                    log.debug("no notchfiller available.");
                    sb.setNotchFillerData(null);
                }
                List elistc = el2.getChildren("coast-file");
                for (Element fe : elistc) {
                    fn = fe.getText();
                    log.debug("coasting file: {}", (Object)fn);
                    sb.addCoastData(AudioUtil.getWavData(S1Notch.getWavStream(vf, fn)));
                }
                log.debug("Number of coasting sounds for notch {} defined: {}", (Object)nn, (Object)elistc.size());
                fn = el2.getChildText("coastfiller-file");
                if (fn != null) {
                    log.debug("coasting filler file: {}", (Object)fn);
                    sb.setCoastFillerData(AudioUtil.getWavData(S1Notch.getWavStream(vf, fn)));
                } else {
                    log.debug("no coastfiller available.");
                    sb.setCoastFillerData(null);
                }
                int j = 0;
                while (j < 12) {
                    AudioBuffer bh = S1Notch.getBufferHelper(String.valueOf(this.name) + "_BUFFERHELPER_" + j, String.valueOf(this.name) + "_BUFFERHELPER_" + j);
                    if (bh != null) {
                        log.debug("buffer helper created: {}, name: {}", (Object)bh, (Object)bh.getSystemName());
                        sb.addHelper(bh);
                    } else {
                        buffer_ok = false;
                    }
                    ++j;
                }
            }
            sb.setMinLimit(Integer.parseInt(el2.getChildText("min-rpm")));
            sb.setMaxLimit(Integer.parseInt(el2.getChildText("max-rpm")));
            this.notch_sounds.put(nn, sb);
            ++nn;
        }
        log.debug("Number of notches defined: {}", (Object)this.notch_sounds.size());
        this.trigger_sounds = new HashMap();
        el2 = e.getChild("idle-sound");
        if (el2 != null) {
            fn = el2.getChild("sound-file").getValue();
            log.debug("idle sound: {}", (Object)fn);
            this.idle_sound = new SoundBite(vf, fn, String.valueOf(this._soundName) + "_IDLE", String.valueOf(this._soundName) + "_Idle");
            this.idle_sound.setGain(this.setXMLGain(el2));
            log.debug("idle sound gain: {}", (Object)Float.valueOf(this.idle_sound.getGain()));
            this.idle_sound.setLooped(true);
            this.idle_sound.setFadeTimes(500, 500);
            this.idle_sound.setReferenceDistance(this.setXMLReferenceDistance(el2));
            log.debug("idle-sound reference distance: {}", (Object)Float.valueOf(this.idle_sound.getReferenceDistance()));
            this.trigger_sounds.put("idle", this.idle_sound);
            log.debug("trigger idle sound: {}", (Object)this.trigger_sounds.get("idle"));
        }
        if ((el2 = e.getChild("boiling-sound")) != null) {
            fn = el2.getChild("sound-file").getValue();
            this.boiling_sound = new SoundBite(vf, fn, String.valueOf(this.name) + "_BOILING", String.valueOf(this.name) + "_Boiling");
            this.boiling_sound.setGain(this.setXMLGain(el2));
            this.boiling_sound.setLooped(true);
            this.boiling_sound.setFadeTimes(500, 500);
            this.boiling_sound.setReferenceDistance(this.setXMLReferenceDistance(el2));
            this.trigger_sounds.put("boiling", this.boiling_sound);
        }
        if ((el2 = e.getChild("brake-sound")) != null) {
            fn = el2.getChild("sound-file").getValue();
            this.brake_sound = new SoundBite(vf, fn, String.valueOf(this._soundName) + "_BRAKE", String.valueOf(this._soundName) + "_Brake");
            this.brake_sound.setGain(this.setXMLGain(el2));
            this.brake_sound.setLooped(false);
            this.brake_sound.setFadeTimes(500, 500);
            this.brake_sound.setReferenceDistance(this.setXMLReferenceDistance(el2));
            this.trigger_sounds.put("brake", this.brake_sound);
        }
        if ((el2 = e.getChild("pre-arrival-sound")) != null) {
            fn = el2.getChild("sound-file").getValue();
            this.pre_arrival_sound = new SoundBite(vf, fn, String.valueOf(this._soundName) + "_PRE-ARRIVAL", String.valueOf(this._soundName) + "_Pre-arrival");
            this.pre_arrival_sound.setGain(this.setXMLGain(el2));
            this.pre_arrival_sound.setLooped(false);
            this.pre_arrival_sound.setFadeTimes(500, 500);
            this.pre_arrival_sound.setReferenceDistance(this.setXMLReferenceDistance(el2));
            this.trigger_sounds.put("pre_arrival", this.pre_arrival_sound);
        }
        if (buffer_ok) {
            this.startThread();
            this.autoStartCheck();
        } else {
            log.warn("Engine cannot be started due to buffer issues");
        }
    }

    private static class S1LoopThread
    extends Thread {
        private Steam1Sound _parent;
        private S1Notch _notch;
        private S1Notch notch1;
        private SoundBite _sound;
        private float _throttle;
        private float last_throttle;
        private boolean is_running = false;
        private boolean is_looping = false;
        private boolean is_auto_coasting;
        private boolean is_key_coasting;
        private boolean is_idling;
        private boolean is_braking;
        private boolean is_half_speed;
        private boolean is_in_rampup_mode;
        private boolean first_start;
        private boolean is_dynamic_gain;
        private int lastRpm;
        private int rpm_dirfn;
        private long timeOfLastSpeedCheck;
        private int chuff_index;
        private int helper_index;
        private float low_volume;
        private float high_volume;
        private float dynamic_volume;
        private float max_volume;
        private int rpm_nominal;
        private int rpm;
        private int topspeed;
        private int _top_speed;
        private int _top_speed_reverse;
        private float _driver_diameter_float;
        private int _num_cylinders;
        private int _decel_trigger_rpms;
        private int acc_time;
        private int dec_time;
        private int count_pre_arrival;
        private int queue_limit;
        private int wait_loops;
        private static final Logger log = LoggerFactory.getLogger(S1LoopThread.class);

        private S1LoopThread(Steam1Sound d, String s, int ts, int tsr, float dd, int nc, int dtr, boolean r) {
            this._parent = d;
            this._top_speed = ts;
            this._top_speed_reverse = tsr;
            this._driver_diameter_float = dd;
            this._num_cylinders = nc;
            this._decel_trigger_rpms = dtr;
            this.is_running = r;
            this.is_looping = false;
            this.is_auto_coasting = false;
            this.is_key_coasting = false;
            this.is_idling = false;
            this.is_braking = false;
            this.is_in_rampup_mode = false;
            this.is_dynamic_gain = false;
            this.lastRpm = 0;
            this.rpm_dirfn = 0;
            this.timeOfLastSpeedCheck = 0L;
            this._throttle = 0.0f;
            this.last_throttle = 0.0f;
            this._notch = null;
            this.high_volume = 0.0f;
            this.low_volume = 0.85f;
            this.dynamic_volume = 1.0f;
            this.max_volume = 1.0f / this._parent.engine_gain;
            this._sound = new SoundBite(s);
            this._sound.setGain(this._parent.engine_gain);
            this.count_pre_arrival = 1;
            this.queue_limit = 2;
            this.wait_loops = 0;
            if (r) {
                this.start();
            }
        }

        private void setRunning(boolean r) {
            this.is_running = r;
        }

        private void setThrottle(float t) {
            if (this._parent.isEngineStarted()) {
                if (t < 0.0f) {
                    this.is_in_rampup_mode = false;
                    this.setRpmNominal(0);
                    this._parent.accdectime = 0;
                    this._parent.startAccDecTimer();
                } else {
                    this._throttle = t;
                    this.last_throttle = t;
                    if (this.is_half_speed) {
                        this._throttle /= 2.0f;
                    }
                    this.setRpmNominal(this.calcRPM(this._throttle));
                    if (this.getRpmNominal() < this.lastRpm) {
                        this._parent.accdectime = this.dec_time;
                        log.debug("decelerate from {} to {}", (Object)this.lastRpm, (Object)this.getRpmNominal());
                        if (this.getRpmNominal() < 23 && this.is_auto_coasting && this.count_pre_arrival > 0 && this._parent.trigger_sounds.containsKey("pre_arrival") && this.dec_time < 250) {
                            ((SoundBite)this._parent.trigger_sounds.get("pre_arrival")).fadeIn();
                            --this.count_pre_arrival;
                        }
                        long currentTime = System.currentTimeMillis();
                        float timePassed = currentTime - this.timeOfLastSpeedCheck;
                        this.timeOfLastSpeedCheck = currentTime;
                        if (this.lastRpm - this.getRpmNominal() > this._decel_trigger_rpms && timePassed < 500.0f) {
                            log.debug("Time passed {}", (Object)Float.valueOf(timePassed));
                            if (this.getRpmNominal() < 30 && this.dec_time < 250) {
                                if (this._parent.trigger_sounds.containsKey("brake")) {
                                    ((SoundBite)this._parent.trigger_sounds.get("brake")).fadeIn();
                                    this.is_braking = true;
                                    log.debug("braking activ!");
                                }
                            } else if (this.notch1.coast_bufs_data.size() > 0 && !this.is_key_coasting) {
                                this.is_auto_coasting = true;
                                log.debug("auto-coasting active");
                            }
                        }
                    } else {
                        this._parent.accdectime = this.acc_time;
                        log.debug("accelerate from {} to {}", (Object)this.lastRpm, (Object)this.getRpmNominal());
                        if (this.is_dynamic_gain) {
                            float new_high_volume = Math.max(this.dynamic_volume * 0.5f, this.low_volume) + this.dynamic_volume * 0.05f * (float)Math.min(this.getRpmNominal() - this.getRpm(), 14);
                            if (new_high_volume > this.high_volume) {
                                this.high_volume = Math.min(new_high_volume, this.max_volume);
                            }
                            log.debug("dynamic volume: {}, max volume: {}, high volume: {}", new Object[]{Float.valueOf(this.dynamic_volume), Float.valueOf(this.max_volume), Float.valueOf(this.high_volume)});
                        }
                        if (this.is_braking) {
                            this.stopBraking();
                        }
                        if (this.is_auto_coasting) {
                            this.stopCoasting();
                        }
                    }
                    this._parent.startAccDecTimer();
                    this.lastRpm = this.getRpmNominal();
                }
            }
        }

        private void stopBraking() {
            if (this.is_braking && this._parent.trigger_sounds.containsKey("brake")) {
                ((SoundBite)this._parent.trigger_sounds.get("brake")).fadeOut();
                this.is_braking = false;
                log.debug("braking sound stopped.");
            }
        }

        private void startBoilingSound() {
            if (this._parent.trigger_sounds.containsKey("boiling")) {
                ((SoundBite)this._parent.trigger_sounds.get("boiling")).setLooped(true);
                ((SoundBite)this._parent.trigger_sounds.get("boiling")).play();
                log.debug("boiling sound playing");
            }
        }

        private void stopBoilingSound() {
            if (this._parent.trigger_sounds.containsKey("boiling")) {
                ((SoundBite)this._parent.trigger_sounds.get("boiling")).setLooped(false);
                ((SoundBite)this._parent.trigger_sounds.get("boiling")).fadeOut();
                log.debug("boiling sound stopped.");
            }
        }

        private void stopCoasting() {
            this.is_auto_coasting = false;
            this.is_key_coasting = false;
            if (this.is_dynamic_gain) {
                this.setDynamicVolume(this.low_volume);
            }
            log.debug("coasting sound stopped.");
        }

        private void getLocoDirection(int d) {
            this.topspeed = d == 1 ? this._top_speed : this._top_speed_reverse;
            log.debug("loco direction: {}, top speed: {}", (Object)d, (Object)this.topspeed);
            this.acc_time = this.calcAccDecTime(this._parent.accel_rate);
            this.dec_time = this.calcAccDecTime(this._parent.decel_rate);
            if (this.getRpm() > 0 && this.getRpmNominal() > 0 && this._parent.isEngineStarted() && !this.is_in_rampup_mode) {
                this.rpm_dirfn = this.getRpm();
                log.debug("ramp-up mode - rpm {} saved, rpm nominal: {}", (Object)this.rpm_dirfn, (Object)this.getRpmNominal());
                this.is_in_rampup_mode = true;
                this.setRpmNominal(0);
                this._parent.startAccDecTimer();
            }
        }

        private void setFunction(String event, boolean is_true, String name) {
            log.debug("throttle function key pressed: {} is {}, function: {}", new Object[]{event, is_true, name});
            if (name.equals("COAST")) {
                log.debug("COAST key pressed");
                if (this.notch1 == null) {
                    this.notch1 = this._parent.getNotch(1);
                }
                if (is_true && this.notch1.coast_bufs_data.size() > 0) {
                    this.is_key_coasting = true;
                } else {
                    this.stopCoasting();
                }
                log.debug("is COAST: {}", (Object)this.is_key_coasting);
            }
            if (name.equals("HALF_SPEED")) {
                log.debug("HALF_SPEED key pressed is {}", (Object)is_true);
                if (this._parent.isEngineStarted()) {
                    this.is_half_speed = is_true;
                    this.setThrottle(this.last_throttle);
                }
            }
            if (name.equals("BRAKE_KEY")) {
                log.debug("BRAKE_KEY pressed is {}", (Object)is_true);
                if (this._parent.isEngineStarted()) {
                    if (is_true) {
                        if (this._parent.brake_time == 0) {
                            this.acc_time = 0;
                            this.dec_time = 0;
                        } else {
                            this.dec_time = this.calcAccDecTime(this._parent.brake_time);
                        }
                        this._parent.accdectime = this.dec_time;
                        log.debug("accdectime: {}", (Object)this._parent.accdectime);
                    } else {
                        this.acc_time = this.calcAccDecTime(this._parent.accel_rate);
                        this.dec_time = this.calcAccDecTime(this._parent.decel_rate);
                        this._parent.accdectime = this.dec_time;
                    }
                }
            }
        }

        private void startEngine() {
            this._sound.unqueueBuffers();
            log.debug("thread: start engine ...");
            this._notch = this._parent.getNotch(1);
            this.notch1 = this._parent.getNotch(1);
            if (this._parent.engine_pane != null) {
                this._parent.engine_pane.setThrottle(1);
            }
            this.is_dynamic_gain = this._parent.is_dynamic_gain;
            this.dynamic_volume = 1.0f;
            this._sound.setReferenceDistance(this._parent.engine_rd);
            this.setRpm(0);
            this.setRpmNominal(0);
            this.helper_index = -1;
            this.setWait(0);
            this.startBoilingSound();
            this.startIdling();
            this.acc_time = this.calcAccDecTime(this._parent.accel_rate);
            this.dec_time = this.calcAccDecTime(this._parent.decel_rate);
            this._parent.initAccDecTimer();
        }

        private void stopEngine() {
            log.debug("thread: stop engine ...");
            if (this.is_looping) {
                this.is_looping = false;
            }
            this.stopBraking();
            this.stopCoasting();
            this.stopBoilingSound();
            this.stopIdling();
            this._parent.stopAccDecTimer();
            this._throttle = 0.0f;
            this._parent.engine_pane.setThrottle(1);
            this.setRpm(0);
        }

        private int calcAccDecTime(int accdec_rate) {
            int topspeed_rpm = (int)Math.round((double)(this.topspeed * 1056) / (Math.PI * (double)this._driver_diameter_float));
            return 896 * accdec_rate / topspeed_rpm;
        }

        private void startIdling() {
            this.is_idling = true;
            if (this._parent.trigger_sounds.containsKey("idle")) {
                ((SoundBite)this._parent.trigger_sounds.get("idle")).setLooped(true);
                ((SoundBite)this._parent.trigger_sounds.get("idle")).play();
            }
            log.debug("start idling ...");
        }

        private void stopIdling() {
            if (this.is_idling) {
                this.is_idling = false;
                if (this._parent.trigger_sounds.containsKey("idle")) {
                    ((SoundBite)this._parent.trigger_sounds.get("idle")).fadeOut();
                    log.debug("idling stopped.");
                }
            }
        }

        @Override
        public void run() {
            try {
                while (this.is_running) {
                    if (this.is_looping && AudioUtil.isAudioRunning()) {
                        if (this._sound.getSource().numProcessedBuffers() > 0) {
                            this._sound.unqueueBuffers();
                        }
                        log.debug("run loop. Buffers queued: {}", (Object)this._sound.getSource().numQueuedBuffers());
                        if (this._sound.getSource().numQueuedBuffers() < this.queue_limit && this.getWait() == 0) {
                            this.setSound(this.selectData());
                        }
                        this.checkAudioState();
                    } else if (this._sound.getSource().numProcessedBuffers() > 0) {
                        this._sound.unqueueBuffers();
                    }
                    S1LoopThread.sleep(this._parent.sleep_interval);
                    this.updateWait();
                }
                this._sound.stop();
            }
            catch (InterruptedException interruptedException) {
                log.debug("thread interrupted");
                return;
            }
        }

        private void checkAudioState() {
            if (this.first_start) {
                this._sound.play();
                this.first_start = false;
            } else if (this._sound.getSource().getState() != 17) {
                this._sound.play();
                log.info("loop sound re-started");
            }
        }

        private ByteBuffer selectData() {
            this.updateVolume();
            ByteBuffer data = this.is_key_coasting || this.is_auto_coasting ? (ByteBuffer)this.notch1.coast_bufs_data.get(this.incChuffIndex()) : (ByteBuffer)this._notch.chuff_bufs_data.get(this.incChuffIndex());
            return data;
        }

        private void changeNotch() {
            int new_notch = this._notch.getNotch();
            log.debug("changing notch ... rpm: {}, notch: {}, chuff index: {}", new Object[]{this.getRpm(), this._notch.getNotch(), this.chuff_index});
            if (this.getRpm() > this._notch.getMaxLimit() && new_notch < this._parent.notch_sounds.size()) {
                log.debug("change up. notch: {}", (Object)(++new_notch));
                this._notch = this._parent.getNotch(new_notch);
            } else if (this.getRpm() < this._notch.getMinLimit() && new_notch > 1) {
                log.debug("change down. notch: {}", (Object)(--new_notch));
                this._notch = this._parent.getNotch(new_notch);
            }
            this._parent.engine_pane.setThrottle(new_notch);
        }

        private int getRpm() {
            return this.rpm;
        }

        private void setRpm(int r) {
            this.rpm = r;
        }

        private int getRpmNominal() {
            return this.rpm_nominal;
        }

        private void setRpmNominal(int rn) {
            this.rpm_nominal = rn;
        }

        private void updateRpm() {
            if (this.getRpmNominal() > this.getRpm()) {
                if (this.getRpm() < this._parent.getNotch(this._parent.notch_sounds.size()).getMaxLimit()) {
                    this.setRpm(this.getRpm() + 1);
                } else {
                    log.debug("actual rpm not increased. Value: {}", (Object)this.getRpm());
                }
                log.debug("accel - nominal RPM: {}, actual RPM: {}", (Object)this.getRpmNominal(), (Object)this.getRpm());
            } else if (this.getRpmNominal() < this.getRpm()) {
                this.setRpm(this.getRpm() - 1);
                if (this.getRpm() < 0) {
                    this.setRpm(0);
                }
                if (this.is_dynamic_gain && this.getRpm() - this.getRpmNominal() > 4 && !this.is_auto_coasting && !this.is_key_coasting) {
                    this.dynamic_volume = this.low_volume;
                }
                log.debug("decel - nominal RPM: {}, actual RPM: {}", (Object)this.getRpmNominal(), (Object)this.getRpm());
            } else {
                this._parent.stopAccDecTimer();
            }
            this.checkState();
            if (this.getRpm() >= this.notch1.getMinLimit() && !this._notch.isInLimits(this.getRpm()).booleanValue()) {
                log.debug("Notch change! Notch: {}, RPM nominal: {}, RPM actual: {}", new Object[]{this._notch.getNotch(), this.getRpmNominal(), this.getRpm()});
                this.changeNotch();
            }
        }

        private void checkState() {
            if (this.is_looping) {
                if (this.getRpm() < this.notch1.getMinLimit()) {
                    this.is_looping = false;
                    this.setWait(0);
                    if (this.is_dynamic_gain && !this.is_key_coasting) {
                        this.high_volume = this.low_volume;
                    }
                    log.debug("change from chuff or coast to idle.");
                    this.is_auto_coasting = false;
                    this.stopBraking();
                    this.startIdling();
                }
            } else {
                if (this._parent.isEngineStarted() && this.getRpm() >= this.notch1.getMinLimit()) {
                    this.stopIdling();
                    if (this.is_dynamic_gain && !this.is_key_coasting) {
                        this.dynamic_volume = this.high_volume;
                    }
                    this._notch = this._parent.getNotch(1);
                    this.chuff_index = -1;
                    this.count_pre_arrival = 1;
                    this.first_start = true;
                    if (this.is_in_rampup_mode && this._sound.getSource().getState() == 17) {
                        this._sound.stop();
                    }
                    this.is_looping = true;
                }
                if (this.is_in_rampup_mode && this.getRpm() == 0) {
                    log.debug("now ramp-up to rpm {}", (Object)this.rpm_dirfn);
                    this.setRpmNominal(this.rpm_dirfn);
                    this._parent.startAccDecTimer();
                    this.is_in_rampup_mode = false;
                }
            }
            if (this.getRpm() > 0) {
                this.queue_limit = Math.max(2, Math.abs(500 / this.calcChuffInterval(this.getRpm())));
                log.debug("queue limit: {}", (Object)this.queue_limit);
            }
        }

        private void updateVolume() {
            if (this.is_dynamic_gain && !this.is_key_coasting && !this.is_auto_coasting) {
                if (this.getRpmNominal() < this.getRpm()) {
                    float inc1 = 0.05f;
                    if (this.dynamic_volume >= this.low_volume) {
                        this.dynamic_volume -= inc1;
                    }
                } else {
                    float inc2 = 0.01f;
                    float inc3 = 0.005f;
                    if (this.dynamic_volume + inc3 < 1.0f && this.high_volume < 1.0f) {
                        this.dynamic_volume += inc3;
                    } else if (this.dynamic_volume + inc2 < this.high_volume) {
                        this.dynamic_volume += inc2;
                    } else if (this.dynamic_volume - inc3 > 1.0f) {
                        this.dynamic_volume -= inc3;
                        this.high_volume -= inc2;
                    }
                }
                this.setDynamicVolume(this.dynamic_volume);
            }
        }

        private void updateWait() {
            if (this.getWait() > 0) {
                this.setWait(this.getWait() - 1);
            }
        }

        private void setWait(int wait) {
            this.wait_loops = wait;
        }

        private int getWait() {
            return this.wait_loops;
        }

        private int incChuffIndex() {
            ++this.chuff_index;
            if (this.chuff_index >= this._num_cylinders * 2) {
                this.chuff_index = 0;
            }
            log.debug("new chuff index: {}", (Object)this.chuff_index);
            return this.chuff_index;
        }

        private int incHelperIndex() {
            ++this.helper_index;
            if (this.helper_index >= this.notch1.bufs_helper.size()) {
                this.helper_index = 0;
            }
            return this.helper_index;
        }

        private int calcRPM(float t) {
            return (int)Math.round(this._parent.speedCurve(t) * (double)this.topspeed * 1056.0 / (Math.PI * (double)this._driver_diameter_float));
        }

        private int calcChuffInterval(int revpm) {
            return (int)Math.round(60000.0 / (double)revpm / (double)this._num_cylinders / 2.0);
        }

        private void setSound(ByteBuffer data) {
            AudioBuffer buf = (AudioBuffer)this.notch1.bufs_helper.get(this.incHelperIndex());
            int sbl = 0;
            if (this.notch1.getBufferFreq() > 0) {
                sbl = 1000 * data.limit() / this.notch1.getBufferFrameSize() / this.notch1.getBufferFreq();
            }
            log.debug("sbl: {}", (Object)sbl);
            int interval = Math.max(this.calcChuffInterval(this.getRpm()), this._parent.sleep_interval);
            int bbufcount = this.notch1.getBufferFrameSize() * (interval * this.notch1.getBufferFreq() / 1000);
            ByteBuffer bbuf = ByteBuffer.allocateDirect(bbufcount);
            if (interval > sbl) {
                int bbufcount2 = this.notch1.getBufferFrameSize() * (sbl * this.notch1.getBufferFreq() / 1000);
                byte[] bbytes2 = new byte[bbufcount2];
                data.get(bbytes2);
                data.rewind();
                bbuf.order(data.order());
                bbuf.put(bbytes2);
                if (bbuf.hasRemaining()) {
                    log.debug("remaining: {}", (Object)bbuf.remaining());
                    ByteBuffer dataf = this.is_key_coasting || this.is_auto_coasting ? this.notch1.getCoastFillerData() : this.notch1.getNotchFillerData();
                    if (dataf == null) {
                        log.debug("No filler sound found");
                        if (this.notch1.getBufferFmt() == 4352) {
                            byte[] bbytesfiller = new byte[bbuf.remaining()];
                            int i = 0;
                            while (i < bbytesfiller.length) {
                                bbytesfiller[i] = -128;
                                ++i;
                            }
                            bbuf.put(bbytesfiller);
                        }
                    } else {
                        log.debug("data limit: {}, remaining: {}", (Object)dataf.limit(), (Object)bbuf.remaining());
                        byte[] bbytesfiller2 = new byte[bbuf.remaining()];
                        if (dataf.limit() >= bbuf.remaining()) {
                            dataf.get(bbytesfiller2);
                            dataf.rewind();
                            bbuf.put(bbytesfiller2);
                        } else {
                            log.debug("not enough filler length");
                            byte[] bbytesfillerpart = new byte[dataf.limit()];
                            dataf.get(bbytesfillerpart);
                            dataf.rewind();
                            int k = 0;
                            int i = 0;
                            while (i < bbytesfiller2.length) {
                                bbytesfiller2[i] = bbytesfillerpart[k];
                                if (++k == dataf.limit()) {
                                    k = 0;
                                }
                                ++i;
                            }
                            bbuf.put(bbytesfiller2);
                        }
                    }
                }
            } else {
                log.debug("need to cut sound clip from {} to length {}", (Object)sbl, (Object)interval);
                byte[] bbytes = new byte[bbufcount];
                data.get(bbytes);
                data.rewind();
                bbuf.order(data.order());
                bbuf.put(bbytes);
            }
            bbuf.rewind();
            buf.loadBuffer(bbuf, this.notch1.getBufferFmt(), this.notch1.getBufferFreq());
            this._sound.queueBuffer(buf);
            log.debug("buffer queued. Length: {}", (Object)((int)SoundBite.calcLength(buf)));
            this.setWait((interval - this._parent.sleep_interval * this._parent.wait_factor) / this._parent.sleep_interval);
            if (this.getWait() < 3) {
                this.setWait(0);
            }
        }

        private void mute(boolean m) {
            this._sound.mute(m);
            for (SoundBite ts : this._parent.trigger_sounds.values()) {
                ts.mute(m);
            }
        }

        private void setDynamicVolume(float v) {
            if (this._parent.getTunnel()) {
                v *= 0.5f;
            }
            if (!this._parent.getVsd().isMuted()) {
                this._sound.setVolume(v * (float)VSDecoderManager.instance().getMasterVolume() * 0.01f * this._parent.getVsd().getDecoderVolume());
            }
        }

        private void setVolume(float v) {
            if (!this.is_dynamic_gain) {
                this._sound.setVolume(v);
            }
            for (SoundBite ts : this._parent.trigger_sounds.values()) {
                ts.setVolume(v);
            }
        }

        private void setPosition(PhysicalLocation p) {
            this._sound.setPosition(p);
            for (SoundBite ts : this._parent.trigger_sounds.values()) {
                ts.setPosition(p);
            }
        }
    }

    private static class S1Notch {
        private int my_notch;
        private int min_rpm;
        private int max_rpm;
        private int buffer_fmt;
        private int buffer_freq;
        private int buffer_frame_size;
        private ByteBuffer notchfiller_data;
        private ByteBuffer coastfiller_data;
        private List<AudioBuffer> bufs_helper = new ArrayList<AudioBuffer>();
        private List<ByteBuffer> chuff_bufs_data = new ArrayList<ByteBuffer>();
        private List<ByteBuffer> coast_bufs_data = new ArrayList<ByteBuffer>();
        private static final Logger log = LoggerFactory.getLogger(S1Notch.class);

        private S1Notch(int notch) {
            this.my_notch = notch;
        }

        private int getNotch() {
            return this.my_notch;
        }

        private int getMaxLimit() {
            return this.max_rpm;
        }

        private int getMinLimit() {
            return this.min_rpm;
        }

        private void setMinLimit(int l) {
            this.min_rpm = l;
        }

        private void setMaxLimit(int l) {
            this.max_rpm = l;
        }

        private Boolean isInLimits(int val) {
            if (val >= this.min_rpm && val <= this.max_rpm) {
                return true;
            }
            return false;
        }

        private void setBufferFmt(int fmt) {
            this.buffer_fmt = fmt;
        }

        private int getBufferFmt() {
            return this.buffer_fmt;
        }

        private void setBufferFreq(int freq) {
            this.buffer_freq = freq;
        }

        private int getBufferFreq() {
            return this.buffer_freq;
        }

        private void setBufferFrameSize(int framesize) {
            this.buffer_frame_size = framesize;
        }

        private int getBufferFrameSize() {
            return this.buffer_frame_size;
        }

        private void setNotchFillerData(ByteBuffer dat) {
            this.notchfiller_data = dat;
        }

        private ByteBuffer getNotchFillerData() {
            return this.notchfiller_data;
        }

        private void setCoastFillerData(ByteBuffer dat) {
            this.coastfiller_data = dat;
        }

        private ByteBuffer getCoastFillerData() {
            return this.coastfiller_data;
        }

        private void addChuffData(ByteBuffer dat) {
            this.chuff_bufs_data.add(dat);
        }

        private void addCoastData(ByteBuffer dat) {
            this.coast_bufs_data.add(dat);
        }

        private void addHelper(AudioBuffer b) {
            this.bufs_helper.add(b);
        }

        private static AudioBuffer getBufferHelper(String sname, String uname) {
            AudioBuffer bf = null;
            AudioManager am = InstanceManager.getDefault(AudioManager.class);
            try {
                bf = (AudioBuffer)am.provideAudio("IAB$VSD:" + sname);
                bf.setUserName("IVSDB_" + uname);
            }
            catch (IllegalArgumentException | AudioException ex) {
                log.warn("problem creating SoundBite", (Throwable)ex);
                return null;
            }
            log.debug("empty buffer created: {}, name: {}", (Object)bf, (Object)bf.getSystemName());
            return bf;
        }

        private static InputStream getWavStream(VSDFile vf, String filename) {
            InputStream ins = vf.getInputStream(filename);
            if (ins != null) {
                return ins;
            }
            log.warn("input Stream failed for {}", (Object)filename);
            return null;
        }
    }
}

