/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.vsdecoder;

import java.io.InputStream;
import jmri.AudioException;
import jmri.AudioManager;
import jmri.InstanceManager;
import jmri.jmrit.audio.AudioBuffer;
import jmri.jmrit.audio.AudioSource;
import jmri.jmrit.vsdecoder.VSDFile;
import jmri.jmrit.vsdecoder.VSDSound;
import jmri.util.PhysicalLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SoundBite
extends VSDSound {
    String filename;
    String system_name;
    String user_name;
    AudioBuffer sound_buf;
    AudioSource sound_src;
    boolean initialized = false;
    boolean looped = false;
    int minloops;
    int maxloops;
    float rd;
    long length;
    BufferMode bufferMode;
    private static final Logger log = LoggerFactory.getLogger(SoundBite.class);

    public SoundBite(String name) {
        super(name);
        this.system_name = name;
        this.user_name = name;
        this.bufferMode = BufferMode.QUEUE_MODE;
        this.initialized = this.init(null, this.bufferMode);
    }

    public SoundBite(VSDFile vf, String filename, String sname, String uname) {
        super(uname);
        this.filename = filename;
        this.system_name = sname;
        this.user_name = uname;
        this.bufferMode = BufferMode.BOUND_MODE;
        this.initialized = this.init(vf, this.bufferMode);
    }

    public String getFileName() {
        return this.filename;
    }

    public String getSystemName() {
        return this.system_name;
    }

    public String getUserName() {
        return this.user_name;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public final boolean init(VSDFile vf, BufferMode mode) {
        block6: {
            AudioManager am = InstanceManager.getDefault(AudioManager.class);
            if (!this.initialized) {
                block7: {
                    this.sound_src = (AudioSource)am.provideAudio("IAS$VSD:" + this.system_name);
                    this.sound_src.setUserName("IVSDS_" + this.user_name);
                    this.setLooped(false);
                    if (mode != BufferMode.BOUND_MODE) break block6;
                    this.sound_buf = (AudioBuffer)am.provideAudio("IAB$VSD:" + this.system_name);
                    this.sound_buf.setUserName("IVSDB_" + this.user_name);
                    if (vf == null) {
                        log.debug("No VSD File! Filename: {}", (Object)this.filename);
                        this.sound_buf.setURL(this.filename);
                        break block7;
                    }
                    InputStream ins = vf.getInputStream(this.filename);
                    if (ins != null) {
                        this.sound_buf.setInputStream(ins);
                        break block7;
                    }
                    return false;
                }
                try {
                    this.sound_src.setAssignedBuffer(this.sound_buf);
                    this.setLength();
                }
                catch (IllegalArgumentException | AudioException ex) {
                    log.warn("Problem creating SoundBite", (Throwable)ex);
                }
            }
        }
        return true;
    }

    public void queueBuffer(AudioBuffer b) {
        if (this.bufferMode == BufferMode.QUEUE_MODE) {
            if (b == null) {
                log.debug("queueAudioBuffer with null buffer input");
                return;
            }
            if (this.sound_src == null) {
                log.debug("queueAudioBuffer with null sound_src");
                return;
            }
            log.debug("Queueing Buffer: {}", (Object)b.getSystemName());
            this.sound_src.queueBuffer(b);
        } else {
            log.warn("Attempted to Queue buffer to a Bound SoundBite.");
        }
    }

    public void unqueueBuffers() {
        if (this.bufferMode == BufferMode.QUEUE_MODE) {
            this.sound_src.unqueueBuffers();
        }
    }

    public int numQueuedBuffers() {
        if (this.bufferMode == BufferMode.QUEUE_MODE) {
            return this.sound_src.numQueuedBuffers();
        }
        return 0;
    }

    public AudioSource getSource() {
        return this.sound_src;
    }

    public AudioBuffer getBuffer() {
        return this.sound_buf;
    }

    public String getSourceSystemName() {
        return "IAS$VSD:" + this.system_name;
    }

    public String getSourceUserName() {
        return "IVSDS_" + this.user_name;
    }

    public String getBufferSystemName() {
        return "IAB$VSD:" + this.system_name;
    }

    public String getBufferUserName() {
        return "IVSDB_" + this.user_name;
    }

    public void setLooped(boolean loop, int minloops, int maxloops) {
        this.looped = loop;
        this.minloops = minloops;
        this.maxloops = maxloops;
        this.sound_src.setLooped(this.looped);
        this.sound_src.setMinLoops(minloops);
        this.sound_src.setMaxLoops(maxloops);
    }

    public void setLooped(boolean loop) {
        if (loop) {
            this.setLooped(true, -1, -1);
        } else {
            this.setLooped(false, 0, 0);
        }
    }

    public boolean isLooped() {
        return this.looped;
    }

    public int getFadeInTime() {
        return this.sound_src.getFadeIn();
    }

    public int getFadeOutTime() {
        return this.sound_src.getFadeOut();
    }

    public void setFadeInTime(int t) {
        this.sound_src.setFadeIn(t);
    }

    public void setFadeOutTime(int t) {
        this.sound_src.setFadeOut(t);
    }

    public void setFadeTimes(int in, int out) {
        this.sound_src.setFadeIn(in);
        this.sound_src.setFadeOut(out);
    }

    public float getReferenceDistance() {
        return this.sound_src.getReferenceDistance();
    }

    public void setReferenceDistance(float r) {
        this.rd = r;
        this.sound_src.setReferenceDistance(this.rd);
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void mute(boolean m) {
        if (m) {
            this.volume = this.sound_src.getGain();
            this.sound_src.setGain(0.0f);
        } else {
            this.sound_src.setGain(this.volume);
        }
    }

    @Override
    public void setVolume(float v) {
        this.volume = v * this.gain;
        this.sound_src.setGain(this.volume);
    }

    @Override
    public void play() {
        this.sound_src.play();
        this.is_playing = true;
    }

    @Override
    public void loop() {
        this.sound_src.play();
        this.is_playing = true;
    }

    @Override
    public void stop() {
        this.sound_src.stop();
        this.is_playing = false;
    }

    public void pause() {
        this.sound_src.pause();
        this.is_playing = false;
    }

    public void rewind() {
        this.sound_src.rewind();
    }

    @Override
    public void fadeOut() {
        if (this.sound_src.getFadeOut() == 0) {
            this.sound_src.stop();
        } else {
            this.sound_src.fadeOut();
        }
        this.is_playing = false;
    }

    @Override
    public void fadeIn() {
        if (this.sound_src.getFadeIn() == 0) {
            this.sound_src.play();
        } else {
            this.sound_src.fadeIn();
        }
        this.is_playing = true;
    }

    @Override
    public void setPosition(PhysicalLocation v) {
        super.setPosition(v);
        this.sound_src.setPosition(v);
    }

    public void setURL(String filename) {
        this.filename = filename;
        this.sound_buf.setURL(filename);
    }

    public long getLength() {
        return this.length;
    }

    public int getLengthAsInt() {
        if (this.length > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)this.length;
    }

    public void setLength(long p) {
        this.length = p;
    }

    public void setLength() {
        this.length = SoundBite.calcLength(this);
    }

    public static long calcLength(SoundBite s) {
        return SoundBite.calcLength(s.getBuffer());
    }

    public static long calcLength(AudioBuffer buf) {
        int frequency;
        long num_frames;
        if (buf != null) {
            num_frames = buf.getLength();
            frequency = buf.getFrequency();
        } else {
            num_frames = 0L;
            frequency = 0;
        }
        if (frequency <= 0) {
            return 0L;
        }
        return 1000L * num_frames / (long)frequency;
    }

    public static enum BufferMode {
        BOUND_MODE,
        QUEUE_MODE;

    }
}

