/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.vsdecoder;

import java.beans.PropertyChangeEvent;
import jmri.jmrit.vsdecoder.EngineSound;
import jmri.jmrit.vsdecoder.Trigger;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NotchTrigger
extends Trigger {
    int current_notch;
    int prev_notch;
    private static final Logger log = LoggerFactory.getLogger(NotchTrigger.class);

    public NotchTrigger(String name) {
        this(name, 0, 0);
    }

    public NotchTrigger(String name, int prev, int cur) {
        super(name);
        this.setTriggerType(Trigger.TriggerType.NOTCH);
        this.prev_notch = prev;
        this.current_notch = cur;
    }

    public void setNotch(int next) {
        this.current_notch = next;
    }

    public int getNotch() {
        return this.current_notch;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (this.target == null) {
            log.debug("Quit.  No target.");
            return;
        }
        if (!event.getPropertyName().equals(this.getEventName())) {
            return;
        }
        if (this.getTriggerType() == Trigger.TriggerType.NONE) {
            return;
        }
        if (this.getTargetAction() == Trigger.TargetAction.NOTHING) {
            return;
        }
        this.prev_notch = this.current_notch;
        this.current_notch = EngineSound.calcEngineNotch(((Float)event.getNewValue()).floatValue());
        log.debug("Notch Trigger prev_notch = {} current_notch = {}", (Object)this.prev_notch, (Object)this.current_notch);
        this.callback.takeAction(this.current_notch);
    }

    @Override
    public Element getXml() {
        Element me = new Element("Trigger");
        me.setAttribute("name", this.getName());
        me.setAttribute("type", "NOTCH");
        log.warn("CompareTrigger.getXml() not implemented");
        return me;
    }

    @Override
    public void setXml(Element e) {
        super.setXml(e);
    }
}

