/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.vsdecoder;

import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipException;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import jmri.jmrit.vsdecoder.Bundle;
import jmri.jmrit.vsdecoder.VSDFile;
import jmri.jmrit.vsdecoder.VSDecoderManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadVSDFileAction
extends AbstractAction {
    JFileChooser fileChooser;
    private String last_path = null;
    private static final Logger log = LoggerFactory.getLogger(LoadVSDFileAction.class);

    public LoadVSDFileAction(String s) {
        super(s);
    }

    public LoadVSDFileAction() {
        this(Bundle.getMessage("VSDecoderFileMenuLoadVSDFile"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int retVal;
        if (this.fileChooser == null) {
            String start_dir = VSDecoderManager.instance().getVSDecoderPreferences().getDefaultVSDFilePath();
            if (this.last_path != null) {
                start_dir = this.last_path;
            }
            log.debug("Using path: {}", (Object)start_dir);
            this.fileChooser = new JFileChooser(start_dir);
            this.fileChooser.setFileFilter(new FileNameExtensionFilter(Bundle.getMessage("LoadVSDFileChooserFilterLabel"), "vsd", "zip"));
            this.fileChooser.setDialogType(0);
            this.fileChooser.setCurrentDirectory(new File(start_dir));
        }
        if ((retVal = this.fileChooser.showOpenDialog(null)) != 0) {
            return;
        }
        LoadVSDFileAction.loadVSDFile(this.fileChooser.getSelectedFile().toString());
        try {
            this.last_path = this.fileChooser.getCurrentDirectory().getCanonicalPath();
        }
        catch (IOException err) {
            log.debug("Error getting current directory", (Throwable)err);
            this.last_path = VSDecoderManager.instance().getVSDecoderPreferences().getDefaultVSDFilePath();
        }
    }

    public static boolean loadVSDFile(String fp) {
        File file = new File(fp);
        if (!file.exists()) {
            log.error("Cannot locate VSD File {}", (Object)fp);
            if (!GraphicsEnvironment.isHeadless()) {
                JOptionPane.showMessageDialog(null, "Cannot locate VSD File", Bundle.getMessage("VSDFileError"), 0);
            }
            return false;
        }
        try {
            VSDFile vsdfile = new VSDFile(fp);
            log.debug("VSD File name: {}", (Object)vsdfile.getName());
            if (vsdfile.isInitialized()) {
                VSDecoderManager.instance().loadProfiles(vsdfile);
            }
            vsdfile.close();
            if (!vsdfile.isInitialized() && !GraphicsEnvironment.isHeadless()) {
                JOptionPane.showMessageDialog(null, vsdfile.getStatusMessage(), Bundle.getMessage("VSDFileError"), 0);
            }
            return vsdfile.isInitialized();
        }
        catch (ZipException ze) {
            log.error("ZipException opening file {}", (Object)fp, (Object)ze);
            return false;
        }
        catch (IOException ze) {
            log.error("IOException opening file {}", (Object)fp, (Object)ze);
            return false;
        }
    }
}

