/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.vsdecoder;

import java.beans.PropertyChangeEvent;
import jmri.jmrit.vsdecoder.Trigger;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IntTrigger
extends Trigger {
    int notch;
    Trigger.CompareType compare_type;
    private static final Logger log = LoggerFactory.getLogger(IntTrigger.class);

    public IntTrigger(String name) {
        this(name, 0, Trigger.CompareType.EQ);
    }

    public IntTrigger(String name, int next, Trigger.CompareType ct) {
        super(name);
        this.setTriggerType(Trigger.TriggerType.INT);
        this.notch = next;
        this.compare_type = ct;
    }

    public void setMatchValue(int next) {
        this.notch = next;
    }

    public int getMatchValue() {
        return this.notch;
    }

    public void setCompareType(Trigger.CompareType ct) {
        this.compare_type = ct;
    }

    public Trigger.CompareType getCompareType() {
        return this.compare_type;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        boolean compare = false;
        if (this.target == null) {
            log.debug("Quit.  No target.");
            return;
        }
        if (!event.getPropertyName().equals(this.getEventName())) {
            log.debug("Quit. Event name mismatch event = {} this = {}", (Object)event.getPropertyName(), (Object)this.getEventName());
            return;
        }
        if (this.getTriggerType() == Trigger.TriggerType.NONE) {
            log.debug("Quit.  TriggerType = NONE");
            return;
        }
        if (this.getTargetAction() == Trigger.TargetAction.NOTHING) {
            log.debug("Quit.  TargetAction = NOTHING");
            return;
        }
        int next = (Integer)event.getNewValue();
        switch (this.compare_type) {
            case GT: {
                compare = next > this.notch;
                break;
            }
            case LT: {
                compare = next < this.notch;
                break;
            }
            case GTE: {
                compare = next >= this.notch;
                break;
            }
            case LTE: {
                compare = next <= this.notch;
                break;
            }
            default: {
                boolean bl = compare = next == this.notch;
            }
        }
        if (compare) {
            this.callback.takeAction();
        }
    }

    @Override
    public void setXml(Element e) {
        super.setXml(e);
        if (e.getAttribute("type").getValue().equals("INT")) {
            this.notch = Integer.parseInt(e.getChild("match").getValue());
            this.compare_type = Trigger.CompareType.valueOf(e.getChild("compare-type").getValue().toUpperCase());
        }
    }
}

