/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.vsdecoder;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import jmri.jmrit.vsdecoder.ButtonTrigger;
import jmri.jmrit.vsdecoder.EnginePane;
import jmri.jmrit.vsdecoder.SoundEvent;
import jmri.jmrit.vsdecoder.Trigger;
import jmri.jmrit.vsdecoder.VSDFile;
import jmri.jmrit.vsdecoder.swing.DieselPane;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineSoundEvent
extends SoundEvent {
    EnginePane engine_pane = null;
    private static final Logger log = LoggerFactory.getLogger(EngineSoundEvent.class);

    public EngineSoundEvent() {
        this(null, null);
    }

    public EngineSoundEvent(String n) {
        this(n, n);
    }

    public EngineSoundEvent(String n, String bl) {
        super(n, bl);
    }

    @Override
    public boolean hasButton() {
        return this.buttontype != SoundEvent.ButtonType.NONE && this.buttontype != SoundEvent.ButtonType.ENGINE && this.button != null;
    }

    @Override
    public boolean hasEnginePane() {
        return this.buttontype == SoundEvent.ButtonType.ENGINE && this.engine_pane != null;
    }

    @Override
    public JComponent getButton() {
        log.debug("engine getButton() called.");
        return this.engine_pane;
    }

    @Override
    public EnginePane getEnginePane() {
        return this.engine_pane;
    }

    @Override
    public void setEnginePane(EnginePane e) {
        this.engine_pane = e;
    }

    @Override
    public void setButtonLabel(String bl) {
    }

    @Override
    public String getButtonLabel() {
        return "Text";
    }

    @Override
    protected ButtonTrigger setupButtonAction(Element te) {
        return null;
    }

    public void guiAction(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("VSDDP:Start")) {
            log.debug("GUI Start button changed. New value: {}", evt.getNewValue());
            if (this.getParent().getEngineSound() != null) {
                if (((Boolean)evt.getNewValue()).booleanValue()) {
                    this.getParent().getEngineSound().setEngineStarted(true);
                    this.parent.getEngineSound().startEngine();
                } else {
                    this.getParent().getEngineSound().setEngineStarted(false);
                    this.getParent().getEngineSound().stopEngine();
                }
            } else {
                log.warn("Lost context, VSDecoder is null. Quit JMRI and start over.");
            }
        } else if (evt.getPropertyName().equals("VSDDP:Volume")) {
            log.debug("decoder volume: {}", evt.getOldValue());
            this.getParent().setDecoderVolume(1.0f * (float)((Integer)evt.getOldValue()).intValue() / 100.0f);
            if (this.getParent().getRosterEntry() != null) {
                this.getParent().getRosterEntry().putAttribute("VSDecoder_Volume", String.valueOf(this.getParent().getDecoderVolume()));
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getPropertyName().equals("SpeedSetting")) {
            this.getParent().getEngineSound().handleSpeedChange((Float)event.getNewValue(), this.engine_pane);
        } else if (event.getPropertyName().equals("IsForward")) {
            this.getParent().getEngineSound().changeLocoDirection((Boolean)event.getNewValue() != false ? 1 : -1);
            log.debug("is forward: {}", event.getNewValue());
        } else if (event.getPropertyName().startsWith("F")) {
            String ev = event.getPropertyName();
            boolean val = (Boolean)event.getNewValue();
            for (Trigger t : this.trigger_list.values()) {
                log.debug("trigger name: {}, event: {}, target: {}", new Object[]{t.getName(), t.getEventName(), t.getTargetName()});
                if (!ev.equals(t.getEventName())) continue;
                if (t.getName().equals("ENGINE_STARTSTOP")) {
                    this.getEnginePane().startButtonClick();
                    continue;
                }
                this.getParent().getEngineSound().functionKey(ev, val, t.getName());
                log.debug("event {} is {}", (Object)ev, (Object)val);
            }
        }
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="DieselPane extends EnginePane")
    private void setDecoderVolume() {
        int dv = Math.round(this.getParent().getDecoderVolume() * 100.0f);
        ((DieselPane)this.engine_pane).volume_slider.setValue(dv);
    }

    @Override
    public Element getXml() {
        Element me = new Element("SoundEvent");
        me.setAttribute("name", this.name);
        me.setAttribute("label", me.getText());
        for (Trigger t : this.trigger_list.values()) {
            me.addContent((Content)t.getXml());
        }
        return me;
    }

    @Override
    public void setXml(Element el) {
        this.setXml(el, null);
    }

    @Override
    public void setXml(Element el, VSDFile vf) {
        log.debug("Creating DieselPane");
        this.engine_pane = new DieselPane("Engine");
        this.setDecoderVolume();
        super.setXml(el, vf);
        this.engine_pane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                EngineSoundEvent.this.guiAction(evt);
            }
        });
        for (Trigger t : this.trigger_list.values()) {
            if (!t.getName().equals("ENGINE_STARTSTOP")) continue;
            if (t.getTargetAction().equals((Object)Trigger.TargetAction.STOP_AT_ZERO)) {
                this.engine_pane.setStopOption(true);
                continue;
            }
            this.engine_pane.setStopOption(false);
        }
        if (log.isDebugEnabled()) {
            for (Trigger bt : this.button_trigger_list.values()) {
                log.debug("Button Trigger: {}", (Object)bt.getName());
                log.debug("  Target: {}", (Object)bt.getTarget().getName());
                log.debug("  Action: {}", (Object)bt.getTargetAction());
            }
            for (Trigger bt : this.trigger_list.values()) {
                log.debug("Trigger: {}", (Object)bt.getName());
                log.debug("  Target: {}", (Object)bt.getTarget());
                log.debug("  Action: {}", (Object)bt.getTargetAction());
            }
        }
    }
}

