/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.vsdecoder;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;
import jmri.jmrit.vsdecoder.EnginePane;
import jmri.jmrit.vsdecoder.VSDFile;
import jmri.jmrit.vsdecoder.VSDSound;
import jmri.jmrit.vsdecoder.VSDecoderManager;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineSound
extends VSDSound {
    boolean initialized = false;
    boolean engine_started = false;
    boolean auto_start_engine = false;
    boolean is_auto_start;
    boolean is_first = false;
    int fade_length = 100;
    int fade_in_time = 100;
    int fade_out_time = 100;
    float engine_rd;
    float engine_gain;
    int sleep_interval;
    private int default_sleep_interval = 50;
    EnginePane engine_pane;
    private static final Logger log = LoggerFactory.getLogger(EngineSound.class);

    public EngineSound(String name) {
        super(name);
        this.is_playing = false;
        this.engine_started = false;
        this.initialized = this.init();
    }

    public boolean init() {
        this.auto_start_engine = VSDecoderManager.instance().getVSDecoderPreferences().isAutoStartingEngine();
        return true;
    }

    @Override
    public void play() {
        log.debug("EngineSound Play");
    }

    @Override
    public void loop() {
        log.debug("EngineSound Loop");
    }

    @Override
    public void stop() {
        log.info("Emergency Stop called!");
        this.is_playing = false;
    }

    @Override
    public void fadeIn() {
        this.play();
    }

    @Override
    public void fadeOut() {
        this.stop();
    }

    public int getFadeInTime() {
        return this.fade_in_time;
    }

    public int getFadeOutTime() {
        return this.fade_out_time;
    }

    protected void setFadeInTime(int t) {
        this.fade_in_time = t;
    }

    protected void setFadeInTime(String s) {
        if (s == null) {
            log.debug("setFadeInTime null string");
            return;
        }
        try {
            this.setFadeInTime(Integer.parseInt(s));
        }
        catch (NumberFormatException numberFormatException) {
            log.debug("setFadeInTime Failed to parse int from: {}", (Object)s);
        }
    }

    protected void setFadeOutTime(int t) {
        this.fade_out_time = t;
    }

    protected void setFadeOutTime(String s) {
        if (s == null) {
            log.debug("setFadeInTime null string");
            return;
        }
        try {
            this.setFadeOutTime(Integer.parseInt(s));
        }
        catch (NumberFormatException numberFormatException) {
            log.debug("setFadeOutTime Failed to parse int from: {}", (Object)s);
        }
    }

    public static final int calcEngineNotch(float throttle) {
        int notch = (int)Math.rint(throttle * 8.0f) + 1;
        if (notch < 1) {
            notch = 1;
        }
        log.debug("Throttle: {}, Notch: {}", (Object)Float.valueOf(throttle), (Object)notch);
        return notch;
    }

    public static final int calcEngineNotch(double throttle) {
        int notch = (int)Math.rint(throttle * 8.0) + 1;
        if (notch < 1) {
            notch = 1;
        }
        return notch;
    }

    public void handleSpeedChange(Float s, EnginePane e) {
        this.engine_pane = e;
        this.engine_pane.setSpeed(s.floatValue());
    }

    void setFirstSpeed(boolean f) {
        this.is_first = f;
    }

    boolean getFirstSpeed() {
        return this.is_first;
    }

    public void startEngine() {
        log.debug("Starting Engine");
    }

    public void stopEngine() {
    }

    public boolean isEngineStarted() {
        return this.engine_started;
    }

    public void setEngineStarted(boolean es) {
        this.engine_started = es;
    }

    public void functionKey(String e, boolean v, String n) {
    }

    public void changeLocoDirection(int d) {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void mute(boolean m) {
    }

    @Override
    public void setVolume(float v) {
    }

    void autoStartCheck() {
        if (this.auto_start_engine || this.is_auto_start) {
            SwingUtilities.invokeLater(() -> {
                this.t = this.newTimer(40, false, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (EngineSound.this.engine_pane != null && EngineSound.this.getFirstSpeed()) {
                            EngineSound.this.engine_pane.startButtonClick();
                        } else {
                            log.warn("engine pane or speed not found");
                        }
                    }
                });
                this.t.start();
            });
        }
    }

    protected boolean setXMLAutoStart(Element e) {
        String a = e.getChildText("auto-start");
        return a != null && a.equals("yes");
    }

    protected float setXMLGain(Element e) {
        String g = e.getChildText("gain");
        log.debug("  gain: {}", (Object)g);
        if (g != null && !g.isEmpty()) {
            return Float.parseFloat(g);
        }
        return 0.8f;
    }

    protected float setXMLReferenceDistance(Element e) {
        String a = e.getChildText("reference-distance");
        if (a != null && !a.isEmpty()) {
            return Float.parseFloat(a);
        }
        return 1.0f;
    }

    protected float setXMLEngineReferenceDistance(Element e) {
        String a = e.getChildText("engine-reference-distance");
        if (a != null && !a.isEmpty()) {
            return Float.parseFloat(a);
        }
        return 1.0f;
    }

    protected int setXMLSleepInterval(Element e) {
        String a = e.getChildText("sleep-interval");
        if (a != null && !a.isEmpty()) {
            int sleep_interval = Integer.parseInt(a);
            if (sleep_interval < 38 || sleep_interval > 55) {
                log.info("Invalid sleep-interval {} was set to default {}", (Object)sleep_interval, (Object)this.default_sleep_interval);
                return this.default_sleep_interval;
            }
            return sleep_interval;
        }
        return this.default_sleep_interval;
    }

    @Override
    public Element getXml() {
        Element me = new Element("sound");
        me.setAttribute("name", this.getName());
        me.setAttribute("type", "engine");
        return me;
    }

    public void setXml(Element e, VSDFile vf) {
        if (this.getName() == null) {
            this.setName(e.getAttributeValue("name"));
        }
        this.setFadeInTime(e.getChildText("fade-in-time"));
        this.setFadeOutTime(e.getChildText("fade-out-time"));
        log.debug("Name: {}, Fade-In-Time: {}, Fade-Out-Time: {}", new Object[]{this.getName(), this.getFadeInTime(), this.getFadeOutTime()});
    }
}

