/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.vsdecoder;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import jmri.jmrit.vsdecoder.EngineSound;
import jmri.jmrit.vsdecoder.NotchTransition;
import jmri.jmrit.vsdecoder.SoundBite;
import jmri.jmrit.vsdecoder.VSDFile;
import jmri.util.PhysicalLocation;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DieselSound
extends EngineSound {
    HashMap<Integer, SoundBite> notch_sounds;
    ArrayList<NotchTransition> transition_sounds;
    SoundBite start_sound;
    SoundBite shutdown_sound;
    NotchTransition notch_transition;
    int current_notch = 1;
    private static final Logger log = LoggerFactory.getLogger(DieselSound.class);

    public DieselSound(String name) {
        super(name);
    }

    @Override
    public void play() {
        log.debug("EngineSound Play: current_notch = {}", (Object)this.current_notch);
        if (this.notch_sounds.containsKey(this.current_notch) && (this.isEngineStarted() || this.auto_start_engine)) {
            this.notch_sounds.get(this.current_notch).play();
            this.is_playing = true;
        }
    }

    @Override
    public void loop() {
        if (this.notch_sounds.containsKey(this.current_notch) && (this.isEngineStarted() || this.auto_start_engine)) {
            this.notch_sounds.get(this.current_notch).play();
            this.is_playing = true;
        }
    }

    @Override
    public void stop() {
        if (this.notch_sounds.containsKey(this.current_notch)) {
            this.notch_sounds.get(this.current_notch).stop();
        }
        this.is_playing = false;
    }

    @Override
    public void changeNotch(int new_notch) {
        log.debug("EngineSound.changeNotch() current = {} new notch = {}", (Object)this.current_notch, (Object)new_notch);
        if (new_notch != this.current_notch) {
            if (this.notch_sounds.containsKey(this.current_notch) && (this.isEngineStarted() || this.auto_start_engine)) {
                this.notch_sounds.get(this.current_notch).fadeOut();
            }
            this.notch_transition = this.findNotchTransient(this.current_notch, new_notch);
            if (this.notch_transition != null) {
                log.debug("notch transition: name = {} length = {}, fade_length = {}", new Object[]{this.notch_transition.getFileName(), this.notch_transition.getLengthAsInt(), this.fade_length});
                this.t = this.newTimer(this.notch_transition.getLengthAsInt() - this.notch_sounds.get(new_notch).getFadeInTime(), false, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DieselSound.this.handleNotchTimerPop(e);
                    }
                });
                this.t.start();
                this.notch_transition.fadeIn();
            } else {
                log.debug("notch transition not found!");
                if (this.notch_sounds.containsKey(new_notch) && (this.isEngineStarted() || this.auto_start_engine)) {
                    this.notch_sounds.get(new_notch).fadeIn();
                }
            }
            this.current_notch = new_notch;
        }
    }

    protected void handleNotchTimerPop(ActionEvent e) {
        log.debug("Notch timer pop. nt.next_notch = {}, file = {}", (Object)this.notch_transition.getNextNotch(), (Object)this.notch_sounds.get(this.notch_transition.getNextNotch()).getFileName());
        if (this.notch_sounds.containsKey(this.notch_transition.getNextNotch()) && (this.isEngineStarted() || this.auto_start_engine)) {
            this.notch_sounds.get(this.notch_transition.getNextNotch()).fadeIn();
        }
        this.notch_transition.fadeOut();
    }

    private NotchTransition findNotchTransient(int prev, int next) {
        log.debug("Looking for Transient: prev = {} next = {}", (Object)prev, (Object)next);
        for (NotchTransition nt : this.transition_sounds) {
            log.debug("searching: nt.prev = {} nt.next = {}", (Object)nt.getPrevNotch(), (Object)nt.getNextNotch());
            if (nt.getPrevNotch() != prev || nt.getNextNotch() != next) continue;
            log.debug("Found transient: prev = {} next = {}", (Object)nt.getPrevNotch(), (Object)nt.getNextNotch());
            return nt;
        }
        return null;
    }

    @Override
    public void startEngine() {
        this.start_sound.play();
        this.current_notch = DieselSound.calcEngineNotch(0.0f);
        this.t = this.newTimer(this.start_sound.getLengthAsInt() - this.start_sound.getFadeOutTime(), false, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DieselSound.this.startToIdleAction(e);
            }
        });
        this.t.setInitialDelay(this.start_sound.getLengthAsInt() - this.start_sound.getFadeOutTime());
        this.t.setRepeats(false);
        log.debug("Starting Engine");
        this.t.start();
    }

    @Override
    public void stopEngine() {
        this.notch_sounds.get(this.current_notch).fadeOut();
        this.shutdown_sound.play();
        this.setEngineStarted(false);
    }

    private void startToIdleAction(ActionEvent e) {
        log.debug("Starting idle sound notch = {} sound = {}", (Object)this.current_notch, (Object)this.notch_sounds.get(this.current_notch));
        this.notch_sounds.get(this.current_notch).loop();
        this.setEngineStarted(true);
    }

    @Override
    public void shutdown() {
        for (SoundBite ns : this.notch_sounds.values()) {
            ns.stop();
        }
        for (NotchTransition nt : this.transition_sounds) {
            nt.stop();
        }
        if (this.start_sound != null) {
            this.start_sound.stop();
        }
        if (this.shutdown_sound != null) {
            this.shutdown_sound.stop();
        }
    }

    @Override
    public void mute(boolean m) {
        for (SoundBite ns : this.notch_sounds.values()) {
            ns.mute(m);
        }
        for (NotchTransition nt : this.transition_sounds) {
            nt.mute(m);
        }
        if (this.start_sound != null) {
            this.start_sound.mute(m);
        }
        if (this.shutdown_sound != null) {
            this.shutdown_sound.mute(m);
        }
    }

    @Override
    public void setVolume(float v) {
        for (SoundBite ns : this.notch_sounds.values()) {
            ns.setVolume(v);
        }
        for (NotchTransition nt : this.transition_sounds) {
            nt.setVolume(v);
        }
        if (this.start_sound != null) {
            this.start_sound.setVolume(v);
        }
        if (this.shutdown_sound != null) {
            this.shutdown_sound.setVolume(v);
        }
    }

    @Override
    public void setPosition(PhysicalLocation p) {
        for (SoundBite ns : this.notch_sounds.values()) {
            ns.setPosition(p);
        }
        for (NotchTransition nt : this.transition_sounds) {
            nt.setPosition(p);
        }
        if (this.start_sound != null) {
            this.start_sound.setPosition(p);
        }
        if (this.shutdown_sound != null) {
            this.shutdown_sound.setPosition(p);
        }
    }

    @Override
    public Element getXml() {
        Element me = new Element("sound");
        me.setAttribute("name", this.getName());
        me.setAttribute("type", "engine");
        return me;
    }

    @Override
    public void setXml(Element e, VSDFile vf) {
        String fn;
        Element el;
        super.setXml(e, vf);
        log.debug("Diesel EngineSound: {}", (Object)e.getAttribute("name").getValue());
        this.notch_sounds = new HashMap();
        this.transition_sounds = new ArrayList();
        Iterator itr = e.getChildren("notch-sound").iterator();
        int i = 0;
        while (itr.hasNext()) {
            el = (Element)itr.next();
            fn = el.getChildText("file");
            int nn = Integer.parseInt(el.getChildText("notch"));
            SoundBite sb = new SoundBite(vf, fn, "Engine_n" + i, "Engine_" + i);
            sb.setLooped(true);
            sb.setFadeTimes(this.getFadeInTime(), this.getFadeOutTime());
            sb.setGain(this.setXMLGain(el));
            this.notch_sounds.put(nn, sb);
            ++i;
        }
        itr = e.getChildren("notch-transition").iterator();
        i = 0;
        while (itr.hasNext()) {
            el = (Element)itr.next();
            fn = el.getChildText("file");
            NotchTransition nt = new NotchTransition(vf, fn, "Engine_nt" + i, "Engine_nt" + i);
            nt.setPrevNotch(Integer.parseInt(el.getChildText("prev-notch")));
            nt.setNextNotch(Integer.parseInt(el.getChildText("next-notch")));
            nt.setLooped(false);
            nt.setFadeTimes(this.getFadeInTime(), this.getFadeOutTime());
            nt.setGain(this.setXMLGain(el));
            this.transition_sounds.add(nt);
            ++i;
        }
        el = e.getChild("start-sound");
        if (el != null) {
            fn = el.getChild("file").getValue();
            this.start_sound = new SoundBite(vf, fn, "Engine_start", "Engine_Start");
            this.start_sound.setGain(this.setXMLGain(el));
            this.start_sound.setFadeTimes(this.getFadeInTime(), this.getFadeOutTime());
            this.start_sound.setLooped(false);
        }
        if ((el = e.getChild("shutdown-sound")) != null) {
            fn = el.getChild("file").getValue();
            this.shutdown_sound = new SoundBite(vf, fn, "Engine_shutdown", "Engine_Shutdown");
            this.shutdown_sound.setLooped(false);
            this.shutdown_sound.setGain(this.setXMLGain(el));
            this.shutdown_sound.setFadeTimes(this.getFadeInTime(), this.getFadeOutTime());
        }
    }
}

