/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.vsdecoder;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import jmri.jmrit.vsdecoder.SoundBite;
import jmri.jmrit.vsdecoder.VSDFile;
import jmri.jmrit.vsdecoder.VSDSound;
import jmri.util.PhysicalLocation;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfigurableSound
extends VSDSound {
    protected String start_file;
    protected String mid_file;
    protected String end_file;
    protected String short_file;
    SoundBite start_sound;
    SoundBite mid_sound;
    SoundBite end_sound;
    SoundBite short_sound;
    boolean initialized = false;
    protected boolean use_start_sound = false;
    protected boolean use_mid_sound = false;
    protected boolean use_end_sound = false;
    protected boolean use_short_sound = false;
    private float rd;
    private static final Logger log = LoggerFactory.getLogger(ConfigurableSound.class);

    public ConfigurableSound(String name) {
        super(name);
        this.is_playing = false;
    }

    public boolean init() {
        return this.init(null);
    }

    public boolean init(VSDFile vf) {
        if (!this.initialized) {
            if (this.use_start_sound) {
                this.start_sound = new SoundBite(vf, this.start_file, String.valueOf(this.name) + "_Start", String.valueOf(this.name) + "_Start");
                if (this.start_sound.isInitialized()) {
                    this.start_sound.setLooped(false);
                    this.start_sound.setReferenceDistance(this.rd);
                    this.start_sound.setGain(this.gain);
                } else {
                    this.use_start_sound = false;
                }
            }
            if (this.use_mid_sound) {
                this.mid_sound = new SoundBite(vf, this.mid_file, String.valueOf(this.name) + "_Mid", String.valueOf(this.name) + "_Mid");
                if (this.mid_sound.isInitialized()) {
                    this.mid_sound.setLooped(false);
                    this.mid_sound.setReferenceDistance(this.rd);
                    this.mid_sound.setGain(this.gain);
                } else {
                    this.use_mid_sound = false;
                }
            }
            if (this.use_end_sound) {
                this.end_sound = new SoundBite(vf, this.end_file, String.valueOf(this.name) + "_End", String.valueOf(this.name) + "_End");
                if (this.end_sound.isInitialized()) {
                    this.end_sound.setLooped(false);
                    this.end_sound.setReferenceDistance(this.rd);
                    this.end_sound.setGain(this.gain);
                } else {
                    this.use_end_sound = false;
                }
            }
            if (this.use_short_sound) {
                this.short_sound = new SoundBite(vf, this.short_file, String.valueOf(this.name) + "_Short", String.valueOf(this.name) + "_Short");
                if (this.short_sound.isInitialized()) {
                    this.short_sound.setLooped(false);
                    this.short_sound.setReferenceDistance(this.rd);
                    this.short_sound.setGain(this.gain);
                } else {
                    this.use_short_sound = false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean isPlaying() {
        return this.is_playing;
    }

    @Override
    public void play() {
        if (this.use_short_sound) {
            this.short_sound.play();
            this.is_playing = false;
        } else if (this.use_start_sound) {
            this.t = this.newTimer(this.start_sound.getLengthAsInt(), false, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConfigurableSound.this.handleTimerPop(e);
                }
            });
            this.start_sound.play();
            if (this.use_mid_sound) {
                this.t.start();
                this.is_playing = true;
            }
        } else if (this.use_mid_sound) {
            this.mid_sound.setLooped(true);
            this.mid_sound.play();
        }
    }

    @Override
    public void loop() {
        if (this.use_start_sound) {
            this.start_sound.setLooped(false);
            this.start_sound.play();
            this.t = this.newTimer(this.start_sound.getLengthAsInt() - 100, false, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConfigurableSound.this.handleTimerPop(e);
                }
            });
            this.t.setRepeats(false);
            this.t.start();
        } else if (this.use_mid_sound) {
            this.mid_sound.setLooped(true);
            this.mid_sound.play();
        }
        this.is_playing = true;
    }

    protected void handleTimerPop(ActionEvent e) {
        log.debug("Received timer pop after start sound played.");
        if (this.use_mid_sound) {
            this.mid_sound.setLooped(true);
            this.mid_sound.play();
        }
        this.t.stop();
    }

    @Override
    public void stop() {
        log.debug("Stopping");
        if (this.use_start_sound) {
            this.start_sound.stop();
        }
        if (this.use_mid_sound) {
            this.mid_sound.setLooped(false);
            this.mid_sound.fadeOut();
        }
        if (this.t != null) {
            this.t.stop();
        }
        if (this.use_end_sound) {
            if (this.use_mid_sound) {
                this.mid_sound.stop();
            }
            this.end_sound.setLooped(false);
            this.end_sound.play();
        }
        this.is_playing = false;
    }

    @Override
    public void fadeIn() {
        this.play();
    }

    @Override
    public void fadeOut() {
        this.stop();
    }

    @Override
    public void shutdown() {
        if (this.use_start_sound) {
            this.start_sound.stop();
        }
        if (this.use_mid_sound) {
            this.mid_sound.stop();
        }
        if (this.use_end_sound) {
            this.end_sound.stop();
        }
        if (this.use_short_sound) {
            this.short_sound.stop();
        }
    }

    @Override
    public void mute(boolean m) {
        if (this.use_start_sound) {
            this.start_sound.mute(m);
        }
        if (this.use_mid_sound) {
            this.mid_sound.mute(m);
        }
        if (this.use_end_sound) {
            this.end_sound.mute(m);
        }
        if (this.use_short_sound) {
            this.short_sound.mute(m);
        }
    }

    @Override
    public void setVolume(float v) {
        if (this.use_start_sound) {
            this.start_sound.setVolume(v);
        }
        if (this.use_mid_sound) {
            this.mid_sound.setVolume(v);
        }
        if (this.use_end_sound) {
            this.end_sound.setVolume(v);
        }
        if (this.use_short_sound) {
            this.short_sound.setVolume(v);
        }
    }

    @Override
    public void setPosition(PhysicalLocation p) {
        super.setPosition(p);
        if (this.use_start_sound) {
            this.start_sound.setPosition(p);
        }
        if (this.use_mid_sound) {
            this.mid_sound.setPosition(p);
        }
        if (this.use_end_sound) {
            this.end_sound.setPosition(p);
        }
        if (this.use_short_sound) {
            this.short_sound.setPosition(p);
        }
    }

    @Override
    public Element getXml() {
        Element me = new Element("sound");
        if (log.isDebugEnabled()) {
            log.debug("Configurable Sound:");
            log.debug("  name: {}", (Object)this.getName());
            log.debug("  start_file: {}", (Object)this.start_file);
            log.debug("  mid_file: {}", (Object)this.mid_file);
            log.debug("  end_file: {}", (Object)this.end_file);
            log.debug("  short_file: {}", (Object)this.short_file);
            log.debug("  use_start_file: {}", (Object)this.start_file);
        }
        me.setAttribute("name", this.getName());
        me.setAttribute("type", "configurable");
        if (this.use_start_sound) {
            me.addContent((Content)new Element("start-file").addContent(this.start_file));
        }
        if (this.use_mid_sound) {
            me.addContent((Content)new Element("mid-file").addContent(this.mid_file));
        }
        if (this.use_end_sound) {
            me.addContent((Content)new Element("end-file").addContent(this.end_file));
        }
        if (this.use_short_sound) {
            me.addContent((Content)new Element("short-file").addContent(this.short_file));
        }
        return me;
    }

    @Override
    public void setXml(Element e) {
        this.setXml(e, null);
    }

    public void setXml(Element e, VSDFile vf) {
        log.debug("ConfigurableSound: {}", (Object)e.getAttributeValue("name"));
        this.start_file = e.getChildText("start-file");
        this.use_start_sound = this.start_file != null && !this.start_file.isEmpty();
        this.mid_file = e.getChildText("mid-file");
        this.use_mid_sound = this.mid_file != null && !this.mid_file.isEmpty();
        this.end_file = e.getChildText("end-file");
        this.use_end_sound = this.end_file != null && !this.end_file.isEmpty();
        this.short_file = e.getChildText("short-file");
        this.use_short_sound = this.short_file != null && !this.short_file.isEmpty();
        String g = e.getChildText("gain");
        this.gain = g != null && !g.isEmpty() ? Float.parseFloat(g) : 0.8f;
        String rds = e.getChildText("reference-distance");
        this.rd = rds != null && !rds.isEmpty() ? Float.parseFloat(rds) : 1.0f;
        this.initialized = false;
        this.init(vf);
    }
}

