/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.vsdecoder;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import javax.swing.AbstractButton;
import jmri.jmrit.vsdecoder.Trigger;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ButtonTrigger
extends Trigger
implements ActionListener,
MouseListener {
    boolean match_value;
    boolean state;
    private static final Logger log = LoggerFactory.getLogger(ButtonTrigger.class);

    public ButtonTrigger(String name) {
        this(name, false);
    }

    public ButtonTrigger(String name, boolean bv) {
        super(name);
        this.setTriggerType(Trigger.TriggerType.BUTTON);
        this.match_value = bv;
    }

    public void setMatchValue(boolean bv) {
        this.match_value = bv;
    }

    public boolean getMatchValue() {
        return this.match_value;
    }

    public void mouseDown() {
        log.debug("buttonTrigger {} mouseDown() called.", (Object)this.getName());
        if (this.match_value) {
            this.callback.takeAction();
        }
    }

    public void mouseUp() {
        log.debug("buttonTrigger {} mouseUp() called.", (Object)this.getName());
        if (!this.match_value) {
            this.callback.takeAction();
        }
    }

    public void click(boolean v) {
        log.debug("buttonTrigger {} click( {}) called.", (Object)this.getName(), (Object)v);
        if (v == this.match_value) {
            this.callback.takeAction();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.debug("ButtonTrigger.actionPerformed() {}", (Object)this.getName());
        this.click(((AbstractButton)e.getSource()).isSelected());
    }

    @Override
    public void mousePressed(MouseEvent e) {
        log.debug("MouseListener.mousePressed() {}", (Object)this.getName());
        this.mouseDown();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        log.debug("MouseListener.mouseReleased() {}", (Object)this.getName());
        this.mouseUp();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public Element getXml() {
        Element me = new Element("Trigger");
        log.debug("Bool Trigger getXml():");
        log.debug("  trigger_name = {}", (Object)this.getName());
        log.debug("  event_name = {}", (Object)this.event_name);
        log.debug("  target_name = {}", (Object)this.target.getName());
        log.debug("  match = {}", (Object)Boolean.valueOf(this.match_value).toString());
        log.debug("  action = {}", (Object)this.getTriggerType().toString());
        me.setAttribute("name", this.getName());
        me.setAttribute("type", "BOOLEAN");
        me.addContent((Content)new Element("event-name").addContent(this.event_name));
        me.addContent((Content)new Element("target-name").addContent(this.target.getName()));
        me.addContent((Content)new Element("match").addContent(Boolean.valueOf(this.match_value).toString()));
        me.addContent((Content)new Element("action").addContent(this.getTriggerType().toString()));
        return me;
    }

    @Override
    public void setXml(Element e) {
        super.setXml(e);
        if (e.getAttribute("type").getValue().equals("BUTTON")) {
            this.match_value = Boolean.parseBoolean(e.getChild("match").getValue());
        }
    }

    static enum ButtonAction {

    }
}

