/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.vsdecoder;

import java.beans.PropertyChangeEvent;
import jmri.jmrit.vsdecoder.Trigger;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BoolTrigger
extends Trigger {
    boolean match_value;
    private static final Logger log = LoggerFactory.getLogger(BoolTrigger.class);

    public BoolTrigger(String name) {
        this(name, false);
    }

    public BoolTrigger(String name, boolean bv) {
        super(name);
        this.setTriggerType(Trigger.TriggerType.BOOLEAN);
        this.match_value = bv;
    }

    public void setMatchValue(boolean bv) {
        this.match_value = bv;
    }

    public boolean getMatchValue() {
        return this.match_value;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (this.target == null) {
            return;
        }
        if (!event.getPropertyName().equals(this.getEventName())) {
            return;
        }
        if (this.getTriggerType() == Trigger.TriggerType.NONE) {
            return;
        }
        if (this.getTargetAction() == Trigger.TargetAction.NOTHING) {
            return;
        }
        if (this.match_value == (Boolean)event.getNewValue()) {
            this.callback.takeAction();
        }
    }

    @Override
    public Element getXml() {
        Element me = new Element("trigger");
        log.debug("Bool Trigger getXml():");
        log.debug("  trigger_name = {}", (Object)this.getName());
        log.debug("  event_name = {}", (Object)this.event_name);
        log.debug("  target_name = {}", (Object)this.target.getName());
        log.debug("  match = {}", (Object)Boolean.valueOf(this.match_value).toString());
        log.debug("  action = {}", (Object)this.getTriggerType().toString());
        me.setAttribute("name", this.getName());
        me.setAttribute("type", "BOOLEAN");
        me.addContent((Content)new Element("event-name").addContent(this.event_name));
        me.addContent((Content)new Element("target-name").addContent(this.target.getName()));
        me.addContent((Content)new Element("match").addContent(Boolean.valueOf(this.match_value).toString()));
        me.addContent((Content)new Element("action").addContent(this.getTriggerType().toString()));
        return me;
    }

    @Override
    public void setXml(Element e) {
        super.setXml(e);
        if (e.getAttribute("type").getValue().equals("BOOLEAN")) {
            this.match_value = Boolean.parseBoolean(e.getChild("match").getValue());
        }
    }
}

