/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ussctc;

import java.beans.PropertyChangeEvent;
import jmri.InstanceManager;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.Turnout;
import jmri.TurnoutManager;
import jmri.jmrit.ussctc.Bell;
import jmri.jmrit.ussctc.CodeGroupNoBits;
import jmri.jmrit.ussctc.CodeGroupOneBit;
import jmri.jmrit.ussctc.Section;
import jmri.jmrit.ussctc.Station;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackCircuitSection
implements Section<CodeGroupNoBits, CodeGroupOneBit> {
    NamedBeanHandle<Sensor> hInputSensor;
    NamedBeanHandle<Turnout> hPanelOutput;
    Bell bell;
    Station station;
    private static final Logger log = LoggerFactory.getLogger(TrackCircuitSection.class);

    TrackCircuitSection() {
    }

    public TrackCircuitSection(String inputSensor, String panelOutput, Station station, Bell bell) {
        NamedBeanHandleManager hm = InstanceManager.getDefault(NamedBeanHandleManager.class);
        TurnoutManager tm = InstanceManager.getDefault(TurnoutManager.class);
        SensorManager sm = InstanceManager.getDefault(SensorManager.class);
        this.hInputSensor = hm.getNamedBeanHandle(inputSensor, sm.provideSensor(inputSensor));
        this.hPanelOutput = hm.getNamedBeanHandle(panelOutput, tm.provideTurnout(panelOutput));
        this.station = station;
        this.bell = bell;
        this.indicationComplete(this.indicationStart());
        sm.provideSensor(inputSensor).addPropertyChangeListener(e -> this.layoutTurnoutChanged(e));
    }

    public TrackCircuitSection(String inputSensor, String panelOutput, Station station) {
        this(inputSensor, panelOutput, station, null);
    }

    @Override
    public Station getStation() {
        return this.station;
    }

    @Override
    public String getName() {
        return "TC for " + this.hInputSensor.getBean().getDisplayName();
    }

    @Override
    public CodeGroupNoBits codeSendStart() {
        return CodeGroupNoBits.None;
    }

    @Override
    public void indicationComplete(CodeGroupOneBit value) {
        if (value == CodeGroupOneBit.Single1 && this.hPanelOutput.getBean().getCommandedState() != 4) {
            this.hPanelOutput.getBean().setCommandedState(4);
            if (this.bell != null) {
                this.bell.ring();
            }
        } else if (value == CodeGroupOneBit.Single0 && this.hPanelOutput.getBean().getCommandedState() != 2) {
            this.hPanelOutput.getBean().setCommandedState(2);
        }
    }

    @Override
    public void codeValueDelivered(CodeGroupNoBits value) {
    }

    @Override
    public CodeGroupOneBit indicationStart() {
        if (this.hInputSensor.getBean().getState() != 4) {
            return CodeGroupOneBit.Single1;
        }
        return CodeGroupOneBit.Single0;
    }

    void layoutTurnoutChanged(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("KnownState") && !e.getNewValue().equals(e.getOldValue())) {
            log.debug("Sensor changed from {} to {}, so requestIndicationStart", e.getOldValue(), e.getNewValue());
            this.station.requestIndicationStart();
        }
    }
}

