/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ussctc;

import java.util.ArrayList;
import java.util.List;
import jmri.BeanSetting;
import jmri.jmrit.ussctc.Lock;
import jmri.jmrit.ussctc.LockLogger;
import jmri.jmrit.ussctc.SignalHeadSection;

public class TimeLock
implements Lock {
    List<SignalHeadSection> list;
    List<BeanSetting> beans;

    public TimeLock(List<SignalHeadSection> list) {
        this.list = list;
        this.beans = null;
    }

    public TimeLock(List<SignalHeadSection> list, List<BeanSetting> beans) {
        this.list = list;
        this.beans = beans;
    }

    public TimeLock(SignalHeadSection[] array, BeanSetting[] beans) {
        this.list = new ArrayList<SignalHeadSection>();
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            SignalHeadSection s = objectArray[n2];
            this.list.add(s);
            ++n2;
        }
        this.beans = new ArrayList<BeanSetting>();
        objectArray = beans;
        n = beans.length;
        n2 = 0;
        while (n2 < n) {
            Object bean = objectArray[n2];
            this.beans.add((BeanSetting)bean);
            ++n2;
        }
    }

    public TimeLock(SignalHeadSection[] array) {
        this.list = new ArrayList<SignalHeadSection>();
        SignalHeadSection[] signalHeadSectionArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            SignalHeadSection s = signalHeadSectionArray[n2];
            this.list.add(s);
            ++n2;
        }
        this.beans = null;
    }

    public TimeLock(SignalHeadSection head) {
        this(new SignalHeadSection[]{head});
    }

    @Override
    public boolean isLockClear(LockLogger lockLogger) {
        if (this.beans != null) {
            for (BeanSetting bean : this.beans) {
                if (bean.check()) continue;
                lockLogger.setStatus(this, "");
                return true;
            }
        }
        for (SignalHeadSection section : this.list) {
            if (!section.isRunningTime()) continue;
            lockLogger.setStatus(this, "Locked: Station " + section.getStation().getName() + " running time");
            return false;
        }
        lockLogger.setStatus(this, "");
        return true;
    }

    public String toString() {
        String retval = this.isLockClear(debugLockLogger) ? "clear " : "locked";
        retval = String.valueOf(retval) + TimeLock.debugLockLogger.memory.getValue();
        return retval;
    }
}

