/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ussctc;

import java.util.ArrayList;
import jmri.jmrit.ussctc.CodeButton;
import jmri.jmrit.ussctc.CodeLine;
import jmri.jmrit.ussctc.Section;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Station {
    String name;
    CodeLine codeline;
    CodeButton button;
    ArrayList<Section> sections = new ArrayList();
    ArrayList<Enum> sentValues;
    ArrayList<Enum> indicationValues;
    private static final Logger log = LoggerFactory.getLogger(Station.class);

    public Station(String name, CodeLine codeline, CodeButton button) {
        this.name = name;
        this.codeline = codeline;
        this.button = button;
        button.addStation(this);
    }

    public Station add(Section section) {
        this.sections.add(section);
        return this;
    }

    CodeLine getCodeLine() {
        return this.codeline;
    }

    String getName() {
        return this.name;
    }

    public String toString() {
        StringBuffer retval = new StringBuffer("Station " + this.name + "\n        sentValues:");
        if (this.sentValues == null) {
            retval.append(" (null)");
        } else {
            for (Enum e : this.sentValues) {
                retval.append(" ");
                retval.append(e);
            }
        }
        retval.append("\n  indicationValues:");
        if (this.indicationValues == null) {
            retval = retval.append(" (null)");
        } else {
            for (Enum e : this.sentValues) {
                retval.append(" ");
                retval.append(e);
            }
        }
        return new String(retval);
    }

    public void codeSendRequest() {
        log.debug("Station - start codeSendRequest");
        this.sentValues = new ArrayList();
        this.sections.forEach(section -> this.sentValues.add((Enum)section.codeSendStart()));
        this.codeline.requestSendCode(this);
        log.debug("Station - end codeSendRequest");
    }

    public void codeSendComplete() {
        log.debug("Station - start codeSendComplete");
        this.sections.forEach(section -> this.sentValues.add((Enum)section.codeSendStart()));
        log.debug("Station - end codeSendComplete");
    }

    public void codeValueDelivered() {
        log.debug("Station - start codeValueDelivered");
        this.button.codeValueDelivered();
        int i = 0;
        while (i < this.sections.size()) {
            this.sections.get(i).codeValueDelivered(this.sentValues.get(i));
            ++i;
        }
        log.debug("Station - end codeValueDelivered");
    }

    public void requestIndicationStart() {
        log.debug("Station - start requestIndicationStart");
        this.codeline.requestIndicationStart(this);
        log.debug("Station - end requestIndicationStart");
    }

    public void indicationStart() {
        log.debug("Station - start indicationStart");
        this.button.indicationStart();
        this.indicationValues = new ArrayList();
        this.sections.forEach(section -> this.indicationValues.add((Enum)section.indicationStart()));
        log.debug("Station - end indicationStart");
    }

    public void indicationComplete() {
        log.debug("Station - start indicationComplete");
        int i = 0;
        while (i < this.sections.size()) {
            this.sections.get(i).indicationComplete(this.indicationValues.get(i));
            ++i;
        }
        this.button.indicationComplete();
        log.debug("Station - end indicationComplete");
    }
}

