/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ussctc;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayDeque;
import java.util.List;
import java.util.TimerTask;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import jmri.InstanceManager;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.Signal;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.Turnout;
import jmri.TurnoutManager;
import jmri.jmrit.ussctc.CodeButton;
import jmri.jmrit.ussctc.CodeGroupThreeBits;
import jmri.jmrit.ussctc.Lock;
import jmri.jmrit.ussctc.Section;
import jmri.jmrit.ussctc.Station;
import jmri.util.LoggingUtil;
import jmri.util.ThreadingUtil;
import jmri.util.TimerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignalHeadSection
implements Section<CodeGroupThreeBits, CodeGroupThreeBits> {
    static final int DEFAULT_RUN_TIME_LENGTH = 30000;
    Memory timeMemory = null;
    Sensor timeLogSensor;
    ArrayDeque<NamedBeanHandle<Signal>> hRightHeads;
    ArrayDeque<NamedBeanHandle<Signal>> hLeftHeads;
    NamedBeanHandle<Turnout> hLeftIndicator;
    NamedBeanHandle<Turnout> hStopIndicator;
    NamedBeanHandle<Turnout> hRightIndicator;
    NamedBeanHandle<Sensor> hLeftInput;
    NamedBeanHandle<Sensor> hRightInput;
    public static final CodeGroupThreeBits CODE_LEFT = CodeGroupThreeBits.Triple100;
    public static final CodeGroupThreeBits CODE_STOP = CodeGroupThreeBits.Triple010;
    public static final CodeGroupThreeBits CODE_RIGHT = CodeGroupThreeBits.Triple001;
    public static final CodeGroupThreeBits CODE_OFF = CodeGroupThreeBits.Triple000;
    Machine machine = Machine.SET_STOP;
    CodeGroupThreeBits lastIndication = CODE_STOP;
    boolean timeRunning = false;
    Station station;
    List<Lock> rightwardLocks;
    List<Lock> leftwardLocks;
    public static int MOVEMENT_DELAY = 5000;
    boolean deferIndication = false;
    final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private static final Logger log = LoggerFactory.getLogger(SignalHeadSection.class);

    SignalHeadSection() {
        this.station = new Station("1", null, new CodeButton("IS1", "IT1"));
    }

    public SignalHeadSection(List<String> rightHeads, List<String> leftHeads, String leftIndicator, String stopIndicator, String rightIndicator, String leftInput, String rightInput, Station station) {
        SignalHead sh;
        this.station = station;
        this.timeMemory = InstanceManager.getDefault(MemoryManager.class).getMemory("USS CTC:SIGNALHEADSECTION:1:TIME");
        if (this.timeMemory == null) {
            this.timeMemory = InstanceManager.getDefault(MemoryManager.class).provideMemory("USS CTC:SIGNALHEADSECTION:1:TIME");
            this.timeMemory.setValue(30000);
        }
        NamedBeanHandleManager hm = InstanceManager.getDefault(NamedBeanHandleManager.class);
        TurnoutManager tm = InstanceManager.getDefault(TurnoutManager.class);
        SensorManager sm = InstanceManager.getDefault(SensorManager.class);
        SignalHeadManager shm = InstanceManager.getDefault(SignalHeadManager.class);
        this.hRightHeads = new ArrayDeque();
        for (String string : rightHeads) {
            sh = shm.getSignalHead(string);
            if (sh != null) {
                this.hRightHeads.add(hm.getNamedBeanHandle(string, sh));
                continue;
            }
            log.debug("Signal {} for SignalHeadSection wasn't found", (Object)string);
        }
        this.hLeftHeads = new ArrayDeque();
        for (String string : leftHeads) {
            sh = shm.getSignalHead(string);
            if (sh != null) {
                this.hLeftHeads.add(hm.getNamedBeanHandle(string, sh));
                continue;
            }
            log.debug("Signal {} for SignalHeadSection wasn't found", (Object)string);
        }
        this.timeLogSensor = InstanceManager.getDefault(SensorManager.class).provideSensor("ISUSS CTC:SIGNALSECTION:" + station.getName() + ":RUNNINGTIME" + ":1:");
        this.timeLogSensor.setCommandedState(4);
        this.hLeftIndicator = hm.getNamedBeanHandle(leftIndicator, tm.provideTurnout(leftIndicator));
        this.hStopIndicator = hm.getNamedBeanHandle(stopIndicator, tm.provideTurnout(stopIndicator));
        this.hRightIndicator = hm.getNamedBeanHandle(rightIndicator, tm.provideTurnout(rightIndicator));
        this.hLeftInput = hm.getNamedBeanHandle(leftInput, sm.provideSensor(leftInput));
        this.hRightInput = hm.getNamedBeanHandle(rightInput, sm.provideSensor(rightInput));
        tm.provideTurnout(leftIndicator).setCommandedState(2);
        tm.provideTurnout(stopIndicator).setCommandedState(4);
        tm.provideTurnout(rightIndicator).setCommandedState(2);
        this.setListHeldState(this.hRightHeads, true);
        this.setListHeldState(this.hLeftHeads, true);
        for (NamedBeanHandle namedBeanHandle : this.hRightHeads) {
            ((Signal)namedBeanHandle.getBean()).addPropertyChangeListener(e -> ThreadingUtil.runOnLayoutEventually(() -> this.layoutSignalHeadChanged(e)));
        }
        for (NamedBeanHandle namedBeanHandle : this.hLeftHeads) {
            ((Signal)namedBeanHandle.getBean()).addPropertyChangeListener(e -> ThreadingUtil.runOnLayoutEventually(() -> this.layoutSignalHeadChanged(e)));
        }
    }

    void setLastIndication(CodeGroupThreeBits v) {
        log.trace("lastIndication goes from {} to {}", (Object)this.lastIndication, (Object)v);
        CodeGroupThreeBits old = this.lastIndication;
        this.lastIndication = v;
        this.firePropertyChange("LastIndication", (Object)old, (Object)this.lastIndication);
    }

    CodeGroupThreeBits getLastIndication() {
        return this.lastIndication;
    }

    public boolean isRunningTime() {
        return this.timeRunning;
    }

    @Override
    public Station getStation() {
        return this.station;
    }

    @Override
    public String getName() {
        return "SH for " + this.hStopIndicator.getBean().getDisplayName();
    }

    public void addRightwardLocks(List<Lock> locks) {
        this.rightwardLocks = locks;
    }

    public void addLeftwardLocks(List<Lock> locks) {
        this.leftwardLocks = locks;
    }

    @Override
    public CodeGroupThreeBits codeSendStart() {
        CodeGroupThreeBits retval;
        if (this.hRightInput.getBean().getKnownState() == 2 && this.hLeftIndicator.getBean().getKnownState() == 4 || this.hLeftInput.getBean().getKnownState() == 2 && this.hRightIndicator.getBean().getKnownState() == 4 || this.hLeftInput.getBean().getKnownState() != 2 && this.hRightInput.getBean().getKnownState() != 2 && (this.hRightIndicator.getBean().getKnownState() == 4 || this.hLeftIndicator.getBean().getKnownState() == 4)) {
            this.startRunningTime();
        }
        if (!this.timeRunning && (this.machine == Machine.SET_LEFT && this.hLeftInput.getBean().getKnownState() == 2 || this.machine == Machine.SET_RIGHT && this.hRightInput.getBean().getKnownState() == 2 || this.machine == Machine.SET_STOP && this.hRightInput.getBean().getKnownState() != 2 && this.hLeftInput.getBean().getKnownState() != 2)) {
            log.debug("No signal change required, states aligned");
        } else {
            log.debug("Signal change requested");
            this.hLeftIndicator.getBean().setCommandedState(2);
            this.hStopIndicator.getBean().setCommandedState(2);
            this.hRightIndicator.getBean().setCommandedState(2);
        }
        if (this.timeRunning) {
            this.machine = Machine.SET_STOP;
            retval = CODE_STOP;
        } else if (this.hLeftInput.getBean().getKnownState() == 2) {
            this.machine = Machine.SET_LEFT;
            retval = CODE_LEFT;
        } else if (this.hRightInput.getBean().getKnownState() == 2) {
            this.machine = Machine.SET_RIGHT;
            retval = CODE_RIGHT;
        } else {
            this.machine = Machine.SET_STOP;
            retval = CODE_STOP;
        }
        log.debug("codeSendStart returns {}", (Object)retval);
        return retval;
    }

    void startRunningTime() {
        if (this.timeRunning) {
            log.error("Attempt to start running time while it is already running", (Throwable)LoggingUtil.shortenStacktrace(new Exception("traceback")));
            return;
        }
        this.timeRunning = true;
        this.timeLogSensor.setCommandedState(2);
        ThreadingUtil.runOnLayoutDelayed(() -> {
            log.debug("End running time: Station {}", (Object)this.station.getName());
            Lock.signalLockLogger.setStatus(this, "End running time: Station " + this.station.getName());
            this.timeLogSensor.setCommandedState(4);
            if (!this.timeRunning) {
                log.warn("Running time timer ended while not marked as running time");
            }
            this.timeRunning = false;
            this.station.requestIndicationStart();
        }, (Integer)this.timeMemory.getValue());
        Lock.signalLockLogger.setStatus(this, "Running time: Station " + this.station.getName());
    }

    @Override
    public void codeValueDelivered(CodeGroupThreeBits value) {
        CodeGroupThreeBits currentIndication = this.getCurrentIndication();
        log.debug("codeValueDelivered sets value {} current: {} last: {}", new Object[]{value, currentIndication, this.lastIndication});
        if (value == CODE_LEFT && Lock.checkLocksClear(this.leftwardLocks, Lock.signalLockLogger)) {
            this.setLastIndication(CODE_LEFT);
            log.debug("Layout signals set LEFT");
            this.setListHeldState(this.hLeftHeads, false);
            this.setListHeldState(this.hRightHeads, true);
        } else if (value == CODE_RIGHT && Lock.checkLocksClear(this.rightwardLocks, Lock.signalLockLogger)) {
            this.setLastIndication(CODE_RIGHT);
            log.debug("Layout signals set RIGHT");
            this.setListHeldState(this.hRightHeads, false);
            this.setListHeldState(this.hLeftHeads, true);
        } else if (value == CODE_STOP) {
            this.setLastIndication(CODE_STOP);
            log.debug("Layout signals set STOP");
            this.setListHeldState(this.hRightHeads, true);
            this.setListHeldState(this.hLeftHeads, true);
        } else {
            Lock.signalLockLogger.setStatus(this, "Force stop: left clear " + Lock.checkLocksClear(this.leftwardLocks, Lock.signalLockLogger) + ", right clear " + Lock.checkLocksClear(this.rightwardLocks, Lock.signalLockLogger));
            this.setLastIndication(CODE_STOP);
            log.debug("Layout signals set STOP due to locks");
            this.setListHeldState(this.hRightHeads, true);
            this.setListHeldState(this.hLeftHeads, true);
        }
        if (currentIndication != this.lastIndication) {
            log.debug("codeValueDelivered started timer for return indication");
            TimerUtil.schedule(new TimerTask(){

                @Override
                public void run() {
                    ThreadingUtil.runOnLayout(() -> {
                        log.debug("end of movement delay from codeValueDelivered");
                        SignalHeadSection.this.station.requestIndicationStart();
                    });
                }
            }, MOVEMENT_DELAY);
        }
        log.debug("End codeValueDelivered");
    }

    protected void setListHeldState(Iterable<NamedBeanHandle<Signal>> list, boolean state) {
        for (NamedBeanHandle<Signal> handle : list) {
            if (handle.getBean().getHeld() == state) continue;
            handle.getBean().setHeld(state);
        }
    }

    public String toString() {
        StringBuffer retVal = new StringBuffer("SignalHeadSection ");
        retVal.append(" state: " + (Object)((Object)this.machine));
        retVal.append(" time: " + this.isRunningTime());
        retVal.append(" defer: " + this.deferIndication);
        for (NamedBeanHandle<Signal> handle : this.hRightHeads) {
            retVal.append("\n  \"").append(handle.getName()).append("\" ");
            retVal.append(" held: " + handle.getBean().getHeld() + " ");
            retVal.append(" clear: " + handle.getBean().isCleared() + " ");
            retVal.append(" stop: " + handle.getBean().isAtStop());
        }
        for (NamedBeanHandle<Signal> handle : this.hLeftHeads) {
            retVal.append("\n  \"").append(handle.getName()).append("\" ");
            retVal.append(" held: " + handle.getBean().getHeld() + " ");
            retVal.append(" clear: " + handle.getBean().isCleared() + " ");
            retVal.append(" stop: " + handle.getBean().isAtStop());
        }
        return retVal.toString();
    }

    @Override
    public CodeGroupThreeBits indicationStart() {
        CodeGroupThreeBits retval = this.getCurrentIndication();
        log.debug("indicationStart with {}; last indication was {}", (Object)retval, (Object)this.lastIndication);
        this.setLastIndication(retval);
        return retval;
    }

    public boolean headShowsClear(NamedBeanHandle<Signal> handle) {
        return !handle.getBean().getHeld() && handle.getBean().isCleared();
    }

    public boolean headShowsRestricting(NamedBeanHandle<Signal> handle) {
        return handle.getBean().isShowingRestricting();
    }

    public CodeGroupThreeBits getCurrentIndication() {
        CodeGroupThreeBits retval;
        log.trace("Start getCurrentIndication with lastIndication {}", (Object)this.lastIndication, (Object)LoggingUtil.shortenStacktrace(new Exception("traceback")));
        boolean leftClear = false;
        boolean leftHeld = false;
        boolean leftRestricting = false;
        for (NamedBeanHandle<Signal> handle : this.hLeftHeads) {
            if (this.headShowsClear(handle)) {
                leftClear = true;
            }
            if (handle.getBean().getHeld()) {
                leftHeld = true;
            }
            if (!this.headShowsRestricting(handle)) continue;
            leftRestricting = true;
        }
        boolean rightClear = false;
        boolean rightHeld = false;
        boolean rightRestricting = false;
        for (NamedBeanHandle<Signal> handle : this.hRightHeads) {
            if (this.headShowsClear(handle)) {
                rightClear = true;
            }
            if (handle.getBean().getHeld()) {
                rightHeld = true;
            }
            if (!this.headShowsRestricting(handle)) continue;
            rightRestricting = true;
        }
        log.trace(" found  leftClear {},  leftHeld {},  leftRestricting {}, lastIndication {}", new Object[]{leftClear, leftHeld, leftRestricting, this.lastIndication});
        log.trace("       rightClear {}, rightHeld {}, rightRestricting {}", new Object[]{rightClear, rightHeld, rightRestricting});
        if (leftClear && rightClear) {
            log.error("Found both left and right clear: {}", (Object)this);
        }
        if (leftClear && rightRestricting) {
            log.warn("Found left clear and right at restricting: {}", (Object)this);
        }
        if (leftRestricting && rightClear) {
            log.warn("Found left at restricting and right clear: {}", (Object)this);
        }
        if (leftRestricting || rightRestricting) {
            Lock.signalLockLogger.setStatus(this, "Force off due to restricting");
            retval = CODE_OFF;
        } else if (!leftClear && !rightClear) {
            if (this.lastIndication != CODE_STOP) {
                log.debug("CurrentIndication stop due to right and left not clear with " + (Object)((Object)this.lastIndication));
                Lock.signalLockLogger.setStatus(this, "Show stop due to right and left not clear");
            } else {
                Lock.signalLockLogger.clear();
            }
            retval = CODE_STOP;
        } else if (!leftClear && rightClear && this.lastIndication == CODE_RIGHT) {
            Lock.signalLockLogger.clear();
            retval = CODE_RIGHT;
        } else if (leftClear && !rightClear && this.lastIndication == CODE_LEFT) {
            Lock.signalLockLogger.clear();
            retval = CODE_LEFT;
        } else {
            log.debug("Not individually cleared, set OFF");
            if (!rightClear) {
                Lock.signalLockLogger.setStatus(this, "Force stop due to right not clear");
            } else if (!leftClear) {
                Lock.signalLockLogger.setStatus(this, "Force stop due to left not clear");
            } else {
                Lock.signalLockLogger.setStatus(this, "Force stop due to vital settings");
            }
            retval = CODE_OFF;
        }
        log.trace("End getCurrentIndication returns {}", (Object)retval);
        return retval;
    }

    @Override
    public void indicationComplete(CodeGroupThreeBits value) {
        log.debug("indicationComplete sets from {} in state {}", (Object)value, (Object)this.machine);
        if (this.timeRunning) {
            this.hLeftIndicator.getBean().setCommandedState(2);
            this.hStopIndicator.getBean().setCommandedState(2);
            this.hRightIndicator.getBean().setCommandedState(2);
        } else {
            switch (value) {
                case Triple100: {
                    this.hLeftIndicator.getBean().setCommandedState(4);
                    this.hStopIndicator.getBean().setCommandedState(2);
                    this.hRightIndicator.getBean().setCommandedState(2);
                    break;
                }
                case Triple010: {
                    this.hLeftIndicator.getBean().setCommandedState(2);
                    this.hStopIndicator.getBean().setCommandedState(4);
                    this.hRightIndicator.getBean().setCommandedState(2);
                    break;
                }
                case Triple001: {
                    this.hLeftIndicator.getBean().setCommandedState(2);
                    this.hStopIndicator.getBean().setCommandedState(2);
                    this.hRightIndicator.getBean().setCommandedState(4);
                    break;
                }
                case Triple000: {
                    this.hLeftIndicator.getBean().setCommandedState(2);
                    this.hStopIndicator.getBean().setCommandedState(2);
                    this.hRightIndicator.getBean().setCommandedState(2);
                    break;
                }
                default: {
                    log.error("Got code not recognized: {}", (Object)value);
                    this.hLeftIndicator.getBean().setCommandedState(2);
                    this.hStopIndicator.getBean().setCommandedState(2);
                    this.hRightIndicator.getBean().setCommandedState(2);
                }
            }
        }
    }

    void layoutSignalHeadChanged(PropertyChangeEvent e) {
        CodeGroupThreeBits current = this.getCurrentIndication();
        log.debug("layoutSignalHeadChanged with last: {} current: {} defer: {}, driving update", new Object[]{this.lastIndication, current, this.deferIndication});
        if (current == CODE_STOP && current != this.lastIndication && !this.deferIndication) {
            this.deferIndication = true;
            this.setListHeldState(this.hRightHeads, true);
            this.setListHeldState(this.hLeftHeads, true);
            this.deferIndication = false;
        }
        if (current != this.lastIndication && !this.deferIndication) {
            log.debug("  SignalHead change sends changed Indication last: {} current: {} defer: {}, driving update", new Object[]{this.lastIndication, current, this.deferIndication});
            this.station.requestIndicationStart();
        } else {
            log.debug("  SignalHead change without change in Indication");
        }
        log.debug("end of layoutSignalHeadChanged");
    }

    @OverridingMethodsMustInvokeSuper
    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    @OverridingMethodsMustInvokeSuper
    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    @OverridingMethodsMustInvokeSuper
    protected void firePropertyChange(String p, Object old, Object n) {
        this.pcs.firePropertyChange(p, old, n);
    }

    static enum Machine {
        SET_LEFT,
        SET_STOP,
        SET_RIGHT;

    }
}

