/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ussctc;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.Memory;
import jmri.MemoryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockLogger {
    Map<Object, String> statusMap = new LinkedHashMap<Object, String>();
    public final String logMemoryName;
    public final Memory memory;
    @SuppressFBWarnings(value={"SLF4J_LOGGER_SHOULD_BE_PRIVATE"}, justification="Findbugs got this one wrong.  The 'log' variable needs to be protected because it's accessed in anonymous subclasses in the `Lock` class which override the `log()` method")
    protected static final Logger log = LoggerFactory.getLogger(LockLogger.class);

    LockLogger(String name) {
        this.logMemoryName = name;
        this.memory = InstanceManager.getDefault(MemoryManager.class).provideMemory(this.logMemoryName);
    }

    public void setStatus(@Nonnull Object logger, @Nonnull String status) {
        log.debug("Object {} set \"{}\" was \"{}\"", new Object[]{logger.getClass(), status, this.statusMap.get(logger)});
        this.statusMap.put(logger, status);
        if (!status.isEmpty()) {
            log.trace("  writing status from call");
            this.memory.setValue(status);
            this.log(status);
            return;
        }
        for (String value : this.statusMap.values()) {
            if (value.isEmpty()) continue;
            log.trace("   writing status from map: \"{}\"", (Object)value);
            this.memory.setValue(value);
            this.log(status);
            return;
        }
        log.trace("   clearing status");
        this.memory.setValue("");
    }

    public void clear() {
        log.debug("LockLogger cleared from \"{}\"", this.memory.getValue());
        this.statusMap.clear();
        this.memory.setValue("");
    }

    void log(String message) {
        log.debug(message);
    }
}

