/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ussctc;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.TimerTask;
import jmri.InstanceManager;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.Turnout;
import jmri.TurnoutManager;
import jmri.jmrit.ussctc.Station;
import jmri.util.ThreadingUtil;
import jmri.util.TimerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeLine {
    final Memory logMemory;
    final NamedBeanHandle<Turnout> hStartIndicateTO;
    final NamedBeanHandle<Turnout> hStartSendTO;
    final NamedBeanHandle<Turnout> hOutput1TO;
    final NamedBeanHandle<Turnout> hOutput2TO;
    final NamedBeanHandle<Turnout> hOutput3TO;
    final NamedBeanHandle<Turnout> hOutput4TO;
    public static int START_PULSE_LENGTH = 500;
    public static int CODE_SEND_DELAY = 2500;
    public static int INTER_INDICATION_DELAY = 500;
    volatile Deque<Station> codeQueue = new ArrayDeque<Station>();
    volatile Deque<Station> indicationQueue = new ArrayDeque<Station>();
    volatile boolean active = false;
    private static final Logger log = LoggerFactory.getLogger(CodeLine.class);

    public CodeLine(String startIndicateTO, String startSendTO, String output1TO, String output2TO, String output3TO, String output4TO) {
        NamedBeanHandleManager hm = InstanceManager.getDefault(NamedBeanHandleManager.class);
        TurnoutManager tm = InstanceManager.getDefault(TurnoutManager.class);
        this.logMemory = InstanceManager.getDefault(MemoryManager.class).provideMemory("USS CTC:CODELINE:1:LOG");
        log.debug("log memory name is {}", (Object)this.logMemory.getSystemName());
        this.hStartIndicateTO = hm.getNamedBeanHandle(startIndicateTO, tm.provideTurnout(startIndicateTO));
        this.hStartSendTO = hm.getNamedBeanHandle(startSendTO, tm.provideTurnout(startSendTO));
        this.hOutput1TO = hm.getNamedBeanHandle(output1TO, tm.provideTurnout(output1TO));
        this.hOutput2TO = hm.getNamedBeanHandle(output2TO, tm.provideTurnout(output2TO));
        this.hOutput3TO = hm.getNamedBeanHandle(output3TO, tm.provideTurnout(output3TO));
        this.hOutput4TO = hm.getNamedBeanHandle(output4TO, tm.provideTurnout(output4TO));
    }

    synchronized void endAndCheckNext() {
        if (!this.active) {
            log.error("endAndCheckNext with active false");
        }
        log.debug("active set false");
        this.active = false;
        this.checkForWork();
    }

    synchronized void checkForWork() {
        log.debug("checkForWork with active == {}", (Object)this.active);
        if (this.active) {
            return;
        }
        log.debug("active set true");
        this.active = true;
        Station indicatorStation = this.indicationQueue.pollFirst();
        if (indicatorStation != null) {
            ThreadingUtil.runOnGUIDelayed(() -> this.startSendIndication(indicatorStation), INTER_INDICATION_DELAY);
            return;
        }
        Station codeStation = this.codeQueue.pollFirst();
        if (codeStation != null) {
            this.startSendCode(codeStation);
            return;
        }
        log.debug("active set false");
        this.active = false;
        this.logMemory.setValue("");
        log.debug("CodeLine goes inactive");
    }

    synchronized void requestSendCode(Station station) {
        log.debug("requestSendCode queued from Station {}", (Object)station.getName());
        while (this.codeQueue.contains(station)) {
            this.codeQueue.remove(station);
            log.debug("     removed previous request");
        }
        this.codeQueue.addLast(station);
        this.checkForWork();
    }

    void startSendCode(Station station) {
        Station s = station;
        log.debug("CodeLine startSendCode - Tell hardware to start sending code");
        this.logMemory.setValue("Sending Code: Station " + station.getName());
        this.startSendExternalCodeLine();
        ThreadingUtil.runOnGUIDelayed(() -> {
            s.codeValueDelivered();
            log.debug("end of codeValueDelivered");
            this.endAndCheckNext();
        }, CODE_SEND_DELAY);
    }

    void startSendExternalCodeLine() {
        this.hStartSendTO.getBean().setCommandedState(4);
        TimerUtil.schedule(new TimerTask(){

            @Override
            public void run() {
                CodeLine.this.hStartSendTO.getBean().setCommandedState(2);
            }
        }, START_PULSE_LENGTH);
    }

    public String toString() {
        return "Codeline " + this.active;
    }

    synchronized void requestIndicationStart(Station station) {
        log.debug("requestIndicationStart queued from Station {}", (Object)station.getName());
        while (this.indicationQueue.contains(station)) {
            this.indicationQueue.remove(station);
            log.debug("     removed previous request");
        }
        this.indicationQueue.addLast(station);
        this.checkForWork();
    }

    void startSendIndication(Station station) {
        Station s = station;
        log.debug("CodeLine startSendIndication - process indication from field");
        station.indicationStart();
        log.debug("Tell hardware to start sending indication");
        this.logMemory.setValue("Receiving Indication: Station " + station.getName());
        this.startIndicationExternalCodeLine();
        ThreadingUtil.runOnGUIDelayed(() -> {
            log.debug("hardware delay done, receiving indication");
            s.indicationComplete();
            log.debug("end of indicationComplete");
            this.endAndCheckNext();
        }, CODE_SEND_DELAY);
    }

    void startIndicationExternalCodeLine() {
        this.hStartIndicateTO.getBean().setCommandedState(4);
        TimerUtil.schedule(new TimerTask(){

            @Override
            public void run() {
                CodeLine.this.hStartIndicateTO.getBean().setCommandedState(2);
            }
        }, START_PULSE_LENGTH);
    }
}

