/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.turnoutoperations;

import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jmri.InstanceManager;
import jmri.TurnoutOperation;
import jmri.TurnoutOperationManager;
import jmri.jmrit.turnoutoperations.Bundle;
import jmri.jmrit.turnoutoperations.TurnoutOperationConfig;

public class TurnoutOperationFrame
extends JDialog {
    TurnoutOperationFrame self = this;
    TurnoutOperationConfig currentConfig = null;
    TurnoutOperation currentOperation = null;
    String previousSelectionName = "";
    JTabbedPane tabPane;

    public TurnoutOperationFrame(Frame parent) {
        super(parent, Bundle.getMessage("TurnoutOperationEditorTitle"));
        Container contentPane = this.getContentPane();
        this.setSize(400, 165);
        Box outerBox = Box.createVerticalBox();
        contentPane.add(outerBox);
        this.tabPane = new JTabbedPane();
        this.tabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TurnoutOperationFrame.this.self.changeTab();
            }
        });
        outerBox.add(this.tabPane);
        Box bottomBox = Box.createHorizontalBox();
        bottomBox.add(Box.createHorizontalGlue());
        JButton cancelButton = new JButton(Bundle.getMessage("ButtonCancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                TurnoutOperationFrame.this.setVisible(false);
            }
        });
        bottomBox.add(cancelButton);
        JButton okButton = new JButton(Bundle.getMessage("ButtonOK"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                TurnoutOperationFrame.this.self.doOK();
            }
        });
        bottomBox.add(okButton);
        JButton deleteButton = new JButton(Bundle.getMessage("ButtonDelete"));
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                TurnoutOperationFrame.this.self.doDelete();
            }
        });
        bottomBox.add(deleteButton);
        outerBox.add(bottomBox);
        this.populateTabs();
        InstanceManager.getDefault(TurnoutOperationManager.class).addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("Content")) {
                    TurnoutOperationFrame.this.populateTabs();
                }
            }
        });
        if (this.tabPane.getTabCount() > 0) {
            this.setVisible(true);
        }
    }

    private void doOK() {
        if (this.currentOperation != null) {
            this.currentConfig.endConfigure();
        }
        this.setVisible(false);
    }

    private void doDelete() {
        String query = "";
        if (this.currentOperation != null && !this.currentOperation.isDefinitive()) {
            if (this.currentOperation.isInUse()) {
                query = String.valueOf(Bundle.getMessage("DeleteOperationInUse", this.currentOperation.getName())) + Bundle.getMessage("DeleteRevert");
            }
            if (JOptionPane.showConfirmDialog(this, String.valueOf(query) + Bundle.getMessage("DeleteOperationDialog", this.currentOperation.getName()), Bundle.getMessage("WarningTitle"), 0) == 0) {
                this.currentOperation.dispose();
                this.populateTabs();
            }
        }
    }

    private void populateTabs() {
        TurnoutOperation op;
        TurnoutOperation[] operations = InstanceManager.getDefault(TurnoutOperationManager.class).getTurnoutOperations();
        TurnoutOperationConfig firstPane = null;
        this.tabPane.removeAll();
        Vector<TurnoutOperation> definitiveOperations = new Vector<TurnoutOperation>(10);
        Vector<TurnoutOperation> namedOperations = new Vector<TurnoutOperation>(50);
        int i = 0;
        while (i < operations.length) {
            if (operations[i].isDefinitive()) {
                definitiveOperations.addElement(operations[i]);
            } else if (!operations[i].isNonce()) {
                namedOperations.addElement(operations[i]);
            }
            ++i;
        }
        Collections.sort(definitiveOperations);
        Collections.sort(namedOperations);
        int j = 0;
        while (j < definitiveOperations.size()) {
            op = (TurnoutOperation)definitiveOperations.elementAt(j);
            TurnoutOperationConfig pane = TurnoutOperationConfig.getConfigPanel(op);
            if (pane != null) {
                if (firstPane == null) {
                    firstPane = pane;
                }
                this.tabPane.add(op.getName(), pane);
                if (op.getName().equals(this.previousSelectionName)) {
                    this.tabPane.setSelectedComponent(pane);
                }
            }
            ++j;
        }
        int k = 0;
        while (k < namedOperations.size()) {
            op = (TurnoutOperation)namedOperations.elementAt(k);
            TurnoutOperationConfig pane = TurnoutOperationConfig.getConfigPanel(op);
            if (pane != null) {
                this.tabPane.add(op.getName(), pane);
                if (op.getName().equals(this.previousSelectionName)) {
                    this.tabPane.setSelectedComponent(pane);
                }
            }
            ++k;
        }
        if (this.tabPane.getSelectedComponent() == null && firstPane != null) {
            this.tabPane.setSelectedComponent(firstPane);
        }
        this.changeTab();
    }

    private void changeTab() {
        this.currentConfig = (TurnoutOperationConfig)this.tabPane.getSelectedComponent();
        if (this.currentConfig == null) {
            this.currentOperation = null;
            this.previousSelectionName = "";
        } else {
            this.currentOperation = this.currentConfig.getOperation();
            this.previousSelectionName = this.currentOperation.getName();
        }
    }
}

