/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.turnoutoperations;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JPanel;
import jmri.TurnoutOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TurnoutOperationConfig
extends JPanel {
    TurnoutOperation myOperation;
    private static final Logger log = LoggerFactory.getLogger(TurnoutOperationConfig.class);

    TurnoutOperationConfig(TurnoutOperation op) {
        this.myOperation = op;
    }

    TurnoutOperation getOperation() {
        return this.myOperation;
    }

    public void endConfigure() {
        log.error("Should have been overridden!");
    }

    public static TurnoutOperationConfig getConfigPanel(TurnoutOperation op) {
        TurnoutOperationConfig config = null;
        String[] path = op.getClass().getName().split("\\.");
        String configName = "jmri.jmrit.turnoutoperations." + path[path.length - 1] + "Config";
        try {
            Class<?> configClass = Class.forName(configName);
            Constructor<?>[] constrs = configClass.getConstructors();
            if (constrs.length == 1) {
                try {
                    config = (TurnoutOperationConfig)constrs[0].newInstance(op);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
                    log.error("Error configuring TurnoutOperation", (Throwable)ex);
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
        if (config == null) {
            log.debug("could not create configurator for {} \"{}\"", (Object)op.getClass().getName(), (Object)op.getName());
        }
        return config;
    }
}

