/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.timetable.swing;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import jmri.jmrit.timetable.swing.TimeTableGraphCommon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeTablePrintGraph
implements Printable {
    final int _segmentId;
    final int _scheduleId;
    final boolean _showTrainTimes;
    final boolean _twoPage;
    private static final Logger log = LoggerFactory.getLogger(TimeTablePrintGraph.class);

    public TimeTablePrintGraph(int segmentId, int scheduleId, boolean showTrainTimes, boolean twoPage) {
        this._segmentId = segmentId;
        this._scheduleId = scheduleId;
        this._showTrainTimes = showTrainTimes;
        this._twoPage = twoPage;
    }

    void printGraph() {
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable(this);
        boolean ok = job.printDialog();
        if (ok) {
            try {
                job.print();
            }
            catch (PrinterException ex) {
                log.warn("A printer exception occurred: ", (Throwable)ex);
            }
        }
    }

    @Override
    public int print(Graphics g, PageFormat pf, int page) throws PrinterException {
        int pageCount;
        int n = pageCount = this._twoPage ? 2 : 1;
        if (page > pageCount - 1) {
            return 1;
        }
        pf.setOrientation(0);
        if (!(g instanceof Graphics2D)) {
            throw new IllegalArgumentException();
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.translate(pf.getImageableX(), pf.getImageableY());
        TimeTableGraphCommon graph = new TimeTableGraphCommon();
        graph.init(this._segmentId, this._scheduleId, this._showTrainTimes, pf.getImageableHeight(), pf.getImageableWidth() * (double)pageCount, false);
        if (page == 1) {
            Double w = pf.getImageableWidth();
            g2d.translate(-w.intValue(), 0);
        }
        graph.doPaint(g2d);
        return 0;
    }
}

