/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.timetable.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SpinnerNumberModel;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jmri.InstanceManager;
import jmri.Scale;
import jmri.ScaleManager;
import jmri.UserPreferencesManager;
import jmri.jmrit.XmlFile;
import jmri.jmrit.operations.trains.tools.ExportTimetable;
import jmri.jmrit.timetable.Layout;
import jmri.jmrit.timetable.Schedule;
import jmri.jmrit.timetable.Segment;
import jmri.jmrit.timetable.Station;
import jmri.jmrit.timetable.Stop;
import jmri.jmrit.timetable.TimeTableCsvExport;
import jmri.jmrit.timetable.TimeTableCsvImport;
import jmri.jmrit.timetable.TimeTableDataManager;
import jmri.jmrit.timetable.TimeTableImport;
import jmri.jmrit.timetable.Train;
import jmri.jmrit.timetable.TrainType;
import jmri.jmrit.timetable.configurexml.TimeTableXml;
import jmri.jmrit.timetable.swing.Bundle;
import jmri.jmrit.timetable.swing.TimeTableDisplayGraph;
import jmri.jmrit.timetable.swing.TimeTablePrintGraph;
import jmri.util.ColorUtil;
import jmri.util.FileUtil;
import jmri.util.JmriJFrame;
import jmri.util.swing.JComboBoxUtil;
import jmri.util.swing.SplitButtonColorChooserPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeTableFrame
extends JmriJFrame {
    public static final String EMPTY_GRID = "EmptyGrid";
    TimeTableDataManager _dataMgr;
    boolean _isDirty = false;
    boolean _showTrainTimes = false;
    boolean _twoPage = false;
    JTree _timetableTree;
    DefaultTreeModel _timetableModel;
    DefaultMutableTreeNode _timetableRoot;
    TreeSelectionListener _timetableListener;
    TreePath _curTreePath = null;
    TimeTableTreeNode _layoutNode = null;
    TimeTableTreeNode _typeHead = null;
    TimeTableTreeNode _typeNode = null;
    TimeTableTreeNode _segmentHead = null;
    TimeTableTreeNode _segmentNode = null;
    TimeTableTreeNode _stationNode = null;
    TimeTableTreeNode _scheduleHead = null;
    TimeTableTreeNode _scheduleNode = null;
    TimeTableTreeNode _trainNode = null;
    TimeTableTreeNode _stopNode = null;
    TimeTableTreeNode _leafNode = null;
    TimeTableTreeNode _curNode = null;
    int _curNodeId = 0;
    String _curNodeType = null;
    String _curNodeText = null;
    int _curNodeRow = -1;
    JPanel _detailGrid = new JPanel();
    JPanel _detailFooter = new JPanel();
    JPanel _gridPanel;
    boolean _editActive = false;
    JButton _cancelAction;
    JButton _updateAction;
    JTextField _editLayoutName;
    JComboBox<Scale> _editScale;
    JTextField _editFastClock;
    JTextField _editThrottles;
    JCheckBox _editMetric;
    JLabel _showScaleMK;
    JTextField _editTrainTypeName;
    JColorChooser _editTrainTypeColor;
    JTextField _editSegmentName;
    JTextField _editStationName;
    JTextField _editDistance;
    JCheckBox _editDoubleTrack;
    JSpinner _editSidings;
    JSpinner _editStaging;
    JTextField _editScheduleName;
    JTextField _editEffDate;
    JSpinner _editStartHour;
    JSpinner _editDuration;
    JTextField _editTrainName;
    JTextField _editTrainDesc;
    JComboBox<TrainType> _editTrainType;
    JTextField _editDefaultSpeed;
    JTextField _editTrainStartTime;
    JSpinner _editThrottle;
    JTextArea _editTrainNotes;
    JLabel _showRouteDuration;
    JLabel _showStopSeq;
    JComboBox<TimeTableDataManager.SegmentStation> _editStopStation;
    JTextField _editStopDuration;
    JTextField _editNextSpeed;
    JSpinner _editStagingTrack;
    JTextArea _editStopNotes;
    JLabel _showArriveTime;
    JLabel _showDepartTime;
    JPanel _leftButtonBar;
    JPanel _addButtonPanel;
    JPanel _deleteButtonPanel;
    JPanel _moveButtonPanel;
    JPanel _graphButtonPanel;
    JButton _addButton = new JButton();
    JButton _deleteButton = new JButton();
    JButton _displayButton = new JButton();
    JButton _printButton = new JButton();
    JButton _saveButton = new JButton();
    transient FocusListener detailFocusEvent = new FocusListener(){

        @Override
        public void focusGained(FocusEvent e) {
            if (!TimeTableFrame.this._editActive) {
                TimeTableFrame.this.setEditMode(true);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    };
    transient ChangeListener detailChangeEvent = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            if (!TimeTableFrame.this._editActive) {
                TimeTableFrame.this.setEditMode(true);
            }
        }
    };
    transient ItemListener stopStationItemEvent = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                TimeTableDataManager.SegmentStation segmentStation = (TimeTableDataManager.SegmentStation)e.getItem();
                int stagingTracks = TimeTableFrame.this._dataMgr.getStation(segmentStation.getStationId()).getStaging();
                Stop stop = TimeTableFrame.this._dataMgr.getStop(TimeTableFrame.this._curNodeId);
                if (stop.getStagingTrack() <= stagingTracks) {
                    TimeTableFrame.this._editStagingTrack.setModel(new SpinnerNumberModel(stop.getStagingTrack(), 0, stagingTracks, 1));
                }
            }
        }
    };
    transient ItemListener layoutScaleItemEvent = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            String ans;
            Scale scale;
            if (e.getStateChange() == 1 && TimeTableFrame.this._editScale.hasFocus() && (scale = (Scale)TimeTableFrame.this._editScale.getSelectedItem()).getScaleName().equals("CUSTOM") && (ans = JOptionPane.showInputDialog(Bundle.getMessage("ScaleRatioChange"), (Object)scale.getScaleRatio())) != null) {
                try {
                    double newRatio = Double.parseDouble(ans);
                    scale.setScaleRatio(newRatio);
                }
                catch (PropertyVetoException | IllegalArgumentException ex) {
                    log.warn("Unable to change custom ratio: {}", (Object)ex.getMessage());
                    JOptionPane.showMessageDialog(null, Bundle.getMessage("NumberFormatError", ans, "Custom ratio"), Bundle.getMessage("WarningTitle"), 2);
                    Layout layout = TimeTableFrame.this._dataMgr.getLayout(TimeTableFrame.this._curNodeId);
                    TimeTableFrame.this._editScale.setSelectedItem(layout.getScale());
                }
            }
        }
    };
    JFileChooser fileChooser;
    List<String> feedbackList;
    private static final Logger log = LoggerFactory.getLogger(TimeTableFrame.class);

    public TimeTableFrame() {
    }

    public TimeTableFrame(String tt) {
        super(true, true);
        this.setTitle(Bundle.getMessage("TitleTimeTable"));
        InstanceManager.setDefault(TimeTableFrame.class, this);
        this._dataMgr = TimeTableDataManager.getDataManager();
        this.buildComponents();
        this.createFrame();
        this.createMenu();
        this.setEditMode(false);
        this.setShowReminder(false);
    }

    private void createFrame() {
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JTree treeContent = this.buildTree();
        JScrollPane treeScroll = new JScrollPane(treeContent);
        JPanel detailPane = new JPanel();
        detailPane.setBorder(BorderFactory.createMatteBorder(0, 2, 0, 0, Color.DARK_GRAY));
        detailPane.setLayout(new BoxLayout(detailPane, 1));
        this.makeDetailGrid(EMPTY_GRID);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        this._cancelAction = new JButton(Bundle.getMessage("ButtonCancel"));
        this._cancelAction.setToolTipText(Bundle.getMessage("HintCancelButton"));
        panel.add(this._cancelAction);
        this._cancelAction.addActionListener(e -> this.cancelPressed());
        panel.add(Box.createHorizontalStrut(10));
        this._updateAction = new JButton(Bundle.getMessage("ButtonUpdate"));
        this._updateAction.setToolTipText(Bundle.getMessage("HintUpdateButton"));
        panel.add(this._updateAction);
        this._updateAction.addActionListener(e -> this.updatePressed());
        this._detailFooter.add(panel);
        JPanel detailEdit = new JPanel(new BorderLayout());
        detailEdit.add((Component)this._detailGrid, "North");
        detailEdit.add((Component)this._detailFooter, "South");
        detailPane.add(detailEdit);
        JSplitPane bodyPane = new JSplitPane(1, treeScroll, detailPane);
        bodyPane.setDividerSize(10);
        bodyPane.setResizeWeight(0.35);
        bodyPane.setOneTouchExpandable(true);
        contentPane.add(bodyPane);
        JPanel footer = new JPanel(new BorderLayout());
        this._leftButtonBar = new JPanel();
        this._addButton = new JButton(Bundle.getMessage("AddLayoutButtonText"));
        this._addButton.setToolTipText(Bundle.getMessage("HintAddButton"));
        this._addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeTableFrame.this.addPressed();
            }
        });
        this._addButtonPanel = new JPanel();
        this._addButtonPanel.add(this._addButton);
        this._leftButtonBar.add(this._addButtonPanel);
        this._deleteButton = new JButton(Bundle.getMessage("DeleteLayoutButtonText"));
        this._deleteButton.setToolTipText(Bundle.getMessage("HintDeleteButton"));
        this._deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeTableFrame.this.deletePressed();
            }
        });
        this._deleteButtonPanel = new JPanel();
        this._deleteButtonPanel.add(this._deleteButton);
        this._deleteButtonPanel.setVisible(false);
        this._leftButtonBar.add(this._deleteButtonPanel);
        JLabel moveLabel = new JLabel(Bundle.getMessage("LabelMove"));
        final JButton upButton = new JButton(Bundle.getMessage("ButtonUp"));
        upButton.setToolTipText(Bundle.getMessage("HintUpButton"));
        final JButton downButton = new JButton(Bundle.getMessage("ButtonDown"));
        downButton.setToolTipText(Bundle.getMessage("HintDownButton"));
        upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                downButton.setEnabled(false);
                upButton.setEnabled(false);
                TimeTableFrame.this.upPressed();
            }
        });
        downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                upButton.setEnabled(false);
                downButton.setEnabled(false);
                TimeTableFrame.this.downPressed();
            }
        });
        this._moveButtonPanel = new JPanel();
        this._moveButtonPanel.add(moveLabel);
        this._moveButtonPanel.add(upButton);
        this._moveButtonPanel.add(new JLabel("|"));
        this._moveButtonPanel.add(downButton);
        this._moveButtonPanel.setVisible(false);
        this._leftButtonBar.add(this._moveButtonPanel);
        JLabel graphLabel = new JLabel(Bundle.getMessage("LabelGraph"));
        this._displayButton = new JButton(Bundle.getMessage("ButtonDisplay"));
        this._displayButton.setToolTipText(Bundle.getMessage("HintDisplayButton"));
        this._displayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeTableFrame.this.graphPressed("Display");
            }
        });
        this._printButton = new JButton(Bundle.getMessage("ButtonPrint"));
        this._printButton.setToolTipText(Bundle.getMessage("HintPrintButton"));
        this._printButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeTableFrame.this.graphPressed("Print");
            }
        });
        this._graphButtonPanel = new JPanel();
        this._graphButtonPanel.add(graphLabel);
        this._graphButtonPanel.add(this._displayButton);
        this._graphButtonPanel.add(new JLabel("|"));
        this._graphButtonPanel.add(this._printButton);
        this._leftButtonBar.add(this._graphButtonPanel);
        footer.add((Component)this._leftButtonBar, "West");
        JPanel rightButtonBar = new JPanel();
        this._saveButton = new JButton(Bundle.getMessage("ButtonSave"));
        this._saveButton.setToolTipText(Bundle.getMessage("HintSaveButton"));
        this._saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeTableFrame.this.savePressed();
            }
        });
        JPanel saveButtonPanel = new JPanel();
        saveButtonPanel.add(this._saveButton);
        rightButtonBar.add(saveButtonPanel);
        JButton doneButton = new JButton(Bundle.getMessage("ButtonDone"));
        doneButton.setToolTipText(Bundle.getMessage("HintDoneButton"));
        doneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeTableFrame.this.donePressed();
            }
        });
        JPanel doneButtonPanel = new JPanel();
        doneButtonPanel.add(doneButton);
        rightButtonBar.add(doneButtonPanel);
        footer.add((Component)rightButtonBar, "East");
        contentPane.add((Component)footer, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TimeTableFrame.this.donePressed();
            }
        });
        this.setDefaultCloseOperation(0);
        this.pack();
        this._addButtonPanel.setVisible(false);
        this._deleteButtonPanel.setVisible(false);
        this._graphButtonPanel.setVisible(false);
    }

    void createMenu() {
        this._showTrainTimes = InstanceManager.getDefault(UserPreferencesManager.class).getSimplePreferenceState("jmri.jmrit.timetable:TrainTimes");
        JCheckBoxMenuItem trainTime = new JCheckBoxMenuItem(Bundle.getMessage("MenuTrainTimes"));
        trainTime.setSelected(this._showTrainTimes);
        trainTime.addActionListener(event -> {
            this._showTrainTimes = trainTime.isSelected();
            InstanceManager.getDefault(UserPreferencesManager.class).setSimplePreferenceState("jmri.jmrit.timetable:TrainTimes", this._showTrainTimes);
        });
        this._twoPage = InstanceManager.getDefault(UserPreferencesManager.class).getSimplePreferenceState("jmri.jmrit.timetable:TwoPage");
        JCheckBoxMenuItem twoPage = new JCheckBoxMenuItem(Bundle.getMessage("MenuTwoPage"));
        twoPage.setSelected(this._twoPage);
        twoPage.addActionListener(event -> {
            this._twoPage = twoPage.isSelected();
            InstanceManager.getDefault(UserPreferencesManager.class).setSimplePreferenceState("jmri.jmrit.timetable:TwoPage", this._twoPage);
        });
        JMenuItem impsgn = new JMenuItem(Bundle.getMessage("MenuImportSgn"));
        impsgn.addActionListener(event -> this.importPressed());
        JMenuItem impcsv = new JMenuItem(Bundle.getMessage("MenuImportCsv"));
        impcsv.addActionListener(event -> this.importCsvPressed());
        JMenuItem impopr = new JMenuItem(Bundle.getMessage("MenuImportOperations"));
        impopr.addActionListener(event -> this.importFromOperationsPressed());
        JMenuItem expcsv = new JMenuItem(Bundle.getMessage("MenuExportCsv"));
        expcsv.addActionListener(event -> this.exportCsvPressed());
        JMenu ttMenu = new JMenu(Bundle.getMessage("MenuTimetable"));
        ttMenu.add(trainTime);
        ttMenu.addSeparator();
        ttMenu.add(twoPage);
        ttMenu.addSeparator();
        ttMenu.add(impsgn);
        ttMenu.add(impcsv);
        ttMenu.add(impopr);
        ttMenu.add(expcsv);
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(ttMenu);
        this.setJMenuBar(menuBar);
        this.addHelpMenu("html.tools.TimeTable", true);
    }

    void buildComponents() {
        this._editLayoutName = new JTextField(20);
        this._editScale = new JComboBox();
        this._editScale.addItemListener(this.layoutScaleItemEvent);
        this._editFastClock = new JTextField(5);
        this._editThrottles = new JTextField(5);
        this._editMetric = new JCheckBox();
        this._showScaleMK = new JLabel();
        this._editLayoutName.addFocusListener(this.detailFocusEvent);
        this._editScale.addFocusListener(this.detailFocusEvent);
        this._editFastClock.addFocusListener(this.detailFocusEvent);
        this._editThrottles.addFocusListener(this.detailFocusEvent);
        this._editMetric.addChangeListener(this.detailChangeEvent);
        this._editTrainTypeName = new JTextField(20);
        this._editTrainTypeColor = new JColorChooser(Color.BLACK);
        this._editTrainTypeColor.setPreviewPanel(new JPanel());
        AbstractColorChooserPanel[] editTypeColorPanels = new AbstractColorChooserPanel[]{new SplitButtonColorChooserPanel()};
        this._editTrainTypeColor.setChooserPanels(editTypeColorPanels);
        this._editTrainTypeName.addFocusListener(this.detailFocusEvent);
        this._editTrainTypeColor.getSelectionModel().addChangeListener(this.detailChangeEvent);
        this._editSegmentName = new JTextField(20);
        this._editSegmentName.addFocusListener(this.detailFocusEvent);
        this._editStationName = new JTextField(20);
        this._editDistance = new JTextField(5);
        this._editDoubleTrack = new JCheckBox();
        this._editSidings = new JSpinner(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this._editStaging = new JSpinner(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this._editStationName.addFocusListener(this.detailFocusEvent);
        this._editDistance.addFocusListener(this.detailFocusEvent);
        this._editDoubleTrack.addChangeListener(this.detailChangeEvent);
        this._editSidings.addChangeListener(this.detailChangeEvent);
        this._editStaging.addChangeListener(this.detailChangeEvent);
        this._editScheduleName = new JTextField(20);
        this._editEffDate = new JTextField(10);
        this._editStartHour = new JSpinner(new SpinnerNumberModel(0, 0, 23, 1));
        this._editDuration = new JSpinner(new SpinnerNumberModel(24, 1, 24, 1));
        this._editScheduleName.addFocusListener(this.detailFocusEvent);
        this._editEffDate.addFocusListener(this.detailFocusEvent);
        this._editStartHour.addChangeListener(this.detailChangeEvent);
        this._editDuration.addChangeListener(this.detailChangeEvent);
        this._editTrainName = new JTextField(10);
        this._editTrainDesc = new JTextField(20);
        this._editTrainType = new JComboBox();
        this._editDefaultSpeed = new JTextField(5);
        this._editTrainStartTime = new JTextField(5);
        this._editThrottle = new JSpinner(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this._editTrainNotes = new JTextArea(4, 30);
        this._showRouteDuration = new JLabel();
        this._editTrainName.addFocusListener(this.detailFocusEvent);
        this._editTrainDesc.addFocusListener(this.detailFocusEvent);
        this._editTrainType.addFocusListener(this.detailFocusEvent);
        this._editDefaultSpeed.addFocusListener(this.detailFocusEvent);
        this._editTrainStartTime.addFocusListener(this.detailFocusEvent);
        this._editThrottle.addChangeListener(this.detailChangeEvent);
        this._editTrainNotes.addFocusListener(this.detailFocusEvent);
        this._showStopSeq = new JLabel();
        this._editStopStation = new JComboBox();
        this._editStopDuration = new JTextField(5);
        this._editNextSpeed = new JTextField(5);
        this._editStagingTrack = new JSpinner(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this._editStopNotes = new JTextArea(4, 30);
        this._showArriveTime = new JLabel();
        this._showDepartTime = new JLabel();
        this._editStopStation.addFocusListener(this.detailFocusEvent);
        this._editStopStation.addItemListener(this.stopStationItemEvent);
        this._editStopDuration.addFocusListener(this.detailFocusEvent);
        this._editNextSpeed.addFocusListener(this.detailFocusEvent);
        this._editStagingTrack.addChangeListener(this.detailChangeEvent);
        this._editStopNotes.addFocusListener(this.detailFocusEvent);
    }

    void makeDetailGrid(String gridType) {
        this._detailGrid.setVisible(false);
        this._detailGrid.removeAll();
        this._detailFooter.setVisible(true);
        this._gridPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.ipadx = 5;
        switch (gridType) {
            case "EmptyGrid": {
                this.makeEmptyGrid(c);
                this._detailFooter.setVisible(false);
                break;
            }
            case "Layout": {
                this.makeLayoutGrid(c);
                break;
            }
            case "TrainType": {
                this.makeTrainTypeGrid(c);
                break;
            }
            case "Segment": {
                this.makeSegmentGrid(c);
                break;
            }
            case "Station": {
                this.makeStationGrid(c);
                break;
            }
            case "Schedule": {
                this.makeScheduleGrid(c);
                break;
            }
            case "Train": {
                this.makeTrainGrid(c);
                break;
            }
            case "Stop": {
                this.makeStopGrid(c);
                break;
            }
            default: {
                log.warn("Invalid grid type: '{}'", (Object)gridType);
                this.makeEmptyGrid(c);
            }
        }
        this._detailGrid.add(this._gridPanel);
        this._detailGrid.setVisible(true);
    }

    void makeEmptyGrid(GridBagConstraints c) {
        c.gridy = 0;
        c.gridx = 0;
        c.anchor = 10;
        JLabel rowLabel = new JLabel(Bundle.getMessage("LabelBlank"));
        this._gridPanel.add((Component)rowLabel, c);
    }

    void makeLayoutGrid(GridBagConstraints c) {
        this.makeGridLabel(0, "LabelLayoutName", "HintLayoutName", c);
        this._gridPanel.add((Component)this._editLayoutName, c);
        this.makeGridLabel(1, "LabelScale", "HintScale", c);
        this._gridPanel.add(this._editScale, c);
        this.makeGridLabel(2, "LabelFastClock", "HintFastClock", c);
        this._gridPanel.add((Component)this._editFastClock, c);
        this.makeGridLabel(3, "LabelThrottles", "HintThrottles", c);
        this._gridPanel.add((Component)this._editThrottles, c);
        this.makeGridLabel(4, "LabelMetric", "HintMetric", c);
        this._gridPanel.add((Component)this._editMetric, c);
        this.makeGridLabel(5, "LabelScaleMK", "HintScaleMK", c);
        this._gridPanel.add((Component)this._showScaleMK, c);
    }

    void makeTrainTypeGrid(GridBagConstraints c) {
        this.makeGridLabel(0, "LabelTrainTypeName", "HintTrainTypeName", c);
        this._gridPanel.add((Component)this._editTrainTypeName, c);
        this.makeGridLabel(1, "LabelTrainTypeColor", "HintTrainTypeColor", c);
        this._gridPanel.add((Component)this._editTrainTypeColor, c);
    }

    void makeSegmentGrid(GridBagConstraints c) {
        this.makeGridLabel(0, "LabelSegmentName", "HintSegmentName", c);
        this._gridPanel.add((Component)this._editSegmentName, c);
    }

    void makeStationGrid(GridBagConstraints c) {
        this.makeGridLabel(0, "LabelStationName", "HintStationName", c);
        this._gridPanel.add((Component)this._editStationName, c);
        this.makeGridLabel(1, "LabelDistance", "HintDistance", c);
        this._gridPanel.add((Component)this._editDistance, c);
        this.makeGridLabel(2, "LabelDoubleTrack", "HintDoubleTrack", c);
        this._gridPanel.add((Component)this._editDoubleTrack, c);
        this.makeGridLabel(3, "LabelSidings", "HintSidings", c);
        this._gridPanel.add((Component)this._editSidings, c);
        this.makeGridLabel(4, "LabelStaging", "HintStaging", c);
        this._gridPanel.add((Component)this._editStaging, c);
    }

    void makeScheduleGrid(GridBagConstraints c) {
        this.makeGridLabel(0, "LabelScheduleName", "HintScheduleName", c);
        this._gridPanel.add((Component)this._editScheduleName, c);
        this.makeGridLabel(1, "LabelEffDate", "HintEffDate", c);
        this._gridPanel.add((Component)this._editEffDate, c);
        this.makeGridLabel(2, "LabelStartHour", "HintStartHour", c);
        this._gridPanel.add((Component)this._editStartHour, c);
        this.makeGridLabel(3, "LabelDuration", "HintDuration", c);
        this._gridPanel.add((Component)this._editDuration, c);
    }

    void makeTrainGrid(GridBagConstraints c) {
        this.makeGridLabel(0, "LabelTrainName", "HintTrainName", c);
        this._gridPanel.add((Component)this._editTrainName, c);
        this.makeGridLabel(1, "LabelTrainDesc", "HintTrainDesc", c);
        this._gridPanel.add((Component)this._editTrainDesc, c);
        this.makeGridLabel(2, "LabelTrainType", "HintTrainType", c);
        this._gridPanel.add(this._editTrainType, c);
        this.makeGridLabel(3, "LabelDefaultSpeed", "HintDefaultSpeed", c);
        this._gridPanel.add((Component)this._editDefaultSpeed, c);
        this.makeGridLabel(4, "LabelTrainStartTime", "HintTrainStartTime", c);
        this._gridPanel.add((Component)this._editTrainStartTime, c);
        this.makeGridLabel(5, "LabelThrottle", "HintThrottle", c);
        this._gridPanel.add((Component)this._editThrottle, c);
        this.makeGridLabel(6, "LabelRouteDuration", "HintRouteDuration", c);
        this._gridPanel.add((Component)this._showRouteDuration, c);
        this.makeGridLabel(7, "LabelTrainNotes", "HintTrainNotes", c);
        this._gridPanel.add((Component)this._editTrainNotes, c);
    }

    void makeStopGrid(GridBagConstraints c) {
        this.makeGridLabel(0, "LabelStopSeq", "HintStopSeq", c);
        this._gridPanel.add((Component)this._showStopSeq, c);
        this.makeGridLabel(1, "LabelStopStation", "HintStopStation", c);
        this._gridPanel.add(this._editStopStation, c);
        this.makeGridLabel(2, "LabelStopDuration", "HintStopDuration", c);
        this._gridPanel.add((Component)this._editStopDuration, c);
        this.makeGridLabel(3, "LabelNextSpeed", "HintNextSpeed", c);
        this._gridPanel.add((Component)this._editNextSpeed, c);
        this.makeGridLabel(4, "LabelStagingTrack", "HintStagingTrack", c);
        this._gridPanel.add((Component)this._editStagingTrack, c);
        this.makeGridLabel(5, "LabelArriveTime", "HintArriveTime", c);
        this._gridPanel.add((Component)this._showArriveTime, c);
        this.makeGridLabel(6, "LabelDepartTime", "HintDepartTime", c);
        this._gridPanel.add((Component)this._showDepartTime, c);
        this.makeGridLabel(7, "LabelStopNotes", "HintStopNotes", c);
        this._gridPanel.add((Component)this._editStopNotes, c);
    }

    void makeGridLabel(int row, String label, String hint, GridBagConstraints c) {
        c.gridy = row;
        c.gridx = 0;
        c.anchor = 13;
        JLabel rowLabel = new JLabel(Bundle.getMessage(label));
        rowLabel.setToolTipText(Bundle.getMessage(hint));
        this._gridPanel.add((Component)rowLabel, c);
        c.gridx = 1;
        c.anchor = 17;
    }

    void addPressed() {
        switch (this._curNodeType) {
            case "Layout": {
                this.addLayout();
                break;
            }
            case "TrainTypes": {
                this.addTrainType();
                break;
            }
            case "Segments": {
                this.addSegment();
                break;
            }
            case "Segment": {
                this.addStation();
                break;
            }
            case "Schedules": {
                this.addSchedule();
                break;
            }
            case "Schedule": {
                this.addTrain();
                break;
            }
            case "Train": {
                this.addStop();
                break;
            }
            default: {
                log.error("Add called for unsupported node type: '{}'", (Object)this._curNodeType);
            }
        }
    }

    void addLayout() {
        Layout newLayout = new Layout();
        this.setShowReminder(true);
        this._curNode = new TimeTableTreeNode(newLayout.getLayoutName(), "Layout", newLayout.getLayoutId(), 0);
        this._timetableRoot.add(this._curNode);
        this._leafNode = new TimeTableTreeNode(this.buildNodeText("TrainTypes", null, 0), "TrainTypes", 0, 0);
        this._curNode.add(this._leafNode);
        this._leafNode = new TimeTableTreeNode(this.buildNodeText("Segments", null, 0), "Segments", 0, 0);
        this._curNode.add(this._leafNode);
        this._leafNode = new TimeTableTreeNode(this.buildNodeText("Schedules", null, 0), "Schedules", 0, 0);
        this._curNode.add(this._leafNode);
        this._timetableModel.nodeStructureChanged(this._timetableRoot);
        this._timetableTree.setSelectionPath(new TreePath(this._curNode.getPath()));
    }

    void addTrainType() {
        TimeTableTreeNode layoutNode = (TimeTableTreeNode)this._curNode.getParent();
        int layoutId = layoutNode.getId();
        TrainType newType = new TrainType(layoutId);
        this.setShowReminder(true);
        this._leafNode = new TimeTableTreeNode(newType.getTypeName(), "TrainType", newType.getTypeId(), 0);
        this._curNode.add(this._leafNode);
        this._timetableModel.nodeStructureChanged(this._curNode);
        this._timetableTree.setSelectionPath(new TreePath(this._leafNode.getPath()));
    }

    void addSegment() {
        TimeTableTreeNode layoutNode = (TimeTableTreeNode)this._curNode.getParent();
        int layoutId = layoutNode.getId();
        Segment newSegment = new Segment(layoutId);
        this.setShowReminder(true);
        this._leafNode = new TimeTableTreeNode(newSegment.getSegmentName(), "Segment", newSegment.getSegmentId(), 0);
        this._curNode.add(this._leafNode);
        this._timetableModel.nodeStructureChanged(this._curNode);
        this._timetableTree.setSelectionPath(new TreePath(this._leafNode.getPath()));
    }

    void addStation() {
        Station newStation = new Station(this._curNodeId);
        this.setShowReminder(true);
        this._leafNode = new TimeTableTreeNode(newStation.getStationName(), "Station", newStation.getStationId(), 0);
        this._curNode.add(this._leafNode);
        this._timetableModel.nodeStructureChanged(this._curNode);
        this._timetableTree.setSelectionPath(new TreePath(this._leafNode.getPath()));
    }

    void addSchedule() {
        TimeTableTreeNode layoutNode = (TimeTableTreeNode)this._curNode.getParent();
        int layoutId = layoutNode.getId();
        Schedule newSchedule = new Schedule(layoutId);
        this.setShowReminder(true);
        this._leafNode = new TimeTableTreeNode(newSchedule.getScheduleName(), "Schedule", newSchedule.getScheduleId(), 0);
        this._curNode.add(this._leafNode);
        this._timetableModel.nodeStructureChanged(this._curNode);
        this._timetableTree.setSelectionPath(new TreePath(this._leafNode.getPath()));
    }

    void addTrain() {
        Train newTrain = new Train(this._curNodeId);
        newTrain.setStartTime(this._dataMgr.getSchedule(this._curNodeId).getStartHour() * 60);
        this.setShowReminder(true);
        this._leafNode = new TimeTableTreeNode(newTrain.getTrainName(), "Train", newTrain.getTrainId(), 0);
        this._curNode.add(this._leafNode);
        this._timetableModel.nodeStructureChanged(this._curNode);
        this._timetableTree.setSelectionPath(new TreePath(this._leafNode.getPath()));
    }

    void addStop() {
        int newSeq = this._dataMgr.getStops(this._curNodeId, 0, false).size();
        Stop newStop = new Stop(this._curNodeId, newSeq + 1);
        this.setShowReminder(true);
        this._leafNode = new TimeTableTreeNode(String.valueOf(newSeq + 1), "Stop", newStop.getStopId(), newSeq + 1);
        this._curNode.add(this._leafNode);
        this._timetableModel.nodeStructureChanged(this._curNode);
        this._timetableTree.setSelectionPath(new TreePath(this._leafNode.getPath()));
    }

    void editPressed() {
        switch (this._curNodeType) {
            case "Layout": {
                this.editLayout();
                this.makeDetailGrid("Layout");
                break;
            }
            case "TrainType": {
                this.editTrainType();
                this.makeDetailGrid("TrainType");
                break;
            }
            case "Segment": {
                this.editSegment();
                this.makeDetailGrid("Segment");
                break;
            }
            case "Station": {
                this.editStation();
                this.makeDetailGrid("Station");
                break;
            }
            case "Schedule": {
                this.editSchedule();
                this.makeDetailGrid("Schedule");
                break;
            }
            case "Train": {
                this.editTrain();
                this.makeDetailGrid("Train");
                break;
            }
            case "Stop": {
                this.editStop();
                this.makeDetailGrid("Stop");
                break;
            }
            default: {
                log.error("Edit called for unsupported node type: '{}'", (Object)this._curNodeType);
            }
        }
        this.setEditMode(false);
    }

    void editLayout() {
        Layout layout = this._dataMgr.getLayout(this._curNodeId);
        this._editLayoutName.setText(layout.getLayoutName());
        this._editFastClock.setText(Integer.toString(layout.getFastClock()));
        this._editThrottles.setText(Integer.toString(layout.getThrottles()));
        this._editMetric.setSelected(layout.getMetric());
        String unitMeasure = layout.getMetric() ? Bundle.getMessage("LabelRealMeters") : Bundle.getMessage("LabelRealFeet");
        this._showScaleMK.setText(String.format("%.2f %s", layout.getScaleMK(), unitMeasure));
        this._editScale.removeAllItems();
        for (Scale scale : ScaleManager.getScales()) {
            this._editScale.addItem(scale);
        }
        JComboBoxUtil.setupComboBoxMaxRows(this._editScale);
        this._editScale.setSelectedItem(layout.getScale());
    }

    void editTrainType() {
        TrainType type = this._dataMgr.getTrainType(this._curNodeId);
        this._editTrainTypeName.setText(type.getTypeName());
        this._editTrainTypeColor.setColor(Color.decode(type.getTypeColor()));
    }

    void editSegment() {
        Segment segment = this._dataMgr.getSegment(this._curNodeId);
        this._editSegmentName.setText(segment.getSegmentName());
    }

    void editStation() {
        Station station = this._dataMgr.getStation(this._curNodeId);
        this._editStationName.setText(station.getStationName());
        this._editDistance.setText(NumberFormat.getNumberInstance().format(station.getDistance()));
        this._editDoubleTrack.setSelected(station.getDoubleTrack());
        this._editSidings.setValue(station.getSidings());
        this._editStaging.setValue(station.getStaging());
    }

    void editSchedule() {
        Schedule schedule = this._dataMgr.getSchedule(this._curNodeId);
        this._editScheduleName.setText(schedule.getScheduleName());
        this._editEffDate.setText(schedule.getEffDate());
        this._editStartHour.setValue(schedule.getStartHour());
        this._editDuration.setValue(schedule.getDuration());
    }

    void editTrain() {
        Train train = this._dataMgr.getTrain(this._curNodeId);
        int layoutId = this._dataMgr.getSchedule(train.getScheduleId()).getLayoutId();
        this._editTrainName.setText(train.getTrainName());
        this._editTrainDesc.setText(train.getTrainDesc());
        this._editDefaultSpeed.setText(Integer.toString(train.getDefaultSpeed()));
        this._editTrainStartTime.setText(String.format("%02d:%02d", train.getStartTime() / 60, train.getStartTime() % 60));
        this._editThrottle.setModel(new SpinnerNumberModel(train.getThrottle(), 0, this._dataMgr.getLayout(layoutId).getThrottles(), 1));
        this._editTrainNotes.setText(train.getTrainNotes());
        this._showRouteDuration.setText(String.format("%02d:%02d", train.getRouteDuration() / 60, train.getRouteDuration() % 60));
        this._editTrainType.removeAllItems();
        for (TrainType type : this._dataMgr.getTrainTypes(layoutId, true)) {
            this._editTrainType.addItem(type);
        }
        JComboBoxUtil.setupComboBoxMaxRows(this._editTrainType);
        if (train.getTypeId() > 0) {
            this._editTrainType.setSelectedItem(this._dataMgr.getTrainType(train.getTypeId()));
        }
    }

    void editStop() {
        Stop stop = this._dataMgr.getStop(this._curNodeId);
        Layout layout = this._dataMgr.getLayoutForStop(this._curNodeId);
        this._showStopSeq.setText(Integer.toString(stop.getSeq()));
        this._editStopDuration.setText(Integer.toString(stop.getDuration()));
        this._editNextSpeed.setText(Integer.toString(stop.getNextSpeed()));
        this._editStopNotes.setText(stop.getStopNotes());
        this._showArriveTime.setText(String.format("%02d:%02d", stop.getArriveTime() / 60, stop.getArriveTime() % 60));
        this._showDepartTime.setText(String.format("%02d:%02d", stop.getDepartTime() / 60, stop.getDepartTime() % 60));
        this._editStopStation.removeAllItems();
        for (TimeTableDataManager.SegmentStation segmentStation : this._dataMgr.getSegmentStations(layout.getLayoutId())) {
            this._editStopStation.addItem(segmentStation);
            if (stop.getStationId() != segmentStation.getStationId()) continue;
            this._editStopStation.setSelectedItem(segmentStation);
        }
        JComboBoxUtil.setupComboBoxMaxRows(this._editStopStation);
        this.setMoveButtons();
    }

    void updatePressed() {
        switch (this._curNodeType) {
            case "Layout": {
                this.updateLayout();
                break;
            }
            case "TrainType": {
                this.updateTrainType();
                break;
            }
            case "Segment": {
                this.updateSegment();
                break;
            }
            case "Station": {
                this.updateStation();
                break;
            }
            case "Schedule": {
                this.updateSchedule();
                break;
            }
            case "Train": {
                this.updateTrain();
                break;
            }
            case "Stop": {
                this.updateStop();
                break;
            }
            default: {
                log.warn("Invalid update button press");
            }
        }
        this.setEditMode(false);
        this._timetableTree.setSelectionPath(this._curTreePath);
        this._timetableTree.grabFocus();
        this.editPressed();
    }

    void updateLayout() {
        int newThrottles;
        Layout layout = this._dataMgr.getLayout(this._curNodeId);
        String newName = this._editLayoutName.getText().trim();
        Scale newScale = (Scale)this._editScale.getSelectedItem();
        int newFastClock = this.parseNumber(this._editFastClock, "fast clock");
        if (newFastClock < 1) {
            newFastClock = layout.getFastClock();
        }
        if ((newThrottles = this.parseNumber(this._editThrottles, "throttles")) < 0) {
            newThrottles = layout.getThrottles();
        }
        boolean newMetric = this._editMetric.isSelected();
        boolean update = false;
        ArrayList<String> exceptionList = new ArrayList<String>();
        if (!layout.getLayoutName().equals(newName)) {
            layout.setLayoutName(newName);
            this._curNode.setText(newName);
            this._timetableModel.nodeChanged(this._curNode);
            update = true;
        }
        if (!layout.getScale().equals(newScale)) {
            try {
                layout.setScale(newScale);
                update = true;
            }
            catch (IllegalArgumentException ex) {
                exceptionList.add(ex.getMessage());
            }
        }
        if (layout.getFastClock() != newFastClock) {
            try {
                layout.setFastClock(newFastClock);
                update = true;
            }
            catch (IllegalArgumentException ex) {
                exceptionList.add(ex.getMessage());
            }
        }
        if (layout.getMetric() != newMetric) {
            try {
                layout.setMetric(newMetric);
                update = true;
            }
            catch (IllegalArgumentException ex) {
                exceptionList.add(ex.getMessage());
            }
        }
        if (layout.getThrottles() != newThrottles) {
            try {
                layout.setThrottles(newThrottles);
                update = true;
            }
            catch (IllegalArgumentException ex) {
                exceptionList.add(ex.getMessage());
            }
        }
        if (update) {
            this.setShowReminder(true);
        }
        if (!exceptionList.isEmpty()) {
            StringBuilder msg = new StringBuilder(Bundle.getMessage("LayoutUpdateErrors"));
            for (String keyWord : exceptionList) {
                if (keyWord.startsWith("TimeOutOfRange")) {
                    String[] comps = keyWord.split("~");
                    msg.append(Bundle.getMessage(comps[0], comps[1], comps[2]));
                    continue;
                }
                if (keyWord.startsWith("ScaleNotFound")) {
                    String[] scaleMsg = keyWord.split("~");
                    msg.append(Bundle.getMessage(scaleMsg[0], scaleMsg[1]));
                    continue;
                }
                msg.append(String.format("%n%s", Bundle.getMessage(keyWord)));
                if (!keyWord.equals("ThrottlesInUse")) continue;
                for (Schedule schedule : this._dataMgr.getSchedules(this._curNodeId, true)) {
                    for (Train train : this._dataMgr.getTrains(schedule.getScheduleId(), 0, true)) {
                        if (train.getThrottle() <= newThrottles) continue;
                        msg.append(String.format("%n      %s [ %d ]", train.getTrainName(), train.getThrottle()));
                    }
                }
            }
            JOptionPane.showMessageDialog(null, msg.toString(), Bundle.getMessage("WarningTitle"), 2);
        }
    }

    void updateTrainType() {
        TrainType type = this._dataMgr.getTrainType(this._curNodeId);
        String newName = this._editTrainTypeName.getText().trim();
        Color newColor = this._editTrainTypeColor.getColor();
        String newColorHex = ColorUtil.colorToHexString(newColor);
        boolean update = false;
        if (!type.getTypeName().equals(newName)) {
            type.setTypeName(newName);
            this._curNode.setText(newName);
            update = true;
        }
        if (!type.getTypeColor().equals(newColorHex)) {
            type.setTypeColor(newColorHex);
            update = true;
        }
        this._timetableModel.nodeChanged(this._curNode);
        if (update) {
            this.setShowReminder(true);
        }
    }

    void updateSegment() {
        String newName = this._editSegmentName.getText().trim();
        Segment segment = this._dataMgr.getSegment(this._curNodeId);
        if (!segment.getSegmentName().equals(newName)) {
            segment.setSegmentName(newName);
            this._curNode.setText(newName);
            this.setShowReminder(true);
        }
        this._timetableModel.nodeChanged(this._curNode);
    }

    void updateStation() {
        double newDistance;
        Station station = this._dataMgr.getStation(this._curNodeId);
        String newName = this._editStationName.getText().trim();
        try {
            newDistance = NumberFormat.getNumberInstance().parse(this._editDistance.getText()).floatValue();
        }
        catch (NumberFormatException | ParseException exception) {
            log.warn("'{}' is not a valid number for {}", (Object)this._editDistance.getText(), (Object)"station distance");
            JOptionPane.showMessageDialog(null, Bundle.getMessage("NumberFormatError", this._editDistance.getText(), "station distance"), Bundle.getMessage("WarningTitle"), 2);
            newDistance = station.getDistance();
        }
        boolean newDoubleTrack = this._editDoubleTrack.isSelected();
        int newSidings = (Integer)this._editSidings.getValue();
        int newStaging = (Integer)this._editStaging.getValue();
        boolean update = false;
        ArrayList<String> exceptionList = new ArrayList<String>();
        if (!station.getStationName().equals(newName)) {
            station.setStationName(newName);
            this._curNode.setText(newName);
            this._timetableModel.nodeChanged(this._curNode);
            update = true;
        }
        if (newDistance < 0.0) {
            newDistance = station.getDistance();
        }
        if (Math.abs(station.getDistance() - newDistance) > 0.01) {
            try {
                station.setDistance(newDistance);
                update = true;
            }
            catch (IllegalArgumentException ex) {
                exceptionList.add(ex.getMessage());
            }
        }
        if (station.getDoubleTrack() != newDoubleTrack) {
            station.setDoubleTrack(newDoubleTrack);
            update = true;
        }
        if (station.getSidings() != newSidings) {
            station.setSidings(newSidings);
            update = true;
        }
        if (station.getStaging() != newStaging) {
            try {
                station.setStaging(newStaging);
                update = true;
            }
            catch (IllegalArgumentException ex) {
                exceptionList.add(ex.getMessage());
            }
        }
        if (update) {
            this.setShowReminder(true);
        }
        if (!exceptionList.isEmpty()) {
            StringBuilder msg = new StringBuilder(Bundle.getMessage("StationUpdateErrors"));
            for (String keyWord : exceptionList) {
                if (keyWord.startsWith("TimeOutOfRange")) {
                    String[] comps = keyWord.split("~");
                    msg.append(Bundle.getMessage(comps[0], comps[1], comps[2]));
                    continue;
                }
                msg.append(String.format("%n%s", Bundle.getMessage(keyWord)));
                if (!keyWord.equals("StagingInUse")) continue;
                for (Stop stop : this._dataMgr.getStops(0, this._curNodeId, false)) {
                    if (stop.getStagingTrack() <= newStaging) continue;
                    Train train = this._dataMgr.getTrain(stop.getTrainId());
                    msg.append(String.format("%n      %s, %d", train.getTrainName(), stop.getSeq()));
                }
            }
            JOptionPane.showMessageDialog(null, msg.toString(), Bundle.getMessage("WarningTitle"), 2);
        }
    }

    void updateSchedule() {
        int newDuration;
        Schedule schedule = this._dataMgr.getSchedule(this._curNodeId);
        String newName = this._editScheduleName.getText().trim();
        String newEffDate = this._editEffDate.getText().trim();
        int newStartHour = (Integer)this._editStartHour.getValue();
        if (newStartHour < 0 || newStartHour > 23) {
            newStartHour = schedule.getStartHour();
        }
        if ((newDuration = ((Integer)this._editDuration.getValue()).intValue()) < 1 || newDuration > 24) {
            newDuration = schedule.getDuration();
        }
        boolean update = false;
        ArrayList<String> exceptionList = new ArrayList<String>();
        if (!schedule.getScheduleName().equals(newName)) {
            schedule.setScheduleName(newName);
            update = true;
        }
        if (!schedule.getEffDate().equals(newEffDate)) {
            schedule.setEffDate(newEffDate);
            update = true;
        }
        if (update) {
            this._curNode.setText(this.buildNodeText("Schedule", schedule, 0));
            this._timetableModel.nodeChanged(this._curNode);
        }
        if (schedule.getStartHour() != newStartHour) {
            try {
                schedule.setStartHour(newStartHour);
                update = true;
            }
            catch (IllegalArgumentException ex) {
                exceptionList.add(ex.getMessage());
            }
        }
        if (schedule.getDuration() != newDuration) {
            try {
                schedule.setDuration(newDuration);
                update = true;
            }
            catch (IllegalArgumentException ex) {
                exceptionList.add(ex.getMessage());
            }
        }
        if (update) {
            this.setShowReminder(true);
        }
        if (!exceptionList.isEmpty()) {
            StringBuilder msg = new StringBuilder(Bundle.getMessage("ScheduleUpdateErrors"));
            for (String keyWord : exceptionList) {
                if (keyWord.startsWith("TimeOutOfRange")) {
                    String[] comps = keyWord.split("~");
                    msg.append(Bundle.getMessage(comps[0], comps[1], comps[2]));
                    continue;
                }
                msg.append(String.format("%n%s", Bundle.getMessage(keyWord)));
            }
            JOptionPane.showMessageDialog(null, msg.toString(), Bundle.getMessage("WarningTitle"), 2);
        }
    }

    void updateTrain() {
        int newStart;
        Train train = this._dataMgr.getTrain(this._curNodeId);
        ArrayList<String> exceptionList = new ArrayList<String>();
        String newName = this._editTrainName.getText().trim();
        String newDesc = this._editTrainDesc.getText().trim();
        int newType = ((TrainType)this._editTrainType.getSelectedItem()).getTypeId();
        int newSpeed = this.parseNumber(this._editDefaultSpeed, "default train speed");
        if (newSpeed < 0) {
            newSpeed = train.getDefaultSpeed();
        }
        try {
            LocalTime newTime = LocalTime.parse(this._editTrainStartTime.getText().trim(), DateTimeFormatter.ofPattern("H:mm"));
            newStart = newTime.getHour() * 60 + newTime.getMinute();
        }
        catch (DateTimeParseException ex) {
            exceptionList.add("StartTimeFormat~" + ex.getParsedString());
            newStart = train.getStartTime();
        }
        int newThrottle = (Integer)this._editThrottle.getValue();
        String newNotes = this._editTrainNotes.getText();
        boolean update = false;
        if (!train.getTrainName().equals(newName)) {
            train.setTrainName(newName);
            update = true;
        }
        if (!train.getTrainDesc().equals(newDesc)) {
            train.setTrainDesc(newDesc);
            update = true;
        }
        if (update) {
            this._curNode.setText(this.buildNodeText("Train", train, 0));
            this._timetableModel.nodeChanged(this._curNode);
        }
        if (train.getTypeId() != newType) {
            train.setTypeId(newType);
            update = true;
        }
        if (train.getDefaultSpeed() != newSpeed) {
            try {
                train.setDefaultSpeed(newSpeed);
                update = true;
            }
            catch (IllegalArgumentException ex) {
                exceptionList.add(ex.getMessage());
            }
        }
        if (train.getStartTime() != newStart) {
            try {
                train.setStartTime(newStart);
                update = true;
            }
            catch (IllegalArgumentException ex) {
                exceptionList.add(ex.getMessage());
            }
        }
        if (train.getThrottle() != newThrottle) {
            try {
                train.setThrottle(newThrottle);
                update = true;
            }
            catch (IllegalArgumentException ex) {
                exceptionList.add(ex.getMessage());
            }
        }
        if (!train.getTrainNotes().equals(newNotes)) {
            train.setTrainNotes(newNotes);
            update = true;
        }
        if (update) {
            this.setShowReminder(true);
        }
        if (!exceptionList.isEmpty()) {
            StringBuilder msg = new StringBuilder(Bundle.getMessage("TrainUpdateErrors"));
            for (String keyWord : exceptionList) {
                log.info("kw = {}", (Object)keyWord);
                if (keyWord.startsWith("TimeOutOfRange")) {
                    String[] comps = keyWord.split("~");
                    msg.append(Bundle.getMessage(comps[0], comps[1], comps[2]));
                    continue;
                }
                if (keyWord.startsWith("StartTimeFormat")) {
                    String[] timeMsg = keyWord.split("~");
                    msg.append(Bundle.getMessage(timeMsg[0], timeMsg[1]));
                    continue;
                }
                if (keyWord.startsWith("StartTimeRange")) {
                    String[] schedMsg = keyWord.split("~");
                    msg.append(Bundle.getMessage(schedMsg[0], schedMsg[1], schedMsg[2]));
                    continue;
                }
                msg.append(String.format("%n%s", Bundle.getMessage(keyWord)));
            }
            JOptionPane.showMessageDialog(null, msg.toString(), Bundle.getMessage("WarningTitle"), 2);
        }
    }

    void updateStop() {
        int newSpeed;
        Stop stop = this._dataMgr.getStop(this._curNodeId);
        TimeTableDataManager.SegmentStation stopSegmentStation = (TimeTableDataManager.SegmentStation)this._editStopStation.getSelectedItem();
        int newStation = stopSegmentStation.getStationId();
        int newDuration = this.parseNumber(this._editStopDuration, "stop duration");
        if (newDuration < 0) {
            newDuration = stop.getDuration();
        }
        if ((newSpeed = this.parseNumber(this._editNextSpeed, "next speed")) < 0) {
            newSpeed = stop.getNextSpeed();
        }
        int newStagingTrack = (Integer)this._editStagingTrack.getValue();
        String newNotes = this._editStopNotes.getText();
        boolean update = false;
        ArrayList<String> exceptionList = new ArrayList<String>();
        if (stop.getStationId() != newStation) {
            stop.setStationId(newStation);
            this._curNode.setText(this.buildNodeText("Stop", stop, 0));
            this._timetableModel.nodeChanged(this._curNode);
            update = true;
        }
        if (stop.getDuration() != newDuration) {
            try {
                stop.setDuration(newDuration);
                update = true;
            }
            catch (IllegalArgumentException ex) {
                exceptionList.add(ex.getMessage());
            }
        }
        if (stop.getNextSpeed() != newSpeed) {
            try {
                stop.setNextSpeed(newSpeed);
                update = true;
            }
            catch (IllegalArgumentException ex) {
                exceptionList.add(ex.getMessage());
            }
        }
        if (stop.getStagingTrack() != newStagingTrack) {
            try {
                stop.setStagingTrack(newStagingTrack);
                update = true;
            }
            catch (IllegalArgumentException ex) {
                exceptionList.add(ex.getMessage());
            }
        }
        if (!stop.getStopNotes().equals(newNotes)) {
            stop.setStopNotes(newNotes);
            update = true;
        }
        if (update) {
            this.setShowReminder(true);
        }
        if (!exceptionList.isEmpty()) {
            StringBuilder msg = new StringBuilder(Bundle.getMessage("StopUpdateErrors"));
            for (String keyWord : exceptionList) {
                if (keyWord.startsWith("TimeOutOfRange")) {
                    String[] comps = keyWord.split("~");
                    msg.append(Bundle.getMessage(comps[0], comps[1], comps[2]));
                    continue;
                }
                msg.append(String.format("%n%s", Bundle.getMessage(keyWord)));
            }
            JOptionPane.showMessageDialog(null, msg.toString(), Bundle.getMessage("WarningTitle"), 2);
        }
    }

    int parseNumber(JTextField textField, String fieldName) {
        String text = textField.getText().trim();
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException numberFormatException) {
            log.warn("'{}' is not a valid number for {}", (Object)text, (Object)fieldName);
            JOptionPane.showMessageDialog(null, Bundle.getMessage("NumberFormatError", text, fieldName), Bundle.getMessage("WarningTitle"), 2);
            return -1;
        }
    }

    void deletePressed() {
        switch (this._curNodeType) {
            case "Layout": {
                this.deleteLayout();
                break;
            }
            case "TrainType": {
                this.deleteTrainType();
                break;
            }
            case "Segment": {
                this.deleteSegment();
                break;
            }
            case "Station": {
                this.deleteStation();
                break;
            }
            case "Schedule": {
                this.deleteSchedule();
                break;
            }
            case "Train": {
                this.deleteTrain();
                break;
            }
            case "Stop": {
                this.deleteStop();
                break;
            }
            default: {
                log.error("Delete called for unsupported node type: '{}'", (Object)this._curNodeType);
            }
        }
    }

    void deleteLayout() {
        Object[] options = new Object[]{Bundle.getMessage("ButtonNo"), Bundle.getMessage("ButtonYes")};
        int selectedOption = JOptionPane.showOptionDialog(null, Bundle.getMessage("LayoutCascade"), Bundle.getMessage("QuestionTitle"), -1, 3, null, options, options[0]);
        if (selectedOption == 0) {
            return;
        }
        for (Schedule schedule : this._dataMgr.getSchedules(this._curNodeId, false)) {
            for (Train train : this._dataMgr.getTrains(schedule.getScheduleId(), 0, false)) {
                for (Stop stop : this._dataMgr.getStops(train.getTrainId(), 0, false)) {
                    this._dataMgr.deleteStop(stop.getStopId());
                }
                this._dataMgr.deleteTrain(train.getTrainId());
            }
            this._dataMgr.deleteSchedule(schedule.getScheduleId());
        }
        for (Segment segment : this._dataMgr.getSegments(this._curNodeId, false)) {
            for (Station station : this._dataMgr.getStations(segment.getSegmentId(), false)) {
                this._dataMgr.deleteStation(station.getStationId());
            }
            this._dataMgr.deleteSegment(segment.getSegmentId());
        }
        for (TrainType type : this._dataMgr.getTrainTypes(this._curNodeId, false)) {
            this._dataMgr.deleteTrainType(type.getTypeId());
        }
        this._dataMgr.deleteLayout(this._curNodeId);
        this.setShowReminder(true);
        TreeNode parentNode = this._curNode.getParent();
        this._curNode.removeFromParent();
        this._curNode = null;
        this._timetableModel.nodeStructureChanged(parentNode);
    }

    void deleteTrainType() {
        ArrayList<String> typeReference = new ArrayList<String>();
        for (Train train : this._dataMgr.getTrains(0, this._curNodeId, true)) {
            typeReference.add(train.getTrainName());
        }
        if (!typeReference.isEmpty()) {
            StringBuilder msg = new StringBuilder(Bundle.getMessage("DeleteWarning", this._curNodeType));
            for (String trainName : typeReference) {
                msg.append("\n    " + trainName);
            }
            JOptionPane.showMessageDialog(null, msg.toString(), Bundle.getMessage("WarningTitle"), 2);
            return;
        }
        this._dataMgr.deleteTrainType(this._curNodeId);
        this.setShowReminder(true);
        TreePath parentPath = this._curTreePath.getParentPath();
        TimeTableTreeNode parentNode = (TimeTableTreeNode)this._curNode.getParent();
        parentNode.remove(this._curNode);
        this._timetableModel.nodeStructureChanged(parentNode);
        this._curNode = null;
        this._timetableTree.setSelectionPath(parentPath);
    }

    void deleteSegment() {
        ArrayList<Station> stationList = new ArrayList<Station>(this._dataMgr.getStations(this._curNodeId, true));
        if (!stationList.isEmpty()) {
            ArrayList<Station> activeList = new ArrayList<Station>();
            for (Station checkActive : stationList) {
                ArrayList<Stop> stopList = new ArrayList<Stop>(this._dataMgr.getStops(0, checkActive.getStationId(), true));
                if (stopList.isEmpty()) continue;
                activeList.add(checkActive);
            }
            if (!activeList.isEmpty()) {
                StringBuilder msg = new StringBuilder(Bundle.getMessage("DeleteWarning", this._curNodeType));
                for (Station activeStation : activeList) {
                    msg.append("\n    " + activeStation.getStationName());
                }
                JOptionPane.showMessageDialog(null, msg.toString(), Bundle.getMessage("WarningTitle"), 2);
                return;
            }
            Object[] options = new Object[]{Bundle.getMessage("ButtonNo"), Bundle.getMessage("ButtonYes")};
            int selectedOption = JOptionPane.showOptionDialog(null, Bundle.getMessage("SegmentCascade"), Bundle.getMessage("QuestionTitle"), -1, 3, null, options, options[0]);
            if (selectedOption == 0) {
                return;
            }
            for (Station delStation : stationList) {
                this._dataMgr.deleteStation(delStation.getStationId());
            }
        }
        this._dataMgr.deleteSegment(this._curNodeId);
        this.setShowReminder(true);
        TreePath parentPath = this._curTreePath.getParentPath();
        TimeTableTreeNode parentNode = (TimeTableTreeNode)this._curNode.getParent();
        this._curNode.removeFromParent();
        this._curNode = null;
        this._timetableModel.nodeStructureChanged(parentNode);
        this._timetableTree.setSelectionPath(parentPath);
    }

    void deleteStation() {
        ArrayList<String> stopReference = new ArrayList<String>();
        for (Stop stop : this._dataMgr.getStops(0, this._curNodeId, true)) {
            Train train = this._dataMgr.getTrain(stop.getTrainId());
            String trainSeq = String.format("%s : %d", train.getTrainName(), stop.getSeq());
            stopReference.add(trainSeq);
        }
        if (!stopReference.isEmpty()) {
            StringBuilder msg = new StringBuilder(Bundle.getMessage("DeleteWarning", this._curNodeType));
            for (String stopTrainSeq : stopReference) {
                msg.append("\n    " + stopTrainSeq);
            }
            JOptionPane.showMessageDialog(null, msg.toString(), Bundle.getMessage("WarningTitle"), 2);
            return;
        }
        this._dataMgr.deleteStation(this._curNodeId);
        this.setShowReminder(true);
        TreePath parentPath = this._curTreePath.getParentPath();
        TimeTableTreeNode parentNode = (TimeTableTreeNode)this._curNode.getParent();
        parentNode.remove(this._curNode);
        this._timetableModel.nodeStructureChanged(parentNode);
        this._curNode = null;
        this._timetableTree.setSelectionPath(parentPath);
    }

    void deleteSchedule() {
        ArrayList<Train> trainList = new ArrayList<Train>(this._dataMgr.getTrains(this._curNodeId, 0, true));
        if (!trainList.isEmpty()) {
            Object[] options = new Object[]{Bundle.getMessage("ButtonNo"), Bundle.getMessage("ButtonYes")};
            int selectedOption = JOptionPane.showOptionDialog(null, Bundle.getMessage("ScheduleCascade"), Bundle.getMessage("QuestionTitle"), -1, 3, null, options, options[0]);
            if (selectedOption == 0) {
                return;
            }
            for (Train train : trainList) {
                for (Stop stop : this._dataMgr.getStops(train.getTrainId(), 0, false)) {
                    this._dataMgr.deleteStop(stop.getStopId());
                }
                this._dataMgr.deleteTrain(train.getTrainId());
            }
        }
        this._dataMgr.deleteSchedule(this._curNodeId);
        this.setShowReminder(true);
        TreePath parentPath = this._curTreePath.getParentPath();
        TimeTableTreeNode parentNode = (TimeTableTreeNode)this._curNode.getParent();
        this._curNode.removeFromParent();
        this._curNode = null;
        this._timetableModel.nodeStructureChanged(parentNode);
        this._timetableTree.setSelectionPath(parentPath);
    }

    void deleteTrain() {
        ArrayList<Stop> stopList = new ArrayList<Stop>(this._dataMgr.getStops(this._curNodeId, 0, true));
        if (!stopList.isEmpty()) {
            Object[] options = new Object[]{Bundle.getMessage("ButtonNo"), Bundle.getMessage("ButtonYes")};
            int selectedOption = JOptionPane.showOptionDialog(null, Bundle.getMessage("TrainCascade"), Bundle.getMessage("QuestionTitle"), -1, 3, null, options, options[0]);
            if (selectedOption == 0) {
                return;
            }
            for (Stop stop : stopList) {
                this._dataMgr.deleteStop(stop.getStopId());
            }
        }
        this._dataMgr.deleteTrain(this._curNodeId);
        this.setShowReminder(true);
        TreePath parentPath = this._curTreePath.getParentPath();
        TimeTableTreeNode parentNode = (TimeTableTreeNode)this._curNode.getParent();
        this._curNode.removeFromParent();
        this._curNode = null;
        this._timetableModel.nodeStructureChanged(parentNode);
        this._timetableTree.setSelectionPath(parentPath);
    }

    void deleteStop() {
        this._dataMgr.deleteStop(this._curNodeId);
        this.setShowReminder(true);
        TreePath parentPath = this._curTreePath.getParentPath();
        TimeTableTreeNode parentNode = (TimeTableTreeNode)this._curNode.getParent();
        this._curNode.removeFromParent();
        this._curNode = null;
        this._timetableModel.nodeStructureChanged(parentNode);
        this._timetableTree.setSelectionPath(parentPath);
    }

    void cancelPressed() {
        this.setEditMode(false);
        this._timetableTree.setSelectionPath(this._curTreePath);
        this._timetableTree.grabFocus();
    }

    void upPressed() {
        this.setShowReminder(true);
        DefaultMutableTreeNode prevNode = this._curNode.getPreviousSibling();
        if (!(prevNode instanceof TimeTableTreeNode)) {
            log.warn("At first node, cannot move up");
            return;
        }
        int prevStopId = ((TimeTableTreeNode)prevNode).getId();
        Stop prevStop = this._dataMgr.getStop(prevStopId);
        prevStop.setSeq(prevStop.getSeq() + 1);
        Stop currStop = this._dataMgr.getStop(this._curNodeId);
        currStop.setSeq(currStop.getSeq() - 1);
        this.moveTreeNode("Up");
    }

    void downPressed() {
        this.setShowReminder(true);
        DefaultMutableTreeNode nextNode = this._curNode.getNextSibling();
        if (!(nextNode instanceof TimeTableTreeNode)) {
            log.warn("At last node, cannot move down");
            return;
        }
        int nextStopId = ((TimeTableTreeNode)nextNode).getId();
        Stop nextStop = this._dataMgr.getStop(nextStopId);
        nextStop.setSeq(nextStop.getSeq() - 1);
        Stop currStop = this._dataMgr.getStop(this._curNodeId);
        currStop.setSeq(currStop.getSeq() + 1);
        this.moveTreeNode("Down");
    }

    void moveTreeNode(String direction) {
        DefaultMutableTreeNode siblingNode;
        this._curNodeRow = direction.equals("Up") ? --this._curNodeRow : ++this._curNodeRow;
        this._curNode.setRow(this._curNodeRow);
        this._timetableModel.nodeChanged(this._curNode);
        if (direction.equals("Up")) {
            siblingNode = this._curNode.getPreviousSibling();
            if (siblingNode instanceof TimeTableTreeNode) {
                TimeTableTreeNode tempNode = (TimeTableTreeNode)siblingNode;
                tempNode.setRow(tempNode.getRow() + 1);
            }
        } else {
            siblingNode = this._curNode.getNextSibling();
            if (siblingNode instanceof TimeTableTreeNode) {
                TimeTableTreeNode tempNode = (TimeTableTreeNode)siblingNode;
                tempNode.setRow(tempNode.getRow() - 1);
            }
        }
        this._timetableModel.nodeChanged(siblingNode);
        TimeTableTreeNode parentNode = (TimeTableTreeNode)this._curNode.getParent();
        parentNode.insert(this._curNode, this._curNodeRow - 1);
        this._timetableModel.nodeStructureChanged(parentNode);
        this._timetableTree.setSelectionPath(new TreePath(this._curNode.getPath()));
        this.setMoveButtons();
        this._dataMgr.calculateTrain(this._dataMgr.getStop(this._curNodeId).getTrainId(), true);
    }

    void setMoveButtons() {
        if (this._curNode == null) {
            return;
        }
        Component[] compList = this._moveButtonPanel.getComponents();
        JButton up = (JButton)compList[1];
        JButton down = (JButton)compList[3];
        up.setEnabled(true);
        down.setEnabled(true);
        int rows = this._curNode.getSiblingCount();
        if (this._curNodeRow < 2) {
            up.setEnabled(false);
        }
        if (this._curNodeRow > rows - 1) {
            down.setEnabled(false);
        }
        if (this._editActive) {
            up.setEnabled(false);
            down.setEnabled(false);
        }
        this._moveButtonPanel.setVisible(true);
    }

    void graphPressed(String graphType) {
        Segment segment = this._dataMgr.getSegment(this._curNodeId);
        Layout layout = this._dataMgr.getLayout(segment.getLayoutId());
        List<Schedule> schedules = this._dataMgr.getSchedules(layout.getLayoutId(), true);
        if (schedules.size() == 0) {
            log.warn("no schedule");
            return;
        }
        int scheduleId = schedules.get(0).getScheduleId();
        if (schedules.size() > 1) {
            Object[] schedArr = new Schedule[schedules.size()];
            schedArr = schedules.toArray(schedArr);
            Schedule schedSelected = (Schedule)JOptionPane.showInputDialog(null, Bundle.getMessage("GraphScheduleMessage"), Bundle.getMessage("QuestionTitle"), 3, null, schedArr, schedArr[0]);
            if (schedSelected == null) {
                log.warn("Schedule not selected, graph request cancelled");
                return;
            }
            scheduleId = schedSelected.getScheduleId();
        }
        if (graphType.equals("Display")) {
            TimeTableDisplayGraph graph = new TimeTableDisplayGraph(this._curNodeId, scheduleId, this._showTrainTimes);
            JmriJFrame f = new JmriJFrame(Bundle.getMessage("TitleTimeTableGraph"), true, true);
            f.setMinimumSize(new Dimension(600, 300));
            f.getContentPane().add(graph);
            f.pack();
            f.addHelpMenu("html.tools.TimeTable", true);
            f.setVisible(true);
        }
        if (graphType.equals("Print")) {
            TimeTablePrintGraph print = new TimeTablePrintGraph(this._curNodeId, scheduleId, this._showTrainTimes, this._twoPage);
            print.printGraph();
        }
    }

    void importPressed() {
        this.fileChooser = XmlFile.userFileChooser("SchedGen File", "sgn");
        int retVal = this.fileChooser.showOpenDialog(null);
        if (retVal == 0) {
            File file = this.fileChooser.getSelectedFile();
            try {
                new TimeTableImport().importSgn(this._dataMgr, file);
            }
            catch (IOException ex) {
                log.error("Import exception: {}", (Throwable)ex);
                JOptionPane.showMessageDialog(null, Bundle.getMessage("ImportFailed", "SGN"), Bundle.getMessage("ErrorTitle"), 0);
                return;
            }
            this.savePressed();
            JOptionPane.showMessageDialog(null, Bundle.getMessage("ImportCompleted", "SGN"), Bundle.getMessage("MessageTitle"), 1);
        }
    }

    void importCsvPressed() {
        this.fileChooser = new JFileChooser(FileUtil.getUserFilesPath());
        this.fileChooser.setFileFilter(new FileNameExtensionFilter("Import File", "csv"));
        int retVal = this.fileChooser.showOpenDialog(null);
        if (retVal == 0) {
            File file = this.fileChooser.getSelectedFile();
            this.completeImport(file);
        }
    }

    void completeImport(File file) {
        try {
            this.feedbackList = new TimeTableCsvImport().importCsv(file);
        }
        catch (IOException ex) {
            log.error("Import exception: {}", (Throwable)ex);
            JOptionPane.showMessageDialog(null, Bundle.getMessage("ImportCsvFailed", "CVS"), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        if (this.feedbackList.size() > 0) {
            StringBuilder msg = new StringBuilder(Bundle.getMessage("ImportCsvErrors"));
            for (String feedback : this.feedbackList) {
                msg.append(String.valueOf(feedback) + "\n");
            }
            JOptionPane.showMessageDialog(null, msg.toString(), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        this.savePressed();
        JOptionPane.showMessageDialog(null, Bundle.getMessage("ImportCompleted", "CSV"), Bundle.getMessage("MessageTitle"), 1);
    }

    void importFromOperationsPressed() {
        ExportTimetable ex = new ExportTimetable();
        new ExportTimetable().writeOperationsTimetableFile();
        this.completeImport(ex.getExportFile());
    }

    void exportCsvPressed() {
        List<Schedule> schedules;
        List<Segment> segments;
        List<Layout> layouts = this._dataMgr.getLayouts(true);
        if (layouts.size() == 0) {
            JOptionPane.showMessageDialog(null, Bundle.getMessage("ExportLayoutError"), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        int layoutId = layouts.get(0).getLayoutId();
        if (layouts.size() > 1) {
            Layout layout = (Layout)JOptionPane.showInputDialog(null, Bundle.getMessage("ExportSelectLayout"), Bundle.getMessage("QuestionTitle"), -1, null, layouts.toArray(), null);
            if (layout == null) {
                return;
            }
            layoutId = layout.getLayoutId();
        }
        if ((segments = this._dataMgr.getSegments(layoutId, true)).size() == 0) {
            JOptionPane.showMessageDialog(null, Bundle.getMessage("ExportSegmentError"), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        int segmentId = segments.get(0).getSegmentId();
        if (segments.size() > 1) {
            Segment segment = (Segment)JOptionPane.showInputDialog(null, Bundle.getMessage("ExportSelectSegment"), Bundle.getMessage("QuestionTitle"), -1, null, segments.toArray(), null);
            if (segment == null) {
                return;
            }
            segmentId = segment.getSegmentId();
        }
        if ((schedules = this._dataMgr.getSchedules(layoutId, true)).size() == 0) {
            JOptionPane.showMessageDialog(null, Bundle.getMessage("ExportScheduleError"), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        int scheduleId = schedules.get(0).getScheduleId();
        if (schedules.size() > 1) {
            Schedule schedule = (Schedule)JOptionPane.showInputDialog(null, Bundle.getMessage("ExportSelectSchedule"), Bundle.getMessage("QuestionTitle"), -1, null, schedules.toArray(), null);
            if (schedule == null) {
                return;
            }
            scheduleId = schedule.getScheduleId();
        }
        this.fileChooser = new JFileChooser(FileUtil.getUserFilesPath());
        this.fileChooser.setFileFilter(new FileNameExtensionFilter("Export as CSV File", "csv"));
        int retVal = this.fileChooser.showSaveDialog(null);
        if (retVal == 0) {
            boolean hasErrors;
            File file = this.fileChooser.getSelectedFile();
            String fileName = file.getAbsolutePath();
            String fileNameLC = fileName.toLowerCase();
            if (!fileNameLC.endsWith(".csv")) {
                fileName = String.valueOf(fileName) + ".csv";
                file = new File(fileName);
            }
            if (file.exists() && JOptionPane.showConfirmDialog(null, Bundle.getMessage("FileOverwriteWarning", file.getName()), Bundle.getMessage("QuestionTitle"), 2, 3) != 0) {
                return;
            }
            try {
                hasErrors = new TimeTableCsvExport().exportCsv(file, layoutId, segmentId, scheduleId);
            }
            catch (IOException ex) {
                log.error("Export exception: {}", (Throwable)ex);
                JOptionPane.showMessageDialog(null, Bundle.getMessage("ExportFailed"), Bundle.getMessage("ErrorTitle"), 0);
                return;
            }
            if (hasErrors) {
                JOptionPane.showMessageDialog(null, Bundle.getMessage("ExportFailed"), Bundle.getMessage("ErrorTitle"), 0);
            } else {
                JOptionPane.showMessageDialog(null, Bundle.getMessage("ExportCompleted", file), Bundle.getMessage("MessageTitle"), 1);
            }
        }
    }

    void savePressed() {
        TimeTableXml.doStore();
        this.setShowReminder(false);
    }

    void donePressed() {
        if (this._isDirty) {
            Object[] options = new Object[]{Bundle.getMessage("ButtonNo"), Bundle.getMessage("ButtonYes")};
            int selectedOption = JOptionPane.showOptionDialog(null, Bundle.getMessage("DirtyDataWarning"), Bundle.getMessage("WarningTitle"), -1, 2, null, options, options[0]);
            if (selectedOption == 0) {
                return;
            }
        }
        InstanceManager.reset(TimeTableFrame.class);
        this.dispose();
    }

    JTree buildTree() {
        this._timetableRoot = new DefaultMutableTreeNode("Root Node");
        this._timetableModel = new DefaultTreeModel(this._timetableRoot);
        this._timetableTree = new JTree(this._timetableModel);
        this.createTimeTableContent();
        this._timetableTree.expandPath(new TreePath(this._timetableRoot));
        this._timetableTree.setRootVisible(false);
        this._timetableTree.setShowsRootHandles(true);
        this._timetableTree.setScrollsOnExpand(true);
        this._timetableTree.setExpandsSelectedPaths(true);
        this._timetableTree.getSelectionModel().setSelectionMode(1);
        this._timetableListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                Object chkLast;
                if (TimeTableFrame.this._editActive) {
                    if (e.getNewLeadSelectionPath() != TimeTableFrame.this._curTreePath) {
                        TimeTableFrame.this._timetableTree.setSelectionPath(e.getOldLeadSelectionPath());
                        TimeTableFrame.this.showNodeEditMessage();
                    }
                    return;
                }
                TimeTableFrame.this._curTreePath = TimeTableFrame.this._timetableTree.getSelectionPath();
                if (TimeTableFrame.this._curTreePath != null && (chkLast = TimeTableFrame.this._curTreePath.getLastPathComponent()) instanceof TimeTableTreeNode) {
                    TimeTableFrame.this.treeRowSelected((TimeTableTreeNode)chkLast);
                }
            }
        };
        this._timetableTree.addTreeSelectionListener(this._timetableListener);
        return this._timetableTree;
    }

    void createTimeTableContent() {
        for (Layout l : this._dataMgr.getLayouts(true)) {
            this._layoutNode = new TimeTableTreeNode(l.getLayoutName(), "Layout", l.getLayoutId(), 0);
            this._timetableRoot.add(this._layoutNode);
            this._typeHead = new TimeTableTreeNode(this.buildNodeText("TrainTypes", null, 0), "TrainTypes", 0, 0);
            this._layoutNode.add(this._typeHead);
            for (TrainType y : this._dataMgr.getTrainTypes(l.getLayoutId(), true)) {
                this._typeNode = new TimeTableTreeNode(y.getTypeName(), "TrainType", y.getTypeId(), 0);
                this._typeHead.add(this._typeNode);
            }
            this._segmentHead = new TimeTableTreeNode(this.buildNodeText("Segments", null, 0), "Segments", 0, 0);
            this._layoutNode.add(this._segmentHead);
            for (Segment sg : this._dataMgr.getSegments(l.getLayoutId(), true)) {
                this._segmentNode = new TimeTableTreeNode(sg.getSegmentName(), "Segment", sg.getSegmentId(), 0);
                this._segmentHead.add(this._segmentNode);
                for (Station st : this._dataMgr.getStations(sg.getSegmentId(), true)) {
                    this._leafNode = new TimeTableTreeNode(st.getStationName(), "Station", st.getStationId(), 0);
                    this._segmentNode.add(this._leafNode);
                }
            }
            this._scheduleHead = new TimeTableTreeNode(this.buildNodeText("Schedules", null, 0), "Schedules", 0, 0);
            this._layoutNode.add(this._scheduleHead);
            for (Schedule c : this._dataMgr.getSchedules(l.getLayoutId(), true)) {
                this._scheduleNode = new TimeTableTreeNode(this.buildNodeText("Schedule", c, 0), "Schedule", c.getScheduleId(), 0);
                this._scheduleHead.add(this._scheduleNode);
                for (Train tr : this._dataMgr.getTrains(c.getScheduleId(), 0, true)) {
                    this._trainNode = new TimeTableTreeNode(this.buildNodeText("Train", tr, 0), "Train", tr.getTrainId(), 0);
                    this._scheduleNode.add(this._trainNode);
                    for (Stop sp : this._dataMgr.getStops(tr.getTrainId(), 0, true)) {
                        this._leafNode = new TimeTableTreeNode(this.buildNodeText("Stop", sp, 0), "Stop", sp.getStopId(), sp.getSeq());
                        this._trainNode.add(this._leafNode);
                    }
                }
            }
        }
    }

    String buildNodeText(String nodeType, Object component, int idx) {
        switch (nodeType) {
            case "TrainTypes": {
                return Bundle.getMessage("LabelTrainTypes");
            }
            case "Segments": {
                return Bundle.getMessage("LabelSegments");
            }
            case "Schedules": {
                return Bundle.getMessage("LabelSchedules");
            }
            case "Schedule": {
                Schedule schedule = (Schedule)component;
                return Bundle.getMessage("LabelSchedule", schedule.getScheduleName(), schedule.getEffDate());
            }
            case "Train": {
                Train train = (Train)component;
                return Bundle.getMessage("LabelTrain", train.getTrainName(), train.getTrainDesc());
            }
            case "Stop": {
                Stop stop = (Stop)component;
                int stationId = stop.getStationId();
                return Bundle.getMessage("LabelStop", stop.getSeq(), this._dataMgr.getStation(stationId).getStationName());
            }
        }
        return "None";
    }

    void treeRowSelected(TimeTableTreeNode selectedNode) {
        this._curNode = selectedNode;
        this._curNodeId = selectedNode.getId();
        this._curNodeType = selectedNode.getType();
        this._curNodeText = selectedNode.getText();
        this._curNodeRow = selectedNode.getRow();
        this._addButtonPanel.setVisible(false);
        this._deleteButtonPanel.setVisible(false);
        this._moveButtonPanel.setVisible(false);
        this._graphButtonPanel.setVisible(false);
        switch (this._curNodeType) {
            case "Layout": {
                this._addButton.setText(Bundle.getMessage("AddLayoutButtonText"));
                this._addButtonPanel.setVisible(true);
                this._deleteButton.setText(Bundle.getMessage("DeleteLayoutButtonText"));
                this._deleteButtonPanel.setVisible(true);
                this.editPressed();
                break;
            }
            case "TrainTypes": {
                this._addButton.setText(Bundle.getMessage("AddTrainTypeButtonText"));
                this._addButtonPanel.setVisible(true);
                this.makeDetailGrid(EMPTY_GRID);
                break;
            }
            case "TrainType": {
                this._deleteButton.setText(Bundle.getMessage("DeleteTrainTypeButtonText"));
                this._deleteButtonPanel.setVisible(true);
                this.editPressed();
                break;
            }
            case "Segments": {
                this._addButton.setText(Bundle.getMessage("AddSegmentButtonText"));
                this._addButtonPanel.setVisible(true);
                this.makeDetailGrid(EMPTY_GRID);
                break;
            }
            case "Segment": {
                this._addButton.setText(Bundle.getMessage("AddStationButtonText"));
                this._addButtonPanel.setVisible(true);
                this._deleteButton.setText(Bundle.getMessage("DeleteSegmentButtonText"));
                this._deleteButtonPanel.setVisible(true);
                this._graphButtonPanel.setVisible(true);
                this.editPressed();
                break;
            }
            case "Station": {
                this._deleteButton.setText(Bundle.getMessage("DeleteStationButtonText"));
                this._deleteButtonPanel.setVisible(true);
                this.editPressed();
                break;
            }
            case "Schedules": {
                this._addButton.setText(Bundle.getMessage("AddScheduleButtonText"));
                this._addButtonPanel.setVisible(true);
                this.makeDetailGrid(EMPTY_GRID);
                break;
            }
            case "Schedule": {
                this._addButton.setText(Bundle.getMessage("AddTrainButtonText"));
                this._addButtonPanel.setVisible(true);
                this._deleteButton.setText(Bundle.getMessage("DeleteScheduleButtonText"));
                this._deleteButtonPanel.setVisible(true);
                this.editPressed();
                break;
            }
            case "Train": {
                this._addButton.setText(Bundle.getMessage("AddStopButtonText"));
                this._addButtonPanel.setVisible(true);
                this._deleteButton.setText(Bundle.getMessage("DeleteTrainButtonText"));
                this._deleteButtonPanel.setVisible(true);
                this.editPressed();
                break;
            }
            case "Stop": {
                this._deleteButton.setText(Bundle.getMessage("DeleteStopButtonText"));
                this._deleteButtonPanel.setVisible(true);
                this.editPressed();
                break;
            }
            default: {
                log.warn("Should not be here");
            }
        }
    }

    void showNodeEditMessage() {
        if (InstanceManager.getNullableDefault(UserPreferencesManager.class) != null) {
            InstanceManager.getDefault(UserPreferencesManager.class).showInfoMessage(Bundle.getMessage("NodeEditTitle"), Bundle.getMessage("NodeEditText"), this.getClassName(), "SkipTimeTableEditMessage");
        }
    }

    public void setShowReminder(boolean dirty) {
        this._isDirty = dirty;
        this._saveButton.setEnabled(dirty);
    }

    void setEditMode(boolean active) {
        this._editActive = active;
        this._cancelAction.setEnabled(active);
        this._updateAction.setEnabled(active);
        this._addButton.setEnabled(!active);
        this._deleteButton.setEnabled(!active);
        if (this._curNodeType != null && this._curNodeType.equals("Stop")) {
            this.setMoveButtons();
        }
    }

    protected String getClassName() {
        return TimeTableFrame.class.getName();
    }

    static class TimeTableTreeNode
    extends DefaultMutableTreeNode {
        private String ttText;
        private String ttType;
        private int ttId;
        private int ttRow;

        public TimeTableTreeNode(String nameText, String type, int sysId, int row) {
            this.ttText = nameText;
            this.ttType = type;
            this.ttId = sysId;
            this.ttRow = row;
        }

        public String getType() {
            return this.ttType;
        }

        public int getId() {
            return this.ttId;
        }

        public void setId(int newId) {
            this.ttId = newId;
        }

        public int getRow() {
            return this.ttRow;
        }

        public void setRow(int newRow) {
            this.ttRow = newRow;
        }

        public String getText() {
            return this.ttText;
        }

        public void setText(String newText) {
            this.ttText = newText;
        }

        @Override
        public String toString() {
            return this.ttText;
        }
    }
}

