/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.timetable.configurexml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import jmri.Scale;
import jmri.ScaleManager;
import jmri.jmrit.XmlFile;
import jmri.jmrit.timetable.Layout;
import jmri.jmrit.timetable.Schedule;
import jmri.jmrit.timetable.Segment;
import jmri.jmrit.timetable.Station;
import jmri.jmrit.timetable.Stop;
import jmri.jmrit.timetable.TimeTableDataManager;
import jmri.jmrit.timetable.Train;
import jmri.jmrit.timetable.TrainType;
import jmri.util.FileUtil;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeTableXml {
    private static final Logger log = LoggerFactory.getLogger(TimeTableXml.class);

    public static boolean doStore() {
        Element e;
        TimeTableDataManager dataMgr = TimeTableDataManager.getDataManager();
        TimeTableXmlFile x = new TimeTableXmlFile();
        File file = x.getFile(true);
        try {
            FileUtil.rotate(file, 4, "bup");
        }
        catch (IOException iOException) {
            log.warn("Rotate failed, reverting to xml backup");
            x.makeBackupFile(TimeTableXmlFile.getDefaultFileName());
        }
        Element root = new Element("timetable-data");
        root.setAttribute("noNamespaceSchemaLocation", "http://jmri.org/xml/schema/timetable.xsd", Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance"));
        Document doc = new Document(root);
        Element values = new Element("layouts");
        root.addContent((Content)values);
        for (Layout layout : dataMgr.getLayouts(false)) {
            e = new Element("layout");
            e.addContent((Content)new Element("layout_id").addContent("" + layout.getLayoutId()));
            e.addContent((Content)new Element("layout_name").addContent(layout.getLayoutName()));
            e.addContent((Content)new Element("scale").addContent(layout.getScale().getScaleName()));
            e.addContent((Content)new Element("fast_clock").addContent("" + layout.getFastClock()));
            e.addContent((Content)new Element("throttles").addContent("" + layout.getThrottles()));
            e.addContent((Content)new Element("metric").addContent(layout.getMetric() ? "yes" : "no"));
            values.addContent((Content)e);
        }
        values = new Element("train_types");
        root.addContent((Content)values);
        for (TrainType type : dataMgr.getTrainTypes(0, false)) {
            e = new Element("train_type");
            e.addContent((Content)new Element("type_id").addContent("" + type.getTypeId()));
            e.addContent((Content)new Element("layout_id").addContent("" + type.getLayoutId()));
            e.addContent((Content)new Element("type_name").addContent(type.getTypeName()));
            e.addContent((Content)new Element("type_color").addContent(type.getTypeColor()));
            values.addContent((Content)e);
        }
        values = new Element("segments");
        root.addContent((Content)values);
        for (Segment segment : dataMgr.getSegments(0, false)) {
            e = new Element("segment");
            e.addContent((Content)new Element("segment_id").addContent("" + segment.getSegmentId()));
            e.addContent((Content)new Element("layout_id").addContent("" + segment.getLayoutId()));
            e.addContent((Content)new Element("segment_name").addContent(segment.getSegmentName()));
            values.addContent((Content)e);
        }
        values = new Element("stations");
        root.addContent((Content)values);
        for (Station station : dataMgr.getStations(0, false)) {
            e = new Element("station");
            e.addContent((Content)new Element("station_id").addContent("" + station.getStationId()));
            e.addContent((Content)new Element("segment_id").addContent("" + station.getSegmentId()));
            e.addContent((Content)new Element("station_name").addContent(station.getStationName()));
            e.addContent((Content)new Element("distance").addContent("" + station.getDistance()));
            e.addContent((Content)new Element("double_track").addContent(station.getDoubleTrack() ? "yes" : "no"));
            e.addContent((Content)new Element("sidings").addContent("" + station.getSidings()));
            e.addContent((Content)new Element("staging").addContent("" + station.getStaging()));
            values.addContent((Content)e);
        }
        values = new Element("schedules");
        root.addContent((Content)values);
        for (Schedule schedule : dataMgr.getSchedules(0, false)) {
            e = new Element("schedule");
            e.addContent((Content)new Element("schedule_id").addContent("" + schedule.getScheduleId()));
            e.addContent((Content)new Element("layout_id").addContent("" + schedule.getLayoutId()));
            e.addContent((Content)new Element("schedule_name").addContent(schedule.getScheduleName()));
            e.addContent((Content)new Element("eff_date").addContent(schedule.getEffDate()));
            e.addContent((Content)new Element("start_hour").addContent("" + schedule.getStartHour()));
            e.addContent((Content)new Element("duration").addContent("" + schedule.getDuration()));
            values.addContent((Content)e);
        }
        values = new Element("trains");
        root.addContent((Content)values);
        for (Train train : dataMgr.getTrains(0, 0, false)) {
            e = new Element("train");
            e.addContent((Content)new Element("train_id").addContent("" + train.getTrainId()));
            e.addContent((Content)new Element("schedule_id").addContent("" + train.getScheduleId()));
            e.addContent((Content)new Element("type_id").addContent("" + train.getTypeId()));
            e.addContent((Content)new Element("train_name").addContent(train.getTrainName()));
            e.addContent((Content)new Element("train_desc").addContent(train.getTrainDesc()));
            e.addContent((Content)new Element("default_speed").addContent("" + train.getDefaultSpeed()));
            e.addContent((Content)new Element("start_time").addContent("" + train.getStartTime()));
            e.addContent((Content)new Element("throttle").addContent("" + train.getThrottle()));
            e.addContent((Content)new Element("route_duration").addContent("" + train.getRouteDuration()));
            e.addContent((Content)new Element("train_notes").addContent(train.getTrainNotes()));
            values.addContent((Content)e);
        }
        values = new Element("stops");
        root.addContent((Content)values);
        for (Stop stop : dataMgr.getStops(0, 0, false)) {
            e = new Element("stop");
            e.addContent((Content)new Element("stop_id").addContent("" + stop.getStopId()));
            e.addContent((Content)new Element("train_id").addContent("" + stop.getTrainId()));
            e.addContent((Content)new Element("station_id").addContent("" + stop.getStationId()));
            e.addContent((Content)new Element("seq").addContent("" + stop.getSeq()));
            e.addContent((Content)new Element("duration").addContent("" + stop.getDuration()));
            e.addContent((Content)new Element("next_speed").addContent("" + stop.getNextSpeed()));
            e.addContent((Content)new Element("arrive_time").addContent("" + stop.getArriveTime()));
            e.addContent((Content)new Element("depart_time").addContent("" + stop.getDepartTime()));
            e.addContent((Content)new Element("staging_track").addContent("" + stop.getStagingTrack()));
            e.addContent((Content)new Element("stop_notes").addContent(stop.getStopNotes()));
            values.addContent((Content)e);
        }
        try {
            x.writeXML(file, doc);
        }
        catch (FileNotFoundException ex) {
            log.error("File not found when writing: {}", (Throwable)ex);
            return false;
        }
        catch (IOException ex) {
            log.error("IO Exception when writing: {}", (Throwable)ex);
            return false;
        }
        log.debug("...done");
        return true;
    }

    public static boolean doLoad() {
        Element stops;
        Element durationE;
        ArrayList<Integer> checkTrainIds;
        ArrayList<Integer> checkStationIds;
        TimeTableDataManager dataMgr;
        block34: {
            Element trains;
            Element root;
            ArrayList<Integer> checkScheduleIds;
            ArrayList<Integer> checkTypeIds;
            block33: {
                Element schedules;
                ArrayList<Integer> checkLayoutIds;
                block32: {
                    Element stations;
                    ArrayList<Integer> checkSegmentIds;
                    block31: {
                        Element segments;
                        block30: {
                            Element train_types;
                            block29: {
                                Element layouts;
                                block28: {
                                    block27: {
                                        dataMgr = TimeTableDataManager.getDataManager();
                                        TimeTableXmlFile x = new TimeTableXmlFile();
                                        File file = x.getFile(false);
                                        if (file == null) {
                                            log.debug("Nothing to load");
                                            return false;
                                        }
                                        checkLayoutIds = new ArrayList<Integer>();
                                        checkTypeIds = new ArrayList<Integer>();
                                        checkSegmentIds = new ArrayList<Integer>();
                                        checkStationIds = new ArrayList<Integer>();
                                        checkScheduleIds = new ArrayList<Integer>();
                                        checkTrainIds = new ArrayList<Integer>();
                                        log.debug("Start loading timetable data...");
                                        root = x.rootFromFile(file);
                                        if (root != null) break block27;
                                        log.debug("File could not be read");
                                        return false;
                                    }
                                    layouts = root.getChild("layouts");
                                    if (layouts != null) break block28;
                                    log.error("Unable to find a layout entry");
                                    return false;
                                }
                                for (Element layout : layouts.getChildren("layout")) {
                                    Element layout_id = layout.getChild("layout_id");
                                    int layoutId = layout_id == null ? 0 : Integer.parseInt(layout_id.getValue());
                                    Element layout_name = layout.getChild("layout_name");
                                    String layoutName = layout_name == null ? "" : layout_name.getValue();
                                    Element scaleE = layout.getChild("scale");
                                    Scale scale = scaleE == null ? ScaleManager.getScale("HO") : ScaleManager.getScale(scaleE.getValue());
                                    Element fast_clock = layout.getChild("fast_clock");
                                    int fastClock = fast_clock == null ? 1 : Integer.parseInt(fast_clock.getValue());
                                    Element throttlesE = layout.getChild("throttles");
                                    int throttles = throttlesE == null ? 0 : Integer.parseInt(throttlesE.getValue());
                                    Element metricE = layout.getChild("metric");
                                    boolean metric = metricE == null ? false : metricE.getValue().equals("yes");
                                    log.debug("  Layout: {} - {} - {} - {} - {} - {}", new Object[]{layoutId, layoutName, scale, fastClock, throttles, metric});
                                    Layout newLayout = new Layout(layoutId, layoutName, scale, fastClock, throttles, metric);
                                    dataMgr.addLayout(layoutId, newLayout);
                                    checkLayoutIds.add(layoutId);
                                }
                                train_types = root.getChild("train_types");
                                if (train_types != null) break block29;
                                log.error("Unable to find train types");
                                return false;
                            }
                            for (Element train_type : train_types.getChildren("train_type")) {
                                Element type_id = train_type.getChild("type_id");
                                int typeId = type_id == null ? 0 : Integer.parseInt(type_id.getValue());
                                Element layout_id = train_type.getChild("layout_id");
                                int layoutId = layout_id == null ? 0 : Integer.parseInt(layout_id.getValue());
                                Element type_name = train_type.getChild("type_name");
                                String typeName = type_name == null ? "" : type_name.getValue();
                                Element type_color = train_type.getChild("type_color");
                                String typeColor = type_color == null ? "#000000" : type_color.getValue();
                                log.debug("    Type: {} - {} - {}", new Object[]{typeId, typeName, typeColor});
                                if (!checkLayoutIds.contains(layoutId)) {
                                    log.warn("TrainType {} layout id not found", (Object)typeName);
                                    continue;
                                }
                                TrainType newType = new TrainType(typeId, layoutId, typeName, typeColor);
                                dataMgr.addTrainType(typeId, newType);
                                checkTypeIds.add(typeId);
                            }
                            segments = root.getChild("segments");
                            if (segments != null) break block30;
                            log.error("Unable to find segments");
                            return false;
                        }
                        for (Element segment : segments.getChildren("segment")) {
                            Element segment_id = segment.getChild("segment_id");
                            int segmentId = segment_id == null ? 0 : Integer.parseInt(segment_id.getValue());
                            Element layout_id = segment.getChild("layout_id");
                            int layoutId = layout_id == null ? 0 : Integer.parseInt(layout_id.getValue());
                            Element segment_name = segment.getChild("segment_name");
                            String segmentName = segment_name == null ? "" : segment_name.getValue();
                            log.debug("    Segment: {} - {} - {}", new Object[]{segmentId, layoutId, segmentName});
                            if (!checkLayoutIds.contains(layoutId)) {
                                log.warn("Segment {} layout id not found", (Object)segmentName);
                                continue;
                            }
                            Segment newSegment = new Segment(segmentId, layoutId, segmentName);
                            dataMgr.addSegment(segmentId, newSegment);
                            checkSegmentIds.add(segmentId);
                        }
                        stations = root.getChild("stations");
                        if (stations != null) break block31;
                        log.error("Unable to find stations");
                        return false;
                    }
                    for (Element station : stations.getChildren("station")) {
                        Element station_id = station.getChild("station_id");
                        int stationId = station_id == null ? 0 : Integer.parseInt(station_id.getValue());
                        Element segment_id = station.getChild("segment_id");
                        int segmentId = segment_id == null ? 0 : Integer.parseInt(segment_id.getValue());
                        Element station_name = station.getChild("station_name");
                        String stationName = station_name == null ? "" : station_name.getValue();
                        Element distanceE = station.getChild("distance");
                        double distance = distanceE == null ? 1.0 : Double.parseDouble(distanceE.getValue());
                        Element double_track = station.getChild("double_track");
                        boolean doubleTrack = double_track == null ? false : double_track.getValue().equals("yes");
                        Element sidingsE = station.getChild("sidings");
                        int sidings = sidingsE == null ? 0 : Integer.parseInt(sidingsE.getValue());
                        Element stagingE = station.getChild("staging");
                        int staging = stagingE == null ? 0 : Integer.parseInt(stagingE.getValue());
                        log.debug("      Station: {} - {} - {} - {} - {} - {}", new Object[]{stationId, stationName, distance, doubleTrack, sidings, staging});
                        if (!checkSegmentIds.contains(segmentId)) {
                            log.warn("Station {} segment id not found", (Object)stationName);
                            continue;
                        }
                        Station newStation = new Station(stationId, segmentId, stationName, distance, doubleTrack, sidings, staging);
                        dataMgr.addStation(stationId, newStation);
                        checkStationIds.add(stationId);
                    }
                    schedules = root.getChild("schedules");
                    if (schedules != null) break block32;
                    log.error("Unable to find schedules");
                    return false;
                }
                for (Element schedule : schedules.getChildren("schedule")) {
                    Element schedule_id = schedule.getChild("schedule_id");
                    int scheduleId = schedule_id == null ? 0 : Integer.parseInt(schedule_id.getValue());
                    Element layout_id = schedule.getChild("layout_id");
                    int layoutId = layout_id == null ? 0 : Integer.parseInt(layout_id.getValue());
                    Element schedule_name = schedule.getChild("schedule_name");
                    String scheduleName = schedule_name == null ? "" : schedule_name.getValue();
                    Element eff_date = schedule.getChild("eff_date");
                    String effDate = eff_date == null ? "" : eff_date.getValue();
                    Element start_hour = schedule.getChild("start_hour");
                    int startHour = start_hour == null ? 0 : Integer.parseInt(start_hour.getValue());
                    durationE = schedule.getChild("duration");
                    int duration = durationE == null ? 0 : Integer.parseInt(durationE.getValue());
                    log.debug("    Schedule: {} - {} - {} - {} - {} - {}", new Object[]{scheduleId, layoutId, scheduleName, effDate, startHour, duration});
                    if (!checkLayoutIds.contains(layoutId)) {
                        log.warn("Schdule {} layout id not found", (Object)scheduleName);
                        continue;
                    }
                    Schedule newSchedule = new Schedule(scheduleId, layoutId, scheduleName, effDate, startHour, duration);
                    dataMgr.addSchedule(scheduleId, newSchedule);
                    checkScheduleIds.add(scheduleId);
                }
                trains = root.getChild("trains");
                if (trains != null) break block33;
                log.error("Unable to find trains");
                return false;
            }
            for (Element train : trains.getChildren("train")) {
                Element train_id = train.getChild("train_id");
                int trainId = train_id == null ? 0 : Integer.parseInt(train_id.getValue());
                Element schedule_id = train.getChild("schedule_id");
                int scheduleId = schedule_id == null ? 0 : Integer.parseInt(schedule_id.getValue());
                Element type_id = train.getChild("type_id");
                int typeId = type_id == null ? 0 : Integer.parseInt(type_id.getValue());
                Element train_name = train.getChild("train_name");
                String trainName = train_name == null ? "" : train_name.getValue();
                Element train_desc = train.getChild("train_desc");
                String trainDesc = train_desc == null ? "" : train_desc.getValue();
                Element default_speed = train.getChild("default_speed");
                int defaultSpeed = default_speed == null ? 1 : Integer.parseInt(default_speed.getValue());
                Element start_time = train.getChild("start_time");
                int startTime = start_time == null ? 0 : Integer.parseInt(start_time.getValue());
                Element throttleE = train.getChild("throttle");
                int throttle = throttleE == null ? 0 : Integer.parseInt(throttleE.getValue());
                Element route_duration = train.getChild("route_duration");
                int routeDuration = route_duration == null ? 0 : Integer.parseInt(route_duration.getValue());
                Element train_notes = train.getChild("train_notes");
                String trainNotes = train_notes == null ? "" : train_notes.getValue();
                log.debug("      Train: {} - {} - {} - {} - {} - {} - {} - {} - {}", new Object[]{trainId, scheduleId, typeId, trainName, trainDesc, defaultSpeed, startTime, throttle, routeDuration, trainNotes});
                if (!checkScheduleIds.contains(scheduleId)) {
                    log.warn("Train {} schedule id not found", (Object)trainName);
                    continue;
                }
                if (!checkTypeIds.contains(typeId)) {
                    log.warn("Train {} type id not found", (Object)trainName);
                    continue;
                }
                Train newTrain = new Train(trainId, scheduleId, typeId, trainName, trainDesc, defaultSpeed, startTime, throttle, routeDuration, trainNotes);
                dataMgr.addTrain(trainId, newTrain);
                checkTrainIds.add(trainId);
            }
            stops = root.getChild("stops");
            if (stops != null) break block34;
            log.error("Unable to find stops");
            return false;
        }
        try {
            for (Element stop : stops.getChildren("stop")) {
                Element stop_id = stop.getChild("stop_id");
                int stopId = stop_id == null ? 0 : Integer.parseInt(stop_id.getValue());
                Element train_id = stop.getChild("train_id");
                int trainId = train_id == null ? 0 : Integer.parseInt(train_id.getValue());
                Element station_id = stop.getChild("station_id");
                int stationId = station_id == null ? 0 : Integer.parseInt(station_id.getValue());
                Element seqE = stop.getChild("seq");
                int seq = seqE == null ? 0 : Integer.parseInt(seqE.getValue());
                durationE = stop.getChild("duration");
                int duration = durationE == null ? 0 : Integer.parseInt(durationE.getValue());
                Element next_speed = stop.getChild("next_speed");
                int nextSpeed = next_speed == null ? 0 : Integer.parseInt(next_speed.getValue());
                Element arrive_time = stop.getChild("arrive_time");
                int arriveTime = arrive_time == null ? 0 : Integer.parseInt(arrive_time.getValue());
                Element depart_time = stop.getChild("depart_time");
                int departTime = depart_time == null ? 0 : Integer.parseInt(depart_time.getValue());
                Element staging_track = stop.getChild("staging_track");
                int stagingTrack = staging_track == null ? 0 : Integer.parseInt(staging_track.getValue());
                Element stop_notes = stop.getChild("stop_notes");
                String stopNotes = stop_notes == null ? "" : stop_notes.getValue();
                log.debug("        Stop: {} - {} - {} - {} - {} - {} - {} - {} - {} - {}", new Object[]{stopId, trainId, stationId, seq, duration, nextSpeed, arriveTime, departTime, stagingTrack, stopNotes});
                if (!checkTrainIds.contains(trainId)) {
                    log.warn("Stop train id not found");
                    continue;
                }
                if (!checkStationIds.contains(stationId)) {
                    log.warn("Stop station id not found");
                    continue;
                }
                Stop newStop = new Stop(stopId, trainId, stationId, seq, duration, nextSpeed, arriveTime, departTime, stagingTrack, stopNotes);
                dataMgr.addStop(stopId, newStop);
            }
        }
        catch (JDOMException ex) {
            log.error("File invalid: {}", (Throwable)ex);
            return false;
        }
        catch (IOException ex) {
            log.error("Error reading file: {}", (Throwable)ex);
            return false;
        }
        log.debug("...done");
        return true;
    }

    public static class TimeTableXmlFile
    extends XmlFile {
        private static String fileLocation = String.valueOf(FileUtil.getUserFilesPath()) + "timetable/";
        private static String demoLocation = String.valueOf(FileUtil.getProgramPath()) + "xml/demoTimetable/";
        private static String baseFileName = "TimeTableData.xml";

        public static String getDefaultFileName() {
            return String.valueOf(TimeTableXmlFile.getFileLocation()) + TimeTableXmlFile.getFileName();
        }

        public File getFile(boolean store) {
            File file;
            File chkdir = new File(TimeTableXmlFile.getFileLocation());
            if (!chkdir.exists() && !chkdir.mkdirs()) {
                log.error("Create {} failed", (Object)chkdir);
                return null;
            }
            File chkfile = new File(TimeTableXmlFile.getDefaultFileName());
            if (!chkfile.exists()) {
                File demoFile = new File(String.valueOf(demoLocation) + baseFileName);
                Path toPath = chkdir.toPath();
                Path fromPath = demoFile.toPath();
                try {
                    Files.copy(fromPath, toPath.resolve(fromPath.getFileName()), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException iOException) {
                    log.error("Copy TimeTable demo file failed");
                    return null;
                }
            }
            if ((file = this.findFile(TimeTableXmlFile.getDefaultFileName())) == null && store) {
                log.info("create new file");
                file = new File(TimeTableXmlFile.getDefaultFileName());
            }
            return file;
        }

        public static String getFileName() {
            if (baseFileName == null) {
                baseFileName = "TimeTableData.xml";
            }
            return baseFileName;
        }

        public static String getFileLocation() {
            if (fileLocation == null) {
                fileLocation = String.valueOf(FileUtil.getUserFilesPath()) + "timetable/";
            }
            return fileLocation;
        }
    }
}

