/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.timetable;

import java.awt.Color;
import jmri.jmrit.timetable.Bundle;
import jmri.jmrit.timetable.TimeTableDataManager;
import jmri.util.swing.JmriColorChooser;

public class TrainType {
    TimeTableDataManager _dm = TimeTableDataManager.getDataManager();
    private final int _typeId;
    private final int _layoutId;
    private String _typeName = Bundle.getMessage("NewTypeName");
    private String _typeColor = "#000000";

    public TrainType(int layoutId) {
        if (this._dm.getLayout(layoutId) == null) {
            throw new IllegalArgumentException("TypeAddFail");
        }
        this._typeId = this._dm.getNextId("TrainType");
        this._layoutId = layoutId;
        this._dm.addTrainType(this._typeId, this);
    }

    public TrainType(int typeId, int layoutId, String typeName, String typeColor) {
        this._typeId = typeId;
        this._layoutId = layoutId;
        this.setTypeName(typeName);
        this.setTypeColor(typeColor);
    }

    public int getTypeId() {
        return this._typeId;
    }

    public int getLayoutId() {
        return this._layoutId;
    }

    public String getTypeName() {
        return this._typeName;
    }

    public void setTypeName(String newName) {
        this._typeName = newName;
    }

    public String getTypeColor() {
        return this._typeColor;
    }

    public void setTypeColor(String newColor) {
        this._typeColor = newColor;
        JmriColorChooser.addRecentColor(Color.decode(newColor));
    }

    public String toString() {
        return this._typeName;
    }
}

