/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.timetable;

import jmri.jmrit.timetable.Bundle;
import jmri.jmrit.timetable.Layout;
import jmri.jmrit.timetable.Schedule;
import jmri.jmrit.timetable.TimeTableDataManager;

public class Train {
    TimeTableDataManager _dm = TimeTableDataManager.getDataManager();
    private final int _trainId;
    private final int _scheduleId;
    private int _typeId = 0;
    private String _trainName = Bundle.getMessage("NewTrainName");
    private String _trainDesc = Bundle.getMessage("NewTrainDesc");
    private int _defaultSpeed = 1;
    private int _startTime = 0;
    private int _throttle = 0;
    private int _routeDuration = 0;
    private String _trainNotes = "";

    public Train(int scheduleId) {
        if (this._dm.getSchedule(scheduleId) == null) {
            throw new IllegalArgumentException("TrainAddFail");
        }
        this._trainId = this._dm.getNextId("Train");
        this._scheduleId = scheduleId;
        this._dm.addTrain(this._trainId, this);
    }

    public Train(int trainId, int scheduleId, int typeId, String trainName, String trainDesc, int defaultSpeed, int startTime, int throttle, int routeDuration, String trainNotes) {
        this._trainId = trainId;
        this._scheduleId = scheduleId;
        this.setTypeId(typeId);
        this.setTrainName(trainName);
        this.setTrainDesc(trainDesc);
        this.setDefaultSpeed(defaultSpeed);
        this.setStartTime(startTime);
        this.setThrottle(throttle);
        this.setRouteDuration(routeDuration);
        this.setTrainNotes(trainNotes);
    }

    public int getTrainId() {
        return this._trainId;
    }

    public int getScheduleId() {
        return this._scheduleId;
    }

    public int getTypeId() {
        return this._typeId;
    }

    public void setTypeId(int newType) {
        this._typeId = newType;
    }

    public String getTrainName() {
        return this._trainName;
    }

    public void setTrainName(String newName) {
        this._trainName = newName;
    }

    public String getTrainDesc() {
        return this._trainDesc;
    }

    public void setTrainDesc(String newDesc) {
        this._trainDesc = newDesc;
    }

    public int getDefaultSpeed() {
        return this._defaultSpeed;
    }

    public void setDefaultSpeed(int newSpeed) {
        if (newSpeed < 0) {
            throw new IllegalArgumentException("DefaultSpeedLt0");
        }
        int oldSpeed = this._defaultSpeed;
        this._defaultSpeed = newSpeed;
        try {
            this._dm.calculateTrain(this._trainId, false);
            this._dm.calculateTrain(this._trainId, true);
        }
        catch (IllegalArgumentException ex) {
            this._defaultSpeed = oldSpeed;
            throw ex;
        }
    }

    public int getStartTime() {
        return this._startTime;
    }

    public void setStartTime(int newStartTime) {
        Schedule schedule = this._dm.getSchedule(this._scheduleId);
        if (!this._dm.validateTime(schedule.getStartHour(), schedule.getDuration(), newStartTime)) {
            throw new IllegalArgumentException(String.format("%s~%d~%d", "StartTimeRange", schedule.getStartHour(), schedule.getStartHour() + schedule.getDuration()));
        }
        int oldStartTime = this._startTime;
        this._startTime = newStartTime;
        try {
            this._dm.calculateTrain(this._trainId, false);
            this._dm.calculateTrain(this._trainId, true);
        }
        catch (IllegalArgumentException ex) {
            this._startTime = oldStartTime;
            throw ex;
        }
    }

    public int getThrottle() {
        return this._throttle;
    }

    public void setThrottle(int newThrottle) {
        Layout layout = this._dm.getLayout(this._dm.getSchedule(this._scheduleId).getLayoutId());
        if (newThrottle < 0 || newThrottle > layout.getThrottles()) {
            throw new IllegalArgumentException("ThrottleRange");
        }
        this._throttle = newThrottle;
    }

    public int getRouteDuration() {
        return this._routeDuration;
    }

    public void setRouteDuration(int newRouteDuration) {
        this._routeDuration = newRouteDuration;
    }

    public String getTrainNotes() {
        return this._trainNotes;
    }

    public void setTrainNotes(String newNotes) {
        this._trainNotes = newNotes;
    }

    public String toString() {
        return this._trainName;
    }
}

