/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.timetable;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jmri.ScaleManager;
import jmri.jmrit.timetable.Layout;
import jmri.jmrit.timetable.Schedule;
import jmri.jmrit.timetable.Segment;
import jmri.jmrit.timetable.Station;
import jmri.jmrit.timetable.Stop;
import jmri.jmrit.timetable.TimeTableDataManager;
import jmri.jmrit.timetable.Train;
import jmri.jmrit.timetable.TrainType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeTableImport {
    BufferedReader bufferedReader;
    FileReader fileReader;
    String line;
    TimeTableDataManager _dm;
    int _layoutId = 0;
    int _segmentId = 0;
    int _scheduleId = 0;
    int _trainId = 0;
    int _routeFirst = 0;
    int _routeLast = 0;
    List<Integer> _stationIds = new ArrayList<Integer>();
    HashMap<String, Integer> _typeIds = new HashMap();
    private static final Logger log = LoggerFactory.getLogger(TimeTableImport.class);

    public void importSgn(TimeTableDataManager dm, File file) throws IOException {
        block24: {
            this._dm = dm;
            this._dm.setLockCalculate(true);
            try {
                try {
                    this.fileReader = new FileReader(file);
                    this.bufferedReader = new BufferedReader(this.fileReader);
                    int row = 1;
                    String currType = "";
                    int stationCount = 0;
                    int typeCount = 0;
                    int trainCount = 0;
                    int stopCount = 0;
                    int stopSeq = 0;
                    while ((this.line = this.bufferedReader.readLine()) != null) {
                        String[] lineStrings = this.line.split(",(?=([^\"]*\"[^\"]*\")*[^\"]*$)");
                        int i = 0;
                        while (i < lineStrings.length) {
                            lineStrings[i] = lineStrings[i].replace("\"", "");
                            ++i;
                        }
                        switch (row) {
                            case 1: {
                                log.info("SchedGen Import, version: {}", (Object)lineStrings[0]);
                                break;
                            }
                            case 2: {
                                this.createLayout(lineStrings);
                                this.createSegment(lineStrings);
                                this.createSchedule(lineStrings);
                                break;
                            }
                            case 3: {
                                stationCount = Integer.parseInt(lineStrings[0]);
                                currType = "Station";
                                break;
                            }
                            default: {
                                if (stationCount > 0) {
                                    this.createStation(lineStrings);
                                    --stationCount;
                                    break;
                                }
                                if (currType.equals("Station")) {
                                    currType = "Type";
                                    typeCount = Integer.parseInt(lineStrings[0]) + 1;
                                    break;
                                }
                                if (typeCount > 0) {
                                    this.createTrainType(lineStrings);
                                    --typeCount;
                                    break;
                                }
                                if (currType.equals("Type")) {
                                    currType = "Train";
                                    trainCount = Integer.parseInt(lineStrings[0]) + 1;
                                    stopCount = 0;
                                    break;
                                }
                                if (trainCount <= 0) break;
                                if (stopCount == 0) {
                                    this.createTrain(lineStrings);
                                    stopCount = -1;
                                    break;
                                }
                                if (stopCount == -1) {
                                    stopCount = Integer.parseInt(lineStrings[0]);
                                    stopSeq = 1;
                                    this._routeFirst = 0;
                                    this._routeLast = 0;
                                    break;
                                }
                                if (stopCount <= 0) break;
                                this.createStop(lineStrings, stopSeq);
                                ++stopSeq;
                                if (--stopCount != 0) break;
                                int routeDur = this._routeLast > this._routeFirst ? this._routeLast - this._routeFirst : 1440 - this._routeFirst + this._routeLast;
                                this._dm.getTrain(this._trainId).setRouteDuration(routeDur);
                                --trainCount;
                            }
                        }
                        ++row;
                    }
                }
                catch (IOException e) {
                    log.error("Error reading file: {}", (Throwable)e);
                    if (this.bufferedReader != null) {
                        this.bufferedReader.close();
                    }
                    if (this.fileReader != null) {
                        this.fileReader.close();
                    }
                    break block24;
                }
            }
            catch (Throwable throwable) {
                if (this.bufferedReader != null) {
                    this.bufferedReader.close();
                }
                if (this.fileReader != null) {
                    this.fileReader.close();
                }
                throw throwable;
            }
            if (this.bufferedReader != null) {
                this.bufferedReader.close();
            }
            if (this.fileReader != null) {
                this.fileReader.close();
            }
        }
        this._dm.setLockCalculate(false);
    }

    void createLayout(String[] lineStrings) {
        String[] clockComp = lineStrings[5].split(":");
        int clock = Integer.parseInt(clockComp[0]);
        int throttles = Integer.parseInt(lineStrings[7]);
        this._layoutId = this._dm.getNextId("Layout");
        Layout layout = new Layout(this._layoutId, lineStrings[0], ScaleManager.getScale(lineStrings[6]), clock, throttles, false);
        this._dm.addLayout(this._layoutId, layout);
    }

    void createTrainType(String[] lineStrings) {
        int colorInt = Integer.parseInt(lineStrings[lineStrings.length - 1]);
        String colorStr = String.format("#%06X", colorInt);
        String typeName = lineStrings[0];
        int typeId = this._dm.getNextId("TrainType");
        TrainType trainType = new TrainType(typeId, this._layoutId, typeName, colorStr);
        this._dm.addTrainType(typeId, trainType);
        this._typeIds.put(typeName, typeId);
    }

    void createSegment(String[] lineStrings) {
        this._segmentId = this._dm.getNextId("Segment");
        Segment segment = new Segment(this._segmentId, this._layoutId, "Mainline");
        this._dm.addSegment(this._segmentId, segment);
    }

    void createStation(String[] lineStrings) {
        int stationId = this._dm.getNextId("Station");
        Station station = new Station(stationId, this._segmentId, lineStrings[0], Double.parseDouble(lineStrings[1]), !lineStrings[4].equals("N"), Integer.parseInt(lineStrings[2]), Integer.parseInt(lineStrings[3]));
        this._dm.addStation(stationId, station);
        this._stationIds.add(stationId);
    }

    void createSchedule(String[] lineStrings) {
        this._scheduleId = this._dm.getNextId("Schedule");
        Schedule schedule = new Schedule(this._scheduleId, this._layoutId, lineStrings[1], lineStrings[2], Integer.parseInt(lineStrings[3]), Integer.parseInt(lineStrings[4]));
        this._dm.addSchedule(this._scheduleId, schedule);
    }

    void createTrain(String[] lineStrings) {
        String notes = lineStrings[6];
        int typeId = this._typeIds.get(lineStrings[2]);
        this._trainId = this._dm.getNextId("Train");
        Train train = new Train(this._trainId, this._scheduleId, typeId, lineStrings[0], lineStrings[1], Integer.parseInt(lineStrings[3]), Integer.parseInt(lineStrings[4]), Integer.parseInt(lineStrings[5]), 0, notes);
        this._dm.addTrain(this._trainId, train);
    }

    void createStop(String[] lineStrings, int seq) {
        int _stopId = this._dm.getNextId("Stop");
        Stop stop = new Stop(_stopId, this._trainId, this._stationIds.get(Integer.parseInt(lineStrings[0]) - 1), seq, Integer.parseInt(lineStrings[1]), Integer.parseInt(lineStrings[2]), Integer.parseInt(lineStrings[3]), Integer.parseInt(lineStrings[4]), Integer.parseInt(lineStrings[5]), lineStrings[6]);
        this._dm.addStop(_stopId, stop);
        if (seq == 1) {
            this._routeFirst = Integer.parseInt(lineStrings[3]);
        }
        this._routeLast = Integer.parseInt(lineStrings[4]);
    }
}

