/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.timetable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import jmri.InstanceManager;
import jmri.jmrit.timetable.Layout;
import jmri.jmrit.timetable.Schedule;
import jmri.jmrit.timetable.Segment;
import jmri.jmrit.timetable.Station;
import jmri.jmrit.timetable.Stop;
import jmri.jmrit.timetable.Train;
import jmri.jmrit.timetable.TrainType;
import jmri.jmrit.timetable.configurexml.TimeTableXml;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeTableDataManager {
    public static final String CLOCK_LT_1 = "FastClockLt1";
    public static final String DURATION_LT_0 = "DurationLt0";
    public static final String THROTTLES_LT_0 = "ThrottlesLt0";
    public static final String THROTTLES_IN_USE = "ThrottlesInUse";
    public static final String SCALE_NF = "ScaleNotFound";
    public static final String TIME_OUT_OF_RANGE = "TimeOutOfRange";
    public static final String SEGMENT_CHANGE_ERROR = "SegmentChangeError";
    public static final String DISTANCE_LT_0 = "DistanceLt0";
    public static final String SIDINGS_LT_0 = "SidingsLt0";
    public static final String STAGING_LT_0 = "StagingLt0";
    public static final String STAGING_IN_USE = "StagingInUse";
    public static final String START_HOUR_RANGE = "StartHourRange";
    public static final String DURATION_RANGE = "DurationRange";
    public static final String DEFAULT_SPEED_LT_0 = "DefaultSpeedLt0";
    public static final String START_TIME_FORMAT = "StartTimeFormat";
    public static final String START_TIME_RANGE = "StartTimeRange";
    public static final String THROTTLE_RANGE = "ThrottleRange";
    public static final String STAGING_RANGE = "StagingRange";
    public static final String STOP_DURATION_LT_0 = "StopDurationLt0";
    public static final String NEXT_SPEED_LT_0 = "NextSpeedLt0";
    public static final String LAYOUT_HAS_CHILDREN = "LayoutHasChildren";
    public static final String TYPE_HAS_REFERENCE = "TypeHasReference";
    public static final String SEGMENT_HAS_CHILDREN = "SegmentHaSChildren";
    public static final String STATION_HAS_REFERENCE = "StationHasReference";
    public static final String SCHEDULE_HAS_CHILDREN = "ScheduleHasChildren";
    public static final String TRAIN_HAS_CHILDREN = "TrainHasChildren";
    public static final String TYPE_ADD_FAIL = "TypeAddFail";
    public static final String SEGMENT_ADD_FAIL = "SegmentAddFail";
    public static final String STATION_ADD_FAIL = "StationAddFail";
    public static final String SCHEDULE_ADD_FAIL = "ScheduleAddFail";
    public static final String TRAIN_ADD_FAIL = "TrainAddFail";
    public static final String STOP_ADD_FAIL = "StopAddFail";
    private TreeMap<Integer, Layout> _layoutMap = new TreeMap();
    private TreeMap<Integer, TrainType> _trainTypeMap = new TreeMap();
    private TreeMap<Integer, Segment> _segmentMap = new TreeMap();
    private TreeMap<Integer, Station> _stationMap = new TreeMap();
    private TreeMap<Integer, Schedule> _scheduleMap = new TreeMap();
    private TreeMap<Integer, Train> _trainMap = new TreeMap();
    private TreeMap<Integer, Stop> _stopMap = new TreeMap();
    private List<SegmentStation> _segmentStations = new ArrayList<SegmentStation>();
    boolean _lockCalculate = false;
    private static final Logger log = LoggerFactory.getLogger(TimeTableDataManager.class);

    public TimeTableDataManager(boolean loadData) {
        InstanceManager.setDefault(TimeTableDataManager.class, this);
        if (loadData) {
            this._lockCalculate = true;
            if (!TimeTableXml.doLoad()) {
                log.error("Unable to load the time table data");
            }
            this._lockCalculate = false;
        }
    }

    public static TimeTableDataManager getDataManager() {
        TimeTableDataManager dm = InstanceManager.getNullableDefault(TimeTableDataManager.class);
        if (dm != null) {
            return dm;
        }
        return new TimeTableDataManager(true);
    }

    public void setLockCalculate(boolean lock) {
        this._lockCalculate = lock;
    }

    public void addLayout(int id, Layout newLayout) {
        this._layoutMap.put(id, newLayout);
    }

    public void addTrainType(int id, TrainType newTrainType) {
        this._trainTypeMap.put(id, newTrainType);
    }

    public void addSegment(int id, Segment newSegment) {
        this._segmentMap.put(id, newSegment);
    }

    public void addStation(int id, Station newStation) {
        this._stationMap.put(id, newStation);
        SegmentStation segmentStation = new SegmentStation(newStation.getSegmentId(), id);
        if (!this._segmentStations.contains(segmentStation)) {
            this._segmentStations.add(segmentStation);
        }
    }

    public void addSchedule(int id, Schedule newSchedule) {
        this._scheduleMap.put(id, newSchedule);
    }

    public void addTrain(int id, Train newTrain) {
        this._trainMap.put(id, newTrain);
    }

    public void addStop(int id, Stop newStop) {
        this._stopMap.put(id, newStop);
    }

    public void deleteLayout(int id) {
        if (!(this.getTrainTypes(id, false).isEmpty() && this.getSegments(id, false).isEmpty() && this.getSchedules(id, false).isEmpty())) {
            throw new IllegalArgumentException(LAYOUT_HAS_CHILDREN);
        }
        this._layoutMap.remove(id);
    }

    public void deleteTrainType(int id) {
        if (!this.getTrains(0, id, false).isEmpty()) {
            throw new IllegalArgumentException(TYPE_HAS_REFERENCE);
        }
        this._trainTypeMap.remove(id);
    }

    public void deleteSegment(int id) {
        if (!this.getStations(id, false).isEmpty()) {
            throw new IllegalArgumentException(SEGMENT_HAS_CHILDREN);
        }
        this._segmentMap.remove(id);
    }

    public void deleteStation(int id) {
        if (!this.getStops(0, id, false).isEmpty()) {
            throw new IllegalArgumentException(STATION_HAS_REFERENCE);
        }
        int segmentId = this.getStation(id).getSegmentId();
        ArrayList<SegmentStation> list = new ArrayList<SegmentStation>();
        for (SegmentStation segmentStation : this._segmentStations) {
            if (segmentStation.getStationId() != id || segmentStation.getSegmentId() != segmentId) continue;
            list.add(segmentStation);
        }
        for (SegmentStation ss : list) {
            this._segmentStations.remove(ss);
        }
        this._stationMap.remove(id);
    }

    public void deleteSchedule(int id) {
        if (!this.getTrains(id, 0, false).isEmpty()) {
            throw new IllegalArgumentException(SCHEDULE_HAS_CHILDREN);
        }
        this._scheduleMap.remove(id);
    }

    public void deleteTrain(int id) {
        if (!this.getStops(id, 0, false).isEmpty()) {
            throw new IllegalArgumentException(TRAIN_HAS_CHILDREN);
        }
        this._trainMap.remove(id);
    }

    public void deleteStop(int id) {
        int trainId = this.getStop(id).getTrainId();
        this._stopMap.remove(id);
        this.calculateTrain(trainId, true);
    }

    public Layout getLayout(int id) {
        return this._layoutMap.get(id);
    }

    public TrainType getTrainType(int id) {
        return this._trainTypeMap.get(id);
    }

    public Segment getSegment(int id) {
        return this._segmentMap.get(id);
    }

    public Station getStation(int id) {
        return this._stationMap.get(id);
    }

    public Schedule getSchedule(int id) {
        return this._scheduleMap.get(id);
    }

    public Train getTrain(int id) {
        return this._trainMap.get(id);
    }

    public Stop getStop(int id) {
        return this._stopMap.get(id);
    }

    public int getNextId(String type) {
        int nextId = 0;
        switch (type) {
            case "Layout": {
                nextId = this._layoutMap.isEmpty() ? 1 : this._layoutMap.lastKey() + 1;
                break;
            }
            case "TrainType": {
                nextId = this._trainTypeMap.isEmpty() ? 1 : this._trainTypeMap.lastKey() + 1;
                break;
            }
            case "Segment": {
                nextId = this._segmentMap.isEmpty() ? 1 : this._segmentMap.lastKey() + 1;
                break;
            }
            case "Station": {
                nextId = this._stationMap.isEmpty() ? 1 : this._stationMap.lastKey() + 1;
                break;
            }
            case "Schedule": {
                nextId = this._scheduleMap.isEmpty() ? 1 : this._scheduleMap.lastKey() + 1;
                break;
            }
            case "Train": {
                nextId = this._trainMap.isEmpty() ? 1 : this._trainMap.lastKey() + 1;
                break;
            }
            case "Stop": {
                nextId = this._stopMap.isEmpty() ? 1 : this._stopMap.lastKey() + 1;
                break;
            }
            default: {
                log.error("getNextId: Invalid record type: {}", (Object)type);
            }
        }
        return nextId;
    }

    public List<Layout> getLayouts(boolean sort) {
        ArrayList<Layout> list = new ArrayList<Layout>(this._layoutMap.values());
        if (sort) {
            Collections.sort(list, (o1, o2) -> o1.getLayoutName().compareTo(o2.getLayoutName()));
        }
        return list;
    }

    public List<TrainType> getTrainTypes(int fKeyLayout, boolean sort) {
        ArrayList<TrainType> list = new ArrayList<TrainType>();
        for (TrainType type : this._trainTypeMap.values()) {
            if (fKeyLayout != 0 && fKeyLayout != type.getLayoutId()) continue;
            list.add(type);
        }
        if (sort) {
            Collections.sort(list, (o1, o2) -> o1.getTypeName().compareTo(o2.getTypeName()));
        }
        return list;
    }

    public List<Segment> getSegments(int fKeyLayout, boolean sort) {
        ArrayList<Segment> list = new ArrayList<Segment>();
        for (Segment segment : this._segmentMap.values()) {
            if (fKeyLayout != 0 && fKeyLayout != segment.getLayoutId()) continue;
            list.add(segment);
        }
        if (sort) {
            Collections.sort(list, (o1, o2) -> o1.getSegmentName().compareTo(o2.getSegmentName()));
        }
        return list;
    }

    public List<Station> getStations(int fKeySegment, boolean sort) {
        ArrayList<Station> list = new ArrayList<Station>();
        for (Station station : this._stationMap.values()) {
            if (fKeySegment != 0 && fKeySegment != station.getSegmentId()) continue;
            list.add(station);
        }
        if (sort) {
            Collections.sort(list, (o1, o2) -> Double.compare(o1.getDistance(), o2.getDistance()));
        }
        return list;
    }

    public List<Schedule> getSchedules(int fKeyLayout, boolean sort) {
        ArrayList<Schedule> list = new ArrayList<Schedule>();
        for (Schedule schedule : this._scheduleMap.values()) {
            if (fKeyLayout != 0 && fKeyLayout != schedule.getLayoutId()) continue;
            list.add(schedule);
        }
        if (sort) {
            Collections.sort(list, (o1, o2) -> o1.getScheduleName().compareTo(o2.getScheduleName()));
        }
        return list;
    }

    public List<Train> getTrains(int fKeySchedule, int fKeyType, boolean sort) {
        ArrayList<Train> list = new ArrayList<Train>();
        for (Train train : this._trainMap.values()) {
            if ((fKeySchedule != 0 || fKeyType != 0) && fKeySchedule != train.getScheduleId() && fKeyType != train.getTypeId()) continue;
            list.add(train);
        }
        if (sort) {
            Collections.sort(list, (o1, o2) -> o1.getTrainName().compareTo(o2.getTrainName()));
        }
        return list;
    }

    public List<Stop> getStops(int fKeyTrain, int fKeyStation, boolean sort) {
        ArrayList<Stop> list = new ArrayList<Stop>();
        for (Stop stop : this._stopMap.values()) {
            if ((fKeyTrain != 0 || fKeyStation != 0) && fKeyTrain != stop.getTrainId() && fKeyStation != stop.getStationId()) continue;
            list.add(stop);
        }
        if (sort) {
            Collections.sort(list, (o1, o2) -> Integer.compare(o1.getSeq(), o2.getSeq()));
        }
        return list;
    }

    public Layout getLayoutForStop(int stopId) {
        return this.getLayout(this.getSchedule(this.getTrain(this.getStop(stopId).getTrainId()).getScheduleId()).getLayoutId());
    }

    public List<SegmentStation> getSegmentStations(int layoutId) {
        ArrayList<SegmentStation> list = new ArrayList<SegmentStation>();
        for (SegmentStation segmentStation : this._segmentStations) {
            if (this.getSegment(segmentStation.getSegmentId()).getLayoutId() != layoutId) continue;
            list.add(segmentStation);
        }
        Collections.sort(list, (o1, o2) -> o1.toString().compareTo(o2.toString()));
        return list;
    }

    void calculateLayoutTrains(int layoutId, boolean updateStops) {
        if (this._lockCalculate) {
            return;
        }
        for (Schedule schedule : this.getSchedules(layoutId, false)) {
            this.calculateScheduleTrains(schedule.getScheduleId(), updateStops);
        }
    }

    void calculateScheduleTrains(int scheduleId, boolean updateStops) {
        if (this._lockCalculate) {
            return;
        }
        for (Train train : this.getTrains(scheduleId, 0, false)) {
            this.calculateTrain(train.getTrainId(), updateStops);
        }
    }

    public void calculateTrain(int trainId, boolean updateStops) {
        if (this._lockCalculate) {
            return;
        }
        Train train = this.getTrain(trainId);
        Schedule schedule = this.getSchedule(train.getScheduleId());
        Layout layout = this.getLayout(schedule.getLayoutId());
        List<Stop> stops = this.getStops(trainId, 0, true);
        double smile = layout.getScaleMK();
        int startHH = schedule.getStartHour();
        int duration = schedule.getDuration();
        int currentTime = train.getStartTime();
        int defaultSpeed = train.getDefaultSpeed();
        int checkStart = startHH;
        int checkDuration = duration;
        String currentStationName = "";
        double currentDistance = 0.0;
        int currentSegment = 0;
        int currentSpeed = 0;
        int newArrive = 0;
        int newDepart = 0;
        int elapseTime = 0;
        boolean firstStop = true;
        for (Stop stop : stops) {
            Station station = this.getStation(stop.getStationId());
            Segment segment = this.getSegment(station.getSegmentId());
            if (firstStop) {
                newArrive = currentTime;
                newDepart = currentTime += stop.getDuration();
                currentDistance = station.getDistance();
                currentSpeed = stop.getNextSpeed() > 0 ? stop.getNextSpeed() : defaultSpeed;
                currentStationName = station.getStationName();
                currentSegment = segment.getSegmentId();
                if (this.validateTime(checkStart, checkDuration, newArrive) && this.validateTime(checkStart, checkDuration, newDepart)) {
                    if (updateStops) {
                        stop.setArriveTime(newArrive);
                        stop.setDepartTime(newDepart);
                    }
                } else {
                    throw new IllegalArgumentException(String.format("%s~%d~%s", TIME_OUT_OF_RANGE, stop.getSeq(), train.getTrainName()));
                }
                firstStop = false;
                continue;
            }
            double wrkDistance = Math.abs(currentDistance - station.getDistance());
            if (segment.getSegmentId() != currentSegment) {
                Station wrkStation = null;
                for (Station findStation : this.getStations(segment.getSegmentId(), false)) {
                    if (!findStation.getStationName().equals(currentStationName)) continue;
                    wrkStation = findStation;
                    break;
                }
                if (wrkStation == null) {
                    throw new IllegalArgumentException(SEGMENT_CHANGE_ERROR);
                }
                wrkDistance = Math.abs(station.getDistance() - wrkStation.getDistance());
            }
            if ((elapseTime = (int)Math.round(wrkDistance / smile / (double)currentSpeed * 60.0)) < 1) {
                elapseTime = 1;
            }
            if ((currentTime += elapseTime) > 1439) {
                currentTime -= 1440;
            }
            newArrive = currentTime;
            if ((currentTime += stop.getDuration()) > 1439) {
                currentTime -= 1440;
            }
            newDepart = currentTime;
            currentDistance = station.getDistance();
            currentSpeed = stop.getNextSpeed() > 0 ? stop.getNextSpeed() : defaultSpeed;
            currentSegment = station.getSegmentId();
            currentStationName = station.getStationName();
            if (this.validateTime(checkStart, checkDuration, newArrive) && this.validateTime(checkStart, checkDuration, newDepart)) {
                if (!updateStops) continue;
                stop.setArriveTime(newArrive);
                stop.setDepartTime(newDepart);
                continue;
            }
            throw new IllegalArgumentException(String.format("%s~%d~%s", TIME_OUT_OF_RANGE, stop.getSeq(), train.getTrainName()));
        }
    }

    public boolean validateTime(int checkStart, int checkDuration, int checkTime) {
        int highLimit;
        int lowLimit;
        boolean dayWrap;
        if (checkDuration == 24 && checkTime < 1440) {
            return true;
        }
        if (checkStart + checkDuration > 24) {
            dayWrap = true;
            lowLimit = checkStart * 60;
            highLimit = (checkStart + checkDuration - 24) * 60 - 1;
        } else {
            dayWrap = false;
            lowLimit = checkStart * 60;
            highLimit = (checkStart + checkDuration) * 60 - 1;
        }
        return dayWrap ? checkTime < 1440 && (checkTime >= lowLimit || checkTime <= highLimit) : checkTime < 1440 && checkTime >= lowLimit && checkTime <= highLimit;
    }

    public class SegmentStation {
        private int _segmentId;
        private int _stationId;

        public SegmentStation(int segmentId, int stationId) {
            this._segmentId = segmentId;
            this._stationId = stationId;
        }

        public int getSegmentId() {
            return this._segmentId;
        }

        public int getStationId() {
            return this._stationId;
        }

        public String toString() {
            return String.format("%s : %s", TimeTableDataManager.this.getSegment(this._segmentId).getSegmentName(), TimeTableDataManager.this.getStation(this._stationId).getStationName());
        }
    }
}

