/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.timetable;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jmri.Scale;
import jmri.ScaleManager;
import jmri.jmrit.timetable.Layout;
import jmri.jmrit.timetable.Schedule;
import jmri.jmrit.timetable.Segment;
import jmri.jmrit.timetable.Station;
import jmri.jmrit.timetable.Stop;
import jmri.jmrit.timetable.TimeTableDataManager;
import jmri.jmrit.timetable.Train;
import jmri.jmrit.timetable.TrainType;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeTableCsvImport {
    TimeTableDataManager tdm = TimeTableDataManager.getDataManager();
    boolean errorOccurred;
    List<String> importFeedback = new ArrayList<String>();
    FileReader fileReader;
    BufferedReader bufferedReader;
    CSVParser csvFile;
    int recordNumber = 0;
    int layoutId = 0;
    int segmentId = 0;
    int scheduleId = 0;
    int trainId = 0;
    List<Integer> trainTypes = new ArrayList<Integer>();
    List<Integer> stations = new ArrayList<Integer>();
    private static final Logger log = LoggerFactory.getLogger(TimeTableCsvImport.class);

    public List<String> importCsv(File file) throws IOException {
        Layout layout;
        block22: {
            this.tdm.setLockCalculate(true);
            this.errorOccurred = false;
            try {
                try {
                    this.fileReader = new FileReader(file);
                    this.bufferedReader = new BufferedReader(this.fileReader);
                    this.csvFile = new CSVParser((Reader)this.bufferedReader, CSVFormat.DEFAULT);
                    for (CSVRecord record : this.csvFile.getRecords()) {
                        if (this.errorOccurred) break;
                        ++this.recordNumber;
                        if (record.size() <= 0) continue;
                        ArrayList list = new ArrayList();
                        record.forEach(list::add);
                        String[] values = list.toArray(new String[record.size()]);
                        String recd = values[0];
                        if (recd.equals("Layout") && this.layoutId == 0) {
                            this.doLayout(values);
                            continue;
                        }
                        if (recd.equals("TrainType") && this.layoutId != 0) {
                            this.doTrainType(values);
                            continue;
                        }
                        if (recd.equals("Segment") && this.layoutId != 0) {
                            this.doSegment(values);
                            continue;
                        }
                        if (recd.equals("Station") && this.segmentId != 0) {
                            this.doStation(values);
                            continue;
                        }
                        if (recd.equals("Schedule") && this.layoutId != 0) {
                            this.doSchedule(values);
                            continue;
                        }
                        if (recd.equals("Train") && this.scheduleId != 0) {
                            this.doTrain(values);
                            continue;
                        }
                        if (recd.equals("Stop") && this.trainId != 0) {
                            this.doStop(values);
                            continue;
                        }
                        log.warn("Unable to process record {}, content = {}", (Object)this.recordNumber, (Object)values);
                        this.importFeedback.add(String.format("Unable to process record %d, content = %s", this.recordNumber, record.toString()));
                        this.errorOccurred = true;
                    }
                    this.csvFile.close();
                }
                catch (IOException ex) {
                    log.error("CSV Import failed: ", (Throwable)ex);
                    this.importFeedback.add(String.format("CSV Import failed: %s", ex.getMessage()));
                    this.errorOccurred = true;
                    if (this.bufferedReader != null) {
                        this.bufferedReader.close();
                    }
                    if (this.fileReader != null) {
                        this.fileReader.close();
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                if (this.bufferedReader != null) {
                    this.bufferedReader.close();
                }
                if (this.fileReader != null) {
                    this.fileReader.close();
                }
                throw throwable;
            }
            if (this.bufferedReader != null) {
                this.bufferedReader.close();
            }
            if (this.fileReader != null) {
                this.fileReader.close();
            }
        }
        this.tdm.setLockCalculate(false);
        if (!this.errorOccurred && (layout = this.tdm.getLayout(this.layoutId)) != null) {
            int fastClock = layout.getFastClock();
            try {
                layout.setFastClock(fastClock + 1);
                layout.setFastClock(fastClock);
            }
            catch (IllegalArgumentException ex) {
                log.error("Calculation error occured: ", (Throwable)ex);
                this.importFeedback.add(String.format("Calculation error occured: %s", ex.getMessage()));
            }
        }
        return this.importFeedback;
    }

    void doLayout(String[] values) {
        String metric;
        String throttlesString;
        int throttles;
        String clockString;
        int clock;
        if (this.recordNumber != 1) {
            log.error("Invalid file structure");
            this.importFeedback.add("Invalid file structure, the first record must be a layout record.");
            this.errorOccurred = true;
            return;
        }
        log.debug("Layout values: {}", (Object)Arrays.toString(values));
        if (values.length == 1) {
            Layout defaultLayout = new Layout();
            this.layoutId = defaultLayout.getLayoutId();
            return;
        }
        String layoutName = values[1];
        for (Layout layout : this.tdm.getLayouts(false)) {
            if (!layout.getLayoutName().equals(layoutName)) continue;
            this.layoutId = layout.getLayoutId();
            return;
        }
        Layout newLayout = new Layout();
        this.layoutId = newLayout.getLayoutId();
        newLayout.setLayoutName(layoutName);
        String scaleName = values.length > 2 ? values[2] : "HO";
        Scale scale = ScaleManager.getScale(scaleName);
        if (scale != null) {
            newLayout.setScale(scale);
        }
        if ((clock = this.convertToInteger(clockString = values.length > 3 ? values[3] : "4")) > 0) {
            newLayout.setFastClock(clock);
        }
        if ((throttles = this.convertToInteger(throttlesString = values.length > 4 ? values[4] : "0")) >= 0) {
            newLayout.setThrottles(throttles);
        }
        String string = metric = values.length > 5 ? values[5] : "No";
        if (metric.equals("Yes") || metric.equals("No")) {
            newLayout.setMetric(metric.equals("Yes"));
        }
    }

    void doTrainType(String[] values) {
        log.debug("TrainType values: {}", (Object)Arrays.toString(values));
        if (values.length == 1) {
            TrainType defaultType = new TrainType(this.layoutId);
            this.trainTypes.add(defaultType.getTypeId());
            return;
        }
        String typeName = values[1];
        if (typeName.equals("UseLayoutTypes")) {
            this.tdm.getTrainTypes(this.layoutId, true).forEach(currType -> this.trainTypes.add(currType.getTypeId()));
            return;
        }
        for (TrainType trainType : this.tdm.getTrainTypes(this.layoutId, false)) {
            if (!trainType.getTypeName().equals(typeName)) continue;
            this.trainTypes.add(trainType.getTypeId());
            return;
        }
        TrainType newType = new TrainType(this.layoutId);
        this.trainTypes.add(newType.getTypeId());
        newType.setTypeName(typeName);
        String typeColor = values.length > 2 ? values[2] : "#000000";
        try {
            Color checkColor = Color.decode(typeColor);
            log.debug("Color = {}", (Object)checkColor);
            newType.setTypeColor(typeColor);
        }
        catch (NumberFormatException numberFormatException) {
            log.error("Invalid color value");
        }
    }

    void doSegment(String[] values) {
        if (this.recordNumber == 2) {
            TrainType trainType = new TrainType(this.layoutId);
            this.trainTypes.add(trainType.getTypeId());
        }
        log.debug("Segment values: {}", (Object)Arrays.toString(values));
        if (values.length == 1) {
            Segment defaultSegment = new Segment(this.layoutId);
            this.segmentId = defaultSegment.getSegmentId();
            return;
        }
        String segmentName = values[1];
        for (Segment segment : this.tdm.getSegments(this.layoutId, false)) {
            if (!segment.getSegmentName().equals(segmentName)) continue;
            this.segmentId = segment.getSegmentId();
            return;
        }
        Segment newSegment = new Segment(this.layoutId);
        newSegment.setSegmentName(segmentName);
        this.segmentId = newSegment.getSegmentId();
    }

    void doStation(String[] values) {
        String stagingString;
        int staging;
        String sidingsString;
        int sidings;
        String doubleTrack;
        log.debug("Station values: {}", (Object)Arrays.toString(values));
        if (values.length == 1) {
            Station defaultStation = new Station(this.segmentId);
            this.stations.add(defaultStation.getStationId());
            return;
        }
        String stationName = values[1];
        if (stationName.equals("UseSegmentStations")) {
            this.tdm.getStations(this.segmentId, true).forEach(currStation -> this.stations.add(currStation.getStationId()));
            return;
        }
        for (Station station : this.tdm.getStations(this.segmentId, false)) {
            if (!station.getStationName().equals(stationName)) continue;
            this.stations.add(station.getStationId());
            return;
        }
        Station newStation = new Station(this.segmentId);
        newStation.setStationName(stationName);
        this.stations.add(newStation.getStationId());
        String distanceString = values.length > 2 ? values[2] : "1.0";
        double distance = this.convertToDouble(distanceString);
        if (distance >= 0.0) {
            newStation.setDistance(distance);
        }
        String string = doubleTrack = values.length > 3 ? values[3] : "No";
        if (doubleTrack.equals("Yes") || doubleTrack.equals("No")) {
            newStation.setDoubleTrack(doubleTrack.equals("Yes"));
        }
        if ((sidings = this.convertToInteger(sidingsString = values.length > 4 ? values[4] : "0")) >= 0) {
            newStation.setSidings(sidings);
        }
        if ((staging = this.convertToInteger(stagingString = values.length > 5 ? values[5] : "0")) >= 0) {
            newStation.setStaging(staging);
        }
    }

    void doSchedule(String[] values) {
        String durationString;
        int duration;
        String startString;
        int startHour;
        String effectiveDate;
        log.debug("Schedule values: {}", (Object)Arrays.toString(values));
        if (values.length == 1) {
            Schedule defaultSchedule = new Schedule(this.layoutId);
            this.scheduleId = defaultSchedule.getScheduleId();
            return;
        }
        String scheduleName = values[1];
        for (Schedule schedule : this.tdm.getSchedules(this.layoutId, false)) {
            if (!schedule.getScheduleName().equals(scheduleName)) continue;
            this.scheduleId = schedule.getScheduleId();
            return;
        }
        Schedule newSchedule = new Schedule(this.layoutId);
        newSchedule.setScheduleName(scheduleName);
        this.scheduleId = newSchedule.getScheduleId();
        String string = effectiveDate = values.length > 2 ? values[2] : "Today";
        if (!effectiveDate.isEmpty()) {
            newSchedule.setEffDate(effectiveDate);
        }
        if ((startHour = this.convertToInteger(startString = values.length > 3 ? values[3] : "0")) >= 0 && startHour < 24) {
            newSchedule.setStartHour(startHour);
        }
        if ((duration = this.convertToInteger(durationString = values.length > 4 ? values[4] : "24")) > 0 && duration < 25) {
            newSchedule.setDuration(duration);
        }
    }

    void doTrain(String[] values) {
        String trainNotes;
        String startTimeString;
        int startTime;
        String speedString;
        int defaultSpeed;
        String description;
        log.debug("Train values: {}", (Object)Arrays.toString(values));
        if (values.length == 1) {
            Train defaultTrain = new Train(this.scheduleId);
            defaultTrain.setTypeId(this.trainTypes.get(0));
            this.trainId = defaultTrain.getTrainId();
            return;
        }
        String trainName = values[1];
        for (Train train : this.tdm.getTrains(this.scheduleId, 0, false)) {
            if (!train.getTrainName().equals(trainName)) continue;
            this.trainId = train.getTrainId();
            return;
        }
        Train newTrain = new Train(this.scheduleId);
        newTrain.setTrainName(trainName);
        newTrain.setTypeId(this.trainTypes.get(0));
        this.trainId = newTrain.getTrainId();
        String string = description = values.length > 2 ? values[2] : "";
        if (!description.isEmpty()) {
            newTrain.setTrainDesc(description);
        }
        String typeIndexString = values.length > 3 ? values[3] : "1";
        int typeIndex = this.convertToInteger(typeIndexString);
        if (--typeIndex >= 0 && typeIndex < this.trainTypes.size()) {
            newTrain.setTypeId(this.trainTypes.get(typeIndex));
        }
        if ((defaultSpeed = this.convertToInteger(speedString = values.length > 4 ? values[4] : "1")) >= 0) {
            newTrain.setDefaultSpeed(defaultSpeed);
        }
        if ((startTime = this.convertToInteger(startTimeString = values.length > 5 ? values[5] : "0")) >= 0 && startTime < 1440) {
            Schedule schedule = this.tdm.getSchedule(this.scheduleId);
            if (this.tdm.validateTime(schedule.getStartHour(), schedule.getDuration(), startTime)) {
                newTrain.setStartTime(startTime);
            } else {
                this.errorOccurred = true;
                log.error("Train start time outside of schedule time: {}", (Object)startTime);
                this.importFeedback.add(String.format("Train start time outside of schedule time: %d", startTime));
            }
        }
        String throttleString = values.length > 6 ? values[6] : "0";
        int throttle = this.convertToInteger(throttleString);
        int throttles = this.tdm.getLayout(this.layoutId).getThrottles();
        if (throttle >= 0 && throttle <= throttles) {
            newTrain.setThrottle(throttle);
        }
        String string2 = trainNotes = values.length > 7 ? values[7] : "";
        if (!trainNotes.isEmpty()) {
            newTrain.setTrainNotes(trainNotes);
        }
    }

    void doStop(String[] values) {
        log.debug("Stop values: {}", (Object)Arrays.toString(values));
        String stopStationString = values.length > 1 ? values[1] : "-1";
        int stopStationIndex = this.convertToInteger(stopStationString);
        if (--stopStationIndex >= 0 && stopStationIndex < this.stations.size()) {
            String stopNotes;
            String nextSpeedString;
            int nextSpeed;
            List<Stop> stops = this.tdm.getStops(this.trainId, 0, false);
            Stop newStop = new Stop(this.trainId, stops.size() + 1);
            newStop.setStationId(this.stations.get(stopStationIndex));
            String durationString = values.length > 2 ? values[2] : "0";
            int stopDuration = this.convertToInteger(durationString);
            if (stopDuration > 0) {
                newStop.setDuration(stopDuration);
            }
            if ((nextSpeed = this.convertToInteger(nextSpeedString = values.length > 3 ? values[3] : "0")) > 0) {
                newStop.setNextSpeed(nextSpeed);
            }
            String stagingString = values.length > 4 ? values[4] : "0";
            int stagingTrack = this.convertToInteger(stagingString);
            Station station = this.tdm.getStation(this.stations.get(stopStationIndex));
            if (stagingTrack >= 0 && stagingTrack <= station.getStaging()) {
                newStop.setStagingTrack(stagingTrack);
            }
            String string = stopNotes = values.length > 5 ? values[5] : "";
            if (!stopNotes.isEmpty()) {
                newStop.setStopNotes(stopNotes);
            }
        }
    }

    int convertToInteger(String number) {
        try {
            return Integer.parseInt(number);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    double convertToDouble(String number) {
        try {
            return Double.parseDouble(number);
        }
        catch (NumberFormatException numberFormatException) {
            return -1.0;
        }
    }
}

