/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.timetable;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import jmri.jmrit.timetable.Layout;
import jmri.jmrit.timetable.Schedule;
import jmri.jmrit.timetable.Segment;
import jmri.jmrit.timetable.Station;
import jmri.jmrit.timetable.Stop;
import jmri.jmrit.timetable.TimeTableDataManager;
import jmri.jmrit.timetable.Train;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class TimeTableCsvExport {
    TimeTableDataManager tdm = TimeTableDataManager.getDataManager();
    boolean errorOccurred;
    FileWriter fileWriter;
    BufferedWriter bufferedWriter;
    CSVPrinter csvFile;
    HashMap<Integer, TrainEntry> trainMap = new HashMap();
    int trainIndex = 0;
    List<TrainEntry> downTrains = new ArrayList<TrainEntry>();
    List<TrainEntry> upTrains = new ArrayList<TrainEntry>();
    String[] stopRow;

    public boolean exportCsv(File file, int layoutId, int segmentId, int scheduleId) throws IOException {
        Train train2;
        this.errorOccurred = false;
        this.fileWriter = new FileWriter(file);
        this.bufferedWriter = new BufferedWriter(this.fileWriter);
        this.csvFile = new CSVPrinter((Appendable)this.bufferedWriter, CSVFormat.DEFAULT);
        Layout layout = this.tdm.getLayout(layoutId);
        Segment segment = this.tdm.getSegment(segmentId);
        Schedule schedule = this.tdm.getSchedule(scheduleId);
        this.csvFile.printRecord(new Object[]{layout.toString(), segment.toString(), schedule.toString()});
        ArrayList<String> record = new ArrayList<String>();
        record.add("");
        List<Train> trains = this.tdm.getTrains(schedule.getScheduleId(), 0, true);
        Collections.sort(trains, (o1, o2) -> Integer.compare(o1.getStartTime(), o2.getStartTime()));
        trains.forEach(train -> {
            List<Stop> trainStops = this.tdm.getStops(train.getTrainId(), 0, true);
            int lastStop = trainStops.size();
            if (lastStop > 1) {
                double secondDistance;
                double firstDistance = this.tdm.getStation(trainStops.get(0).getStationId()).getDistance();
                if (firstDistance < (secondDistance = this.tdm.getStation(trainStops.get(1).getStationId()).getDistance())) {
                    this.downTrains.add(new TrainEntry((Train)train, "Down", lastStop));
                } else {
                    this.upTrains.add(new TrainEntry((Train)train, "Up", lastStop));
                }
            } else {
                this.downTrains.add(new TrainEntry((Train)train, "Down", lastStop));
            }
        });
        for (TrainEntry downTrain : this.downTrains) {
            train2 = downTrain.getTrain();
            downTrain.setTrainIndex(this.trainIndex);
            this.trainMap.put(train2.getTrainId(), downTrain);
            record.add(train2.toString());
            ++this.trainIndex;
        }
        for (TrainEntry upTrain : this.upTrains) {
            train2 = upTrain.getTrain();
            upTrain.setTrainIndex(this.trainIndex);
            this.trainMap.put(train2.getTrainId(), upTrain);
            record.add(train2.toString());
            ++this.trainIndex;
        }
        this.csvFile.printRecord(record);
        for (Station station : this.tdm.getStations(segment.getSegmentId(), true)) {
            this.stopRow = new String[this.trainMap.size()];
            Arrays.fill(this.stopRow, "_");
            this.tdm.getStops(0, station.getStationId(), false).forEach(stop -> {
                Train chkTrain = this.tdm.getTrain(stop.getTrainId());
                if (chkTrain.getScheduleId() == schedule.getScheduleId()) {
                    TrainEntry trainEntry = this.trainMap.get(stop.getTrainId());
                    int idx = trainEntry.getTrainIndex();
                    int lastStop = trainEntry.getLastStation();
                    String direction = trainEntry.getDirection();
                    int thisStop = stop.getSeq();
                    int arrive = stop.getArriveTime();
                    int depart = stop.getDepartTime();
                    if (thisStop != 1 && thisStop != lastStop) {
                        this.stopRow[idx] = arrive == depart ? String.format("%s (d)", this.formatTime(depart)) : (direction.equals("Down") ? String.format("%s (a)%n%s (d)", this.formatTime(arrive), this.formatTime(depart)) : String.format("%s (d)%n%s (a)", this.formatTime(depart), this.formatTime(arrive)));
                    } else if (thisStop == 1) {
                        this.stopRow[idx] = String.format("%s (d)", this.formatTime(depart));
                    } else if (thisStop == lastStop) {
                        this.stopRow[idx] = String.format("%s (a)", this.formatTime(arrive));
                    }
                }
            });
            record = new ArrayList();
            record.add(station.toString());
            record.addAll(Arrays.asList(this.stopRow));
            this.csvFile.printRecord(record);
        }
        this.csvFile.flush();
        this.csvFile.close();
        return this.errorOccurred;
    }

    String formatTime(int t) {
        return String.format("%02d:%02d", t / 60, t % 60);
    }

    static class TrainEntry {
        private final Train _train;
        private final String _direction;
        private final int _lastStation;
        private int _trainIndex;

        public TrainEntry(Train train, String direction, int lastStation) {
            this._train = train;
            this._direction = direction;
            this._lastStation = lastStation;
            this._trainIndex = -1;
        }

        public Train getTrain() {
            return this._train;
        }

        public String getDirection() {
            return this._direction;
        }

        public int getLastStation() {
            return this._lastStation;
        }

        public int getTrainIndex() {
            return this._trainIndex;
        }

        public void setTrainIndex(int trainIndex) {
            this._trainIndex = trainIndex;
        }

        public String toString() {
            return String.format("%s : %s : %d : %d", this._train.getTrainName(), this._direction, this._lastStation, this._trainIndex);
        }
    }
}

