/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.timetable;

import jmri.jmrit.timetable.Station;
import jmri.jmrit.timetable.TimeTableDataManager;

public class Stop {
    TimeTableDataManager _dm = TimeTableDataManager.getDataManager();
    private final int _stopId;
    private final int _trainId;
    private int _stationId = 0;
    private int _seq = 0;
    private int _duration = 0;
    private int _nextSpeed = 0;
    private int _arriveTime = 0;
    private int _departTime = 0;
    private int _stagingTrack = 0;
    private String _stopNotes = "";

    public Stop(int trainId, int seq) {
        if (this._dm.getTrain(trainId) == null) {
            throw new IllegalArgumentException("StopAddFail");
        }
        this._stopId = this._dm.getNextId("Stop");
        this._trainId = trainId;
        this._seq = seq;
        this._dm.addStop(this._stopId, this);
    }

    public Stop(int stopId, int trainId, int stationId, int seq, int duration, int nextSpeed, int arriveTime, int departTime, int stagingTrack, String stopNotes) {
        this._stopId = stopId;
        this._trainId = trainId;
        this._stationId = stationId;
        this._seq = seq;
        this.setDuration(duration);
        this.setNextSpeed(nextSpeed);
        this.setArriveTime(arriveTime);
        this.setDepartTime(departTime);
        this.setStagingTrack(stagingTrack);
        this.setStopNotes(stopNotes);
    }

    public int getStopId() {
        return this._stopId;
    }

    public int getTrainId() {
        return this._trainId;
    }

    public int getStationId() {
        return this._stationId;
    }

    public void setStationId(int newStationId) {
        int oldDStationId = this._stationId;
        this._stationId = newStationId;
        try {
            this._dm.calculateTrain(this._trainId, false);
            this._dm.calculateTrain(this._trainId, true);
        }
        catch (IllegalArgumentException ex) {
            this._stationId = oldDStationId;
            throw ex;
        }
    }

    public int getSeq() {
        return this._seq;
    }

    public void setSeq(int newSeq) {
        this._seq = newSeq;
    }

    public int getDuration() {
        return this._duration;
    }

    public void setDuration(int newDuration) {
        if (newDuration < 0) {
            throw new IllegalArgumentException("StopDurationLt0");
        }
        int oldDuration = this._duration;
        this._duration = newDuration;
        try {
            this._dm.calculateTrain(this._trainId, false);
            this._dm.calculateTrain(this._trainId, true);
        }
        catch (IllegalArgumentException ex) {
            this._duration = oldDuration;
            throw ex;
        }
    }

    public int getNextSpeed() {
        return this._nextSpeed;
    }

    public void setNextSpeed(int newNextSpeed) {
        if (newNextSpeed < 0) {
            throw new IllegalArgumentException("NextSpeedLt0");
        }
        int oldNextSpeed = this._nextSpeed;
        this._nextSpeed = newNextSpeed;
        try {
            this._dm.calculateTrain(this._trainId, false);
            this._dm.calculateTrain(this._trainId, true);
        }
        catch (IllegalArgumentException ex) {
            this._nextSpeed = oldNextSpeed;
            throw ex;
        }
    }

    public int getArriveTime() {
        return this._arriveTime;
    }

    public void setArriveTime(int newArriveTime) {
        this._arriveTime = newArriveTime;
    }

    public int getDepartTime() {
        return this._departTime;
    }

    public void setDepartTime(int newDepartTime) {
        this._departTime = newDepartTime;
    }

    public int getStagingTrack() {
        return this._stagingTrack;
    }

    public void setStagingTrack(int newStagingTrack) {
        Station station = this._dm.getStation(this._stationId);
        if (newStagingTrack < 0 || newStagingTrack > station.getStaging()) {
            throw new IllegalArgumentException("StagingRange");
        }
        this._stagingTrack = newStagingTrack;
    }

    public String getStopNotes() {
        return this._stopNotes;
    }

    public void setStopNotes(String newNotes) {
        this._stopNotes = newNotes;
    }

    public String toString() {
        TimeTableDataManager dataMgr = TimeTableDataManager.getDataManager();
        Station station = dataMgr.getStation(this._stationId);
        return String.valueOf(this._seq) + " :: " + station.getStationName();
    }
}

