/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.timetable;

import jmri.jmrit.timetable.Bundle;
import jmri.jmrit.timetable.TimeTableDataManager;

public class Segment {
    TimeTableDataManager _dm = TimeTableDataManager.getDataManager();
    private final int _segmentId;
    private final int _layoutId;
    private String _segmentName = Bundle.getMessage("NewSegmentName");

    public Segment(int layoutId) {
        if (this._dm.getLayout(layoutId) == null) {
            throw new IllegalArgumentException("SegmentAddFail");
        }
        this._segmentId = this._dm.getNextId("Segment");
        this._layoutId = layoutId;
        this._dm.addSegment(this._segmentId, this);
    }

    public Segment(int segmentId, int layoutId, String segmentName) {
        this._segmentId = segmentId;
        this._layoutId = layoutId;
        this.setSegmentName(segmentName);
    }

    public int getSegmentId() {
        return this._segmentId;
    }

    public int getLayoutId() {
        return this._layoutId;
    }

    public String getSegmentName() {
        return this._segmentName;
    }

    public void setSegmentName(String newName) {
        this._segmentName = newName;
    }

    public String toString() {
        return this._segmentName;
    }
}

