/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.throttle;

import java.awt.Container;
import java.awt.Dimension;
import java.beans.PropertyVetoException;
import javax.swing.JInternalFrame;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowPreferences {
    private static final Logger log = LoggerFactory.getLogger(WindowPreferences.class);

    public static Element getPreferences(JInternalFrame c) {
        Element window = WindowPreferences.getPreferences((Container)c);
        window.setAttribute("isIconified", String.valueOf(c.isIcon()));
        return window;
    }

    public static void setPreferences(JInternalFrame c, Element e) {
        WindowPreferences.setPreferences((Container)c, e);
        try {
            if (e.getAttribute("isIconified") != null) {
                c.setIcon(e.getAttribute("isIconified").getBooleanValue());
            }
        }
        catch (PropertyVetoException | DataConversionException ex) {
            log.warn("Exception setting preferences", ex);
        }
    }

    public static Element getPreferences(Container c) {
        Element window = new Element("window");
        window.setAttribute("x", String.valueOf(c.getLocation().x));
        window.setAttribute("y", String.valueOf(c.getLocation().y));
        Dimension size = c.getSize();
        window.setAttribute("width", String.valueOf(size.width));
        window.setAttribute("height", String.valueOf(size.height));
        window.setAttribute("isVisible", String.valueOf(c.isVisible()));
        return window;
    }

    public static void setPreferences(Container c, Element e, boolean ignorePosition) {
        try {
            int x = e.getAttribute("x").getIntValue();
            int y = e.getAttribute("y").getIntValue();
            int width = e.getAttribute("width").getIntValue();
            int height = e.getAttribute("height").getIntValue();
            if (!ignorePosition) {
                c.setLocation(x, y);
            }
            c.setSize(width, height);
            if (e.getAttribute("isVisible") != null) {
                c.setVisible(e.getAttribute("isVisible").getBooleanValue());
            }
        }
        catch (DataConversionException ex) {
            log.warn("Exception setting preferences", (Throwable)ex);
        }
    }

    public static void setPreferences(Container c, Element e) {
        WindowPreferences.setPreferences(c, e, false);
    }
}

